/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.Scene;
import artofillusion.math.Noise;
import artofillusion.math.Vec3;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.Module;
import artofillusion.procedural.PointInfo;
import artofillusion.procedural.ProcedureEditor;
import artofillusion.ui.PanelDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import buoy.event.ValueChangedEvent;
import buoy.widget.BLabel;
import buoy.widget.FormContainer;
import buoy.widget.WindowWidget;
import java.awt.Point;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class JitterModule
extends Module {
    boolean valueOk;
    Vec3 v = new Vec3();
    Vec3 tempVec = new Vec3();
    double xamp = 0.1;
    double yamp = 0.1;
    double zamp = 0.1;
    double xscale = 1.0;
    double yscale = 1.0;
    double zscale = 1.0;
    double invxscale = 1.0;
    double invyscale = 1.0;
    double invzscale = 1.0;
    double lastBlur;
    PointInfo point;

    public JitterModule(Point position) {
        super(Translate.text("menu.jitterModule"), new IOPort[]{new IOPort(0, 0, 2, new String[]{"X", "(X)"}), new IOPort(0, 0, 2, new String[]{"Y", "(Y)"}), new IOPort(0, 0, 2, new String[]{"Z", "(Z)"})}, new IOPort[]{new IOPort(0, 1, 3, new String[]{"X"}), new IOPort(0, 1, 3, new String[]{"Y"}), new IOPort(0, 1, 3, new String[]{"Z"})}, position);
    }

    public double getXScale() {
        return this.xscale;
    }

    public void setXScale(double scale) {
        this.xscale = scale;
        this.invxscale = 1.0 / scale;
    }

    public double getYScale() {
        return this.yscale;
    }

    public void setYScale(double scale) {
        this.yscale = scale;
        this.invyscale = 1.0 / scale;
    }

    public double getZScale() {
        return this.zscale;
    }

    public void setZScale(double scale) {
        this.zscale = scale;
        this.invzscale = 1.0 / scale;
    }

    public double getXAmplitude() {
        return this.xamp;
    }

    public void setXAmplitude(double amp) {
        this.xamp = amp;
    }

    public double getYAmplitude() {
        return this.yamp;
    }

    public void setYAmplitude(double amp) {
        this.yamp = amp;
    }

    public double getZAmplitude() {
        return this.zamp;
    }

    public void setZAmplitude(double amp) {
        this.zamp = amp;
    }

    public void init(PointInfo p) {
        this.point = p;
        this.valueOk = false;
    }

    public double getAverageValue(int which, double blur) {
        if (!this.valueOk || blur != this.lastBlur) {
            this.v.x = this.linkFrom[0] == null ? this.point.x : this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
            this.v.y = this.linkFrom[1] == null ? this.point.y : this.linkFrom[1].getAverageValue(this.linkFromIndex[1], blur);
            this.v.z = this.linkFrom[2] == null ? this.point.z : this.linkFrom[2].getAverageValue(this.linkFromIndex[2], blur);
            Noise.calcVector(this.tempVec, this.invxscale * this.v.x, this.invyscale * this.v.y, this.invzscale * this.v.z);
            this.v.x += this.xamp * this.tempVec.x;
            this.v.y += this.yamp * this.tempVec.y;
            this.v.z += this.zamp * this.tempVec.z;
            this.valueOk = true;
            this.lastBlur = blur;
        }
        if (which == 0) {
            return this.v.x;
        }
        if (which == 1) {
            return this.v.y;
        }
        return this.v.z;
    }

    public double getValueError(int which, double blur) {
        if (this.linkFrom[which] != null) {
            return this.linkFrom[which].getValueError(this.linkFromIndex[which], blur);
        }
        if (which == 0) {
            return this.point.xsize * 0.5 + blur;
        }
        if (which == 1) {
            return this.point.ysize * 0.5 + blur;
        }
        return this.point.zsize * 0.5 + blur;
    }

    public void getValueGradient(int which, Vec3 grad, double blur) {
        if (this.linkFrom[which] != null) {
            this.linkFrom[which].getValueGradient(this.linkFromIndex[which], grad, blur);
        } else if (which == 0) {
            grad.set(1.0, 0.0, 0.0);
        } else if (which == 1) {
            grad.set(0.0, 1.0, 0.0);
        } else {
            grad.set(0.0, 0.0, 1.0);
        }
    }

    public boolean edit(final ProcedureEditor editor, Scene theScene) {
        final ValueField amp1 = new ValueField(this.xamp, 0, 4);
        final ValueField amp2 = new ValueField(this.yamp, 0, 4);
        final ValueField amp3 = new ValueField(this.zamp, 0, 4);
        final ValueField scale1 = new ValueField(this.xscale, 3, 4);
        final ValueField scale2 = new ValueField(this.yscale, 3, 4);
        final ValueField scale3 = new ValueField(this.zscale, 3, 4);
        Object listener = new Object(){

            void processEvent() {
                JitterModule.this.xamp = amp1.getValue();
                JitterModule.this.yamp = amp2.getValue();
                JitterModule.this.zamp = amp3.getValue();
                JitterModule.this.xscale = scale1.getValue();
                JitterModule.this.yscale = scale2.getValue();
                JitterModule.this.zscale = scale3.getValue();
                JitterModule.this.invxscale = 1.0 / JitterModule.this.xscale;
                JitterModule.this.invyscale = 1.0 / JitterModule.this.yscale;
                JitterModule.this.invzscale = 1.0 / JitterModule.this.zscale;
                editor.updatePreview();
            }
        };
        amp1.addEventLink(ValueChangedEvent.class, listener);
        amp2.addEventLink(ValueChangedEvent.class, listener);
        amp3.addEventLink(ValueChangedEvent.class, listener);
        scale1.addEventLink(ValueChangedEvent.class, listener);
        scale2.addEventLink(ValueChangedEvent.class, listener);
        scale3.addEventLink(ValueChangedEvent.class, listener);
        FormContainer p = new FormContainer(4, 3);
        p.add(new BLabel(), 0, 0);
        p.add(new BLabel("X"), 1, 0);
        p.add(new BLabel("Y"), 2, 0);
        p.add(new BLabel("Z"), 3, 0);
        p.add(Translate.label("Amplitude"), 0, 1);
        p.add(amp1, 1, 1);
        p.add(amp2, 2, 1);
        p.add(amp3, 3, 1);
        p.add(Translate.label("Scale"), 0, 2);
        p.add(scale1, 1, 2);
        p.add(scale2, 2, 2);
        p.add(scale3, 3, 2);
        PanelDialog dlg = new PanelDialog((WindowWidget)editor.getParentFrame(), Translate.text("selectJitterParameters"), p);
        return dlg.clickedOk();
    }

    public Module duplicate() {
        JitterModule mod = new JitterModule(new Point(this.bounds.x, this.bounds.y));
        mod.xamp = this.xamp;
        mod.yamp = this.yamp;
        mod.zamp = this.zamp;
        mod.xscale = this.xscale;
        mod.yscale = this.yscale;
        mod.zscale = this.zscale;
        mod.invxscale = this.invxscale;
        mod.invyscale = this.invyscale;
        mod.invzscale = this.invzscale;
        return mod;
    }

    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
        out.writeDouble(this.xamp);
        out.writeDouble(this.yamp);
        out.writeDouble(this.zamp);
        out.writeDouble(this.xscale);
        out.writeDouble(this.yscale);
        out.writeDouble(this.zscale);
    }

    public void readFromStream(DataInputStream in, Scene theScene) throws IOException {
        this.xamp = in.readDouble();
        this.yamp = in.readDouble();
        this.zamp = in.readDouble();
        this.xscale = in.readDouble();
        this.yscale = in.readDouble();
        this.zscale = in.readDouble();
        this.invxscale = 1.0 / this.xscale;
        this.invyscale = 1.0 / this.yscale;
        this.invzscale = 1.0 / this.zscale;
    }
}

