/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.procedural.Module;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class IOPort {
    int x;
    int y;
    int type;
    int direction;
    int location;
    String[] description;
    Rectangle bounds;
    Module module;
    public static final int INPUT = 0;
    public static final int OUTPUT = 1;
    public static final int NUMBER = 0;
    public static final int COLOR = 1;
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int SIZE = 5;

    public IOPort(int type, int direction, int location, String[] description) {
        this.type = type;
        this.direction = direction;
        this.location = location;
        this.description = description;
    }

    public Point getPosition() {
        return new Point(this.x, this.y);
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
        if (this.location == 0) {
            this.bounds = new Rectangle(x - 5, y - 1, 10, 7);
        } else if (this.location == 1) {
            this.bounds = new Rectangle(x - 5, y - 5 - 1, 10, 7);
        }
        if (this.location == 2) {
            this.bounds = new Rectangle(x - 1, y - 5, 7, 10);
        } else if (this.location == 3) {
            this.bounds = new Rectangle(x - 5 - 1, y - 5, 7, 10);
        }
    }

    public int getValueType() {
        return this.type;
    }

    public int getType() {
        return this.direction;
    }

    public int getLocation() {
        return this.location;
    }

    public Module getModule() {
        return this.module;
    }

    public void setModule(Module mod) {
        this.module = mod;
    }

    public boolean contains(Point p) {
        return this.bounds.contains(p);
    }

    public String[] getDescription() {
        return this.description;
    }

    public void setDescription(String[] desc) {
        this.description = desc;
    }

    public void draw(Graphics g) {
        if (this.type == 0) {
            g.setColor(Color.BLACK);
        } else {
            g.setColor(Color.BLUE);
        }
        if (this.location == 0) {
            g.fillPolygon(new int[]{this.x + 5, this.x - 5, this.x}, new int[]{this.y, this.y, this.y + 5}, 3);
        } else if (this.location == 1) {
            g.fillPolygon(new int[]{this.x + 5, this.x - 5, this.x}, new int[]{this.y, this.y, this.y - 5}, 3);
        } else if (this.location == 2) {
            g.fillPolygon(new int[]{this.x, this.x, this.x + 5}, new int[]{this.y + 5, this.y - 5, this.y}, 3);
        } else if (this.location == 3) {
            g.fillPolygon(new int[]{this.x - 5, this.x - 5, this.x}, new int[]{this.y + 5, this.y - 5, this.y}, 3);
        }
    }
}

