/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.Scene;
import artofillusion.math.Vec3;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.Module;
import artofillusion.procedural.ProcedureEditor;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import buoy.event.ValueChangedEvent;
import buoy.widget.BStandardDialog;
import buoy.widget.Widget;
import java.awt.Point;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ClipModule
extends Module {
    double min = 0.0;
    double max = 1.0;

    public ClipModule(Point position) {
        super(Translate.text("menu.clipModule"), new IOPort[]{new IOPort(0, 0, 2, new String[]{"Input", "(0)"})}, new IOPort[]{new IOPort(0, 1, 3, new String[]{"Output"})}, position);
    }

    public double getMinimum() {
        return this.min;
    }

    public void setMinimum(double m) {
        this.min = m;
    }

    public double getMaximum() {
        return this.max;
    }

    public void setMaximum(double m) {
        this.max = m;
    }

    public double getAverageValue(int which, double blur) {
        if (this.linkFrom[0] == null) {
            return 0.0;
        }
        double v = this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
        if (v < this.min) {
            return this.min;
        }
        if (v > this.max) {
            return this.max;
        }
        return v;
    }

    public double getValueError(int which, double blur) {
        if (this.linkFrom[0] == null) {
            return 0.0;
        }
        double v = this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
        if (v < this.min || v > this.max) {
            return 0.0;
        }
        return this.linkFrom[0].getValueError(this.linkFromIndex[0], blur);
    }

    public void getValueGradient(int which, Vec3 grad, double blur) {
        if (this.linkFrom[0] == null) {
            grad.set(0.0, 0.0, 0.0);
            return;
        }
        double v = this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
        if (v < this.min || v > this.max) {
            grad.set(0.0, 0.0, 0.0);
        } else {
            this.linkFrom[0].getValueGradient(this.linkFromIndex[0], grad, blur);
        }
    }

    public boolean edit(final ProcedureEditor editor, Scene theScene) {
        final ValueField minField = new ValueField(this.min, 0);
        final ValueField maxField = new ValueField(this.max, 0);
        Object listener = new Object(){

            void processEvent() {
                if (minField.getValue() <= maxField.getValue()) {
                    ClipModule.this.min = minField.getValue();
                    ClipModule.this.max = maxField.getValue();
                    editor.updatePreview();
                }
            }
        };
        minField.addEventLink(ValueChangedEvent.class, listener);
        maxField.addEventLink(ValueChangedEvent.class, listener);
        ComponentsDialog dlg = new ComponentsDialog(editor.getParentFrame(), Translate.text("selectClipRange"), new Widget[]{minField, maxField}, new String[]{Translate.text("Minimum"), Translate.text("Maximum")});
        if (!dlg.clickedOk()) {
            return false;
        }
        this.min = minField.getValue();
        this.max = maxField.getValue();
        if (this.min > this.max) {
            new BStandardDialog("", Translate.text("minimumAboveMaxError"), BStandardDialog.INFORMATION).showMessageDialog(editor.getParent());
            return this.edit(editor, theScene);
        }
        return true;
    }

    public Module duplicate() {
        ClipModule mod = new ClipModule(new Point(this.bounds.x, this.bounds.y));
        mod.min = this.min;
        mod.max = this.max;
        return mod;
    }

    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
        out.writeDouble(this.min);
        out.writeDouble(this.max);
    }

    public void readFromStream(DataInputStream in, Scene theScene) throws IOException {
        this.min = in.readDouble();
        this.max = in.readDouble();
    }
}

