/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.object;

import artofillusion.ArtOfIllusion;
import artofillusion.MeshViewer;
import artofillusion.Property;
import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.Scene;
import artofillusion.TextureParameter;
import artofillusion.TriMeshEditorWindow;
import artofillusion.TriMeshViewer;
import artofillusion.ViewerCanvas;
import artofillusion.WireframeMesh;
import artofillusion.animation.Actor;
import artofillusion.animation.Joint;
import artofillusion.animation.Keyframe;
import artofillusion.animation.MeshGesture;
import artofillusion.animation.Skeleton;
import artofillusion.material.Material;
import artofillusion.material.MaterialMapping;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec3;
import artofillusion.object.FacetedMesh;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.texture.ConstantParameterValue;
import artofillusion.texture.FaceParameterValue;
import artofillusion.texture.FaceVertexParameterValue;
import artofillusion.texture.ParameterValue;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.VertexParameterValue;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.MeshEditController;
import artofillusion.ui.Translate;
import buoy.widget.RowContainer;
import java.awt.Point;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.lang.ref.SoftReference;
import java.util.Hashtable;
import java.util.Vector;

public class TriangleMesh
extends Object3D
implements FacetedMesh {
    private Vertex[] vertex;
    private Edge[] edge;
    private Face[] face;
    private Skeleton skeleton;
    private boolean closed;
    private BoundingBox bounds;
    private int smoothingMethod = 1;
    private SoftReference<RenderingMesh> cachedMesh;
    private SoftReference<WireframeMesh> cachedWire;
    private static double[] LOOP_BETA;
    private static double[][] BUTTERFLY_COEFF;
    private static final int MAX_SUBDIVISIONS = 20;
    private static final Property[] PROPERTIES;
    private static final int PER_OBJECT = 0;
    private static final int PER_VERTEX = 1;
    private static final int PER_FACE = 2;
    private static final int PER_FACE_VERTEX = 3;

    public TriangleMesh(Vec3[] v, int[][] faces) {
        this.setSkeleton(new Skeleton());
        Vertex[] vt = new Vertex[v.length];
        for (int i = 0; i < v.length; ++i) {
            vt[i] = new Vertex(v[i]);
        }
        this.setShape(vt, faces);
    }

    public TriangleMesh(Vertex[] v, int[][] faces) {
        this.setSkeleton(new Skeleton());
        this.setShape(v, faces);
    }

    protected TriangleMesh() {
    }

    public Object3D duplicate() {
        TriangleMesh mesh = new TriangleMesh();
        mesh.copyObject(this);
        return mesh;
    }

    public void copyObject(Object3D obj) {
        int i;
        TriangleMesh mesh = (TriangleMesh)obj;
        this.texParam = null;
        this.vertex = new Vertex[mesh.vertex.length];
        this.edge = new Edge[mesh.edge.length];
        this.face = new Face[mesh.face.length];
        for (i = 0; i < mesh.vertex.length; ++i) {
            this.vertex[i] = new Vertex(mesh.vertex[i]);
        }
        for (i = 0; i < mesh.edge.length; ++i) {
            this.edge[i] = new Edge(mesh.edge[i].v1, mesh.edge[i].v2, mesh.edge[i].f1);
            this.edge[i].f2 = mesh.edge[i].f2;
            this.edge[i].smoothness = mesh.edge[i].smoothness;
        }
        for (i = 0; i < mesh.face.length; ++i) {
            this.face[i] = new Face(mesh.face[i].v1, mesh.face[i].v2, mesh.face[i].v3, mesh.face[i].e1, mesh.face[i].e2, mesh.face[i].e3);
        }
        if (this.skeleton == null) {
            this.skeleton = mesh.skeleton.duplicate();
        } else {
            this.skeleton.copy(mesh.skeleton);
        }
        this.setSmoothingMethod(mesh.getSmoothingMethod());
        this.closed = mesh.closed;
        this.copyTextureAndMaterial(obj);
    }

    void findEdges(int[][] faces) {
        int i;
        int numEdges1 = 0;
        int numEdges2 = 0;
        int numCopied = 0;
        int[][] faceEdges = new int[faces.length][3];
        int[] copiedEdges = new int[faces.length * 3];
        Edge[] edges1 = new Edge[faces.length * 3];
        Edge[] edges2 = new Edge[faces.length * 3];
        this.closed = true;
        for (i = 0; i < faces.length; ++i) {
            if (faces[i][0] > faces[i][1]) {
                int n = numEdges1++;
                faceEdges[i][0] = n;
                edges1[n] = new Edge(faces[i][0], faces[i][1], i);
            } else {
                int n = numEdges2++;
                faceEdges[i][0] = n;
                edges2[n] = new Edge(faces[i][0], faces[i][1], i);
                int[] nArray = faceEdges[i];
                nArray[0] = nArray[0] + edges1.length;
            }
            if (faces[i][1] > faces[i][2]) {
                int n = numEdges1++;
                faceEdges[i][1] = n;
                edges1[n] = new Edge(faces[i][1], faces[i][2], i);
            } else {
                int n = numEdges2++;
                faceEdges[i][1] = n;
                edges2[n] = new Edge(faces[i][1], faces[i][2], i);
                int[] nArray = faceEdges[i];
                nArray[1] = nArray[1] + edges1.length;
            }
            if (faces[i][2] > faces[i][0]) {
                int n = numEdges1++;
                faceEdges[i][2] = n;
                edges1[n] = new Edge(faces[i][2], faces[i][0], i);
                continue;
            }
            int n = numEdges2++;
            faceEdges[i][2] = n;
            edges2[n] = new Edge(faces[i][2], faces[i][0], i);
            int[] nArray = faceEdges[i];
            nArray[2] = nArray[2] + edges1.length;
        }
        if (numEdges1 != numEdges2) {
            this.closed = false;
        }
        Hashtable<Point, Integer> edgeTable = new Hashtable<Point, Integer>();
        for (i = 0; i < numEdges1; ++i) {
            edgeTable.put(new Point(edges1[i].v1, edges1[i].v2), i);
        }
        for (i = 0; i < numEdges2; ++i) {
            Integer index = (Integer)edgeTable.get(new Point(edges2[i].v2, edges2[i].v1));
            if (index == null) {
                copiedEdges[i] = numEdges1 + numCopied++;
                edges1[copiedEdges[i]] = edges2[i];
                continue;
            }
            copiedEdges[i] = index;
            edges1[index.intValue()].f2 = edges2[i].f1;
        }
        if (numCopied > 0) {
            this.closed = false;
        }
        for (i = 0; i < faces.length; ++i) {
            if (faceEdges[i][0] >= edges1.length) {
                faceEdges[i][0] = copiedEdges[faceEdges[i][0] - edges1.length];
            }
            if (faceEdges[i][1] >= edges1.length) {
                faceEdges[i][1] = copiedEdges[faceEdges[i][1] - edges1.length];
            }
            if (faceEdges[i][2] < edges1.length) continue;
            faceEdges[i][2] = copiedEdges[faceEdges[i][2] - edges1.length];
        }
        this.edge = new Edge[numEdges1 + numCopied];
        for (i = 0; i < numEdges1 + numCopied; ++i) {
            this.edge[i] = edges1[i];
        }
        this.face = new Face[faces.length];
        for (i = 0; i < faces.length; ++i) {
            this.face[i] = new Face(faces[i][0], faces[i][1], faces[i][2], faceEdges[i][0], faceEdges[i][1], faceEdges[i][2]);
        }
    }

    private void findBounds() {
        double minx;
        double maxx;
        double miny;
        double maxy;
        double minz;
        double maxz;
        Object cached;
        Vec3[] vert = null;
        if (this.cachedMesh != null && (cached = this.cachedMesh.get()) != null) {
            vert = ((RenderingMesh)cached).vert;
        }
        if (vert == null && this.cachedWire != null) {
            cached = this.cachedWire.get();
            if (cached != null) {
                vert = ((WireframeMesh)cached).vert;
            }
            vert = ((WireframeMesh)cached).vert;
        }
        if (vert == null) {
            vert = this.getWireframeMesh().vert;
        }
        if (vert.length == 0) {
            maxz = 0.0;
            minz = 0.0;
            maxy = 0.0;
            miny = 0.0;
            maxx = 0.0;
            minx = 0.0;
        } else {
            minx = maxx = vert[0].x;
            miny = maxy = vert[0].y;
            minz = maxz = vert[0].z;
            for (int i = 1; i < vert.length; ++i) {
                if (vert[i].x < minx) {
                    minx = vert[i].x;
                }
                if (vert[i].x > maxx) {
                    maxx = vert[i].x;
                }
                if (vert[i].y < miny) {
                    miny = vert[i].y;
                }
                if (vert[i].y > maxy) {
                    maxy = vert[i].y;
                }
                if (vert[i].z < minz) {
                    minz = vert[i].z;
                }
                if (!(vert[i].z > maxz)) continue;
                maxz = vert[i].z;
            }
        }
        this.bounds = new BoundingBox(minx, maxx, miny, maxy, minz, maxz);
    }

    public BoundingBox getBounds() {
        if (this.bounds == null) {
            this.findBounds();
        }
        return this.bounds;
    }

    public MeshVertex[] getVertices() {
        return this.vertex;
    }

    public Edge[] getEdges() {
        return this.edge;
    }

    public Face[] getFaces() {
        return this.face;
    }

    public int getSmoothingMethod() {
        return this.smoothingMethod;
    }

    public Vec3[] getVertexPositions() {
        Vec3[] v = new Vec3[this.vertex.length];
        for (int i = 0; i < v.length; ++i) {
            v[i] = new Vec3(this.vertex[i].r);
        }
        return v;
    }

    public void setVertexPositions(Vec3[] v) {
        for (int i = 0; i < v.length; ++i) {
            this.vertex[i].r = v[i];
        }
        this.cachedMesh = null;
        this.cachedWire = null;
        this.bounds = null;
    }

    public void setSmoothingMethod(int method) {
        this.smoothingMethod = method;
        this.cachedMesh = null;
        this.cachedWire = null;
        this.bounds = null;
    }

    public void setShape(Vertex[] v, int[][] faces) {
        int i;
        this.vertex = new Vertex[v.length];
        for (i = 0; i < v.length; ++i) {
            this.vertex[i] = new Vertex(v[i]);
            this.vertex[i].firstEdge = -1;
            this.vertex[i].edges = 0;
        }
        if (faces.length == 0) {
            this.edge = new Edge[0];
            this.face = new Face[0];
        } else {
            this.findEdges(faces);
        }
        this.cachedMesh = null;
        this.cachedWire = null;
        this.bounds = null;
        for (i = 0; i < this.edge.length; ++i) {
            Vertex v1 = this.vertex[this.edge[i].v1];
            Vertex v2 = this.vertex[this.edge[i].v2];
            ++v1.edges;
            ++v2.edges;
            if (this.edge[i].f2 == -1) {
                v1.firstEdge = v2.firstEdge = i;
                continue;
            }
            if (v1.firstEdge == -1) {
                v1.firstEdge = i;
            }
            if (v2.firstEdge != -1) continue;
            v2.firstEdge = i;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setSize(double xsize, double ysize, double zsize) {
        Vec3 size = this.getBounds().getSize();
        double xscale = size.x == 0.0 ? 1.0 : xsize / size.x;
        double yscale = size.y == 0.0 ? 1.0 : ysize / size.y;
        double zscale = size.z == 0.0 ? 1.0 : zsize / size.z;
        for (int i = 0; i < this.vertex.length; ++i) {
            this.vertex[i].r.x *= xscale;
            this.vertex[i].r.y *= yscale;
            this.vertex[i].r.z *= zscale;
        }
        if (xscale * yscale * zscale < 0.0) {
            this.reverseNormals();
        }
        this.skeleton.scale(xscale, yscale, zscale);
        this.cachedMesh = null;
        this.cachedWire = null;
        this.bounds = null;
    }

    public int[][] findBoundaryEdges() {
        int j;
        Vector<Integer> allEdges = new Vector<Integer>();
        for (int i = 0; i < this.edge.length; ++i) {
            if (this.edge[i].f2 != -1) continue;
            allEdges.addElement(i);
        }
        Vector boundary = new Vector();
        while (allEdges.size() > 0) {
            Vector<Integer> current = new Vector<Integer>();
            Integer start = (Integer)allEdges.elementAt(0);
            allEdges.removeElementAt(0);
            current.addElement(start);
            int i = start;
            j = 0;
            block2: while (j < allEdges.size()) {
                for (j = 0; j < allEdges.size(); ++j) {
                    int k = (Integer)allEdges.elementAt(j);
                    if (this.edge[i].v1 != this.edge[k].v1 && this.edge[i].v1 != this.edge[k].v2 && this.edge[i].v2 != this.edge[k].v1 && this.edge[i].v2 != this.edge[k].v2) continue;
                    current.addElement((Integer)allEdges.elementAt(j));
                    allEdges.removeElementAt(j);
                    i = k;
                    --j;
                    continue block2;
                }
            }
            boundary.addElement(current);
        }
        int[][] index = new int[boundary.size()][];
        for (int i = 0; i < index.length; ++i) {
            Vector current = (Vector)boundary.elementAt(i);
            index[i] = new int[current.size()];
            for (j = 0; j < index[i].length; ++j) {
                index[i][j] = (Integer)current.elementAt(j);
            }
        }
        return index;
    }

    public boolean isEditable() {
        return true;
    }

    public void edit(EditingWindow parent, ObjectInfo info, Runnable cb) {
        TriMeshEditorWindow ed = new TriMeshEditorWindow(parent, "Triangle Mesh '" + info.getName() + "'", info, cb, true);
        ed.setVisible(true);
    }

    public void editGesture(EditingWindow parent, ObjectInfo info, Runnable cb, ObjectInfo realObject) {
        TriMeshEditorWindow ed = new TriMeshEditorWindow(parent, "Gesture '" + info.getName() + "'", info, cb, false);
        ViewerCanvas[] views = ed.getAllViews();
        for (int i = 0; i < views.length; ++i) {
            ((MeshViewer)views[i]).setScene(parent.getScene(), realObject);
        }
        ed.setVisible(true);
    }

    public MeshViewer createMeshViewer(MeshEditController controller, RowContainer options) {
        return new TriMeshViewer(controller, options);
    }

    public int canConvertToTriangleMesh() {
        if (this.smoothingMethod == 0 || this.smoothingMethod == 1) {
            return 1;
        }
        return 2;
    }

    public TriangleMesh convertToTriangleMesh(double tol) {
        if (this.smoothingMethod == 2 || this.smoothingMethod == 3) {
            boolean[] split = new boolean[this.edge.length];
            for (int i = 0; i < split.length; ++i) {
                split[i] = true;
            }
            if (this.smoothingMethod == 2) {
                return TriangleMesh.subdivideButterfly(this, split, tol);
            }
            return TriangleMesh.subdivideLoop(this, split, tol);
        }
        return (TriangleMesh)this.duplicate();
    }

    public WireframeMesh getWireframeMesh() {
        Edge[] e;
        Vertex[] v;
        int i;
        WireframeMesh cached;
        TriangleMesh mesh = this;
        if (this.cachedWire != null && (cached = this.cachedWire.get()) != null) {
            return cached;
        }
        if (this.smoothingMethod == 2 || this.smoothingMethod == 3) {
            boolean[] split = new boolean[this.edge.length];
            for (i = 0; i < split.length; ++i) {
                split[i] = true;
            }
            mesh = this.smoothingMethod == 2 ? TriangleMesh.subdivideButterfly(mesh, split, ArtOfIllusion.getPreferences().getInteractiveSurfaceError()) : TriangleMesh.subdivideLoop(mesh, split, ArtOfIllusion.getPreferences().getInteractiveSurfaceError());
            v = mesh.vertex;
            e = mesh.edge;
        } else {
            v = this.vertex;
            e = this.edge;
        }
        Vec3[] point = new Vec3[v.length];
        int[] from = new int[e.length];
        int[] to = new int[e.length];
        for (i = 0; i < v.length; ++i) {
            point[i] = v[i].r;
        }
        for (i = 0; i < e.length; ++i) {
            from[i] = e[i].v1;
            to[i] = e[i].v2;
        }
        WireframeMesh wire = new WireframeMesh(point, from, to);
        this.cachedWire = new SoftReference<WireframeMesh>(wire);
        return wire;
    }

    public RenderingMesh getRenderingMesh(double tol, boolean interactive, ObjectInfo info) {
        Vec3[] normalArray;
        Face[] f;
        Edge[] e;
        Vertex[] v;
        int i;
        RenderingMesh cached;
        TriangleMesh mesh = this;
        if (interactive && this.cachedMesh != null && (cached = this.cachedMesh.get()) != null) {
            return cached;
        }
        if (this.face.length == 0) {
            RenderingMesh rend = new RenderingMesh(new Vec3[]{new Vec3()}, new Vec3[]{Vec3.vx()}, new RenderingTriangle[0], this.texMapping, this.matMapping);
            rend.setParameters(mesh.paramValue);
            return rend;
        }
        if (this.smoothingMethod == 2 || this.smoothingMethod == 3) {
            double tol2 = tol * tol;
            Vec3 diff = new Vec3();
            boolean[] split = new boolean[this.edge.length];
            for (i = 0; i < split.length; ++i) {
                Vec3 r1 = this.vertex[this.edge[i].v1].r;
                Vec3 r2 = this.vertex[this.edge[i].v2].r;
                diff.set(r1.x - r2.x, r1.y - r2.y, r1.z - r2.z);
                split[i] = diff.length2() > tol2;
            }
            mesh = this.smoothingMethod == 2 ? TriangleMesh.subdivideButterfly(mesh, split, tol) : TriangleMesh.subdivideLoop(mesh, split, tol);
            v = mesh.vertex;
            e = mesh.edge;
            f = mesh.face;
        } else {
            v = this.vertex;
            e = this.edge;
            f = this.face;
        }
        Vec3[] vert = new Vec3[v.length];
        Vector<Vec3> norm = new Vector<Vec3>();
        RenderingTriangle[] tri = new RenderingTriangle[f.length];
        int[] facenorm = new int[f.length * 3];
        int normals = 0;
        int last = 0;
        int k = 0;
        if (this.smoothingMethod != 0) {
            Face tempFace;
            Vec3[] trueNorm = new Vec3[f.length];
            for (i = 0; i < f.length; ++i) {
                trueNorm[i] = v[f[i].v2].r.minus(v[f[i].v1].r).cross(v[f[i].v3].r.minus(v[f[i].v1].r));
                double length = trueNorm[i].length();
                if (!(length > 0.0)) continue;
                trueNorm[i].scale(1.0 / length);
            }
            block2: for (i = 0; i < v.length; ++i) {
                Edge tempEdge;
                int j;
                vert[i] = v[i].r;
                int[] ed = v[i].getEdges();
                if (v[i].smoothness < 1.0f) {
                    norm.addElement(null);
                    for (j = 0; j < ed.length; ++j) {
                        k = e[ed[j]].f1;
                        tempFace = f[k];
                        if (tempFace.v1 == i) {
                            facenorm[k * 3] = normals;
                        } else if (tempFace.v2 == i) {
                            facenorm[k * 3 + 1] = normals;
                        } else {
                            facenorm[k * 3 + 2] = normals;
                        }
                        k = e[ed[j]].f2;
                        if (k == -1) continue;
                        tempFace = f[k];
                        if (tempFace.v1 == i) {
                            facenorm[k * 3] = normals;
                            continue;
                        }
                        if (tempFace.v2 == i) {
                            facenorm[k * 3 + 1] = normals;
                            continue;
                        }
                        facenorm[k * 3 + 2] = normals;
                    }
                    ++normals;
                    continue;
                }
                k = -1;
                for (j = 0; j < ed.length; ++j) {
                    tempEdge = e[ed[j]];
                    if (tempEdge.f2 != -1 && !(tempEdge.smoothness < 1.0f)) continue;
                    if (k != -1) break;
                    k = j;
                }
                if (j == ed.length) {
                    Vec3 temp = new Vec3();
                    int faceIndex = -1;
                    for (j = 0; j < ed.length; ++j) {
                        double dot;
                        Edge tempEdge2 = e[ed[j]];
                        faceIndex = tempEdge2.f1 == faceIndex ? tempEdge2.f2 : tempEdge2.f1;
                        int otherFace = tempEdge2.f1 == faceIndex ? tempEdge2.f2 : tempEdge2.f1;
                        tempFace = f[faceIndex];
                        Vec3 edge1 = v[tempFace.v2].r.minus(v[tempFace.v1].r);
                        Vec3 edge2 = v[tempFace.v3].r.minus(v[tempFace.v1].r);
                        Vec3 edge3 = v[tempFace.v3].r.minus(v[tempFace.v2].r);
                        if (edge1.length2() < 1.0E-20 || edge2.length2() < 1.0E-20 || edge3.length2() < 1.0E-20) continue;
                        edge1.normalize();
                        edge2.normalize();
                        edge3.normalize();
                        if (tempFace.v1 == i) {
                            facenorm[faceIndex * 3] = normals;
                            dot = edge1.dot(edge2);
                        } else if (tempFace.v2 == i) {
                            facenorm[faceIndex * 3 + 1] = normals;
                            dot = -edge1.dot(edge3);
                        } else {
                            facenorm[faceIndex * 3 + 2] = normals;
                            dot = edge2.dot(edge3);
                        }
                        if (dot < -1.0) {
                            dot = -1.0;
                        }
                        if (dot > 1.0) {
                            dot = 1.0;
                        }
                        temp.add(trueNorm[faceIndex].times(Math.acos(dot)));
                        if (otherFace == -1) continue;
                        tempFace = f[otherFace];
                        if (tempFace.v1 == i) {
                            facenorm[otherFace * 3] = normals;
                            continue;
                        }
                        if (tempFace.v2 == i) {
                            facenorm[otherFace * 3 + 1] = normals;
                            continue;
                        }
                        facenorm[otherFace * 3 + 2] = normals;
                    }
                    temp.normalize();
                    norm.addElement(temp);
                    ++normals;
                    continue;
                }
                int first = j = k;
                tempEdge = e[ed[j]];
                do {
                    Vec3 temp = new Vec3();
                    do {
                        double dot;
                        j = (j + 1) % ed.length;
                        int m = tempEdge.f1;
                        tempFace = f[m];
                        if (tempFace.e1 != ed[j] && tempFace.e2 != ed[j] && tempFace.e3 != ed[j]) {
                            m = tempEdge.f2;
                            if (m == -1) continue block2;
                            tempFace = f[m];
                        }
                        Vec3 edge1 = v[tempFace.v2].r.minus(v[tempFace.v1].r);
                        Vec3 edge2 = v[tempFace.v3].r.minus(v[tempFace.v1].r);
                        Vec3 edge3 = v[tempFace.v3].r.minus(v[tempFace.v2].r);
                        edge1.normalize();
                        edge2.normalize();
                        edge3.normalize();
                        if (tempFace.v1 == i) {
                            facenorm[m * 3] = normals;
                            dot = edge1.dot(edge2);
                        } else if (tempFace.v2 == i) {
                            facenorm[m * 3 + 1] = normals;
                            dot = -edge1.dot(edge3);
                        } else {
                            facenorm[m * 3 + 2] = normals;
                            dot = edge2.dot(edge3);
                        }
                        if (dot < -1.0) {
                            dot = -1.0;
                        }
                        if (dot > 1.0) {
                            dot = 1.0;
                        }
                        temp.add(trueNorm[m].times(Math.acos(dot)));
                        tempEdge = e[ed[j]];
                    } while (tempEdge.f2 != -1 && tempEdge.smoothness == 1.0f);
                    last = j;
                    temp.normalize();
                    norm.addElement(temp);
                    ++normals;
                    j = first = last;
                    tempEdge = e[ed[first]];
                } while (last != k);
            }
            normalArray = new Vec3[norm.size()];
            for (i = 0; i < normalArray.length; ++i) {
                normalArray[i] = (Vec3)norm.elementAt(i);
            }
            for (i = 0; i < f.length; ++i) {
                tempFace = mesh.face[i];
                tri[i] = this.texMapping.mapTriangle(tempFace.v1, tempFace.v2, tempFace.v3, facenorm[i * 3], facenorm[i * 3 + 1], facenorm[i * 3 + 2], vert);
            }
        } else {
            normalArray = new Vec3[]{null};
            for (i = 0; i < v.length; ++i) {
                vert[i] = v[i].r;
            }
            for (i = 0; i < f.length; ++i) {
                tri[i] = this.texMapping.mapTriangle(f[i].v1, f[i].v2, f[i].v3, 0, 0, 0, vert);
            }
        }
        RenderingMesh rend = new RenderingMesh(vert, normalArray, tri, this.texMapping, this.matMapping);
        rend.setParameters(mesh.paramValue);
        if (interactive) {
            this.cachedMesh = new SoftReference<RenderingMesh>(rend);
        }
        return rend;
    }

    public void setTexture(Texture tex, TextureMapping mapping) {
        super.setTexture(tex, mapping);
        this.cachedMesh = null;
        this.cachedWire = null;
    }

    public void setMaterial(Material mat, MaterialMapping map) {
        super.setMaterial(mat, map);
        this.cachedMesh = null;
    }

    public void setParameterValues(ParameterValue[] val) {
        super.setParameterValues(val);
        this.cachedMesh = null;
    }

    public void setParameterValue(TextureParameter param, ParameterValue val) {
        super.setParameterValue(param, val);
        this.cachedMesh = null;
    }

    public Skeleton getSkeleton() {
        return this.skeleton;
    }

    public void setSkeleton(Skeleton s) {
        this.skeleton = s;
    }

    private Vertex blend(Vertex v1, Vertex v2, double w1, double w2) {
        return new Vertex(new Vec3(w1 * v1.r.x + w2 * v2.r.x, w1 * v1.r.y + w2 * v2.r.y, w1 * v1.r.z + w2 * v2.r.z));
    }

    private Vertex blend(Vertex v1, Vertex v2, Vertex v3, double w1, double w2, double w3) {
        return new Vertex(new Vec3(w1 * v1.r.x + w2 * v2.r.x + w3 * v3.r.x, w1 * v1.r.y + w2 * v2.r.y + w3 * v3.r.y, w1 * v1.r.z + w2 * v2.r.z + w3 * v3.r.z));
    }

    private static void setBlend(Vertex v, Vertex v1, Vertex v2, double w1, double w2) {
        v.r.set(w1 * v1.r.x + w2 * v2.r.x, w1 * v1.r.y + w2 * v2.r.y, w1 * v1.r.z + w2 * v2.r.z);
    }

    private static void blendIKParams(Vertex newvert, Vertex v1, Vertex v2) {
        if (v1.ikJoint == v2.ikJoint) {
            newvert.ikJoint = v1.ikJoint;
            newvert.ikWeight = 0.5 * (v1.ikWeight + v2.ikWeight);
        } else if (v1.ikWeight > v2.ikWeight) {
            newvert.ikJoint = v1.ikJoint;
            newvert.ikWeight = v1.ikWeight;
        } else {
            newvert.ikJoint = v2.ikJoint;
            newvert.ikWeight = v2.ikWeight;
        }
    }

    private static void blendParamValues(double[][][] oldValues, double[][][] newValues, int[] paramType, int v1, int v2, int newv) {
        for (int i = 0; i < paramType.length; ++i) {
            if (paramType[i] != 1) continue;
            newValues[i][0][newv] = 0.5 * (oldValues[i][0][v1] + oldValues[i][0][v2]);
        }
    }

    private static void setBlendParams(double[] newValues, double[] vert1Val, int v2, double w1, double w2, double[][][] oldVertValues, int[] paramType) {
        for (int i = 0; i < paramType.length; ++i) {
            if (paramType[i] != 1) continue;
            newValues[i] = w1 * vert1Val[i] + w2 * oldVertValues[i][0][v2];
        }
    }

    private static void setBlendParams(double[] newValues, int v1, int v2, double w1, double w2, double[][][] oldVertValues, int[] paramType) {
        for (int i = 0; i < paramType.length; ++i) {
            if (paramType[i] != 1) continue;
            newValues[i] = w1 * oldVertValues[i][0][v1] + w2 * oldVertValues[i][0][v2];
        }
    }

    private static void recordParamValues(double[] values, int v, double[][][] vertValues, int[] paramType) {
        for (int i = 0; i < paramType.length; ++i) {
            if (paramType[i] != 1) continue;
            values[i] = vertValues[i][0][v];
        }
    }

    public static TriangleMesh subdivideEdges(TriangleMesh mesh, boolean[] splitEdge, double tol) {
        if (mesh.smoothingMethod == 2) {
            return TriangleMesh.subdivideButterfly(mesh, splitEdge, tol);
        }
        if (mesh.smoothingMethod == 3) {
            return TriangleMesh.subdivideLoop(mesh, splitEdge, tol);
        }
        return TriangleMesh.subdivideLinear(mesh, splitEdge);
    }

    public static TriangleMesh subdivideLinear(TriangleMesh mesh, boolean[] split) {
        int j;
        int index;
        int i;
        Vertex[] vertex = mesh.vertex;
        Edge[] edge = mesh.edge;
        Face[] face = mesh.face;
        TriangleMesh newmesh = new TriangleMesh();
        if (split == null) {
            split = new boolean[edge.length];
            for (i = 0; i < split.length; ++i) {
                split[i] = true;
            }
        }
        int numVert = vertex.length;
        int numEdge = edge.length;
        int numFace = face.length;
        for (i = 0; i < edge.length; ++i) {
            if (!split[i]) continue;
            ++numVert;
            numEdge += 2;
            ++numFace;
            if (edge[i].f2 == -1) continue;
            ++numEdge;
            ++numFace;
        }
        Vertex[] newvert = new Vertex[numVert];
        Edge[] newedge = new Edge[numEdge];
        Face[] newface = new Face[numFace];
        int[] paramType = new int[mesh.paramValue.length];
        double[][][] newParamValue = new double[mesh.paramValue.length][][];
        double[][][] oldParamValue = new double[mesh.paramValue.length][][];
        for (i = 0; i < mesh.paramValue.length; ++i) {
            if (mesh.paramValue[i] instanceof ConstantParameterValue) {
                paramType[i] = 0;
                continue;
            }
            if (mesh.paramValue[i] instanceof VertexParameterValue) {
                oldParamValue[i] = new double[][]{((VertexParameterValue)mesh.paramValue[i]).getValue()};
                newParamValue[i] = new double[1][numVert];
                paramType[i] = 1;
                continue;
            }
            if (mesh.paramValue[i] instanceof FaceParameterValue) {
                oldParamValue[i] = new double[][]{((FaceParameterValue)mesh.paramValue[i]).getValue()};
                newParamValue[i] = new double[1][numFace];
                paramType[i] = 2;
                continue;
            }
            if (!(mesh.paramValue[i] instanceof FaceVertexParameterValue)) continue;
            FaceVertexParameterValue fvpv = (FaceVertexParameterValue)mesh.paramValue[i];
            oldParamValue[i] = new double[3][fvpv.getFaceCount()];
            for (index = 0; index < fvpv.getFaceCount(); ++index) {
                oldParamValue[i][0][index] = fvpv.getValue(index, 0);
                oldParamValue[i][1][index] = fvpv.getValue(index, 1);
                oldParamValue[i][2][index] = fvpv.getValue(index, 2);
            }
            newParamValue[i] = new double[3][numFace];
            paramType[i] = 3;
        }
        for (i = 0; i < vertex.length; ++i) {
            TriangleMesh triangleMesh = newmesh;
            triangleMesh.getClass();
            newvert[i] = triangleMesh.new Vertex(vertex[i]);
            for (j = 0; j < paramType.length; ++j) {
                if (paramType[j] != 1) continue;
                newParamValue[j][0][i] = oldParamValue[j][0][i];
            }
        }
        for (j = 0; j < edge.length; ++j) {
            if (!split[j]) continue;
            newvert[i] = newmesh.blend(vertex[edge[j].v1], vertex[edge[j].v2], 0.5, 0.5);
            TriangleMesh.blendParamValues(oldParamValue, newParamValue, paramType, edge[j].v1, edge[j].v2, i);
            TriangleMesh.blendIKParams(newvert[i++], vertex[edge[j].v1], vertex[edge[j].v2]);
        }
        TriangleMesh.doSubdivide(newmesh, vertex, edge, face, split, newvert, newedge, newface, oldParamValue, newParamValue, paramType);
        newmesh.copyTextureAndMaterial(mesh);
        for (i = 0; i < paramType.length; ++i) {
            if (paramType[i] == 1) {
                newmesh.paramValue[i] = new VertexParameterValue(newParamValue[i][0]);
                continue;
            }
            if (paramType[i] == 2) {
                newmesh.paramValue[i] = new FaceParameterValue(newParamValue[i][0]);
                continue;
            }
            if (paramType[i] != 3) continue;
            double[][] val = new double[newParamValue[i][0].length][];
            for (index = 0; index < val.length; ++index) {
                val[index] = new double[]{newParamValue[i][0][index], newParamValue[i][1][index], newParamValue[i][2][index]};
            }
            newmesh.paramValue[i] = new FaceVertexParameterValue(val);
        }
        newmesh.vertex = newvert;
        newmesh.edge = newedge;
        newmesh.face = newface;
        newmesh.closed = mesh.closed;
        newmesh.smoothingMethod = mesh.smoothingMethod;
        newmesh.skeleton = mesh.skeleton.duplicate();
        return newmesh;
    }

    public static TriangleMesh subdivideLoop(TriangleMesh mesh, boolean[] refineEdge, double tol) {
        boolean done;
        int i;
        TriangleMesh newmesh;
        Vertex[] vertex = mesh.vertex;
        Edge[] edge = mesh.edge;
        Face[] face = mesh.face;
        TriangleMesh triangleMesh = newmesh = new TriangleMesh();
        triangleMesh.getClass();
        Vertex creasePos = triangleMesh.new Vertex(new Vec3());
        TriangleMesh triangleMesh2 = newmesh;
        triangleMesh2.getClass();
        Vertex smoothPos = triangleMesh2.new Vertex(new Vec3());
        TriangleMesh triangleMesh3 = newmesh;
        triangleMesh3.getClass();
        Vertex temp = triangleMesh3.new Vertex(new Vec3());
        Vec3 finalPos = new Vec3();
        Vec3 tempVec = new Vec3();
        double tol2 = tol * tol;
        if (refineEdge == null) {
            refineEdge = new boolean[edge.length];
            for (i = 0; i < refineEdge.length; ++i) {
                refineEdge[i] = true;
            }
        }
        boolean[] refineVert = new boolean[vertex.length];
        for (i = 0; i < refineEdge.length; ++i) {
            if (!refineEdge[i]) continue;
            refineVert[edge[i].v2] = true;
            refineVert[edge[i].v1] = true;
        }
        int[] paramType = new int[mesh.paramValue.length];
        double[][][] oldParamValue = new double[mesh.paramValue.length][][];
        for (i = 0; i < mesh.paramValue.length; ++i) {
            if (mesh.paramValue[i] instanceof ConstantParameterValue) {
                paramType[i] = 0;
                continue;
            }
            if (mesh.paramValue[i] instanceof VertexParameterValue) {
                oldParamValue[i] = new double[][]{((VertexParameterValue)mesh.paramValue[i]).getValue()};
                paramType[i] = 1;
                continue;
            }
            if (mesh.paramValue[i] instanceof FaceParameterValue) {
                oldParamValue[i] = new double[][]{((FaceParameterValue)mesh.paramValue[i]).getValue()};
                paramType[i] = 2;
                continue;
            }
            if (!(mesh.paramValue[i] instanceof FaceVertexParameterValue)) continue;
            FaceVertexParameterValue fvpv = (FaceVertexParameterValue)mesh.paramValue[i];
            oldParamValue[i] = new double[3][fvpv.getFaceCount()];
            for (int index = 0; index < fvpv.getFaceCount(); ++index) {
                oldParamValue[i][0][index] = fvpv.getValue(index, 0);
                oldParamValue[i][1][index] = fvpv.getValue(index, 1);
                oldParamValue[i][2][index] = fvpv.getValue(index, 2);
            }
            paramType[i] = 3;
        }
        double[] creaseParam = new double[paramType.length];
        double[] smoothParam = new double[paramType.length];
        double[] tempParam = new double[paramType.length];
        double[] finalParam = new double[paramType.length];
        int iterations = 0;
        do {
            Edge tempEdge;
            double s1;
            double smoothWeight;
            double creaseWeight;
            int j;
            done = true;
            boolean[] notconverged = new boolean[vertex.length];
            int numVert = vertex.length;
            int numEdge = edge.length;
            int numFace = face.length;
            for (i = 0; i < edge.length; ++i) {
                if (!refineEdge[i]) continue;
                ++numVert;
                numEdge += 2;
                ++numFace;
                if (edge[i].f2 == -1) continue;
                ++numEdge;
                ++numFace;
            }
            Vertex[] newvert = new Vertex[numVert];
            Edge[] newedge = new Edge[numEdge];
            Face[] newface = new Face[numFace];
            double[][][] newParamValue = new double[paramType.length][][];
            for (i = 0; i < paramType.length; ++i) {
                if (paramType[i] == 1) {
                    newParamValue[i] = new double[1][numVert];
                    continue;
                }
                if (paramType[i] == 2) {
                    newParamValue[i] = new double[1][numFace];
                    continue;
                }
                if (paramType[i] != 3) continue;
                newParamValue[i] = new double[3][numFace];
            }
            double s3 = 0.0;
            double s2 = 0.0;
            for (i = 0; i < vertex.length; ++i) {
                double w1;
                double beta;
                double cornerWeight;
                if (!refineVert[i]) {
                    TriangleMesh triangleMesh4 = newmesh;
                    triangleMesh4.getClass();
                    newvert[i] = triangleMesh4.new Vertex(vertex[i]);
                    for (j = 0; j < paramType.length; ++j) {
                        if (paramType[j] != 1) continue;
                        newParamValue[j][0][i] = oldParamValue[j][0][i];
                    }
                    continue;
                }
                int[] e = vertex[i].getEdges();
                if (edge[e[0]].f2 == -1) {
                    cornerWeight = 1.0 - (double)vertex[i].smoothness;
                    creaseWeight = 1.0 - cornerWeight;
                    smoothWeight = 0.0;
                } else {
                    s2 = s3 = (double)vertex[i].smoothness;
                    s1 = s3;
                    for (j = 0; j < e.length; ++j) {
                        if ((double)edge[e[j]].smoothness < s1) {
                            s3 = s2;
                            s2 = s1;
                            s1 = edge[e[j]].smoothness;
                            continue;
                        }
                        if ((double)edge[e[j]].smoothness < s2) {
                            s3 = s2;
                            s2 = edge[e[j]].smoothness;
                            continue;
                        }
                        if (!((double)edge[e[j]].smoothness < s3)) continue;
                        s3 = edge[e[j]].smoothness;
                    }
                    cornerWeight = 1.0 - s3;
                    creaseWeight = 1.0 - s2 - cornerWeight;
                    smoothWeight = 1.0 - cornerWeight - creaseWeight;
                }
                temp.clear();
                for (j = 0; j < tempParam.length; ++j) {
                    tempParam[j] = 0.0;
                }
                if (e.length < LOOP_BETA.length) {
                    beta = LOOP_BETA[e.length];
                } else {
                    beta = 0.375 + 0.25 * Math.cos(Math.PI * 2 / (double)e.length);
                    beta = (0.625 - beta * beta) / (double)e.length;
                }
                for (j = 0; j < e.length; ++j) {
                    tempEdge = edge[e[j]];
                    if (tempEdge.v1 == i) {
                        TriangleMesh.setBlend(temp, temp, vertex[tempEdge.v2], 1.0, 1.0);
                        TriangleMesh.setBlendParams(tempParam, tempParam, tempEdge.v2, 1.0, 1.0, (double[][][])oldParamValue, paramType);
                        continue;
                    }
                    TriangleMesh.setBlend(temp, temp, vertex[tempEdge.v1], 1.0, 1.0);
                    TriangleMesh.setBlendParams(tempParam, tempParam, tempEdge.v1, 1.0, 1.0, (double[][][])oldParamValue, paramType);
                }
                if (smoothWeight > 0.0) {
                    TriangleMesh.setBlend(smoothPos, vertex[i], temp, beta * (1.0 / beta - (double)e.length), beta);
                    TriangleMesh.setBlendParams(smoothParam, tempParam, i, beta * (1.0 / beta - (double)e.length), beta, (double[][][])oldParamValue, paramType);
                }
                if (edge[e[0]].f2 == -1) {
                    tempEdge = edge[e[0]];
                    if (tempEdge.v1 == i) {
                        TriangleMesh.setBlend(creasePos, vertex[i], vertex[tempEdge.v2], 0.75, 0.125);
                        TriangleMesh.setBlendParams(creaseParam, i, tempEdge.v2, 0.75, 0.125, (double[][][])oldParamValue, paramType);
                    } else {
                        TriangleMesh.setBlend(creasePos, vertex[i], vertex[tempEdge.v1], 0.75, 0.125);
                        TriangleMesh.setBlendParams(creaseParam, i, tempEdge.v1, 0.75, 0.125, (double[][][])oldParamValue, paramType);
                    }
                    tempEdge = edge[e[e.length - 1]];
                    if (tempEdge.v1 == i) {
                        TriangleMesh.setBlend(creasePos, creasePos, vertex[tempEdge.v2], 1.0, 0.125);
                        TriangleMesh.setBlendParams(creaseParam, creaseParam, tempEdge.v2, 1.0, 0.125, (double[][][])oldParamValue, paramType);
                    } else {
                        TriangleMesh.setBlend(creasePos, creasePos, vertex[tempEdge.v1], 1.0, 0.125);
                        TriangleMesh.setBlendParams(creaseParam, creaseParam, tempEdge.v1, 1.0, 0.125, (double[][][])oldParamValue, paramType);
                    }
                } else if (creaseWeight > 0.0) {
                    creasePos.copy(vertex[i]);
                    creasePos.scale(0.75);
                    for (j = 0; j < paramType.length; ++j) {
                        if (paramType[j] != 1) continue;
                        creaseParam[j] = 0.75 * oldParamValue[j][0][i];
                    }
                    for (j = 0; j < e.length; ++j) {
                        tempEdge = edge[e[j]];
                        if (!((double)tempEdge.smoothness < s3)) continue;
                        if (tempEdge.v1 == i) {
                            TriangleMesh.setBlend(creasePos, creasePos, vertex[tempEdge.v2], 1.0, 0.125);
                            TriangleMesh.setBlendParams(creaseParam, creaseParam, tempEdge.v2, 1.0, 0.125, (double[][][])oldParamValue, paramType);
                            continue;
                        }
                        TriangleMesh.setBlend(creasePos, creasePos, vertex[tempEdge.v1], 1.0, 0.125);
                        TriangleMesh.setBlendParams(creaseParam, creaseParam, tempEdge.v1, 1.0, 0.125, (double[][][])oldParamValue, paramType);
                    }
                }
                if (smoothWeight + cornerWeight > 0.0) {
                    beta = 1.0 / (0.375 / beta + (double)e.length);
                    w1 = (smoothWeight + cornerWeight) * beta;
                    double w2 = 1.0 / beta - (double)e.length;
                    finalPos.set(vertex[i].r);
                    finalPos.scale(w2);
                    finalPos.add(temp.r);
                    finalPos.scale(w1);
                    for (j = 0; j < paramType.length; ++j) {
                        if (paramType[j] != 1) continue;
                        finalParam[j] = w1 * (tempParam[j] + w2 * oldParamValue[j][0][i]);
                    }
                } else {
                    finalPos.set(0.0, 0.0, 0.0);
                    for (j = 0; j < paramType.length; ++j) {
                        finalParam[j] = 0.0;
                    }
                }
                if (creaseWeight > 0.0) {
                    w1 = creaseWeight / 3.0;
                    tempVec.set(creasePos.r);
                    tempVec.scale(4.0);
                    tempVec.subtract(vertex[i].r);
                    tempVec.scale(w1);
                    finalPos.add(tempVec);
                    for (j = 0; j < paramType.length; ++j) {
                        if (paramType[j] != 1) continue;
                        int n = j;
                        finalParam[n] = finalParam[n] + w1 * (4.0 * creaseParam[j] - oldParamValue[j][0][i]);
                    }
                }
                newvert[i] = newmesh.blend(vertex[i], creasePos, smoothPos, cornerWeight, creaseWeight, smoothWeight);
                newvert[i].smoothness = Math.min(2.0f * vertex[i].smoothness, 1.0f);
                newvert[i].ikJoint = vertex[i].ikJoint;
                newvert[i].ikWeight = vertex[i].ikWeight;
                for (j = 0; j < paramType.length; ++j) {
                    if (paramType[j] != 1) continue;
                    newParamValue[j][0][i] = finalParam[j];
                }
                finalPos.subtract(newvert[i].r);
                double error = finalPos.length2();
                if (!(error > tol2)) continue;
                notconverged[i] = true;
                done = false;
            }
            j = vertex.length;
            for (i = 0; i < edge.length; ++i) {
                int pm;
                if (!refineEdge[i]) continue;
                tempEdge = edge[i];
                TriangleMesh.setBlend(creasePos, vertex[tempEdge.v1], vertex[tempEdge.v2], 1.0, 1.0);
                for (pm = 0; pm < paramType.length; ++pm) {
                    if (paramType[pm] != 1) continue;
                    creaseParam[pm] = oldParamValue[pm][0][tempEdge.v1] + oldParamValue[pm][0][tempEdge.v2];
                }
                if (tempEdge.f2 == -1 || tempEdge.smoothness == 0.0f) {
                    TriangleMesh triangleMesh5 = newmesh;
                    triangleMesh5.getClass();
                    newvert[j] = triangleMesh5.new Vertex(creasePos);
                    newvert[j].scale(0.5);
                    for (pm = 0; pm < paramType.length; ++pm) {
                        if (paramType[pm] != 1) continue;
                        newParamValue[pm][0][j] = 0.5 * creaseParam[pm];
                    }
                } else {
                    Face tempFace = face[tempEdge.f1];
                    if (tempFace.e1 == i) {
                        smoothPos.copy(vertex[tempFace.v3]);
                        TriangleMesh.recordParamValues(smoothParam, tempFace.v3, oldParamValue, paramType);
                    } else if (tempFace.e2 == i) {
                        smoothPos.copy(vertex[tempFace.v1]);
                        TriangleMesh.recordParamValues(smoothParam, tempFace.v1, oldParamValue, paramType);
                    } else {
                        smoothPos.copy(vertex[tempFace.v2]);
                        TriangleMesh.recordParamValues(smoothParam, tempFace.v2, oldParamValue, paramType);
                    }
                    tempFace = face[tempEdge.f2];
                    if (tempFace.e1 == i) {
                        TriangleMesh.setBlend(smoothPos, smoothPos, vertex[tempFace.v3], 1.0, 1.0);
                        TriangleMesh.setBlendParams(smoothParam, smoothParam, tempFace.v3, 1.0, 1.0, (double[][][])oldParamValue, paramType);
                    } else if (tempFace.e2 == i) {
                        TriangleMesh.setBlend(smoothPos, smoothPos, vertex[tempFace.v1], 1.0, 1.0);
                        TriangleMesh.setBlendParams(smoothParam, smoothParam, tempFace.v1, 1.0, 1.0, (double[][][])oldParamValue, paramType);
                    } else {
                        TriangleMesh.setBlend(smoothPos, smoothPos, vertex[tempFace.v2], 1.0, 1.0);
                        TriangleMesh.setBlendParams(smoothParam, smoothParam, tempFace.v2, 1.0, 1.0, (double[][][])oldParamValue, paramType);
                    }
                    s1 = 1.0 - (double)tempEdge.smoothness;
                    creaseWeight = 0.125 * s1 + 0.375;
                    smoothWeight = 0.125 * (1.0 - s1);
                    newvert[j] = newmesh.blend(creasePos, smoothPos, creaseWeight, smoothWeight);
                    for (pm = 0; pm < paramType.length; ++pm) {
                        if (paramType[pm] != 1) continue;
                        newParamValue[pm][0][j] = creaseWeight * creaseParam[pm] + smoothWeight * smoothParam[pm];
                    }
                }
                newvert[j].smoothness = 1.0f;
                TriangleMesh.blendIKParams(newvert[j], vertex[tempEdge.v1], vertex[tempEdge.v2]);
                ++j;
            }
            TriangleMesh.doSubdivide(newmesh, vertex, edge, face, refineEdge, newvert, newedge, newface, oldParamValue, newParamValue, paramType);
            if (!done) {
                refineVert = new boolean[newvert.length];
                refineEdge = new boolean[newedge.length];
                for (i = 0; i < newedge.length; ++i) {
                    if (newedge[i].v1 >= notconverged.length || !notconverged[newedge[i].v1]) continue;
                    refineVert[newedge[i].v2] = true;
                    refineVert[newedge[i].v1] = true;
                }
                for (i = 0; i < newedge.length; ++i) {
                    if (!refineVert[newedge[i].v1] && !refineVert[newedge[i].v2] || !(newvert[newedge[i].v1].r.distance2(newvert[newedge[i].v2].r) > tol2)) continue;
                    refineEdge[i] = true;
                }
            }
            vertex = newvert;
            newmesh.vertex = newvert;
            edge = newedge;
            newmesh.edge = newedge;
            face = newface;
            newmesh.face = newface;
            oldParamValue = newParamValue;
            newmesh.copyTextureAndMaterial(mesh);
            for (i = 0; i < newedge.length; ++i) {
                newedge[i].smoothness = Math.min(2.0f * newedge[i].smoothness, 1.0f);
            }
            for (i = 0; i < paramType.length; ++i) {
                if (paramType[i] == 1) {
                    newmesh.paramValue[i] = new VertexParameterValue(newParamValue[i][0]);
                    continue;
                }
                if (paramType[i] == 2) {
                    newmesh.paramValue[i] = new FaceParameterValue(newParamValue[i][0]);
                    continue;
                }
                if (paramType[i] != 3) continue;
                double[][] val = new double[newParamValue[i][0].length][];
                for (int index = 0; index < val.length; ++index) {
                    val[index] = new double[]{newParamValue[i][0][index], newParamValue[i][1][index], newParamValue[i][2][index]};
                }
                newmesh.paramValue[i] = new FaceVertexParameterValue(val);
            }
        } while (!done && ++iterations < 20);
        newmesh.closed = mesh.closed;
        newmesh.smoothingMethod = mesh.smoothingMethod;
        newmesh.skeleton = mesh.skeleton.duplicate();
        return newmesh;
    }

    public static TriangleMesh subdivideButterfly(TriangleMesh mesh, boolean[] refineEdge, double tol) {
        boolean done;
        int i;
        TriangleMesh newmesh;
        Vertex[] vertex = mesh.vertex;
        Edge[] edge = mesh.edge;
        Face[] face = mesh.face;
        TriangleMesh triangleMesh = newmesh = new TriangleMesh();
        triangleMesh.getClass();
        Vertex creasePos = triangleMesh.new Vertex(new Vec3());
        TriangleMesh triangleMesh2 = newmesh;
        triangleMesh2.getClass();
        Vertex smoothPos = triangleMesh2.new Vertex(new Vec3());
        TriangleMesh triangleMesh3 = newmesh;
        triangleMesh3.getClass();
        Vertex cornerPos = triangleMesh3.new Vertex(new Vec3());
        TriangleMesh triangleMesh4 = newmesh;
        triangleMesh4.getClass();
        Vertex temp = triangleMesh4.new Vertex(new Vec3());
        Vec3 axis = new Vec3();
        Vec3 tempVec = new Vec3();
        double tol2 = tol * tol * 9.0;
        if (refineEdge == null) {
            refineEdge = new boolean[edge.length];
            for (i = 0; i < refineEdge.length; ++i) {
                refineEdge[i] = true;
            }
        }
        int[] paramType = new int[mesh.paramValue.length];
        double[][][] oldParamValue = new double[mesh.paramValue.length][][];
        for (i = 0; i < mesh.paramValue.length; ++i) {
            if (mesh.paramValue[i] instanceof ConstantParameterValue) {
                paramType[i] = 0;
                continue;
            }
            if (mesh.paramValue[i] instanceof VertexParameterValue) {
                oldParamValue[i] = new double[][]{((VertexParameterValue)mesh.paramValue[i]).getValue()};
                paramType[i] = 1;
                continue;
            }
            if (mesh.paramValue[i] instanceof FaceParameterValue) {
                oldParamValue[i] = new double[][]{((FaceParameterValue)mesh.paramValue[i]).getValue()};
                paramType[i] = 2;
                continue;
            }
            if (!(mesh.paramValue[i] instanceof FaceVertexParameterValue)) continue;
            FaceVertexParameterValue fvpv = (FaceVertexParameterValue)mesh.paramValue[i];
            oldParamValue[i] = new double[3][fvpv.getFaceCount()];
            for (int index = 0; index < fvpv.getFaceCount(); ++index) {
                oldParamValue[i][0][index] = fvpv.getValue(index, 0);
                oldParamValue[i][1][index] = fvpv.getValue(index, 1);
                oldParamValue[i][2][index] = fvpv.getValue(index, 2);
            }
            paramType[i] = 3;
        }
        double[] creaseParam = new double[paramType.length];
        double[] smoothParam = new double[paramType.length];
        double[] cornerParam = new double[paramType.length];
        double[] tempParam = new double[paramType.length];
        boolean[] refineVert = new boolean[vertex.length];
        for (i = 0; i < refineEdge.length; ++i) {
            if (!refineEdge[i]) continue;
            refineVert[edge[i].v2] = true;
            refineVert[edge[i].v1] = true;
        }
        int iterations = 0;
        do {
            int j;
            int[] e;
            double s1;
            done = true;
            boolean[] notconverged = new boolean[edge.length];
            int numVert = vertex.length;
            int numEdge = edge.length;
            int numFace = face.length;
            for (i = 0; i < edge.length; ++i) {
                if (!refineEdge[i]) continue;
                ++numVert;
                numEdge += 2;
                ++numFace;
                if (edge[i].f2 == -1) continue;
                ++numEdge;
                ++numFace;
            }
            Vertex[] newvert = new Vertex[numVert];
            Edge[] newedge = new Edge[numEdge];
            Face[] newface = new Face[numFace];
            double[][][] newParamValue = new double[paramType.length][][];
            for (i = 0; i < paramType.length; ++i) {
                if (paramType[i] == 1) {
                    newParamValue[i] = new double[1][numVert];
                    continue;
                }
                if (paramType[i] == 2) {
                    newParamValue[i] = new double[1][numFace];
                    continue;
                }
                if (paramType[i] != 3) continue;
                newParamValue[i] = new double[3][numFace];
            }
            int[][] vertEdge = new int[vertex.length][];
            for (i = 0; i < vertex.length; ++i) {
                vertEdge[i] = vertex[i].getEdges();
            }
            double[] s2 = new double[vertex.length];
            double[] s3 = new double[vertex.length];
            for (i = 0; i < vertex.length; ++i) {
                s3[i] = 1.0;
                s2[i] = 1.0;
                s1 = 1.0;
                e = vertEdge[i];
                for (j = 0; j < e.length; ++j) {
                    if (edge[e[j]].f2 == -1) {
                        s3[i] = s2[i];
                        s2[i] = s1;
                        s1 = 0.0;
                        continue;
                    }
                    if ((double)edge[e[j]].smoothness < s1) {
                        s3[i] = s2[i];
                        s2[i] = s1;
                        s1 = edge[e[j]].smoothness;
                        continue;
                    }
                    if ((double)edge[e[j]].smoothness < s2[i]) {
                        s3[i] = s2[i];
                        s2[i] = edge[e[j]].smoothness;
                        continue;
                    }
                    if (!((double)edge[e[j]].smoothness < s3[i])) continue;
                    s3[i] = edge[e[j]].smoothness;
                }
            }
            double[] edgeSmoothness = new double[edge.length];
            for (i = 0; i < edge.length; ++i) {
                edgeSmoothness[i] = edge[i].f2 == -1 ? 0.0 : (double)edge[i].smoothness;
            }
            double[] vertSmoothness = new double[vertex.length];
            boolean[] regular = new boolean[vertex.length];
            for (i = 0; i < vertex.length; ++i) {
                vertSmoothness[i] = Math.min((double)vertex[i].smoothness, s3[i]);
                regular[i] = vertEdge[i].length == 6 || s2[i] < s3[i];
                TriangleMesh triangleMesh5 = newmesh;
                triangleMesh5.getClass();
                newvert[i] = triangleMesh5.new Vertex(vertex[i]);
                newvert[i].smoothness = Math.min(2.0f * vertex[i].smoothness, 1.0f);
                for (j = 0; j < paramType.length; ++j) {
                    if (paramType[j] != 1) continue;
                    newParamValue[j][0][i] = oldParamValue[j][0][i];
                }
            }
            j = vertex.length;
            for (i = 0; i < edge.length; ++i) {
                int whichVert;
                int k;
                if (!refineEdge[i]) continue;
                Edge tempEdge = edge[i];
                int v1 = tempEdge.v1;
                int v2 = tempEdge.v2;
                double cornerWeight = 1.0 - Math.min(vertSmoothness[v1], vertSmoothness[v2]);
                double creaseWeight = tempEdge.f2 == -1 ? 1.0 - cornerWeight : Math.max(1.0 - edgeSmoothness[i] - cornerWeight, 0.0);
                double smoothWeight = 1.0 - cornerWeight - creaseWeight;
                TriangleMesh.setBlend(cornerPos, vertex[v1], vertex[v2], 0.5, 0.5);
                TriangleMesh.setBlendParams(cornerParam, v1, v2, 0.5, 0.5, (double[][][])oldParamValue, paramType);
                if (creaseWeight > 0.0) {
                    double w1;
                    double w2;
                    creasePos.copy(vertex[v1]);
                    TriangleMesh.recordParamValues(creaseParam, v1, oldParamValue, paramType);
                    if (s2[v1] < 1.0) {
                        e = vertEdge[v1];
                        if (tempEdge.f2 == -1) {
                            k = e[0] == i ? e.length - 1 : 0;
                        } else {
                            k = 0;
                            while (e[k] == i || edgeSmoothness[e[k]] > s2[v1]) {
                                ++k;
                            }
                        }
                        whichVert = edge[e[k]].v1 == v1 ? edge[e[k]].v2 : edge[e[k]].v1;
                        w2 = -0.125 * (double)vertex[v1].smoothness;
                        w1 = 1.0 - w2;
                        TriangleMesh.setBlend(creasePos, creasePos, vertex[whichVert], w1, w2);
                        TriangleMesh.setBlendParams(creaseParam, creaseParam, whichVert, w1, w2, (double[][][])oldParamValue, paramType);
                    }
                    temp.copy(vertex[v2]);
                    TriangleMesh.recordParamValues(tempParam, v2, oldParamValue, paramType);
                    if (s2[v2] < 1.0) {
                        e = vertEdge[v2];
                        if (tempEdge.f2 == -1) {
                            k = e[0] == i ? e.length - 1 : 0;
                        } else {
                            k = 0;
                            while (e[k] == i || edgeSmoothness[e[k]] > s2[v2]) {
                                ++k;
                            }
                        }
                        whichVert = edge[e[k]].v1 == v2 ? edge[e[k]].v2 : edge[e[k]].v1;
                        w2 = -0.125 * (double)vertex[v2].smoothness;
                        w1 = 1.0 - w2;
                        TriangleMesh.setBlend(temp, temp, vertex[whichVert], w1, w2);
                        TriangleMesh.setBlendParams(tempParam, tempParam, whichVert, w1, w2, (double[][][])oldParamValue, paramType);
                    }
                    TriangleMesh.setBlend(creasePos, creasePos, temp, 0.5, 0.5);
                    for (k = 0; k < paramType.length; ++k) {
                        if (paramType[k] != 1) continue;
                        creaseParam[k] = 0.5 * (creaseParam[k] + tempParam[k]);
                    }
                }
                if (smoothWeight > 0.0) {
                    if (regular[v1] && regular[v2]) {
                        int e3;
                        int e2;
                        int v3;
                        smoothPos.copy(cornerPos);
                        for (k = 0; k < smoothParam.length; ++k) {
                            smoothParam[k] = cornerParam[k];
                        }
                        Face tempFace = face[tempEdge.f1];
                        if (tempFace.e1 == i) {
                            v3 = tempFace.v3;
                            e2 = tempFace.e2;
                            e3 = tempFace.e3;
                        } else if (tempFace.e2 == i) {
                            v3 = tempFace.v1;
                            e2 = tempFace.e3;
                            e3 = tempFace.e1;
                        } else {
                            v3 = tempFace.v2;
                            e2 = tempFace.e1;
                            e3 = tempFace.e2;
                        }
                        TriangleMesh.setBlend(smoothPos, smoothPos, vertex[v3], 1.0, 0.125);
                        TriangleMesh.setBlendParams(smoothParam, smoothParam, v3, 1.0, 0.125, (double[][][])oldParamValue, paramType);
                        TriangleMesh.findOppositeVertex(temp, tempEdge.f1, e2, edgeSmoothness[e2], vertex, edge, face, tempParam, oldParamValue, paramType);
                        TriangleMesh.setBlend(smoothPos, smoothPos, temp, 1.0, -0.0625);
                        for (k = 0; k < paramType.length; ++k) {
                            if (paramType[k] != 1) continue;
                            int n = k;
                            smoothParam[n] = smoothParam[n] - 0.0625 * tempParam[k];
                        }
                        TriangleMesh.findOppositeVertex(temp, tempEdge.f1, e3, edgeSmoothness[e3], vertex, edge, face, tempParam, oldParamValue, paramType);
                        TriangleMesh.setBlend(smoothPos, smoothPos, temp, 1.0, -0.0625);
                        for (k = 0; k < paramType.length; ++k) {
                            if (paramType[k] != 1) continue;
                            int n = k;
                            smoothParam[n] = smoothParam[n] - 0.0625 * tempParam[k];
                        }
                        tempFace = face[tempEdge.f2];
                        if (tempFace.e1 == i) {
                            v3 = tempFace.v3;
                            e2 = tempFace.e2;
                            e3 = tempFace.e3;
                        } else if (tempFace.e2 == i) {
                            v3 = tempFace.v1;
                            e2 = tempFace.e3;
                            e3 = tempFace.e1;
                        } else {
                            v3 = tempFace.v2;
                            e2 = tempFace.e1;
                            e3 = tempFace.e2;
                        }
                        TriangleMesh.setBlend(smoothPos, smoothPos, vertex[v3], 1.0, 0.125);
                        TriangleMesh.setBlendParams(smoothParam, smoothParam, v3, 1.0, 0.125, (double[][][])oldParamValue, paramType);
                        TriangleMesh.findOppositeVertex(temp, tempEdge.f2, e2, edgeSmoothness[e2], vertex, edge, face, tempParam, oldParamValue, paramType);
                        TriangleMesh.setBlend(smoothPos, smoothPos, temp, 1.0, -0.0625);
                        for (k = 0; k < paramType.length; ++k) {
                            if (paramType[k] != 1) continue;
                            int n = k;
                            smoothParam[n] = smoothParam[n] - 0.0625 * tempParam[k];
                        }
                        TriangleMesh.findOppositeVertex(temp, tempEdge.f2, e3, edgeSmoothness[e3], vertex, edge, face, tempParam, oldParamValue, paramType);
                        TriangleMesh.setBlend(smoothPos, smoothPos, temp, 1.0, -0.0625);
                        for (k = 0; k < paramType.length; ++k) {
                            if (paramType[k] != 1) continue;
                            int n = k;
                            smoothParam[n] = smoothParam[n] - 0.0625 * tempParam[k];
                        }
                    } else {
                        int n;
                        double[] coeff;
                        smoothPos.clear();
                        for (k = 0; k < smoothParam.length; ++k) {
                            smoothParam[k] = 0.0;
                        }
                        if (!regular[v1]) {
                            e = vertEdge[v1];
                            coeff = TriangleMesh.getButterflyCoeff(e.length);
                            n = 0;
                            while (e[n] != i) {
                                ++n;
                            }
                            for (k = 0; k < e.length; ++k) {
                                tempEdge = edge[e[(n + k) % e.length]];
                                whichVert = tempEdge.v1 == v1 ? tempEdge.v2 : tempEdge.v1;
                                TriangleMesh.setBlend(smoothPos, smoothPos, vertex[whichVert], 1.0, coeff[k]);
                                TriangleMesh.setBlendParams(smoothParam, smoothParam, whichVert, 1.0, coeff[k], (double[][][])oldParamValue, paramType);
                            }
                            TriangleMesh.setBlend(smoothPos, smoothPos, vertex[v1], 1.0, coeff[k]);
                            TriangleMesh.setBlendParams(smoothParam, smoothParam, v1, 1.0, coeff[k], (double[][][])oldParamValue, paramType);
                        }
                        if (!regular[v2]) {
                            e = vertEdge[v2];
                            coeff = TriangleMesh.getButterflyCoeff(e.length);
                            n = 0;
                            while (e[n] != i) {
                                ++n;
                            }
                            for (k = 0; k < e.length; ++k) {
                                tempEdge = edge[e[(n + k) % e.length]];
                                whichVert = tempEdge.v1 == v2 ? tempEdge.v2 : tempEdge.v1;
                                TriangleMesh.setBlend(smoothPos, smoothPos, vertex[whichVert], 1.0, coeff[k]);
                                TriangleMesh.setBlendParams(smoothParam, smoothParam, whichVert, 1.0, coeff[k], (double[][][])oldParamValue, paramType);
                            }
                            TriangleMesh.setBlend(smoothPos, smoothPos, vertex[v2], 1.0, coeff[k]);
                            TriangleMesh.setBlendParams(smoothParam, smoothParam, v2, 1.0, coeff[k], (double[][][])oldParamValue, paramType);
                        }
                        if (!regular[v1] && !regular[v2]) {
                            smoothPos.scale(0.5);
                            k = 0;
                            while (k < smoothParam.length) {
                                int n2 = k++;
                                smoothParam[n2] = smoothParam[n2] * 0.5;
                            }
                        }
                    }
                }
                newvert[j] = newmesh.blend(cornerPos, creasePos, smoothPos, cornerWeight, creaseWeight, smoothWeight);
                for (k = 0; k < paramType.length; ++k) {
                    if (paramType[k] != 1) continue;
                    newParamValue[k][0][j] = cornerWeight * cornerParam[k] + creaseWeight * creaseParam[k] + smoothWeight * smoothParam[k];
                }
                TriangleMesh.blendIKParams(newvert[j], vertex[tempEdge.v1], vertex[tempEdge.v2]);
                axis.set(vertex[v2].r);
                axis.subtract(vertex[v1].r);
                axis.normalize();
                tempVec.set(newvert[++j - 1].r);
                tempVec.subtract(vertex[v1].r);
                s1 = tempVec.dot(axis);
                axis.scale(s1);
                tempVec.subtract(axis);
                double error = tempVec.length2();
                if (!(error > tol2)) continue;
                notconverged[i] = true;
                done = false;
            }
            TriangleMesh.doSubdivide(newmesh, vertex, edge, face, refineEdge, newvert, newedge, newface, oldParamValue, newParamValue, paramType);
            if (!done) {
                refineVert = new boolean[newvert.length];
                refineEdge = new boolean[newedge.length];
                for (i = 0; i < edge.length; ++i) {
                    if (!notconverged[i]) continue;
                    refineVert[newedge[i].v2] = true;
                    refineVert[edge[i].v2] = true;
                    refineVert[edge[i].v1] = true;
                }
                for (i = 0; i < newedge.length; ++i) {
                    if (!refineVert[newedge[i].v1] && !refineVert[newedge[i].v2] || !(newvert[newedge[i].v1].r.distance2(newvert[newedge[i].v2].r) > tol2)) continue;
                    refineEdge[i] = true;
                }
            }
            vertex = newvert;
            newmesh.vertex = newvert;
            edge = newedge;
            newmesh.edge = newedge;
            face = newface;
            newmesh.face = newface;
            oldParamValue = newParamValue;
            newmesh.copyTextureAndMaterial(mesh);
            for (i = 0; i < newedge.length; ++i) {
                newedge[i].smoothness = Math.min(2.0f * newedge[i].smoothness, 1.0f);
            }
            for (i = 0; i < paramType.length; ++i) {
                if (paramType[i] == 1) {
                    newmesh.paramValue[i] = new VertexParameterValue(newParamValue[i][0]);
                    continue;
                }
                if (paramType[i] == 2) {
                    newmesh.paramValue[i] = new FaceParameterValue(newParamValue[i][0]);
                    continue;
                }
                if (paramType[i] != 3) continue;
                double[][] val = new double[newParamValue[i][0].length][];
                for (int index = 0; index < val.length; ++index) {
                    val[index] = new double[]{newParamValue[i][0][index], newParamValue[i][1][index], newParamValue[i][2][index]};
                }
                newmesh.paramValue[i] = new FaceVertexParameterValue(val);
            }
        } while (!done && ++iterations < 20);
        newmesh.closed = mesh.closed;
        newmesh.smoothingMethod = mesh.smoothingMethod;
        newmesh.skeleton = mesh.skeleton.duplicate();
        return newmesh;
    }

    private static void findOppositeVertex(Vertex pos, int whichFace, int whichEdge, double smoothWeight, Vertex[] v, Edge[] e, Face[] f, double[] paramVal, double[][][] oldParamValue, int[] paramType) {
        Face fc;
        if (smoothWeight > 0.0) {
            fc = e[whichEdge].f1 == whichFace ? f[e[whichEdge].f2] : f[e[whichEdge].f1];
            if (fc.e1 == whichEdge) {
                pos.copy(v[fc.v3]);
                TriangleMesh.recordParamValues(paramVal, fc.v3, oldParamValue, paramType);
            } else if (fc.e2 == whichEdge) {
                pos.copy(v[fc.v1]);
                TriangleMesh.recordParamValues(paramVal, fc.v1, oldParamValue, paramType);
            } else {
                pos.copy(v[fc.v2]);
                TriangleMesh.recordParamValues(paramVal, fc.v2, oldParamValue, paramType);
            }
            pos.scale(smoothWeight);
            int i = 0;
            while (i < paramVal.length) {
                int n = i++;
                paramVal[n] = paramVal[n] * smoothWeight;
            }
        } else {
            pos.clear();
            for (int i = 0; i < paramVal.length; ++i) {
                paramVal[i] = 0.0;
            }
        }
        if (smoothWeight < 1.0) {
            Vec3 axis = v[e[whichEdge].v1].r.minus(v[e[whichEdge].v2].r);
            axis.normalize();
            fc = f[whichFace];
            Vec3 r = fc.e1 == whichEdge ? v[fc.v3].r : (fc.e2 == whichEdge ? v[fc.v1].r : v[fc.v2].r);
            Vec3 delta = r.minus(v[e[whichEdge].v2].r);
            double dot = delta.dot(axis);
            axis.scale(dot);
            delta.subtract(axis);
            pos.r.x += (1.0 - smoothWeight) * (r.x + axis.x - 2.0 * delta.x);
            pos.r.y += (1.0 - smoothWeight) * (r.y + axis.y - 2.0 * delta.y);
            pos.r.z += (1.0 - smoothWeight) * (r.z + axis.z - 2.0 * delta.z);
        }
    }

    private static double[] getButterflyCoeff(int numEdges) {
        if (numEdges < BUTTERFLY_COEFF.length) {
            return BUTTERFLY_COEFF[numEdges];
        }
        double[] coeff = new double[numEdges + 1];
        double beta = Math.PI * 2 / (double)numEdges;
        coeff[numEdges] = 1.0;
        for (int i = 0; i < numEdges; ++i) {
            coeff[i] = (0.25 + Math.cos(beta * (double)i) + 0.5 * Math.cos(2.0 * beta * (double)i)) / (double)numEdges;
            int n = numEdges;
            coeff[n] = coeff[n] - coeff[i];
        }
        return coeff;
    }

    private static void doSubdivide(TriangleMesh mesh, Vertex[] vertex, Edge[] edge, Face[] face, boolean[] split, Vertex[] newvert, Edge[] newedge, Face[] newface, double[][][] oldParamValue, double[][][] newParamValue, int[] paramType) {
        Face tempFace;
        int v2;
        int v1;
        int i;
        int[] newEdgeIndex = new int[edge.length];
        int j = edge.length;
        int k = vertex.length;
        for (i = 0; i < edge.length; ++i) {
            Edge tempEdge = edge[i];
            v1 = tempEdge.v1;
            v2 = tempEdge.v2;
            if (!split[i]) {
                TriangleMesh triangleMesh = mesh;
                triangleMesh.getClass();
                newedge[i] = triangleMesh.new Edge(v1, v2, -1);
                newedge[i].smoothness = tempEdge.smoothness;
                if (vertex[v1].firstEdge == i) {
                    newvert[v1].firstEdge = i;
                }
                if (vertex[v2].firstEdge == i) {
                    newvert[v2].firstEdge = i;
                }
                newEdgeIndex[i] = i;
                continue;
            }
            TriangleMesh triangleMesh = mesh;
            triangleMesh.getClass();
            newedge[i] = triangleMesh.new Edge(v1, k, -1);
            TriangleMesh triangleMesh2 = mesh;
            triangleMesh2.getClass();
            newedge[j] = triangleMesh2.new Edge(v2, k, -1);
            newedge[i].smoothness = newedge[j].smoothness = tempEdge.smoothness;
            if (vertex[v1].firstEdge == i) {
                newvert[v1].firstEdge = i;
            }
            if (vertex[v2].firstEdge == i) {
                newvert[v2].firstEdge = j;
            }
            newvert[k].firstEdge = i;
            newEdgeIndex[i] = j++;
            ++k;
        }
        int[] addedFace = new int[4];
        k = face.length;
        for (i = 0; i < face.length; ++i) {
            int e3;
            int e2;
            int e1;
            int v3;
            int n;
            tempFace = face[i];
            if (split[tempFace.e1]) {
                if (split[tempFace.e2]) {
                    if (split[tempFace.e3]) {
                        n = 3;
                        v1 = tempFace.v1;
                        v2 = tempFace.v2;
                        v3 = tempFace.v3;
                        e1 = tempFace.e1;
                        e2 = tempFace.e2;
                        e3 = tempFace.e3;
                    } else {
                        n = 2;
                        v1 = tempFace.v1;
                        v2 = tempFace.v2;
                        v3 = tempFace.v3;
                        e1 = tempFace.e1;
                        e2 = tempFace.e2;
                        e3 = tempFace.e3;
                    }
                } else if (split[tempFace.e3]) {
                    n = 2;
                    v1 = tempFace.v3;
                    v2 = tempFace.v1;
                    v3 = tempFace.v2;
                    e1 = tempFace.e3;
                    e2 = tempFace.e1;
                    e3 = tempFace.e2;
                } else {
                    n = 1;
                    v1 = tempFace.v1;
                    v2 = tempFace.v2;
                    v3 = tempFace.v3;
                    e1 = tempFace.e1;
                    e2 = tempFace.e2;
                    e3 = tempFace.e3;
                }
            } else if (split[tempFace.e2]) {
                if (split[tempFace.e3]) {
                    n = 2;
                    v1 = tempFace.v2;
                    v2 = tempFace.v3;
                    v3 = tempFace.v1;
                    e1 = tempFace.e2;
                    e2 = tempFace.e3;
                    e3 = tempFace.e1;
                } else {
                    n = 1;
                    v1 = tempFace.v2;
                    v2 = tempFace.v3;
                    v3 = tempFace.v1;
                    e1 = tempFace.e2;
                    e2 = tempFace.e3;
                    e3 = tempFace.e1;
                }
            } else if (split[tempFace.e3]) {
                n = 1;
                v1 = tempFace.v3;
                v2 = tempFace.v1;
                v3 = tempFace.v2;
                e1 = tempFace.e3;
                e2 = tempFace.e1;
                e3 = tempFace.e2;
            } else {
                n = 0;
                v1 = tempFace.v1;
                v2 = tempFace.v2;
                v3 = tempFace.v3;
                e1 = tempFace.e1;
                e2 = tempFace.e2;
                e3 = tempFace.e3;
            }
            switch (n) {
                case 0: {
                    TriangleMesh triangleMesh = mesh;
                    triangleMesh.getClass();
                    newface[i] = triangleMesh.new Face(v1, v2, v3, e1, e2, e3);
                    break;
                }
                case 1: {
                    TriangleMesh triangleMesh = mesh;
                    triangleMesh.getClass();
                    newedge[j] = triangleMesh.new Edge(v3, newedge[e1].v2, -1);
                    if (edge[e1].v1 == v1) {
                        TriangleMesh triangleMesh3 = mesh;
                        triangleMesh3.getClass();
                        newface[i] = triangleMesh3.new Face(v1, newedge[e1].v2, v3, e1, j, e3);
                        TriangleMesh triangleMesh4 = mesh;
                        triangleMesh4.getClass();
                        newface[k] = triangleMesh4.new Face(v3, newedge[e1].v2, v2, j, newEdgeIndex[e1], e2);
                        break;
                    }
                    TriangleMesh triangleMesh5 = mesh;
                    triangleMesh5.getClass();
                    newface[i] = triangleMesh5.new Face(v1, newedge[e1].v2, v3, newEdgeIndex[e1], j, e3);
                    TriangleMesh triangleMesh6 = mesh;
                    triangleMesh6.getClass();
                    newface[k] = triangleMesh6.new Face(v3, newedge[e1].v2, v2, j, e1, e2);
                    break;
                }
                case 2: {
                    TriangleMesh triangleMesh = mesh;
                    triangleMesh.getClass();
                    newedge[j] = triangleMesh.new Edge(newedge[e1].v2, newedge[e2].v2, -1);
                    TriangleMesh triangleMesh7 = mesh;
                    triangleMesh7.getClass();
                    newedge[j + 1] = triangleMesh7.new Edge(v3, newedge[e1].v2, -1);
                    if (edge[e1].v1 == v1) {
                        if (edge[e2].v1 == v2) {
                            TriangleMesh triangleMesh8 = mesh;
                            triangleMesh8.getClass();
                            newface[i] = triangleMesh8.new Face(v1, newedge[e1].v2, v3, e1, j + 1, e3);
                            TriangleMesh triangleMesh9 = mesh;
                            triangleMesh9.getClass();
                            newface[k] = triangleMesh9.new Face(v3, newedge[e1].v2, newedge[e2].v2, j + 1, j, newEdgeIndex[e2]);
                            TriangleMesh triangleMesh10 = mesh;
                            triangleMesh10.getClass();
                            newface[k + 1] = triangleMesh10.new Face(newedge[e2].v2, newedge[e1].v2, v2, j, newEdgeIndex[e1], e2);
                            break;
                        }
                        TriangleMesh triangleMesh11 = mesh;
                        triangleMesh11.getClass();
                        newface[i] = triangleMesh11.new Face(v1, newedge[e1].v2, v3, e1, j + 1, e3);
                        TriangleMesh triangleMesh12 = mesh;
                        triangleMesh12.getClass();
                        newface[k] = triangleMesh12.new Face(v3, newedge[e1].v2, newedge[e2].v2, j + 1, j, e2);
                        TriangleMesh triangleMesh13 = mesh;
                        triangleMesh13.getClass();
                        newface[k + 1] = triangleMesh13.new Face(newedge[e2].v2, newedge[e1].v2, v2, j, newEdgeIndex[e1], newEdgeIndex[e2]);
                        break;
                    }
                    if (edge[e2].v1 == v2) {
                        TriangleMesh triangleMesh14 = mesh;
                        triangleMesh14.getClass();
                        newface[i] = triangleMesh14.new Face(v1, newedge[e1].v2, v3, newEdgeIndex[e1], j + 1, e3);
                        TriangleMesh triangleMesh15 = mesh;
                        triangleMesh15.getClass();
                        newface[k] = triangleMesh15.new Face(v3, newedge[e1].v2, newedge[e2].v2, j + 1, j, newEdgeIndex[e2]);
                        TriangleMesh triangleMesh16 = mesh;
                        triangleMesh16.getClass();
                        newface[k + 1] = triangleMesh16.new Face(newedge[e2].v2, newedge[e1].v2, v2, j, e1, e2);
                        break;
                    }
                    TriangleMesh triangleMesh17 = mesh;
                    triangleMesh17.getClass();
                    newface[i] = triangleMesh17.new Face(v1, newedge[e1].v2, v3, newEdgeIndex[e1], j + 1, e3);
                    TriangleMesh triangleMesh18 = mesh;
                    triangleMesh18.getClass();
                    newface[k] = triangleMesh18.new Face(v3, newedge[e1].v2, newedge[e2].v2, j + 1, j, e2);
                    TriangleMesh triangleMesh19 = mesh;
                    triangleMesh19.getClass();
                    newface[k + 1] = triangleMesh19.new Face(newedge[e2].v2, newedge[e1].v2, v2, j, e1, newEdgeIndex[e2]);
                    break;
                }
                case 3: {
                    TriangleMesh triangleMesh = mesh;
                    triangleMesh.getClass();
                    newedge[j] = triangleMesh.new Edge(newedge[e1].v2, newedge[e2].v2, -1);
                    TriangleMesh triangleMesh20 = mesh;
                    triangleMesh20.getClass();
                    newedge[j + 1] = triangleMesh20.new Edge(newedge[e2].v2, newedge[e3].v2, -1);
                    TriangleMesh triangleMesh21 = mesh;
                    triangleMesh21.getClass();
                    newedge[j + 2] = triangleMesh21.new Edge(newedge[e3].v2, newedge[e1].v2, -1);
                    if (edge[e1].v1 == v1) {
                        if (edge[e2].v1 == v2) {
                            if (edge[e3].v1 == v3) {
                                TriangleMesh triangleMesh22 = mesh;
                                triangleMesh22.getClass();
                                newface[i] = triangleMesh22.new Face(v1, newedge[e1].v2, newedge[e3].v2, e1, j + 2, newEdgeIndex[e3]);
                                TriangleMesh triangleMesh23 = mesh;
                                triangleMesh23.getClass();
                                newface[k] = triangleMesh23.new Face(v2, newedge[e2].v2, newedge[e1].v2, e2, j, newEdgeIndex[e1]);
                                TriangleMesh triangleMesh24 = mesh;
                                triangleMesh24.getClass();
                                newface[k + 1] = triangleMesh24.new Face(v3, newedge[e3].v2, newedge[e2].v2, e3, j + 1, newEdgeIndex[e2]);
                            } else {
                                TriangleMesh triangleMesh25 = mesh;
                                triangleMesh25.getClass();
                                newface[i] = triangleMesh25.new Face(v1, newedge[e1].v2, newedge[e3].v2, e1, j + 2, e3);
                                TriangleMesh triangleMesh26 = mesh;
                                triangleMesh26.getClass();
                                newface[k] = triangleMesh26.new Face(v2, newedge[e2].v2, newedge[e1].v2, e2, j, newEdgeIndex[e1]);
                                TriangleMesh triangleMesh27 = mesh;
                                triangleMesh27.getClass();
                                newface[k + 1] = triangleMesh27.new Face(v3, newedge[e3].v2, newedge[e2].v2, newEdgeIndex[e3], j + 1, newEdgeIndex[e2]);
                            }
                        } else if (edge[e3].v1 == v3) {
                            TriangleMesh triangleMesh28 = mesh;
                            triangleMesh28.getClass();
                            newface[i] = triangleMesh28.new Face(v1, newedge[e1].v2, newedge[e3].v2, e1, j + 2, newEdgeIndex[e3]);
                            TriangleMesh triangleMesh29 = mesh;
                            triangleMesh29.getClass();
                            newface[k] = triangleMesh29.new Face(v2, newedge[e2].v2, newedge[e1].v2, newEdgeIndex[e2], j, newEdgeIndex[e1]);
                            TriangleMesh triangleMesh30 = mesh;
                            triangleMesh30.getClass();
                            newface[k + 1] = triangleMesh30.new Face(v3, newedge[e3].v2, newedge[e2].v2, e3, j + 1, e2);
                        } else {
                            TriangleMesh triangleMesh31 = mesh;
                            triangleMesh31.getClass();
                            newface[i] = triangleMesh31.new Face(v1, newedge[e1].v2, newedge[e3].v2, e1, j + 2, e3);
                            TriangleMesh triangleMesh32 = mesh;
                            triangleMesh32.getClass();
                            newface[k] = triangleMesh32.new Face(v2, newedge[e2].v2, newedge[e1].v2, newEdgeIndex[e2], j, newEdgeIndex[e1]);
                            TriangleMesh triangleMesh33 = mesh;
                            triangleMesh33.getClass();
                            newface[k + 1] = triangleMesh33.new Face(v3, newedge[e3].v2, newedge[e2].v2, newEdgeIndex[e3], j + 1, e2);
                        }
                    } else if (edge[e2].v1 == v2) {
                        if (edge[e3].v1 == v3) {
                            TriangleMesh triangleMesh34 = mesh;
                            triangleMesh34.getClass();
                            newface[i] = triangleMesh34.new Face(v1, newedge[e1].v2, newedge[e3].v2, newEdgeIndex[e1], j + 2, newEdgeIndex[e3]);
                            TriangleMesh triangleMesh35 = mesh;
                            triangleMesh35.getClass();
                            newface[k] = triangleMesh35.new Face(v2, newedge[e2].v2, newedge[e1].v2, e2, j, e1);
                            TriangleMesh triangleMesh36 = mesh;
                            triangleMesh36.getClass();
                            newface[k + 1] = triangleMesh36.new Face(v3, newedge[e3].v2, newedge[e2].v2, e3, j + 1, newEdgeIndex[e2]);
                        } else {
                            TriangleMesh triangleMesh37 = mesh;
                            triangleMesh37.getClass();
                            newface[i] = triangleMesh37.new Face(v1, newedge[e1].v2, newedge[e3].v2, newEdgeIndex[e1], j + 2, e3);
                            TriangleMesh triangleMesh38 = mesh;
                            triangleMesh38.getClass();
                            newface[k] = triangleMesh38.new Face(v2, newedge[e2].v2, newedge[e1].v2, e2, j, e1);
                            TriangleMesh triangleMesh39 = mesh;
                            triangleMesh39.getClass();
                            newface[k + 1] = triangleMesh39.new Face(v3, newedge[e3].v2, newedge[e2].v2, newEdgeIndex[e3], j + 1, newEdgeIndex[e2]);
                        }
                    } else if (edge[e3].v1 == v3) {
                        TriangleMesh triangleMesh40 = mesh;
                        triangleMesh40.getClass();
                        newface[i] = triangleMesh40.new Face(v1, newedge[e1].v2, newedge[e3].v2, newEdgeIndex[e1], j + 2, newEdgeIndex[e3]);
                        TriangleMesh triangleMesh41 = mesh;
                        triangleMesh41.getClass();
                        newface[k] = triangleMesh41.new Face(v2, newedge[e2].v2, newedge[e1].v2, newEdgeIndex[e2], j, e1);
                        TriangleMesh triangleMesh42 = mesh;
                        triangleMesh42.getClass();
                        newface[k + 1] = triangleMesh42.new Face(v3, newedge[e3].v2, newedge[e2].v2, e3, j + 1, e2);
                    } else {
                        TriangleMesh triangleMesh43 = mesh;
                        triangleMesh43.getClass();
                        newface[i] = triangleMesh43.new Face(v1, newedge[e1].v2, newedge[e3].v2, newEdgeIndex[e1], j + 2, e3);
                        TriangleMesh triangleMesh44 = mesh;
                        triangleMesh44.getClass();
                        newface[k] = triangleMesh44.new Face(v2, newedge[e2].v2, newedge[e1].v2, newEdgeIndex[e2], j, e1);
                        TriangleMesh triangleMesh45 = mesh;
                        triangleMesh45.getClass();
                        newface[k + 1] = triangleMesh45.new Face(v3, newedge[e3].v2, newedge[e2].v2, newEdgeIndex[e3], j + 1, e2);
                    }
                    TriangleMesh triangleMesh46 = mesh;
                    triangleMesh46.getClass();
                    newface[k + 2] = triangleMesh46.new Face(newedge[e1].v2, newedge[e2].v2, newedge[e3].v2, j, j + 1, j + 2);
                }
            }
            int numAddedFaces = n + 1;
            addedFace[0] = i;
            for (int m = 0; m < n; ++m) {
                addedFace[m + 1] = k + m;
            }
            for (int p = 0; p < paramType.length; ++p) {
                if (paramType[p] == 2) {
                    for (int m = 0; m < numAddedFaces; ++m) {
                        newParamValue[p][0][addedFace[m]] = oldParamValue[p][0][i];
                    }
                    continue;
                }
                if (paramType[p] != 3) continue;
                int[] vertInd = new int[]{v1, v2, v3, -1, -1, -1};
                if (n > 0) {
                    vertInd[3] = newedge[e1].v2;
                }
                if (n > 1) {
                    vertInd[4] = newedge[e2].v2;
                }
                if (n > 2) {
                    vertInd[5] = newedge[e3].v2;
                }
                double[] vertVal = v1 == tempFace.v1 ? new double[]{oldParamValue[p][0][i], oldParamValue[p][1][i], oldParamValue[p][2][i], 0.5 * (oldParamValue[p][0][i] + oldParamValue[p][1][i]), 0.5 * (oldParamValue[p][1][i] + oldParamValue[p][2][i]), 0.5 * (oldParamValue[p][2][i] + oldParamValue[p][0][i])} : (v1 == tempFace.v2 ? new double[]{oldParamValue[p][1][i], oldParamValue[p][2][i], oldParamValue[p][0][i], 0.5 * (oldParamValue[p][1][i] + oldParamValue[p][2][i]), 0.5 * (oldParamValue[p][2][i] + oldParamValue[p][0][i]), 0.5 * (oldParamValue[p][0][i] + oldParamValue[p][1][i])} : new double[]{oldParamValue[p][2][i], oldParamValue[p][0][i], oldParamValue[p][1][i], 0.5 * (oldParamValue[p][2][i] + oldParamValue[p][0][i]), 0.5 * (oldParamValue[p][0][i] + oldParamValue[p][1][i]), 0.5 * (oldParamValue[p][1][i] + oldParamValue[p][2][i])});
                for (int m = 0; m < numAddedFaces; ++m) {
                    Face fc = newface[addedFace[m]];
                    for (int q = 0; q < 6; ++q) {
                        if (fc.v1 == vertInd[q]) {
                            newParamValue[p][0][addedFace[m]] = vertVal[q];
                            continue;
                        }
                        if (fc.v2 == vertInd[q]) {
                            newParamValue[p][1][addedFace[m]] = vertVal[q];
                            continue;
                        }
                        if (fc.v3 != vertInd[q]) continue;
                        newParamValue[p][2][addedFace[m]] = vertVal[q];
                    }
                }
            }
            j += n;
            k += n;
        }
        for (i = 0; i < newface.length; ++i) {
            tempFace = newface[i];
            if (newedge[tempFace.e1].f1 == -1) {
                newedge[tempFace.e1].f1 = i;
            } else {
                newedge[tempFace.e1].f2 = i;
            }
            if (newedge[tempFace.e2].f1 == -1) {
                newedge[tempFace.e2].f1 = i;
            } else {
                newedge[tempFace.e2].f2 = i;
            }
            if (newedge[tempFace.e3].f1 == -1) {
                newedge[tempFace.e3].f1 = i;
                continue;
            }
            newedge[tempFace.e3].f2 = i;
        }
        for (i = 0; i < newvert.length; ++i) {
            newvert[i].edges = 0;
        }
        for (i = 0; i < newedge.length; ++i) {
            ++newvert[newedge[i].v1].edges;
            ++newvert[newedge[i].v2].edges;
        }
    }

    public static TriangleMesh subdivideFaces(TriangleMesh mesh, boolean[] split) {
        int j;
        int index;
        int i;
        Vertex[] vertex = mesh.vertex;
        Edge[] edge = mesh.edge;
        Face[] face = mesh.face;
        TriangleMesh newmesh = new TriangleMesh();
        int numVert = vertex.length;
        int numEdge = edge.length;
        int numFace = face.length;
        for (i = 0; i < split.length; ++i) {
            if (!split[i]) continue;
            ++numVert;
            numEdge += 3;
            numFace += 2;
        }
        Vertex[] newvert = new Vertex[numVert];
        Edge[] newedge = new Edge[numEdge];
        Face[] newface = new Face[numFace];
        int[] paramType = new int[mesh.paramValue.length];
        double[][][] newParamValue = new double[mesh.paramValue.length][][];
        double[][][] oldParamValue = new double[mesh.paramValue.length][][];
        for (i = 0; i < mesh.paramValue.length; ++i) {
            if (mesh.paramValue[i] instanceof ConstantParameterValue) {
                paramType[i] = 0;
                continue;
            }
            if (mesh.paramValue[i] instanceof VertexParameterValue) {
                oldParamValue[i] = new double[][]{((VertexParameterValue)mesh.paramValue[i]).getValue()};
                newParamValue[i] = new double[1][numVert];
                paramType[i] = 1;
                continue;
            }
            if (mesh.paramValue[i] instanceof FaceParameterValue) {
                oldParamValue[i] = new double[][]{((FaceParameterValue)mesh.paramValue[i]).getValue()};
                newParamValue[i] = new double[1][numFace];
                paramType[i] = 2;
                continue;
            }
            if (!(mesh.paramValue[i] instanceof FaceVertexParameterValue)) continue;
            FaceVertexParameterValue fvpv = (FaceVertexParameterValue)mesh.paramValue[i];
            oldParamValue[i] = new double[3][fvpv.getFaceCount()];
            for (index = 0; index < fvpv.getFaceCount(); ++index) {
                oldParamValue[i][0][index] = fvpv.getValue(index, 0);
                oldParamValue[i][1][index] = fvpv.getValue(index, 1);
                oldParamValue[i][2][index] = fvpv.getValue(index, 2);
            }
            newParamValue[i] = new double[3][numFace];
            paramType[i] = 3;
        }
        for (i = 0; i < vertex.length; ++i) {
            TriangleMesh triangleMesh = newmesh;
            triangleMesh.getClass();
            newvert[i] = triangleMesh.new Vertex(vertex[i]);
            for (j = 0; j < paramType.length; ++j) {
                if (paramType[j] != 1) continue;
                newParamValue[j][0][i] = oldParamValue[j][0][i];
            }
        }
        for (i = 0; i < edge.length; ++i) {
            TriangleMesh triangleMesh = newmesh;
            triangleMesh.getClass();
            newedge[i] = triangleMesh.new Edge(edge[i].v1, edge[i].v2, -1);
            newedge[i].smoothness = edge[i].smoothness;
        }
        for (i = 0; i < face.length; ++i) {
            if (split[i]) continue;
            TriangleMesh triangleMesh = newmesh;
            triangleMesh.getClass();
            newface[i] = triangleMesh.new Face(face[i].v1, face[i].v2, face[i].v3, face[i].e1, face[i].e2, face[i].e3);
            for (j = 0; j < paramType.length; ++j) {
                if (paramType[j] == 2) {
                    newParamValue[j][0][i] = oldParamValue[j][0][i];
                    continue;
                }
                if (paramType[j] != 3) continue;
                newParamValue[j][0][i] = oldParamValue[j][0][i];
                newParamValue[j][1][i] = oldParamValue[j][1][i];
                newParamValue[j][2][i] = oldParamValue[j][2][i];
            }
        }
        numVert = vertex.length;
        numEdge = edge.length;
        numFace = face.length;
        for (i = 0; i < face.length; ++i) {
            if (!split[i]) continue;
            newvert[numVert] = newmesh.blend(vertex[face[i].v1], vertex[face[i].v2], vertex[face[i].v3], 0.3333333333333333, 0.3333333333333333, 0.3333333333333333);
            TriangleMesh.blendIKParams(newvert[numVert], vertex[face[i].v1], vertex[face[i].v2]);
            newvert[numVert].firstEdge = numEdge;
            TriangleMesh triangleMesh = newmesh;
            triangleMesh.getClass();
            newedge[numEdge] = triangleMesh.new Edge(face[i].v1, numVert, -1);
            TriangleMesh triangleMesh2 = newmesh;
            triangleMesh2.getClass();
            newedge[numEdge + 1] = triangleMesh2.new Edge(face[i].v2, numVert, -1);
            TriangleMesh triangleMesh3 = newmesh;
            triangleMesh3.getClass();
            newedge[numEdge + 2] = triangleMesh3.new Edge(face[i].v3, numVert, -1);
            TriangleMesh triangleMesh4 = newmesh;
            triangleMesh4.getClass();
            newface[i] = triangleMesh4.new Face(face[i].v1, face[i].v2, numVert, face[i].e1, numEdge + 1, numEdge);
            TriangleMesh triangleMesh5 = newmesh;
            triangleMesh5.getClass();
            newface[numFace] = triangleMesh5.new Face(face[i].v2, face[i].v3, numVert, face[i].e2, numEdge + 2, numEdge + 1);
            TriangleMesh triangleMesh6 = newmesh;
            triangleMesh6.getClass();
            newface[numFace + 1] = triangleMesh6.new Face(face[i].v3, face[i].v1, numVert, face[i].e3, numEdge, numEdge + 2);
            for (j = 0; j < paramType.length; ++j) {
                if (paramType[j] == 2) {
                    double d = oldParamValue[j][0][i];
                    newParamValue[j][0][numFace + 1] = d;
                    newParamValue[j][0][numFace] = d;
                    newParamValue[j][0][i] = d;
                    continue;
                }
                if (paramType[j] != 3) continue;
                double centerVal = (oldParamValue[j][0][i] + oldParamValue[j][1][i] + oldParamValue[j][2][i]) / 3.0;
                newParamValue[j][0][i] = oldParamValue[j][0][i];
                newParamValue[j][1][i] = oldParamValue[j][1][i];
                newParamValue[j][2][i] = centerVal;
                newParamValue[j][0][numFace] = oldParamValue[j][1][i];
                newParamValue[j][1][numFace] = oldParamValue[j][2][i];
                newParamValue[j][2][numFace] = centerVal;
                newParamValue[j][0][numFace + 1] = oldParamValue[j][2][i];
                newParamValue[j][1][numFace + 1] = oldParamValue[j][0][i];
                newParamValue[j][2][numFace + 1] = centerVal;
            }
            ++numVert;
            numEdge += 3;
            numFace += 2;
        }
        for (i = 0; i < newface.length; ++i) {
            Face tempFace = newface[i];
            if (newedge[tempFace.e1].f1 == -1) {
                newedge[tempFace.e1].f1 = i;
            } else {
                newedge[tempFace.e1].f2 = i;
            }
            if (newedge[tempFace.e2].f1 == -1) {
                newedge[tempFace.e2].f1 = i;
            } else {
                newedge[tempFace.e2].f2 = i;
            }
            if (newedge[tempFace.e3].f1 == -1) {
                newedge[tempFace.e3].f1 = i;
                continue;
            }
            newedge[tempFace.e3].f2 = i;
        }
        for (i = 0; i < newvert.length; ++i) {
            newvert[i].edges = 0;
        }
        for (i = 0; i < newedge.length; ++i) {
            ++newvert[newedge[i].v1].edges;
            ++newvert[newedge[i].v2].edges;
        }
        newmesh.copyTextureAndMaterial(mesh);
        for (i = 0; i < paramType.length; ++i) {
            if (paramType[i] == 1) {
                newmesh.paramValue[i] = new VertexParameterValue(newParamValue[i][0]);
                continue;
            }
            if (paramType[i] == 2) {
                newmesh.paramValue[i] = new FaceParameterValue(newParamValue[i][0]);
                continue;
            }
            if (paramType[i] != 3) continue;
            double[][] val = new double[newParamValue[i][0].length][];
            for (index = 0; index < val.length; ++index) {
                val[index] = new double[]{newParamValue[i][0][index], newParamValue[i][1][index], newParamValue[i][2][index]};
            }
            newmesh.paramValue[i] = new FaceVertexParameterValue(val);
        }
        newmesh.vertex = newvert;
        newmesh.edge = newedge;
        newmesh.face = newface;
        newmesh.closed = mesh.closed;
        newmesh.smoothingMethod = mesh.smoothingMethod;
        newmesh.skeleton = mesh.skeleton.duplicate();
        return newmesh;
    }

    public TriangleMesh subdivideToLimit(double tol) {
        TriangleMesh newmesh = this;
        boolean converged = false;
        double tol2 = 2.0 * tol * tol;
        while (!converged) {
            converged = true;
            boolean[] split = new boolean[newmesh.edge.length];
            for (int i = 0; i < split.length; ++i) {
                Vec3 v1 = newmesh.vertex[newmesh.edge[i].v1].r;
                Vec3 v2 = newmesh.vertex[newmesh.edge[i].v2].r;
                double dx = v1.x - v2.x;
                double dy = v1.y - v2.y;
                double dz = v1.z - v2.z;
                if (dx * dx + dy * dy + dz * dz > tol2) {
                    split[i] = true;
                    converged = false;
                    continue;
                }
                split[i] = false;
            }
            if (this.getSmoothingMethod() == 3) {
                newmesh = TriangleMesh.subdivideLoop(newmesh, split, Double.MAX_VALUE);
                continue;
            }
            if (this.getSmoothingMethod() == 2) {
                newmesh = TriangleMesh.subdivideButterfly(newmesh, split, Double.MAX_VALUE);
                continue;
            }
            newmesh = TriangleMesh.subdivideLinear(newmesh, split);
        }
        return newmesh;
    }

    public TriangleMesh getDisplacedMesh(double tol, double time) {
        TriangleMesh newmesh = this;
        boolean converged = false;
        double tol2 = 2.0 * tol * tol;
        Vec3 t1 = new Vec3();
        Vec3 t2 = new Vec3();
        while (!converged) {
            converged = true;
            boolean[] split = new boolean[newmesh.edge.length];
            for (int i = 0; i < split.length; ++i) {
                Vec3 v1 = newmesh.vertex[newmesh.edge[i].v1].r;
                Vec3 v2 = newmesh.vertex[newmesh.edge[i].v2].r;
                double dx = v1.x - v2.x;
                double dy = v1.y - v2.y;
                double dz = v1.z - v2.z;
                if (dx * dx + dy * dy + dz * dz > tol2) {
                    split[i] = true;
                    converged = false;
                    continue;
                }
                split[i] = false;
            }
            if (this.getSmoothingMethod() == 3) {
                newmesh = TriangleMesh.subdivideLoop(newmesh, split, Double.MAX_VALUE);
                continue;
            }
            if (this.getSmoothingMethod() == 2) {
                newmesh = TriangleMesh.subdivideButterfly(newmesh, split, Double.MAX_VALUE);
                continue;
            }
            newmesh = TriangleMesh.subdivideLinear(newmesh, split);
        }
        Vertex[] v = newmesh.vertex;
        Edge[] e = newmesh.edge;
        Vec3[] norm = new Vec3[v.length];
        for (int i = 0; i < v.length; ++i) {
            int[] ed = v[i].getEdges();
            double b = Math.PI * 2 / (double)ed.length;
            t1.set(0.0, 0.0, 0.0);
            t2.set(0.0, 0.0, 0.0);
            for (int j = 0; j < ed.length; ++j) {
                Edge tempEdge = e[ed[j]];
                if (tempEdge.v1 == i) {
                    t1.add(v[tempEdge.v2].r.times(Math.cos(b * (double)j)));
                    t2.add(v[tempEdge.v2].r.times(Math.sin(b * (double)j)));
                    continue;
                }
                t1.add(v[tempEdge.v1].r.times(Math.cos(b * (double)j)));
                t2.add(v[tempEdge.v1].r.times(Math.sin(b * (double)j)));
            }
            Vec3 temp = t1.cross(t2);
            b = temp.length();
            if (b == 0.0) {
                temp = null;
            } else if (v[i].clockwise()) {
                temp.scale(-1.0 / b);
            } else {
                temp.scale(1.0 / b);
            }
            norm[i] = temp;
        }
        double[] param = new double[this.paramValue.length];
        for (int i = 0; i < this.paramValue.length; ++i) {
            param[i] = this.paramValue[i].getAverageValue();
        }
        TextureMapping map = this.getTextureMapping();
        for (int i = 0; i < v.length; ++i) {
            for (int j = 0; j < this.paramValue.length; ++j) {
                if (!(this.paramValue[j] instanceof VertexParameterValue)) continue;
                param[j] = ((VertexParameterValue)this.paramValue[j]).getValue()[i];
            }
            double height = map.getDisplacement(v[i].r, tol, time, param);
            v[i].r.x += height * norm[i].x;
            v[i].r.y += height * norm[i].y;
            v[i].r.z += height * norm[i].z;
        }
        System.gc();
        return newmesh;
    }

    public void makeRightSideOut() {
        Vec3[] norm = this.getNormals();
        Vec3 result = new Vec3();
        for (int i = 0; i < norm.length; ++i) {
            result.x += this.vertex[i].r.x * norm[i].x;
            result.y += this.vertex[i].r.y * norm[i].y;
            result.z += this.vertex[i].r.z * norm[i].z;
        }
        if (result.x + result.y + result.z < 0.0) {
            this.reverseNormals();
        }
    }

    public void reverseNormals() {
        for (int i = 0; i < this.face.length; ++i) {
            int temp = this.face[i].v2;
            this.face[i].v2 = this.face[i].v3;
            this.face[i].v3 = temp;
            temp = this.face[i].e1;
            this.face[i].e1 = this.face[i].e3;
            this.face[i].e3 = temp;
        }
        this.cachedMesh = null;
    }

    public Vec3[] getNormals() {
        int i;
        Vec3[] norm = new Vec3[this.vertex.length];
        for (i = 0; i < norm.length; ++i) {
            norm[i] = new Vec3();
        }
        for (i = 0; i < this.face.length; ++i) {
            Vec3 edge1 = this.vertex[this.face[i].v2].r.minus(this.vertex[this.face[i].v1].r);
            Vec3 edge2 = this.vertex[this.face[i].v3].r.minus(this.vertex[this.face[i].v1].r);
            Vec3 edge3 = this.vertex[this.face[i].v3].r.minus(this.vertex[this.face[i].v2].r);
            edge1.normalize();
            edge2.normalize();
            edge3.normalize();
            Vec3 faceNorm = edge1.cross(edge2);
            double length = faceNorm.length();
            if (length == 0.0) continue;
            faceNorm.scale(1.0 / length);
            double dot1 = edge1.dot(edge2);
            double dot2 = -edge1.dot(edge3);
            double dot3 = edge2.dot(edge3);
            if (dot1 < -1.0) {
                dot1 = -1.0;
            }
            if (dot1 > 1.0) {
                dot1 = 1.0;
            }
            if (dot2 < -1.0) {
                dot2 = -1.0;
            }
            if (dot2 > 1.0) {
                dot2 = 1.0;
            }
            if (dot3 < -1.0) {
                dot3 = -1.0;
            }
            if (dot3 > 1.0) {
                dot3 = 1.0;
            }
            norm[this.face[i].v1].add(faceNorm.times(Math.acos(dot1)));
            norm[this.face[i].v2].add(faceNorm.times(Math.acos(dot2)));
            norm[this.face[i].v3].add(faceNorm.times(Math.acos(dot3)));
        }
        for (i = 0; i < norm.length; ++i) {
            norm[i].normalize();
        }
        return norm;
    }

    public int getFaceCount() {
        return this.face.length;
    }

    public int getFaceVertexCount(int faceIndex) {
        return 3;
    }

    public int getFaceVertexIndex(int faceIndex, int vertexIndex) {
        Face f = this.face[faceIndex];
        if (vertexIndex == 0) {
            return f.v1;
        }
        if (vertexIndex == 1) {
            return f.v2;
        }
        return f.v3;
    }

    public static TriangleMesh optimizeMesh(TriangleMesh mesh) {
        Face[] face = mesh.face;
        Edge[] edge = mesh.edge;
        Vertex[] vertex = mesh.vertex;
        boolean[] candidate = new boolean[edge.length];
        TriangleMesh newmesh = null;
        for (int i = 0; i < edge.length; ++i) {
            candidate[i] = true;
        }
        block1: while (true) {
            int i;
            int i2;
            Vec3[] faceNorm = new Vec3[face.length];
            boolean[] onBoundary = new boolean[vertex.length];
            int[] numEdges = new int[vertex.length];
            for (i2 = 0; i2 < face.length; ++i2) {
                Face f = face[i2];
                if (!candidate[f.e1] && !candidate[f.e2] && !candidate[f.e3]) continue;
                Vec3 v1 = vertex[f.v1].r;
                Vec3 v2 = vertex[f.v2].r;
                Vec3 v3 = vertex[f.v3].r;
                Vec3 d1 = v2.minus(v1);
                Vec3 d2 = v3.minus(v1);
                faceNorm[i2] = d1.cross(d2);
                double length = faceNorm[i2].length();
                if (length > 0.0) {
                    faceNorm[i2].scale(1.0 / length);
                    continue;
                }
                if (v1.equals(v2) || v1.equals(v3) || v2.equals(v3)) continue;
                faceNorm[i2] = null;
            }
            for (i2 = 0; i2 < edge.length; ++i2) {
                Edge e = edge[i2];
                int n = e.v1;
                numEdges[n] = numEdges[n] + 1;
                int n2 = e.v2;
                numEdges[n2] = numEdges[n2] + 1;
                if (e.f2 == -1) {
                    onBoundary[e.v2] = true;
                    onBoundary[e.v1] = true;
                    candidate[i2] = false;
                    continue;
                }
                if (!candidate[i2] || faceNorm[e.f1] == null || faceNorm[e.f2] == null || !(faceNorm[e.f1].dot(faceNorm[e.f2]) < 0.99)) continue;
                candidate[i2] = false;
            }
            int[][] swapVert = new int[edge.length][];
            double[][] minAngle = new double[edge.length][];
            for (int i3 = 0; i3 < edge.length; ++i3) {
                if (!candidate[i3]) continue;
                swapVert[i3] = new int[4];
                Edge e = edge[i3];
                Face f1 = face[e.f1];
                Face f2 = face[e.f2];
                if (e.v1 == f1.v1 && e.v2 == f1.v2 || e.v1 == f1.v2 && e.v2 == f1.v3 || e.v1 == f1.v3 && e.v2 == f1.v1) {
                    swapVert[i3][0] = e.v1;
                    swapVert[i3][1] = e.v2;
                } else {
                    swapVert[i3][0] = e.v2;
                    swapVert[i3][1] = e.v1;
                }
                swapVert[i3][2] = e.v1 != f1.v1 && e.v2 != f1.v1 ? f1.v1 : (e.v1 != f1.v2 && e.v2 != f1.v2 ? f1.v2 : f1.v3);
                swapVert[i3][3] = e.v1 != f2.v1 && e.v2 != f2.v1 ? f2.v1 : (e.v1 != f2.v2 && e.v2 != f2.v2 ? f2.v2 : f2.v3);
                minAngle[i3] = new double[4];
                Vec3 d1 = vertex[swapVert[i3][1]].r.minus(vertex[swapVert[i3][0]].r);
                Vec3 d2 = vertex[swapVert[i3][2]].r.minus(vertex[swapVert[i3][0]].r);
                Vec3 d3 = vertex[swapVert[i3][3]].r.minus(vertex[swapVert[i3][0]].r);
                Vec3 d4 = vertex[swapVert[i3][2]].r.minus(vertex[swapVert[i3][1]].r);
                Vec3 d5 = vertex[swapVert[i3][3]].r.minus(vertex[swapVert[i3][1]].r);
                Vec3 d6 = vertex[swapVert[i3][3]].r.minus(vertex[swapVert[i3][2]].r);
                d1.normalize();
                d2.normalize();
                d3.normalize();
                d4.normalize();
                d5.normalize();
                d6.normalize();
                double a1 = Math.acos(d1.dot(d2));
                double a2 = Math.acos(d1.dot(d3));
                if (a1 + a2 >= Math.PI) {
                    candidate[i3] = false;
                    continue;
                }
                minAngle[i3][0] = a1 < a2 ? a1 : a2;
                a1 = Math.acos(-d1.dot(d4));
                if (a1 + (a2 = Math.acos(-d1.dot(d5))) >= Math.PI) {
                    candidate[i3] = false;
                    continue;
                }
                minAngle[i3][1] = a1 < a2 ? a1 : a2;
                a1 = Math.acos(-d6.dot(d2));
                a2 = Math.acos(-d6.dot(d4));
                minAngle[i3][2] = a1 < a2 ? a1 : a2;
                a1 = Math.acos(d6.dot(d3));
                a2 = Math.acos(d6.dot(d5));
                minAngle[i3][3] = a1 < a2 ? a1 : a2;
            }
            double[] score = new double[edge.length];
            boolean[] swap = new boolean[edge.length];
            for (int i4 = 0; i4 < score.length; ++i4) {
                if (!candidate[i4]) continue;
                score[i4] = TriangleMesh.calcSwapScore(minAngle[i4], swapVert[i4], numEdges, onBoundary);
            }
            block6: while (true) {
                int best = -1;
                double maxScore = 0.0;
                for (int i5 = 0; i5 < candidate.length; ++i5) {
                    if (!candidate[i5] || !(score[i5] > maxScore)) continue;
                    best = i5;
                    maxScore = score[i5];
                }
                if (best == -1) break;
                swap[best] = true;
                Edge e = edge[best];
                Face f = face[e.f1];
                candidate[f.e3] = false;
                candidate[f.e2] = false;
                candidate[f.e1] = false;
                f = face[e.f2];
                candidate[f.e3] = false;
                candidate[f.e2] = false;
                candidate[f.e1] = false;
                int n = swapVert[best][0];
                numEdges[n] = numEdges[n] - 1;
                int n3 = swapVert[best][1];
                numEdges[n3] = numEdges[n3] - 1;
                int n4 = swapVert[best][2];
                numEdges[n4] = numEdges[n4] + 1;
                int n5 = swapVert[best][3];
                numEdges[n5] = numEdges[n5] + 1;
                int i6 = 0;
                while (true) {
                    if (i6 >= 4) continue block6;
                    int[] vertEdges = vertex[swapVert[best][i6]].getEdges();
                    for (int j = 0; j < vertEdges.length; ++j) {
                        if (!candidate[vertEdges[j]]) continue;
                        score[vertEdges[j]] = TriangleMesh.calcSwapScore(minAngle[vertEdges[j]], swapVert[vertEdges[j]], numEdges, onBoundary);
                    }
                    ++i6;
                }
                break;
            }
            int[][] newface = new int[face.length][];
            int next = 0;
            for (int i7 = 0; i7 < face.length; ++i7) {
                Face f = face[i7];
                if (swap[f.e1] || swap[f.e2] || swap[f.e3]) continue;
                newface[next++] = new int[]{f.v1, f.v2, f.v3};
            }
            int firstSplit = next;
            for (int i8 = 0; i8 < edge.length; ++i8) {
                if (!swap[i8]) continue;
                newface[next++] = new int[]{swapVert[i8][2], swapVert[i8][0], swapVert[i8][3]};
                newface[next++] = new int[]{swapVert[i8][2], swapVert[i8][3], swapVert[i8][1]};
            }
            newmesh = new TriangleMesh(vertex, (int[][])newface);
            Vertex[] newvert = (Vertex[])newmesh.getVertices();
            Edge[] newedge = newmesh.getEdges();
            block12: for (i = 0; i < edge.length; ++i) {
                if (swap[i] || (double)edge[i].smoothness == 1.0) continue;
                int[] edges2 = newvert[edge[i].v1].getEdges();
                Edge e1 = edge[i];
                for (int k = 0; k < edges2.length; ++k) {
                    Edge e2 = newedge[edges2[k]];
                    if ((e1.v1 != e2.v1 || e1.v2 != e2.v2) && (e1.v1 != e2.v2 || e1.v2 != e2.v1)) continue;
                    e2.smoothness = e1.smoothness;
                    continue block12;
                }
            }
            if (firstSplit == next) break;
            vertex = newvert;
            edge = newedge;
            face = newmesh.getFaces();
            candidate = new boolean[edge.length];
            i = firstSplit;
            while (true) {
                if (i >= face.length) continue block1;
                Face f = face[i];
                candidate[f.e3] = true;
                candidate[f.e2] = true;
                candidate[f.e1] = true;
                ++i;
            }
            break;
        }
        newmesh.copyTextureAndMaterial(mesh);
        newmesh.smoothingMethod = mesh.smoothingMethod;
        newmesh.skeleton = mesh.skeleton.duplicate();
        return newmesh;
    }

    private static double calcSwapScore(double[] minAngle, int[] vert, int[] numEdges, boolean[] onBoundary) {
        double[] s = new double[4];
        for (int i = 0; i < 4; ++i) {
            int ideal;
            int v = vert[i];
            int n = ideal = onBoundary[v] ? 4 : 6;
            if (i > 1) {
                --ideal;
            }
            s[i] = numEdges[v] > ideal ? minAngle[i] / ((double)(numEdges[v] - ideal) + 1.5) : minAngle[i];
        }
        double currentScore = s[0] < s[1] ? s[0] : s[1];
        double swapScore = s[2] < s[3] ? s[2] : s[3];
        return swapScore - currentScore;
    }

    public void autosmoothMeshEdges(double angle) {
        double cutoff = Math.cos(angle);
        for (int i = 0; i < this.edge.length; ++i) {
            if (this.edge[i].f2 == -1) {
                this.edge[i].smoothness = 1.0f;
                continue;
            }
            Face f1 = this.face[this.edge[i].f1];
            Face f2 = this.face[this.edge[i].f2];
            Vec3 norm1 = this.vertex[f1.v1].r.minus(this.vertex[f1.v2].r).cross(this.vertex[f1.v1].r.minus(this.vertex[f1.v3].r));
            Vec3 norm2 = this.vertex[f2.v1].r.minus(this.vertex[f2.v2].r).cross(this.vertex[f2.v1].r.minus(this.vertex[f2.v3].r));
            norm1.normalize();
            norm2.normalize();
            this.edge[i].smoothness = norm1.dot(norm2) < cutoff ? 0.0f : 1.0f;
        }
    }

    public TriangleMesh(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        super(in, theScene);
        int i;
        short version = in.readShort();
        if (version < 0 || version > 1) {
            throw new InvalidObjectException("");
        }
        this.vertex = new Vertex[in.readInt()];
        if (version == 0) {
            for (i = 0; i < this.paramValue.length; ++i) {
                this.paramValue[i] = new VertexParameterValue(new double[this.vertex.length]);
            }
        }
        for (i = 0; i < this.vertex.length; ++i) {
            this.vertex[i] = new Vertex(new Vec3(in));
            this.vertex[i].smoothness = in.readFloat();
            this.vertex[i].ikJoint = in.readInt();
            this.vertex[i].ikWeight = in.readDouble();
            if (version != 0) continue;
            for (int j = 0; j < this.paramValue.length; ++j) {
                ((VertexParameterValue)this.paramValue[j]).getValue()[i] = in.readDouble();
            }
        }
        this.edge = new Edge[in.readInt()];
        for (i = 0; i < this.edge.length; ++i) {
            this.edge[i] = new Edge(in.readInt(), in.readInt(), in.readInt());
            this.edge[i].f2 = in.readInt();
            this.edge[i].smoothness = in.readFloat();
        }
        this.face = new Face[in.readInt()];
        for (i = 0; i < this.face.length; ++i) {
            this.face[i] = new Face(in.readInt(), in.readInt(), in.readInt(), in.readInt(), in.readInt(), in.readInt());
        }
        this.closed = in.readBoolean();
        this.smoothingMethod = in.readInt();
        for (i = 0; i < this.edge.length; ++i) {
            Vertex v1 = this.vertex[this.edge[i].v1];
            Vertex v2 = this.vertex[this.edge[i].v2];
            ++v1.edges;
            ++v2.edges;
            if (this.edge[i].f2 == -1) {
                v1.firstEdge = v2.firstEdge = i;
                continue;
            }
            if (v1.firstEdge == -1) {
                v1.firstEdge = i;
            }
            if (v2.firstEdge != -1) continue;
            v2.firstEdge = i;
        }
        this.skeleton = new Skeleton(in);
    }

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        int i;
        super.writeToFile(out, theScene);
        out.writeShort(1);
        out.writeInt(this.vertex.length);
        for (i = 0; i < this.vertex.length; ++i) {
            this.vertex[i].r.writeToFile(out);
            out.writeFloat(this.vertex[i].smoothness);
            out.writeInt(this.vertex[i].ikJoint);
            out.writeDouble(this.vertex[i].ikWeight);
        }
        out.writeInt(this.edge.length);
        for (i = 0; i < this.edge.length; ++i) {
            out.writeInt(this.edge[i].v1);
            out.writeInt(this.edge[i].v2);
            out.writeInt(this.edge[i].f1);
            out.writeInt(this.edge[i].f2);
            out.writeFloat(this.edge[i].smoothness);
        }
        out.writeInt(this.face.length);
        for (i = 0; i < this.face.length; ++i) {
            out.writeInt(this.face[i].v1);
            out.writeInt(this.face[i].v2);
            out.writeInt(this.face[i].v3);
            out.writeInt(this.face[i].e1);
            out.writeInt(this.face[i].e2);
            out.writeInt(this.face[i].e3);
        }
        out.writeBoolean(this.closed);
        out.writeInt(this.smoothingMethod);
        this.skeleton.writeToStream(out);
    }

    public Property[] getProperties() {
        return (Property[])PROPERTIES.clone();
    }

    public Object getPropertyValue(int index) {
        return PROPERTIES[0].getAllowedValues()[this.smoothingMethod];
    }

    public void setPropertyValue(int index, Object value) {
        Object[] values = PROPERTIES[0].getAllowedValues();
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].equals(value)) continue;
            this.setSmoothingMethod(i);
        }
    }

    public Keyframe getPoseKeyframe() {
        return new TriangleMeshKeyframe(this);
    }

    public void applyPoseKeyframe(Keyframe k) {
        int i;
        TriangleMeshKeyframe key = (TriangleMeshKeyframe)k;
        for (i = 0; i < this.vertex.length; ++i) {
            Vertex v = this.vertex[i];
            v.r.set(key.vertPos[i]);
            v.smoothness = key.vertSmoothness[i];
        }
        if (this.texParam != null && this.texParam.length > 0) {
            for (i = 0; i < this.texParam.length; ++i) {
                this.paramValue[i] = key.paramValue[i].duplicate();
            }
        }
        for (i = 0; i < this.edge.length; ++i) {
            this.edge[i].smoothness = key.edgeSmoothness[i];
        }
        this.skeleton.copy(key.skeleton);
        this.cachedMesh = null;
        this.cachedWire = null;
        this.bounds = null;
    }

    public boolean canConvertToActor() {
        return true;
    }

    public Object3D getPosableObject() {
        TriangleMesh m = (TriangleMesh)this.duplicate();
        return new Actor(m);
    }

    static {
        double beta;
        int i;
        PROPERTIES = new Property[]{new Property(Translate.text("menu.smoothingMethod"), new Object[]{Translate.text("menu.none"), Translate.text("menu.shading"), Translate.text("menu.interpolating"), Translate.text("menu.approximating")}, Translate.text("menu.shading"))};
        LOOP_BETA = new double[32];
        for (i = 3; i < LOOP_BETA.length; ++i) {
            beta = 0.375 + 0.25 * Math.cos(Math.PI * 2 / (double)i);
            TriangleMesh.LOOP_BETA[i] = (0.625 - beta * beta) / (double)i;
        }
        BUTTERFLY_COEFF = new double[32][];
        for (i = 5; i < BUTTERFLY_COEFF.length; ++i) {
            TriangleMesh.BUTTERFLY_COEFF[i] = new double[i + 1];
            TriangleMesh.BUTTERFLY_COEFF[i][i] = 1.0;
            beta = Math.PI * 2 / (double)i;
            for (int j = 0; j < i; ++j) {
                TriangleMesh.BUTTERFLY_COEFF[i][j] = (0.25 + Math.cos(beta * (double)j) + 0.5 * Math.cos(2.0 * beta * (double)j)) / (double)i;
                double[] dArray = BUTTERFLY_COEFF[i];
                int n = i;
                dArray[n] = dArray[n] - BUTTERFLY_COEFF[i][j];
            }
        }
        TriangleMesh.BUTTERFLY_COEFF[3] = new double[]{0.4166666666666667, -0.08333333333333333, -0.08333333333333333, 0.75};
        TriangleMesh.BUTTERFLY_COEFF[4] = new double[]{0.375, 0.0, -0.125, 0.0, 0.75};
        TriangleMesh.BUTTERFLY_COEFF[6] = new double[]{1.0, 0.125, -0.125, 0.0, -0.125, 0.125, 0.0};
    }

    public static class TriangleMeshKeyframe
    extends MeshGesture {
        Vec3[] vertPos;
        float[] vertSmoothness;
        float[] edgeSmoothness;
        ParameterValue[] paramValue;
        Skeleton skeleton;
        TriangleMesh mesh;

        public TriangleMeshKeyframe(TriangleMesh mesh) {
            int i;
            this.mesh = mesh;
            this.skeleton = mesh.getSkeleton().duplicate();
            this.vertPos = new Vec3[mesh.vertex.length];
            this.vertSmoothness = new float[mesh.vertex.length];
            this.edgeSmoothness = new float[mesh.edge.length];
            for (i = 0; i < this.vertPos.length; ++i) {
                Vertex v = mesh.vertex[i];
                this.vertPos[i] = new Vec3(v.r);
                this.vertSmoothness[i] = v.smoothness;
            }
            for (i = 0; i < this.edgeSmoothness.length; ++i) {
                this.edgeSmoothness[i] = ((TriangleMesh)mesh).edge[i].smoothness;
            }
            this.paramValue = new ParameterValue[mesh.texParam.length];
            for (i = 0; i < this.paramValue.length; ++i) {
                this.paramValue[i] = mesh.paramValue[i].duplicate();
            }
        }

        private TriangleMeshKeyframe() {
        }

        protected Mesh getMesh() {
            return this.mesh;
        }

        protected Vec3[] getVertexPositions() {
            return this.vertPos;
        }

        protected void setVertexPositions(Vec3[] pos) {
            this.vertPos = pos;
        }

        public Skeleton getSkeleton() {
            return this.skeleton;
        }

        public void setSkeleton(Skeleton s) {
            this.skeleton = s;
        }

        public Keyframe duplicate() {
            return this.duplicate(this.mesh);
        }

        public Keyframe duplicate(Object owner) {
            int i;
            TriangleMeshKeyframe k = new TriangleMeshKeyframe();
            k.mesh = owner instanceof TriangleMesh ? (TriangleMesh)owner : (TriangleMesh)((ObjectInfo)owner).getObject();
            k.skeleton = this.skeleton.duplicate();
            k.vertPos = new Vec3[this.vertPos.length];
            k.vertSmoothness = new float[this.vertSmoothness.length];
            k.edgeSmoothness = new float[this.edgeSmoothness.length];
            for (i = 0; i < this.vertPos.length; ++i) {
                k.vertPos[i] = new Vec3(this.vertPos[i]);
                k.vertSmoothness[i] = this.vertSmoothness[i];
            }
            for (i = 0; i < this.edgeSmoothness.length; ++i) {
                k.edgeSmoothness[i] = this.edgeSmoothness[i];
            }
            k.paramValue = new ParameterValue[this.paramValue.length];
            for (i = 0; i < this.paramValue.length; ++i) {
                k.paramValue[i] = this.paramValue[i].duplicate();
            }
            return k;
        }

        public double[] getGraphValues() {
            return new double[0];
        }

        public void setGraphValues(double[] values) {
        }

        public Keyframe blend(Keyframe o2, double weight1, double weight2) {
            return null;
        }

        public Keyframe blend(Keyframe o2, Keyframe o3, double weight1, double weight2, double weight3) {
            return null;
        }

        public Keyframe blend(Keyframe o2, Keyframe o3, Keyframe o4, double weight1, double weight2, double weight3, double weight4) {
            return null;
        }

        public void blendSurface(MeshGesture average, MeshGesture[] p, double[] weight) {
            int i;
            super.blendSurface(average, p, weight);
            TriangleMeshKeyframe avg = (TriangleMeshKeyframe)average;
            for (i = 0; i < weight.length; ++i) {
                int j;
                TriangleMeshKeyframe key = (TriangleMeshKeyframe)p[i];
                for (j = 0; j < this.vertSmoothness.length; ++j) {
                    int n = j;
                    avg.vertSmoothness[n] = avg.vertSmoothness[n] + (float)(weight[i] * (double)(key.vertSmoothness[j] - this.vertSmoothness[j]));
                }
                for (j = 0; j < this.edgeSmoothness.length; ++j) {
                    int n = j;
                    avg.edgeSmoothness[n] = (float)((double)avg.edgeSmoothness[n] + weight[i] * (double)(key.edgeSmoothness[j] - this.edgeSmoothness[j]));
                }
            }
            for (i = 0; i < this.vertSmoothness.length; ++i) {
                if ((double)avg.vertSmoothness[i] < 0.0) {
                    avg.vertSmoothness[i] = 0.0f;
                }
                if (!((double)avg.vertSmoothness[i] > 1.0)) continue;
                avg.vertSmoothness[i] = 1.0f;
            }
            for (i = 0; i < this.edgeSmoothness.length; ++i) {
                if ((double)avg.edgeSmoothness[i] < 0.0) {
                    avg.edgeSmoothness[i] = 0.0f;
                }
                if (!((double)avg.edgeSmoothness[i] > 1.0)) continue;
                avg.edgeSmoothness[i] = 1.0f;
            }
        }

        public boolean equals(Keyframe k) {
            int i;
            if (!(k instanceof TriangleMeshKeyframe)) {
                return false;
            }
            TriangleMeshKeyframe key = (TriangleMeshKeyframe)k;
            for (i = 0; i < this.vertPos.length; ++i) {
                if (!this.vertPos[i].equals(key.vertPos[i])) {
                    return false;
                }
                if (this.vertSmoothness[i] == key.vertSmoothness[i]) continue;
                return false;
            }
            for (i = 0; i < this.paramValue.length; ++i) {
                if (this.paramValue[i].equals(key.paramValue[i])) continue;
                return false;
            }
            for (i = 0; i < this.edgeSmoothness.length; ++i) {
                if (this.edgeSmoothness[i] == key.edgeSmoothness[i]) continue;
                return false;
            }
            return this.skeleton.equals(key.skeleton);
        }

        public void textureChanged(TextureParameter[] oldParams, TextureParameter[] newParams) {
            ParameterValue[] newval = new ParameterValue[newParams.length];
            block0: for (int i = 0; i < newParams.length; ++i) {
                int j;
                for (j = 0; j < oldParams.length && !oldParams[j].equals(newParams[i]); ++j) {
                }
                if (j == oldParams.length) {
                    for (int k = 0; k < this.mesh.texParam.length; ++k) {
                        if (!this.mesh.texParam[k].equals(newParams[i])) continue;
                        newval[i] = this.mesh.paramValue[k].duplicate();
                        continue block0;
                    }
                    continue;
                }
                newval[i] = this.paramValue[j];
            }
            this.paramValue = newval;
        }

        public ParameterValue getTextureParameter(TextureParameter p) {
            for (int i = 0; i < this.mesh.texParam.length; ++i) {
                if (!this.mesh.texParam[i].equals(p)) continue;
                return this.paramValue[i];
            }
            return null;
        }

        public void setTextureParameter(TextureParameter p, ParameterValue value) {
            int which;
            for (which = 0; which < this.mesh.texParam.length && !this.mesh.texParam[which].equals(p); ++which) {
            }
            if (which == this.mesh.texParam.length) {
                return;
            }
            this.paramValue[which] = value;
        }

        public void writeToStream(DataOutputStream out) throws IOException {
            int i;
            out.writeShort(1);
            out.writeInt(this.vertPos.length);
            for (i = 0; i < this.vertPos.length; ++i) {
                this.vertPos[i].writeToFile(out);
                out.writeFloat(this.vertSmoothness[i]);
            }
            for (i = 0; i < this.paramValue.length; ++i) {
                out.writeUTF(this.paramValue[i].getClass().getName());
                this.paramValue[i].writeToStream(out);
            }
            out.writeInt(this.edgeSmoothness.length);
            for (i = 0; i < this.edgeSmoothness.length; ++i) {
                out.writeFloat(this.edgeSmoothness[i]);
            }
            Joint[] joint = this.skeleton.getJoints();
            for (int i2 = 0; i2 < joint.length; ++i2) {
                joint[i2].coords.writeToFile(out);
                out.writeDouble(joint[i2].angle1.pos);
                out.writeDouble(joint[i2].angle2.pos);
                out.writeDouble(joint[i2].twist.pos);
                out.writeDouble(joint[i2].length.pos);
            }
        }

        public TriangleMeshKeyframe(DataInputStream in, Object parent) throws IOException, InvalidObjectException {
            this();
            int i;
            short version = in.readShort();
            if (version < 0 || version > 1) {
                throw new InvalidObjectException("");
            }
            this.mesh = (TriangleMesh)parent;
            int numVert = in.readInt();
            this.vertPos = new Vec3[numVert];
            this.vertSmoothness = new float[numVert];
            this.paramValue = new ParameterValue[this.mesh.texParam.length];
            if (version == 0) {
                for (i = 0; i < this.paramValue.length; ++i) {
                    this.paramValue[i] = new VertexParameterValue(new double[numVert]);
                }
            }
            for (i = 0; i < numVert; ++i) {
                this.vertPos[i] = new Vec3(in);
                this.vertSmoothness[i] = in.readFloat();
                if (version != 0) continue;
                for (int j = 0; j < this.paramValue.length; ++j) {
                    ((VertexParameterValue)this.paramValue[j]).getValue()[i] = in.readDouble();
                }
            }
            if (version > 0) {
                for (i = 0; i < this.paramValue.length; ++i) {
                    this.paramValue[i] = Object3D.readParameterValue(in);
                }
            }
            this.edgeSmoothness = new float[in.readInt()];
            for (i = 0; i < this.edgeSmoothness.length; ++i) {
                this.edgeSmoothness[i] = in.readFloat();
            }
            this.skeleton = this.mesh.getSkeleton().duplicate();
            Joint[] joint = this.skeleton.getJoints();
            for (int i2 = 0; i2 < joint.length; ++i2) {
                joint[i2].coords = new CoordinateSystem(in);
                joint[i2].angle1.pos = in.readDouble();
                joint[i2].angle2.pos = in.readDouble();
                joint[i2].twist.pos = in.readDouble();
                joint[i2].length.pos = in.readDouble();
            }
        }
    }

    public class Face {
        public int v1;
        public int v2;
        public int v3;
        public int e1;
        public int e2;
        public int e3;

        public Face(int vertex1, int vertex2, int vertex3, int edge1, int edge2, int edge3) {
            this.v1 = vertex1;
            this.v2 = vertex2;
            this.v3 = vertex3;
            this.e1 = edge1;
            this.e2 = edge2;
            this.e3 = edge3;
        }

        public int getSharedFace(Face f) {
            if (f.e1 == this.e1 || f.e2 == this.e1 || f.e3 == this.e1) {
                return this.e1;
            }
            if (f.e1 == this.e2 || f.e2 == this.e2 || f.e3 == this.e2) {
                return this.e2;
            }
            if (f.e1 == this.e3 || f.e2 == this.e3 || f.e3 == this.e3) {
                return this.e3;
            }
            return -1;
        }
    }

    public class Edge {
        public int v1;
        public int v2;
        public int f1;
        public int f2;
        public float smoothness;

        public Edge(int vertex1, int vertex2, int face1) {
            this.v1 = vertex1;
            this.v2 = vertex2;
            this.f1 = face1;
            this.f2 = -1;
            this.smoothness = 1.0f;
        }
    }

    public class Vertex
    extends MeshVertex {
        public int edges;
        public int firstEdge;
        public float smoothness;

        public Vertex(Vec3 p) {
            super(p);
            this.edges = 0;
            this.firstEdge = -1;
            this.smoothness = 1.0f;
        }

        public Vertex(Vertex v) {
            super(v);
            this.edges = v.edges;
            this.firstEdge = v.firstEdge;
            this.smoothness = v.smoothness;
        }

        public void copy(Vertex v) {
            this.r.set(v.r);
            this.edges = v.edges;
            this.firstEdge = v.firstEdge;
            this.smoothness = v.smoothness;
            this.ikJoint = v.ikJoint;
            this.ikWeight = v.ikWeight;
        }

        public void scale(double d) {
            this.r.scale(d);
            this.smoothness = (float)((double)this.smoothness * d);
            this.ikWeight *= d;
        }

        public void clear() {
            this.r.set(0.0, 0.0, 0.0);
            this.smoothness = 0.0f;
            this.ikWeight = 0.0;
        }

        public int[] getEdges() {
            int[] e = new int[this.edges];
            if (this.edges == 0) {
                return e;
            }
            Face f = TriangleMesh.this.face[((TriangleMesh)TriangleMesh.this).edge[this.firstEdge].f1];
            e[0] = this.firstEdge;
            for (int i = 1; i < this.edges; ++i) {
                e[i] = TriangleMesh.this.vertex[f.v1] == this ? (f.e1 == e[i - 1] ? f.e3 : f.e1) : (TriangleMesh.this.vertex[f.v2] == this ? (f.e1 == e[i - 1] ? f.e2 : f.e1) : (f.e2 == e[i - 1] ? f.e3 : f.e2));
                f = TriangleMesh.this.face[((TriangleMesh)TriangleMesh.this).edge[e[i]].f1] == f && ((TriangleMesh)TriangleMesh.this).edge[e[i]].f2 > -1 ? TriangleMesh.this.face[((TriangleMesh)TriangleMesh.this).edge[e[i]].f2] : TriangleMesh.this.face[((TriangleMesh)TriangleMesh.this).edge[e[i]].f1];
            }
            return e;
        }

        public boolean clockwise() {
            Face f = TriangleMesh.this.face[((TriangleMesh)TriangleMesh.this).edge[this.firstEdge].f1];
            if (f.e1 == this.firstEdge) {
                return TriangleMesh.this.vertex[f.v2] == this;
            }
            if (f.e2 == this.firstEdge) {
                return TriangleMesh.this.vertex[f.v3] == this;
            }
            return TriangleMesh.this.vertex[f.v1] == this;
        }
    }
}

