/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.object;

import artofillusion.ArtOfIllusion;
import artofillusion.MeshViewer;
import artofillusion.Property;
import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.Scene;
import artofillusion.SplineMeshEditorWindow;
import artofillusion.SplineMeshViewer;
import artofillusion.TextureParameter;
import artofillusion.ViewerCanvas;
import artofillusion.WireframeMesh;
import artofillusion.animation.Actor;
import artofillusion.animation.Joint;
import artofillusion.animation.Keyframe;
import artofillusion.animation.MeshGesture;
import artofillusion.animation.Skeleton;
import artofillusion.material.Material;
import artofillusion.material.MaterialMapping;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.ParameterValue;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.VertexParameterValue;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.MeshEditController;
import artofillusion.ui.Translate;
import buoy.widget.RowContainer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;

public class SplineMesh
extends Object3D
implements Mesh {
    MeshVertex[] vertex;
    Skeleton skeleton;
    boolean uclosed;
    boolean vclosed;
    BoundingBox bounds;
    int usize;
    int vsize;
    int cachedUSize;
    int cachedVSize;
    int smoothingMethod;
    float[] usmoothness;
    float[] vsmoothness;
    SoftReference<RenderingMesh> cachedMesh;
    SoftReference<WireframeMesh> cachedWire;
    private static final int MAX_SUBDIVISIONS = 20;
    private static final Property[] PROPERTIES = new Property[]{new Property(Translate.text("menu.smoothingMethod"), new Object[]{Translate.text("menu.interpolating"), Translate.text("menu.approximating")}, Translate.text("menu.shading")), new Property(Translate.text("menu.closed"), new Object[]{Translate.text("menu.udirection"), Translate.text("menu.vdirection"), Translate.text("menu.both"), Translate.text("menu.neither")}, Translate.text("menu.neither"))};

    public SplineMesh(Vec3[][] v, float[] usmoothness, float[] vsmoothness, int smoothingMethod, boolean uclosed, boolean vclosed) {
        this.smoothingMethod = smoothingMethod;
        this.uclosed = uclosed;
        this.vclosed = vclosed;
        this.setSkeleton(new Skeleton());
        MeshVertex[][] vert = new MeshVertex[v.length][v[0].length];
        for (int i = 0; i < v.length; ++i) {
            for (int j = 0; j < v[0].length; ++j) {
                vert[i][j] = new MeshVertex(v[i][j]);
            }
        }
        this.setShape(vert, usmoothness, vsmoothness);
    }

    protected SplineMesh() {
    }

    public Object3D duplicate() {
        SplineMesh mesh = new SplineMesh();
        mesh.copyObject(this);
        return mesh;
    }

    public void copyObject(Object3D obj) {
        int i;
        SplineMesh mesh = (SplineMesh)obj;
        this.texParam = null;
        this.vertex = new MeshVertex[mesh.vertex.length];
        for (i = 0; i < mesh.vertex.length; ++i) {
            this.vertex[i] = new MeshVertex(mesh.vertex[i]);
        }
        this.usmoothness = new float[mesh.usize];
        for (i = 0; i < mesh.usize; ++i) {
            this.usmoothness[i] = mesh.usmoothness[i];
        }
        this.vsmoothness = new float[mesh.vsize];
        for (i = 0; i < mesh.vsize; ++i) {
            this.vsmoothness[i] = mesh.vsmoothness[i];
        }
        this.setSmoothingMethod(mesh.getSmoothingMethod());
        if (this.skeleton == null) {
            this.skeleton = mesh.skeleton.duplicate();
        } else {
            this.skeleton.copy(mesh.skeleton);
        }
        this.usize = mesh.usize;
        this.vsize = mesh.vsize;
        this.uclosed = mesh.uclosed;
        this.vclosed = mesh.vclosed;
        this.copyTextureAndMaterial(obj);
    }

    void findBounds() {
        double maxz;
        double maxy;
        double maxx;
        Object cached;
        Vec3[] vert = null;
        if (this.cachedMesh != null && (cached = this.cachedMesh.get()) != null) {
            vert = ((RenderingMesh)cached).vert;
        }
        if (vert == null && this.cachedWire != null) {
            cached = this.cachedWire.get();
            if (cached != null) {
                vert = ((WireframeMesh)cached).vert;
            }
            vert = ((WireframeMesh)cached).vert;
        }
        if (vert == null) {
            vert = this.getWireframeMesh().vert;
        }
        double minx = maxx = vert[0].x;
        double miny = maxy = vert[0].y;
        double minz = maxz = vert[0].z;
        for (int i = 1; i < vert.length; ++i) {
            if (vert[i].x < minx) {
                minx = vert[i].x;
            }
            if (vert[i].x > maxx) {
                maxx = vert[i].x;
            }
            if (vert[i].y < miny) {
                miny = vert[i].y;
            }
            if (vert[i].y > maxy) {
                maxy = vert[i].y;
            }
            if (vert[i].z < minz) {
                minz = vert[i].z;
            }
            if (!(vert[i].z > maxz)) continue;
            maxz = vert[i].z;
        }
        this.bounds = new BoundingBox(minx, maxx, miny, maxy, minz, maxz);
    }

    public BoundingBox getBounds() {
        if (this.bounds == null) {
            this.findBounds();
        }
        return this.bounds;
    }

    public MeshVertex[] getVertices() {
        return this.vertex;
    }

    public final MeshVertex getVertex(int u, int v) {
        return this.vertex[u + this.usize * v];
    }

    public final int getUSize() {
        return this.usize;
    }

    public final int getVSize() {
        return this.vsize;
    }

    public int getSmoothingMethod() {
        return this.smoothingMethod;
    }

    public float[] getUSmoothness() {
        return this.usmoothness;
    }

    public float[] getVSmoothness() {
        return this.vsmoothness;
    }

    public Vec3[] getVertexPositions() {
        Vec3[] v = new Vec3[this.vertex.length];
        for (int i = 0; i < v.length; ++i) {
            v[i] = new Vec3(this.vertex[i].r);
        }
        return v;
    }

    public void setVertexPositions(Vec3[] v) {
        for (int i = 0; i < v.length; ++i) {
            this.vertex[i].r = v[i];
        }
        this.cachedMesh = null;
        this.cachedWire = null;
        this.bounds = null;
    }

    public void setSmoothingMethod(int method) {
        this.smoothingMethod = method;
        this.cachedMesh = null;
        this.cachedWire = null;
        this.bounds = null;
    }

    public void setSmoothness(float[] usmoothness, float[] vsmoothness) {
        this.usmoothness = usmoothness;
        this.vsmoothness = vsmoothness;
        this.cachedMesh = null;
        this.cachedWire = null;
        this.bounds = null;
    }

    public void setShape(MeshVertex[][] v, float[] usmoothness, float[] vsmoothness) {
        this.usize = v.length;
        this.vsize = v[0].length;
        this.vertex = new MeshVertex[this.usize * this.vsize];
        for (int i = 0; i < this.usize; ++i) {
            for (int j = 0; j < this.vsize; ++j) {
                this.vertex[i + this.usize * j] = v[i][j];
            }
        }
        this.usmoothness = usmoothness;
        this.vsmoothness = vsmoothness;
        this.cachedMesh = null;
        this.cachedWire = null;
        this.bounds = null;
    }

    public boolean isUClosed() {
        return this.uclosed;
    }

    public boolean isVClosed() {
        return this.vclosed;
    }

    public boolean isClosed() {
        int i;
        Vec3 v2;
        Vec3 v1;
        if (!this.vclosed) {
            v1 = this.vertex[0].r;
            v2 = this.vertex[this.usize * (this.vsize - 1)].r;
            for (i = 1; i < this.usize; ++i) {
                if (!(v1.distance2(this.vertex[i].r) > 1.0E-24) && !(v2.distance2(this.vertex[i + this.usize * (this.vsize - 1)].r) > 1.0E-24)) continue;
                return false;
            }
        }
        if (!this.uclosed) {
            v1 = this.vertex[0].r;
            v2 = this.vertex[this.usize - 1].r;
            for (i = 1; i < this.vsize; ++i) {
                if (!(v1.distance2(this.vertex[i * this.usize].r) > 1.0E-24) && !(v2.distance2(this.vertex[i * this.usize + this.usize - 1].r) > 1.0E-24)) continue;
                return false;
            }
        }
        return true;
    }

    public void setClosed(boolean u, boolean v) {
        this.uclosed = u;
        this.vclosed = v;
        this.cachedMesh = null;
        this.cachedWire = null;
        this.bounds = null;
    }

    public void setSize(double xsize, double ysize, double zsize) {
        Vec3 size = this.getBounds().getSize();
        double xscale = size.x == 0.0 ? 1.0 : xsize / size.x;
        double yscale = size.y == 0.0 ? 1.0 : ysize / size.y;
        double zscale = size.z == 0.0 ? 1.0 : zsize / size.z;
        for (int i = 0; i < this.vertex.length; ++i) {
            this.vertex[i].r.x *= xscale;
            this.vertex[i].r.y *= yscale;
            this.vertex[i].r.z *= zscale;
        }
        this.skeleton.scale(xscale, yscale, zscale);
        this.cachedMesh = null;
        this.cachedWire = null;
        this.bounds = null;
    }

    public boolean isEditable() {
        return true;
    }

    public void edit(EditingWindow parent, ObjectInfo info, Runnable cb) {
        SplineMeshEditorWindow ed = new SplineMeshEditorWindow(parent, "Spline Mesh '" + info.getName() + "'", info, cb, true);
        ed.setVisible(true);
    }

    public void editGesture(EditingWindow parent, ObjectInfo info, Runnable cb, ObjectInfo realObject) {
        SplineMeshEditorWindow ed = new SplineMeshEditorWindow(parent, "Gesture '" + info.getName() + "'", info, cb, false);
        ViewerCanvas[] views = ed.getAllViews();
        for (int i = 0; i < views.length; ++i) {
            ((MeshViewer)views[i]).setScene(parent.getScene(), realObject);
        }
        ed.setVisible(true);
    }

    public MeshViewer createMeshViewer(MeshEditController controller, RowContainer options) {
        return new SplineMeshViewer(controller, options);
    }

    public static SplineMesh subdivideMesh(SplineMesh mesh, double tol) {
        int j;
        int i;
        int k;
        int i2;
        SplineMesh newmesh = new SplineMesh();
        int usize = mesh.usize;
        int vsize = mesh.vsize;
        MeshVertex[][] v = new MeshVertex[vsize][usize];
        int numParam = mesh.texParam == null ? 0 : mesh.texParam.length;
        double[][][] param = new double[vsize][usize][numParam];
        for (i2 = 0; i2 < usize; ++i2) {
            for (int j2 = 0; j2 < vsize; ++j2) {
                v[j2][i2] = new MeshVertex(mesh.vertex[i2 + usize * j2]);
            }
        }
        for (k = 0; k < numParam; ++k) {
            if (!(mesh.paramValue[k] instanceof VertexParameterValue)) continue;
            double[] val = ((VertexParameterValue)mesh.paramValue[k]).getValue();
            for (i = 0; i < usize; ++i) {
                for (j = 0; j < vsize; ++j) {
                    param[j][i][k] = val[i + usize * j];
                }
            }
        }
        Object[] output = usize == 2 ? new Object[]{v, mesh.usmoothness, param} : (mesh.smoothingMethod == 2 ? SplineMesh.interpOneAxis(v, mesh.usmoothness, param, mesh.uclosed, tol) : SplineMesh.approxOneAxis(v, mesh.usmoothness, param, mesh.uclosed, tol));
        MeshVertex[][] newv = (MeshVertex[][])output[0];
        float[] newus = (float[])output[1];
        double[][][] newparam = (double[][][])output[2];
        v = new MeshVertex[newv[0].length][newv.length];
        for (i2 = 0; i2 < newv.length; ++i2) {
            for (int j3 = 0; j3 < newv[0].length; ++j3) {
                v[j3][i2] = newv[i2][j3];
            }
        }
        param = new double[newparam[0].length][newparam.length][newparam[0][0].length];
        for (i2 = 0; i2 < newparam.length; ++i2) {
            for (int j4 = 0; j4 < newparam[0].length; ++j4) {
                for (int k2 = 0; k2 < newparam[0][0].length; ++k2) {
                    param[j4][i2][k2] = newparam[i2][j4][k2];
                }
            }
        }
        output = vsize == 2 ? new Object[]{v, mesh.vsmoothness, param} : (mesh.smoothingMethod == 2 ? SplineMesh.interpOneAxis(v, mesh.vsmoothness, param, mesh.vclosed, tol) : SplineMesh.approxOneAxis(v, mesh.vsmoothness, param, mesh.vclosed, tol));
        v = (MeshVertex[][])output[0];
        newmesh.usize = v.length;
        newmesh.vsize = v[0].length;
        newmesh.vertex = new MeshVertex[newmesh.usize * newmesh.vsize];
        for (i2 = 0; i2 < newmesh.usize; ++i2) {
            for (int j5 = 0; j5 < newmesh.vsize; ++j5) {
                newmesh.vertex[i2 + newmesh.usize * j5] = v[i2][j5];
            }
        }
        newmesh.usmoothness = newus;
        newmesh.vsmoothness = (float[])output[1];
        newmesh.uclosed = mesh.uclosed;
        newmesh.vclosed = mesh.vclosed;
        newmesh.smoothingMethod = mesh.smoothingMethod;
        newmesh.skeleton = mesh.skeleton.duplicate();
        newmesh.copyTextureAndMaterial(mesh);
        param = (double[][][])output[2];
        for (k = 0; k < numParam; ++k) {
            if (!(newmesh.paramValue[k] instanceof VertexParameterValue)) continue;
            double[] val = new double[newmesh.usize * newmesh.vsize];
            for (i = 0; i < newmesh.usize; ++i) {
                for (j = 0; j < newmesh.vsize; ++j) {
                    val[i + newmesh.usize * j] = param[i][j][k];
                }
            }
            newmesh.paramValue[k] = new VertexParameterValue(val);
        }
        return newmesh;
    }

    private static Object[] interpOneAxis(MeshVertex[][] v, float[] s, double[][][] param, boolean closed, double tol) {
        int i;
        int numParam = param[0][0].length;
        double[] paramTemp = new double[numParam];
        double tol2 = tol * tol;
        boolean[] refine = closed ? new boolean[v[0].length] : new boolean[v[0].length - 1];
        for (i = 0; i < refine.length; ++i) {
            refine[i] = true;
        }
        int count = refine.length;
        int iterations = 0;
        do {
            int j;
            boolean[] newrefine = new boolean[refine.length + count];
            MeshVertex[][] newv = new MeshVertex[v.length][v[0].length + count];
            float[] news = new float[v[0].length + count];
            double[][][] newparam = new double[v.length][v[0].length + count][numParam];
            int k = 0;
            for (i = 0; i < refine.length; ++i) {
                int p4;
                int p3;
                for (j = 0; j < v.length; ++j) {
                    newv[j][k] = v[j][i];
                    newparam[j][k] = param[j][i];
                }
                news[k] = Math.min(s[i] * 2.0f, 1.0f);
                ++k;
                if (!refine[i]) continue;
                int p1 = i - 1;
                if (p1 < 0) {
                    p1 = closed ? v[0].length - 1 : 0;
                }
                if ((p3 = i + 1) == v[0].length) {
                    p3 = closed ? 0 : v[0].length - 1;
                }
                if ((p4 = i + 2) >= v[0].length) {
                    p4 = closed ? (p4 %= v[0].length) : v[0].length - 1;
                }
                for (j = 0; j < v.length; ++j) {
                    Vec3 temp;
                    newv[j][k] = SplineMesh.calcInterpPoint(v[j], s, param[j], paramTemp, p1, i, p3, p4);
                    for (int m = 0; m < numParam; ++m) {
                        newparam[j][k][m] = paramTemp[m];
                    }
                    if (!(v[j][i].r.distance2(newv[j][k].r) > tol2) || !(v[j][p3].r.distance2(newv[j][k].r) > tol2) || !((temp = v[j][i].r.plus(v[j][p3].r).times(0.5)).distance2(newv[j][k].r) > tol2)) continue;
                    newrefine[(k - 1 + newrefine.length) % newrefine.length] = true;
                    newrefine[k] = true;
                }
                news[k] = 1.0f;
                ++k;
            }
            if (!closed) {
                for (j = 0; j < v.length; ++j) {
                    newv[j][k] = v[j][i];
                    newparam[j][k] = param[j][i];
                }
            }
            count = 0;
            for (j = 0; j < newrefine.length; ++j) {
                if (!newrefine[j]) continue;
                ++count;
            }
            v = newv;
            s = news;
            param = newparam;
            refine = newrefine;
        } while (count > 0 && ++iterations < 20);
        return new Object[]{v, s, param};
    }

    private static Object[] approxOneAxis(MeshVertex[][] v, float[] s, double[][][] param, boolean closed, double tol) {
        int count;
        int i;
        int numParam = param[0][0].length;
        double[] paramTemp = new double[numParam];
        boolean[] refine = new boolean[v[0].length];
        for (i = 0; i < refine.length; ++i) {
            refine[i] = true;
        }
        if (closed) {
            count = refine.length;
        } else {
            count = refine.length - 1;
            refine[refine.length - 1] = false;
            refine[0] = false;
        }
        int iterations = 0;
        do {
            int j;
            boolean[] newrefine = new boolean[refine.length + count];
            MeshVertex[][] newv = new MeshVertex[v.length][v[0].length + count];
            float[] news = new float[v[0].length + count];
            double[][][] newparam = new double[v.length][v[0].length + count][numParam];
            int k = 0;
            for (i = 0; i < refine.length; ++i) {
                int m;
                int p3;
                int p1 = i - 1;
                if (p1 < 0) {
                    p1 = closed ? refine.length - 1 : 0;
                }
                if ((p3 = i + 1) == refine.length) {
                    p3 = closed ? 0 : refine.length - 1;
                }
                if (!refine[i]) {
                    for (j = 0; j < v.length; ++j) {
                        newv[j][k] = v[j][i];
                        newparam[j][k] = param[j][i];
                    }
                } else {
                    for (j = 0; j < v.length; ++j) {
                        newv[j][k] = SplineMesh.calcApproxPoint(v[j], s, param[j], paramTemp, p1, i, p3);
                        for (m = 0; m < numParam; ++m) {
                            newparam[j][k][m] = paramTemp[m];
                        }
                        Vec3 temp = newv[j][k].r.minus(v[j][i].r);
                        if (!(temp.length2() > tol * tol)) continue;
                        newrefine[(k + 1) % newrefine.length] = true;
                        newrefine[(k - 1 + newrefine.length) % newrefine.length] = true;
                        newrefine[k] = true;
                    }
                }
                news[k] = Math.min(s[i] * 2.0f, 1.0f);
                if (!closed && i == refine.length - 1) break;
                ++k;
                if (!refine[i] && !refine[p3]) continue;
                for (j = 0; j < v.length; ++j) {
                    newv[j][k] = MeshVertex.blend(v[j][i], v[j][p3], 0.5, 0.5);
                    for (m = 0; m < numParam; ++m) {
                        newparam[j][k][m] = 0.5 * (param[j][i][m] + param[j][p3][m]);
                    }
                }
                news[k] = 1.0f;
                ++k;
            }
            count = 0;
            for (j = 0; j < newrefine.length - 1; ++j) {
                if (!newrefine[j] && !newrefine[j + 1]) continue;
                ++count;
            }
            if (closed && (newrefine[0] || newrefine[newrefine.length - 1])) {
                ++count;
            }
            v = newv;
            s = news;
            param = newparam;
            refine = newrefine;
        } while (count > 0 && ++iterations < 20);
        return new Object[]{v, s, param};
    }

    public static MeshVertex calcInterpPoint(MeshVertex[] v, float[] s, double[][] oldParam, double[] newParam, int i, int j, int k, int m) {
        double w1 = -0.0625 * (double)s[j];
        double w2 = 0.5 - w1;
        double w4 = -0.0625 * (double)s[k];
        double w3 = 0.5 - w4;
        MeshVertex vt = new MeshVertex(new Vec3(w1 * v[i].r.x + w2 * v[j].r.x + w3 * v[k].r.x + w4 * v[m].r.x, w1 * v[i].r.y + w2 * v[j].r.y + w3 * v[k].r.y + w4 * v[m].r.y, w1 * v[i].r.z + w2 * v[j].r.z + w3 * v[k].r.z + w4 * v[m].r.z));
        for (int n = 0; n < newParam.length; ++n) {
            newParam[n] = w1 * oldParam[i][n] + w2 * oldParam[j][n] + w3 * oldParam[k][n] + w4 * oldParam[m][n];
        }
        if (v[j].ikJoint == v[k].ikJoint) {
            vt.ikJoint = v[j].ikJoint;
            vt.ikWeight = 0.5 * (v[j].ikWeight + v[k].ikWeight);
        } else if (v[j].ikWeight > v[k].ikWeight) {
            vt.ikJoint = v[j].ikJoint;
            vt.ikWeight = v[j].ikWeight;
        } else {
            vt.ikJoint = v[k].ikJoint;
            vt.ikWeight = v[k].ikWeight;
        }
        return vt;
    }

    public static MeshVertex calcApproxPoint(MeshVertex[] v, float[] s, double[][] oldParam, double[] newParam, int i, int j, int k) {
        double w1 = 0.125 * (double)s[j];
        double w2 = 1.0 - 2.0 * w1;
        MeshVertex vt = new MeshVertex(new Vec3(w1 * v[i].r.x + w2 * v[j].r.x + w1 * v[k].r.x, w1 * v[i].r.y + w2 * v[j].r.y + w1 * v[k].r.y, w1 * v[i].r.z + w2 * v[j].r.z + w1 * v[k].r.z));
        for (int n = 0; n < newParam.length; ++n) {
            newParam[n] = w1 * oldParam[i][n] + w2 * oldParam[j][n] + w1 * oldParam[k][n];
        }
        vt.ikJoint = v[j].ikJoint;
        vt.ikWeight = v[j].ikWeight;
        return vt;
    }

    public WireframeMesh getWireframeMesh() {
        int i;
        int vdim;
        int udim;
        Vec3[] point;
        Object cached;
        if (this.cachedWire != null && (cached = this.cachedWire.get()) != null) {
            return cached;
        }
        cached = null;
        if (this.cachedMesh != null) {
            cached = this.cachedMesh.get();
        }
        if (cached != null) {
            point = ((RenderingMesh)cached).vert;
            udim = this.cachedUSize;
            vdim = this.cachedVSize;
        } else {
            SplineMesh newmesh = SplineMesh.subdivideMesh(this, ArtOfIllusion.getPreferences().getInteractiveSurfaceError());
            this.cachedUSize = udim = newmesh.usize;
            this.cachedVSize = vdim = newmesh.vsize;
            point = new Vec3[newmesh.vertex.length];
            for (i = 0; i < point.length; ++i) {
                point[i] = newmesh.vertex[i].r;
            }
        }
        i = udim * (vdim - 1) + vdim * (udim - 1);
        if (this.uclosed) {
            i += vdim;
        }
        if (this.vclosed) {
            i += udim;
        }
        int[] from = new int[i];
        int[] to = new int[i];
        int k = 0;
        for (i = 0; i < udim - 1; ++i) {
            for (int j = 0; j < vdim - 1; ++j) {
                int n = i + udim * j;
                from[k + 1] = n;
                from[k] = n;
                to[k++] = i + 1 + udim * j;
                to[k++] = i + udim * (j + 1);
            }
        }
        for (i = 0; i < udim - 1; ++i) {
            from[k] = i + udim * (vdim - 1);
            to[k++] = i + 1 + udim * (vdim - 1);
        }
        for (i = 0; i < vdim - 1; ++i) {
            from[k] = udim - 1 + udim * i;
            to[k++] = udim - 1 + udim * (i + 1);
        }
        if (this.uclosed) {
            for (i = 0; i < vdim; ++i) {
                from[k] = i * udim;
                to[k++] = i * udim + udim - 1;
            }
        }
        if (this.vclosed) {
            for (i = 0; i < udim; ++i) {
                from[k] = i;
                to[k++] = i + udim * (vdim - 1);
            }
        }
        WireframeMesh wire = new WireframeMesh(point, from, to);
        this.cachedWire = new SoftReference<WireframeMesh>(wire);
        return wire;
    }

    public RenderingMesh getRenderingMesh(double tol, boolean interactive, ObjectInfo info) {
        int j;
        int i;
        int vdim;
        int udim;
        RenderingMesh cached;
        if (interactive && this.cachedMesh != null && (cached = this.cachedMesh.get()) != null) {
            return cached;
        }
        SplineMesh newmesh = SplineMesh.subdivideMesh(this, tol);
        float[] us = newmesh.usmoothness;
        float[] vs = newmesh.vsmoothness;
        this.cachedUSize = udim = newmesh.usize;
        this.cachedVSize = vdim = newmesh.vsize;
        Vec3[] point = new Vec3[newmesh.vertex.length];
        for (i = 0; i < point.length; ++i) {
            point[i] = newmesh.vertex[i].r;
        }
        ArrayList<Vec3> normal = new ArrayList<Vec3>(point.length);
        int[][][] normIndex = new int[udim][vdim][4];
        int k = 0;
        for (i = 0; i < udim; ++i) {
            for (j = 0; j < vdim; ++j) {
                int v2;
                int v1;
                int u2;
                int u1 = i - 1;
                if (u1 == -1) {
                    u1 = this.uclosed ? udim - 1 : 0;
                }
                if ((u2 = i + 1) == udim) {
                    u2 = this.uclosed ? 0 : i;
                }
                if ((v1 = j - 1) == -1) {
                    v1 = this.vclosed ? vdim - 1 : 0;
                }
                if ((v2 = j + 1) == vdim) {
                    v2 = this.vclosed ? 0 : j;
                }
                if (us[i] < 1.0f && vs[j] < 1.0f) {
                    normal.add(this.calcNormal(point, i, j, u1, i, v1, j, udim));
                    normal.add(this.calcNormal(point, i, j, i, u2, v1, j, udim));
                    normal.add(this.calcNormal(point, i, j, u1, i, j, v2, udim));
                    normal.add(this.calcNormal(point, i, j, i, u2, j, v2, udim));
                    normIndex[i][j][0] = k++;
                    normIndex[i][j][1] = k++;
                    normIndex[i][j][2] = k++;
                    normIndex[i][j][3] = k++;
                    continue;
                }
                if (us[i] < 1.0f) {
                    normal.add(this.calcNormal(point, i, j, u1, i, v1, v2, udim));
                    normal.add(this.calcNormal(point, i, j, i, u2, v1, v2, udim));
                    int n = k++;
                    normIndex[i][j][2] = n;
                    normIndex[i][j][0] = n;
                    int n2 = k++;
                    normIndex[i][j][3] = n2;
                    normIndex[i][j][1] = n2;
                    continue;
                }
                if (vs[j] < 1.0f) {
                    normal.add(this.calcNormal(point, i, j, u1, u2, v1, j, udim));
                    normal.add(this.calcNormal(point, i, j, u1, u2, j, v2, udim));
                    int n = k++;
                    normIndex[i][j][1] = n;
                    normIndex[i][j][0] = n;
                    int n3 = k++;
                    normIndex[i][j][3] = n3;
                    normIndex[i][j][2] = n3;
                    continue;
                }
                normal.add(this.calcNormal(point, i, j, u1, u2, v1, v2, udim));
                int n = k++;
                normIndex[i][j][3] = n;
                normIndex[i][j][2] = n;
                normIndex[i][j][1] = n;
                normIndex[i][j][0] = n;
            }
        }
        Vec3[] norm = new Vec3[normal.size()];
        for (i = 0; i < norm.length; ++i) {
            norm[i] = (Vec3)normal.get(i);
        }
        i = (udim - 1) * (vdim - 1);
        if (this.uclosed) {
            i += vdim - 1;
        }
        if (this.vclosed) {
            i += udim - 1;
        }
        if (this.uclosed && this.vclosed) {
            ++i;
        }
        RenderingTriangle[] tri = new RenderingTriangle[i *= 2];
        k = 0;
        for (i = 0; i < udim - 1; ++i) {
            for (j = 0; j < vdim - 1; ++j) {
                tri[k++] = this.texMapping.mapTriangle(i + udim * j, i + 1 + udim * j, i + 1 + udim * (j + 1), normIndex[i][j][3], normIndex[i + 1][j][2], normIndex[i + 1][j + 1][0], point);
                tri[k++] = this.texMapping.mapTriangle(i + udim * j, i + 1 + udim * (j + 1), i + udim * (j + 1), normIndex[i][j][3], normIndex[i + 1][j + 1][0], normIndex[i][j + 1][1], point);
            }
        }
        if (this.uclosed) {
            for (i = 0; i < vdim - 1; ++i) {
                tri[k++] = this.texMapping.mapTriangle((i + 1) * udim - 1, i * udim, (i + 1) * udim, normIndex[udim - 1][i][3], normIndex[0][i][2], normIndex[0][i + 1][0], point);
                tri[k++] = this.texMapping.mapTriangle((i + 1) * udim - 1, (i + 1) * udim, (i + 2) * udim - 1, normIndex[udim - 1][i][3], normIndex[0][i + 1][0], normIndex[udim - 1][i + 1][1], point);
            }
        }
        if (this.vclosed) {
            for (i = 0; i < udim - 1; ++i) {
                tri[k++] = this.texMapping.mapTriangle(i + udim * (vdim - 1), i + 1 + udim * (vdim - 1), i + 1, normIndex[i][vdim - 1][3], normIndex[i + 1][vdim - 1][2], normIndex[i + 1][0][0], point);
                tri[k++] = this.texMapping.mapTriangle(i + udim * (vdim - 1), i + 1, i, normIndex[i][vdim - 1][3], normIndex[i + 1][0][0], normIndex[i][0][1], point);
            }
        }
        if (this.uclosed && this.vclosed) {
            tri[k++] = this.texMapping.mapTriangle(udim * vdim - 1, udim * (vdim - 1), 0, normIndex[udim - 1][vdim - 1][3], normIndex[0][vdim - 1][2], normIndex[0][0][0], point);
            tri[k++] = this.texMapping.mapTriangle(udim * vdim - 1, 0, udim - 1, normIndex[udim - 1][vdim - 1][3], normIndex[0][0][0], normIndex[udim - 1][0][1], point);
        }
        RenderingMesh mesh = new RenderingMesh(point, norm, tri, this.texMapping, this.matMapping);
        mesh.setParameters(newmesh.paramValue);
        if (interactive) {
            this.cachedMesh = new SoftReference<RenderingMesh>(mesh);
        }
        return mesh;
    }

    private Vec3 calcNormal(Vec3[] point, int u, int v, int u1, int u2, int v1, int v2, int udim) {
        Vec3 vec2;
        double len2;
        Vec3 vec1 = point[u1 + udim * v].minus(point[u2 + udim * v]);
        double len1 = vec1.length2();
        if (len1 == 0.0) {
            vec1 = point[u1 + udim * v1].minus(point[u2 + udim * v1]);
            len1 = vec1.length2();
        }
        if (len1 == 0.0) {
            vec1 = point[u1 + udim * v2].minus(point[u2 + udim * v2]);
            len1 = vec1.length2();
        }
        if ((len2 = (vec2 = point[u + udim * v1].minus(point[u + udim * v2])).length2()) == 0.0) {
            vec2 = point[u1 + udim * v1].minus(point[u1 + udim * v2]);
            len2 = vec2.length2();
        }
        if (len2 == 0.0) {
            vec2 = point[u2 + udim * v1].minus(point[u2 + udim * v2]);
            len2 = vec2.length2();
        }
        if (len1 == 0.0 || len2 == 0.0) {
            return new Vec3();
        }
        Vec3 norm = vec1.cross(vec2);
        norm.normalize();
        return norm;
    }

    public int canConvertToTriangleMesh() {
        return 2;
    }

    public TriangleMesh convertToTriangleMesh(double tol) {
        int j;
        int i;
        SplineMesh newmesh = SplineMesh.subdivideMesh(this, tol);
        float[] us = newmesh.usmoothness;
        float[] vs = newmesh.vsmoothness;
        int udim = newmesh.usize;
        int vdim = newmesh.vsize;
        Vec3[] point = new Vec3[newmesh.vertex.length];
        for (i = 0; i < point.length; ++i) {
            point[i] = newmesh.vertex[i].r;
        }
        i = (udim - 1) * (vdim - 1);
        if (this.uclosed) {
            i += vdim - 1;
        }
        if (this.vclosed) {
            i += udim - 1;
        }
        if (this.uclosed && this.vclosed) {
            ++i;
        }
        int[][] faces = new int[i *= 2][];
        int k = 0;
        for (i = 0; i < udim - 1; ++i) {
            for (j = 0; j < vdim - 1; ++j) {
                faces[k++] = new int[]{i + udim * j, i + 1 + udim * j, i + 1 + udim * (j + 1)};
                faces[k++] = new int[]{i + udim * j, i + 1 + udim * (j + 1), i + udim * (j + 1)};
            }
        }
        if (this.uclosed) {
            for (i = 0; i < vdim - 1; ++i) {
                faces[k++] = new int[]{(i + 1) * udim - 1, i * udim, (i + 1) * udim};
                faces[k++] = new int[]{(i + 1) * udim - 1, (i + 1) * udim, (i + 2) * udim - 1};
            }
        }
        if (this.vclosed) {
            i = 0;
            while (i < udim - 1) {
                faces[k++] = new int[]{i + udim * (vdim - 1), i + 1 + udim * (vdim - 1), i + 1};
                faces[k++] = new int[]{i + udim * (vdim - 1), i + 1, i++};
            }
        }
        if (this.uclosed && this.vclosed) {
            faces[k++] = new int[]{udim * vdim - 1, udim * (vdim - 1), 0};
            faces[k++] = new int[]{udim * vdim - 1, 0, udim - 1};
        }
        TriangleMesh trimesh = new TriangleMesh(point, (int[][])faces);
        TriangleMesh.Edge[] ed = trimesh.getEdges();
        for (i = 0; i < ed.length; ++i) {
            j = ed[i].v1 / udim;
            k = ed[i].v2 / udim;
            if (j == k) {
                ed[i].smoothness = vs[j];
                continue;
            }
            j = ed[i].v1 % udim;
            ed[i].smoothness = us[j];
        }
        trimesh.copyTextureAndMaterial(newmesh);
        return trimesh;
    }

    public void setTexture(Texture tex, TextureMapping mapping) {
        super.setTexture(tex, mapping);
        this.cachedMesh = null;
        this.cachedWire = null;
    }

    public void setMaterial(Material mat, MaterialMapping map) {
        super.setMaterial(mat, map);
        this.cachedMesh = null;
    }

    public void setParameterValues(ParameterValue[] val) {
        super.setParameterValues(val);
        this.cachedMesh = null;
    }

    public void setParameterValue(TextureParameter param, ParameterValue val) {
        super.setParameterValue(param, val);
        this.cachedMesh = null;
    }

    public Skeleton getSkeleton() {
        return this.skeleton;
    }

    public void setSkeleton(Skeleton s) {
        this.skeleton = s;
    }

    public SplineMesh(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        super(in, theScene);
        int i;
        short version = in.readShort();
        if (version < 0 || version > 1) {
            throw new InvalidObjectException("");
        }
        this.usize = in.readInt();
        this.vsize = in.readInt();
        this.vertex = new MeshVertex[this.usize * this.vsize];
        this.usmoothness = new float[this.usize];
        this.vsmoothness = new float[this.vsize];
        if (version == 0) {
            for (i = 0; i < this.paramValue.length; ++i) {
                this.paramValue[i] = new VertexParameterValue(new double[this.vertex.length]);
            }
        }
        for (i = 0; i < this.vertex.length; ++i) {
            this.vertex[i] = new MeshVertex(new Vec3(in));
            this.vertex[i].ikJoint = in.readInt();
            this.vertex[i].ikWeight = in.readDouble();
            if (version != 0) continue;
            for (int j = 0; j < this.paramValue.length; ++j) {
                ((VertexParameterValue)this.paramValue[j]).getValue()[i] = in.readDouble();
            }
        }
        for (i = 0; i < this.usize; ++i) {
            this.usmoothness[i] = in.readFloat();
        }
        for (i = 0; i < this.vsize; ++i) {
            this.vsmoothness[i] = in.readFloat();
        }
        this.uclosed = in.readBoolean();
        this.vclosed = in.readBoolean();
        this.smoothingMethod = in.readInt();
        this.skeleton = new Skeleton(in);
        this.findBounds();
    }

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        int i;
        super.writeToFile(out, theScene);
        out.writeShort(1);
        out.writeInt(this.usize);
        out.writeInt(this.vsize);
        for (i = 0; i < this.vertex.length; ++i) {
            this.vertex[i].r.writeToFile(out);
            out.writeInt(this.vertex[i].ikJoint);
            out.writeDouble(this.vertex[i].ikWeight);
        }
        for (i = 0; i < this.usize; ++i) {
            out.writeFloat(this.usmoothness[i]);
        }
        for (i = 0; i < this.vsize; ++i) {
            out.writeFloat(this.vsmoothness[i]);
        }
        out.writeBoolean(this.uclosed);
        out.writeBoolean(this.vclosed);
        out.writeInt(this.smoothingMethod);
        this.skeleton.writeToStream(out);
    }

    public void makeRightSideOut() {
        Vec3[] norm = this.getNormals();
        Vec3 result = new Vec3();
        for (int i = 0; i < norm.length; ++i) {
            result.x += this.vertex[i].r.x * norm[i].x;
            result.y += this.vertex[i].r.y * norm[i].y;
            result.z += this.vertex[i].r.z * norm[i].z;
        }
        if (result.x + result.y + result.z < 0.0) {
            this.reverseOrientation();
        }
    }

    public void reverseOrientation() {
        for (int i = 0; i < this.usize / 2; ++i) {
            for (int j = 0; j < this.vsize; ++j) {
                MeshVertex swapVert = this.vertex[i + this.usize * j];
                this.vertex[i + this.usize * j] = this.vertex[this.usize - 1 - i + this.usize * j];
                this.vertex[this.usize - 1 - i + this.usize * j] = swapVert;
            }
            float swapSmooth = this.usmoothness[i];
            this.usmoothness[i] = this.usmoothness[this.usize - 1 - i];
            this.usmoothness[this.usize - 1 - i] = swapSmooth;
        }
        this.cachedMesh = null;
    }

    public Vec3[] getNormals() {
        int i;
        Vec3[] point = new Vec3[this.vertex.length];
        Vec3[] norm = new Vec3[this.vertex.length];
        for (i = 0; i < this.vertex.length; ++i) {
            point[i] = this.vertex[i].r;
        }
        for (i = 0; i < this.usize; ++i) {
            for (int j = 0; j < this.vsize; ++j) {
                int v2;
                int v1;
                int u2;
                int u1 = i - 1;
                if (u1 == -1) {
                    u1 = this.uclosed ? this.usize - 1 : 0;
                }
                if ((u2 = i + 1) == this.usize) {
                    u2 = this.uclosed ? 0 : i;
                }
                if ((v1 = j - 1) == -1) {
                    v1 = this.vclosed ? this.vsize - 1 : 0;
                }
                if ((v2 = j + 1) == this.vsize) {
                    v2 = this.vclosed ? 0 : j;
                }
                norm[i + this.usize * j] = this.calcNormal(point, i, j, u1, u2, v1, v2, this.usize);
            }
        }
        return norm;
    }

    public Property[] getProperties() {
        return (Property[])PROPERTIES.clone();
    }

    public Object getPropertyValue(int index) {
        if (index == 0) {
            return PROPERTIES[0].getAllowedValues()[this.smoothingMethod - 2];
        }
        Object[] values = PROPERTIES[1].getAllowedValues();
        if (this.uclosed && !this.vclosed) {
            return values[0];
        }
        if (!this.uclosed && this.vclosed) {
            return values[1];
        }
        if (this.uclosed && this.vclosed) {
            return values[2];
        }
        return values[3];
    }

    public void setPropertyValue(int index, Object value) {
        if (index == 0) {
            Object[] values = PROPERTIES[0].getAllowedValues();
            for (int i = 0; i < values.length; ++i) {
                if (!values[i].equals(value)) continue;
                this.setSmoothingMethod(i + 2);
            }
        } else {
            Object[] values = PROPERTIES[1].getAllowedValues();
            for (int i = 0; i < values.length; ++i) {
                if (!values[i].equals(value)) continue;
                this.setClosed(i == 0 || i == 2, i == 1 || i == 2);
            }
        }
    }

    public Keyframe getPoseKeyframe() {
        return new SplineMeshKeyframe(this);
    }

    public void applyPoseKeyframe(Keyframe k) {
        int i;
        SplineMeshKeyframe key = (SplineMeshKeyframe)k;
        for (i = 0; i < this.vertex.length; ++i) {
            this.vertex[i].r.set(key.vertPos[i]);
        }
        System.arraycopy(key.usmoothness, 0, this.usmoothness, 0, this.usmoothness.length);
        System.arraycopy(key.vsmoothness, 0, this.vsmoothness, 0, this.vsmoothness.length);
        if (this.texParam != null && this.texParam.length > 0) {
            for (i = 0; i < this.texParam.length; ++i) {
                this.paramValue[i] = key.paramValue[i].duplicate();
            }
        }
        this.skeleton.copy(key.skeleton);
        this.cachedMesh = null;
        this.cachedWire = null;
        this.findBounds();
    }

    public boolean canConvertToActor() {
        return true;
    }

    public Object3D getPosableObject() {
        SplineMesh m = (SplineMesh)this.duplicate();
        return new Actor(m);
    }

    public static class SplineMeshKeyframe
    extends MeshGesture {
        Vec3[] vertPos;
        float[] usmoothness;
        float[] vsmoothness;
        ParameterValue[] paramValue;
        Skeleton skeleton;
        SplineMesh mesh;

        public SplineMeshKeyframe(SplineMesh mesh) {
            int i;
            this.mesh = mesh;
            this.skeleton = mesh.getSkeleton().duplicate();
            this.vertPos = new Vec3[mesh.vertex.length];
            this.usmoothness = new float[mesh.usmoothness.length];
            this.vsmoothness = new float[mesh.vsmoothness.length];
            for (i = 0; i < this.vertPos.length; ++i) {
                this.vertPos[i] = new Vec3(mesh.vertex[i].r);
            }
            System.arraycopy(mesh.usmoothness, 0, this.usmoothness, 0, this.usmoothness.length);
            System.arraycopy(mesh.vsmoothness, 0, this.vsmoothness, 0, this.vsmoothness.length);
            this.paramValue = new ParameterValue[mesh.texParam.length];
            for (i = 0; i < this.paramValue.length; ++i) {
                this.paramValue[i] = mesh.paramValue[i].duplicate();
            }
        }

        private SplineMeshKeyframe() {
        }

        protected Mesh getMesh() {
            return this.mesh;
        }

        protected Vec3[] getVertexPositions() {
            return this.vertPos;
        }

        protected void setVertexPositions(Vec3[] pos) {
            this.vertPos = pos;
        }

        public Skeleton getSkeleton() {
            return this.skeleton;
        }

        public void setSkeleton(Skeleton s) {
            this.skeleton = s;
        }

        public Keyframe duplicate() {
            return this.duplicate(this.mesh);
        }

        public Keyframe duplicate(Object owner) {
            int i;
            SplineMeshKeyframe k = new SplineMeshKeyframe();
            k.mesh = owner instanceof SplineMesh ? (SplineMesh)owner : (SplineMesh)((ObjectInfo)owner).getObject();
            k.skeleton = this.skeleton.duplicate();
            k.vertPos = new Vec3[this.vertPos.length];
            k.usmoothness = new float[this.usmoothness.length];
            k.vsmoothness = new float[this.vsmoothness.length];
            for (i = 0; i < this.vertPos.length; ++i) {
                k.vertPos[i] = new Vec3(this.vertPos[i]);
            }
            System.arraycopy(this.usmoothness, 0, k.usmoothness, 0, this.usmoothness.length);
            System.arraycopy(this.vsmoothness, 0, k.vsmoothness, 0, this.vsmoothness.length);
            k.paramValue = new ParameterValue[this.paramValue.length];
            for (i = 0; i < this.paramValue.length; ++i) {
                k.paramValue[i] = this.paramValue[i].duplicate();
            }
            return k;
        }

        public double[] getGraphValues() {
            return new double[0];
        }

        public void setGraphValues(double[] values) {
        }

        public Keyframe blend(Keyframe o2, double weight1, double weight2) {
            return null;
        }

        public Keyframe blend(Keyframe o2, Keyframe o3, double weight1, double weight2, double weight3) {
            return null;
        }

        public Keyframe blend(Keyframe o2, Keyframe o3, Keyframe o4, double weight1, double weight2, double weight3, double weight4) {
            return null;
        }

        public void blendSurface(MeshGesture average, MeshGesture[] p, double[] weight) {
            int i;
            super.blendSurface(average, p, weight);
            SplineMeshKeyframe avg = (SplineMeshKeyframe)average;
            for (i = 0; i < weight.length; ++i) {
                int j;
                SplineMeshKeyframe key = (SplineMeshKeyframe)p[i];
                for (j = 0; j < this.usmoothness.length; ++j) {
                    int n = j;
                    avg.usmoothness[n] = (float)((double)avg.usmoothness[n] + weight[i] * (double)(key.usmoothness[j] - this.usmoothness[j]));
                }
                for (j = 0; j < this.vsmoothness.length; ++j) {
                    int n = j;
                    avg.vsmoothness[n] = (float)((double)avg.vsmoothness[n] + weight[i] * (double)(key.vsmoothness[j] - this.vsmoothness[j]));
                }
            }
            for (i = 0; i < avg.usmoothness.length; ++i) {
                if ((double)avg.usmoothness[i] < 0.0) {
                    avg.usmoothness[i] = 0.0f;
                }
                if (!((double)avg.usmoothness[i] > 1.0)) continue;
                avg.usmoothness[i] = 1.0f;
            }
            for (i = 0; i < avg.vsmoothness.length; ++i) {
                if ((double)avg.vsmoothness[i] < 0.0) {
                    avg.vsmoothness[i] = 0.0f;
                }
                if (!((double)avg.vsmoothness[i] > 1.0)) continue;
                avg.vsmoothness[i] = 1.0f;
            }
        }

        public boolean equals(Keyframe k) {
            int i;
            if (!(k instanceof SplineMeshKeyframe)) {
                return false;
            }
            SplineMeshKeyframe key = (SplineMeshKeyframe)k;
            for (i = 0; i < this.vertPos.length; ++i) {
                if (this.vertPos[i].equals(key.vertPos[i])) continue;
                return false;
            }
            for (i = 0; i < this.paramValue.length; ++i) {
                if (this.paramValue[i].equals(key.paramValue[i])) continue;
                return false;
            }
            for (i = 0; i < this.usmoothness.length; ++i) {
                if (this.usmoothness[i] == key.usmoothness[i]) continue;
                return false;
            }
            for (i = 0; i < this.vsmoothness.length; ++i) {
                if (this.vsmoothness[i] == key.vsmoothness[i]) continue;
                return false;
            }
            return this.skeleton.equals(key.skeleton);
        }

        public void textureChanged(TextureParameter[] oldParams, TextureParameter[] newParams) {
            ParameterValue[] newval = new ParameterValue[newParams.length];
            block0: for (int i = 0; i < newParams.length; ++i) {
                int j;
                for (j = 0; j < oldParams.length && !oldParams[j].equals(newParams[i]); ++j) {
                }
                if (j == oldParams.length) {
                    for (int k = 0; k < this.mesh.texParam.length; ++k) {
                        if (!this.mesh.texParam[k].equals(newParams[i])) continue;
                        newval[i] = this.mesh.paramValue[k].duplicate();
                        continue block0;
                    }
                    continue;
                }
                newval[i] = this.paramValue[j];
            }
            this.paramValue = newval;
        }

        public ParameterValue getTextureParameter(TextureParameter p) {
            for (int i = 0; i < this.mesh.texParam.length; ++i) {
                if (!this.mesh.texParam[i].equals(p)) continue;
                return this.paramValue[i];
            }
            return null;
        }

        public void setTextureParameter(TextureParameter p, ParameterValue value) {
            int which;
            for (which = 0; which < this.mesh.texParam.length && !this.mesh.texParam[which].equals(p); ++which) {
            }
            if (which == this.mesh.texParam.length) {
                return;
            }
            this.paramValue[which] = value;
        }

        public void writeToStream(DataOutputStream out) throws IOException {
            int i;
            out.writeShort(1);
            out.writeInt(this.vertPos.length);
            for (i = 0; i < this.vertPos.length; ++i) {
                this.vertPos[i].writeToFile(out);
            }
            for (i = 0; i < this.paramValue.length; ++i) {
                out.writeUTF(this.paramValue[i].getClass().getName());
                this.paramValue[i].writeToStream(out);
            }
            out.writeInt(this.usmoothness.length);
            for (i = 0; i < this.usmoothness.length; ++i) {
                out.writeFloat(this.usmoothness[i]);
            }
            out.writeInt(this.vsmoothness.length);
            for (i = 0; i < this.vsmoothness.length; ++i) {
                out.writeFloat(this.vsmoothness[i]);
            }
            Joint[] joint = this.skeleton.getJoints();
            for (int i2 = 0; i2 < joint.length; ++i2) {
                joint[i2].coords.writeToFile(out);
                out.writeDouble(joint[i2].angle1.pos);
                out.writeDouble(joint[i2].angle2.pos);
                out.writeDouble(joint[i2].twist.pos);
                out.writeDouble(joint[i2].length.pos);
            }
        }

        public SplineMeshKeyframe(DataInputStream in, Object parent) throws IOException, InvalidObjectException {
            this();
            int i;
            short version = in.readShort();
            if (version < 0 || version > 1) {
                throw new InvalidObjectException("");
            }
            this.mesh = (SplineMesh)parent;
            int numVert = in.readInt();
            this.vertPos = new Vec3[numVert];
            this.paramValue = new ParameterValue[this.mesh.texParam.length];
            if (version == 0) {
                for (i = 0; i < this.paramValue.length; ++i) {
                    this.paramValue[i] = new VertexParameterValue(new double[numVert]);
                }
            }
            for (i = 0; i < numVert; ++i) {
                this.vertPos[i] = new Vec3(in);
                if (version != 0) continue;
                for (int j = 0; j < this.paramValue.length; ++j) {
                    ((VertexParameterValue)this.paramValue[j]).getValue()[i] = in.readDouble();
                }
            }
            if (version > 0) {
                for (i = 0; i < this.paramValue.length; ++i) {
                    this.paramValue[i] = Object3D.readParameterValue(in);
                }
            }
            this.usmoothness = new float[in.readInt()];
            for (i = 0; i < this.usmoothness.length; ++i) {
                this.usmoothness[i] = in.readFloat();
            }
            this.vsmoothness = new float[in.readInt()];
            for (i = 0; i < this.vsmoothness.length; ++i) {
                this.vsmoothness[i] = in.readFloat();
            }
            this.skeleton = this.mesh.getSkeleton().duplicate();
            Joint[] joint = this.skeleton.getJoints();
            for (int i2 = 0; i2 < joint.length; ++i2) {
                joint[i2].coords = new CoordinateSystem(in);
                joint[i2].angle1.pos = in.readDouble();
                joint[i2].angle2.pos = in.readDouble();
                joint[i2].twist.pos = in.readDouble();
                joint[i2].length.pos = in.readDouble();
            }
        }
    }
}

