/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.object;

import artofillusion.MaterialPreviewer;
import artofillusion.Property;
import artofillusion.Scene;
import artofillusion.TextureParameter;
import artofillusion.animation.Keyframe;
import artofillusion.animation.PoseTrack;
import artofillusion.math.BoundingBox;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.DirectionalLight;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.PointLight;
import artofillusion.procedural.Module;
import artofillusion.procedural.OutputModule;
import artofillusion.procedural.ParameterModule;
import artofillusion.procedural.PointInfo;
import artofillusion.procedural.Procedure;
import artofillusion.procedural.ProcedureEditor;
import artofillusion.procedural.ProcedureOwner;
import artofillusion.texture.UniformTexture;
import artofillusion.ui.ActionProcessor;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueSelector;
import buoy.event.ValueChangedEvent;
import buoy.widget.BComboBox;
import buoy.widget.BDialog;
import buoy.widget.BFrame;
import buoy.widget.BorderContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.awt.Rectangle;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.util.HashMap;
import java.util.Map;

public class ProceduralPointLight
extends PointLight {
    private Procedure procedure;
    private ThreadLocal renderingProc;
    private double currentTime;
    private TextureParameter[] parameters;
    private double[] parameterValues;
    private static final Property[] PROPERTIES = new Property[]{new Property(Translate.text("Radius"), 0.0, 45.0, 1.0), new Property(Translate.text("lightType"), new String[]{Translate.text("normalLight"), Translate.text("shadowlessLight"), Translate.text("ambientLight")}, Translate.text("normalLight"))};

    public ProceduralPointLight(double theRadius) {
        super(new RGBColor(), 1.0f, theRadius);
        this.procedure = this.createProcedure();
        this.findParameters();
        this.initThreadLocal();
    }

    private Procedure createProcedure() {
        return new Procedure(new OutputModule[]{new OutputModule("Color", "White", 0.0, new RGBColor(1.0, 1.0, 1.0), 1), new OutputModule("Intensity", "1/r\u00b2", 1.0, null, 0)});
    }

    private void initThreadLocal() {
        this.renderingProc = new ThreadLocal(){

            protected Object initialValue() {
                Procedure localProc = ProceduralPointLight.this.createProcedure();
                localProc.copy(ProceduralPointLight.this.procedure);
                return localProc;
            }
        };
    }

    private void findParameters() {
        Module[] module = this.procedure.getModules();
        int count = 0;
        for (int i = 0; i < module.length; ++i) {
            if (!(module[i] instanceof ParameterModule)) continue;
            ++count;
        }
        TextureParameter[] newParameters = new TextureParameter[count];
        double[] newValues = new double[count];
        count = 0;
        for (int i = 0; i < module.length; ++i) {
            if (!(module[i] instanceof ParameterModule)) continue;
            newParameters[count] = ((ParameterModule)module[i]).getParameter(this);
            newValues[count] = newParameters[count].defaultVal;
            if (this.parameters != null) {
                for (int j = 0; j < this.parameters.length; ++j) {
                    if (!newParameters[count].equals(this.parameters[j])) continue;
                    newValues[count] = this.parameterValues[j];
                }
            }
            ((ParameterModule)module[i]).setIndex(count++);
        }
        this.parameters = newParameters;
        this.parameterValues = newValues;
    }

    public Object3D duplicate() {
        ProceduralPointLight light = new ProceduralPointLight(this.getRadius());
        light.copyObject(this);
        return light;
    }

    public void copyObject(Object3D obj) {
        ProceduralPointLight lt = (ProceduralPointLight)obj;
        this.setRadius(lt.getRadius());
        this.procedure.copy(lt.procedure);
    }

    public void sceneChanged(ObjectInfo info, Scene scene) {
        this.currentTime = scene.getTime();
    }

    public void getLight(RGBColor light, Vec3 position) {
        PointInfo point = new PointInfo();
        point.x = position.x;
        point.y = position.y;
        point.z = position.z;
        point.t = this.currentTime;
        point.param = this.parameterValues;
        Procedure pr = (Procedure)this.renderingProc.get();
        pr.initForPoint(point);
        OutputModule[] output = pr.getOutputModules();
        output[0].getColor(0, light, 0.0);
        double intensity = output[1].inputConnected(0) ? output[1].getAverageValue(0, 0.0) : 1.0 / position.length2();
        light.scale(intensity);
    }

    public ProceduralPointLight(DataInputStream in, Scene theScene) throws IOException {
        super(in, theScene);
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.procedure = this.createProcedure();
        this.procedure.readFromStream(in, theScene);
        bounds = new BoundingBox(-0.15, 0.15, -0.15, 0.15, -0.15, 0.25);
        this.findParameters();
        this.initThreadLocal();
    }

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        super.writeToFile(out, theScene);
        out.writeShort(0);
        this.procedure.writeToStream(out, theScene);
    }

    public void edit(EditingWindow parent, ObjectInfo info, Runnable cb) {
        ProcedureEditor editor = new ProcedureEditor(this.procedure, new LightProcedureOwner(info, cb), parent.getScene());
        editor.setEditingWindow(parent);
    }

    public Property[] getProperties() {
        Property[] properties = new Property[this.parameters.length + 2];
        for (int i = 0; i < this.parameters.length; ++i) {
            properties[i] = new Property(this.parameters[i].name, this.parameters[i].minVal, this.parameters[i].maxVal, this.parameters[i].defaultVal);
        }
        properties[properties.length - 2] = PROPERTIES[0];
        properties[properties.length - 1] = PROPERTIES[1];
        return properties;
    }

    public Object getPropertyValue(int index) {
        if (index < this.parameterValues.length) {
            return this.parameterValues[index];
        }
        switch (index - this.parameterValues.length) {
            case 0: {
                return new Double(this.getRadius());
            }
            case 1: {
                return PROPERTIES[1].getAllowedValues()[this.type];
            }
        }
        return null;
    }

    public void setPropertyValue(int index, Object value) {
        if (index < this.parameterValues.length) {
            this.parameterValues[index] = (Double)value;
        } else if (index == this.parameterValues.length) {
            this.setRadius((Double)value);
        } else if (index == this.parameterValues.length + 1) {
            Object[] values = PROPERTIES[index].getAllowedValues();
            for (int i = 0; i < values.length; ++i) {
                if (!values[i].equals(value)) continue;
                this.type = i;
            }
        }
    }

    public Keyframe getPoseKeyframe() {
        return new ProceduralLightKeyframe(this);
    }

    public void applyPoseKeyframe(Keyframe k) {
        ProceduralLightKeyframe key = (ProceduralLightKeyframe)k;
        this.setRadius(key.radius);
        for (int i = 0; i < this.parameters.length; ++i) {
            this.parameterValues[i] = key.paramValues.containsKey(this.parameters[i]) ? key.paramValues.get(this.parameters[i]) : this.parameters[i].defaultVal;
        }
    }

    public void configurePoseTrack(PoseTrack track) {
        String[] names = new String[this.parameters.length + 1];
        double[] defaults = new double[this.parameters.length + 1];
        double[][] ranges = new double[this.parameters.length + 1][];
        for (int i = 0; i < this.parameters.length; ++i) {
            TextureParameter param = this.parameters[i];
            names[i] = param.name;
            defaults[i] = param.defaultVal;
            ranges[i] = new double[]{param.minVal, param.maxVal};
        }
        names[this.parameters.length] = Translate.text("Radius");
        defaults[this.parameters.length] = this.getRadius();
        ranges[this.parameters.length] = new double[]{0.0, 45.0};
        track.setGraphableValues(names, defaults, ranges);
    }

    public void editKeyframe(EditingWindow parent, Keyframe k, ObjectInfo info) {
        ProceduralLightKeyframe key = (ProceduralLightKeyframe)k;
        Widget[] fields = new ValueSelector[this.parameters.length + 1];
        String[] names = new String[this.parameters.length + 1];
        for (int i = 0; i < this.parameters.length; ++i) {
            TextureParameter param = this.parameters[i];
            double value = key.paramValues.containsKey(param) ? key.paramValues.get(param) : param.defaultVal;
            double range = param.maxVal - param.minVal;
            if (range == 0.0 || Double.isInfinite(range)) {
                range = 1.0;
            }
            fields[i] = new ValueSelector(value, param.minVal, param.maxVal, range * 0.01);
            names[i] = param.name;
        }
        fields[fields.length - 1] = new ValueSelector(key.radius, 0.0, 45.0, 0.1);
        names[names.length - 1] = Translate.text("Radius");
        ComponentsDialog dlg = new ComponentsDialog(parent.getFrame(), Translate.text("editPointLightTitle"), fields, names);
        if (!dlg.clickedOk()) {
            return;
        }
        for (int i = 0; i < this.parameters.length; ++i) {
            key.paramValues.put(this.parameters[i], ((ValueSelector)fields[i]).getValue());
        }
        key.radius = ((ValueSelector)fields[fields.length - 1]).getValue();
    }

    private class LightProcedureOwner
    implements ProcedureOwner {
        private ObjectInfo info;
        private Runnable callback;

        public LightProcedureOwner(ObjectInfo info, Runnable callback) {
            this.info = info;
            this.callback = callback;
        }

        public String getWindowTitle() {
            return Translate.text("editProceduralPointLightTitle");
        }

        public Object getPreview(ProcedureEditor editor) {
            BDialog dlg = new BDialog(editor.getParentFrame(), "Preview", false);
            BorderContainer content = new BorderContainer();
            final MaterialPreviewer preview = new MaterialPreviewer(new UniformTexture(), null, 200, 160);
            Scene scene = preview.getScene();
            for (int i = 0; i < scene.getNumObjects(); ++i) {
                ObjectInfo info = scene.getObject(i);
                if (!(info.getObject() instanceof DirectionalLight)) continue;
                info.setObject(ProceduralPointLight.this);
                info.getCoords().setOrigin(new Vec3(1.0, 0.8, 2.0));
            }
            content.add(preview, BorderContainer.CENTER);
            RowContainer row = new RowContainer();
            content.add(row, BorderContainer.SOUTH, new LayoutInfo());
            row.add(Translate.label("Time", ":"));
            final ValueSelector value = new ValueSelector(0.0, -1.7976931348623157E308, Double.MAX_VALUE, 0.01);
            final ActionProcessor processor = new ActionProcessor();
            row.add(value);
            value.addEventLink(ValueChangedEvent.class, new Object(){

                void processEvent() {
                    processor.addEvent(new Runnable(){

                        public void run() {
                            preview.getScene().setTime(value.getValue());
                            preview.render();
                        }
                    });
                }
            });
            dlg.setContent(content);
            dlg.pack();
            Rectangle parentBounds = editor.getParentFrame().getBounds();
            Rectangle location = dlg.getBounds();
            location.y = parentBounds.y;
            location.x = parentBounds.x + parentBounds.width;
            dlg.setBounds(location);
            dlg.setVisible(true);
            return preview;
        }

        public void updatePreview(Object preview) {
            ProceduralPointLight.this.findParameters();
            ProceduralPointLight.this.initThreadLocal();
            ((MaterialPreviewer)preview).render();
        }

        public void disposePreview(Object preview) {
            UIUtilities.findWindow((MaterialPreviewer)preview).dispose();
        }

        public boolean allowParameters() {
            return true;
        }

        public boolean allowViewAngle() {
            return false;
        }

        public boolean canEditName() {
            return false;
        }

        public String getName() {
            return this.info.getName();
        }

        public void setName(String name) {
        }

        public void acceptEdits(ProcedureEditor editor) {
            ProceduralPointLight.this.findParameters();
            ProceduralPointLight.this.initThreadLocal();
            this.callback.run();
        }

        public void editProperties(ProcedureEditor editor) {
            ValueSelector radiusField = new ValueSelector(ProceduralPointLight.this.getRadius(), 0.0, 45.0, 0.1);
            BComboBox typeChoice = new BComboBox(new String[]{Translate.text("normalLight"), Translate.text("shadowlessLight"), Translate.text("ambientLight")});
            typeChoice.setSelectedIndex(ProceduralPointLight.this.type);
            BFrame parentFrame = editor.getParentFrame();
            ComponentsDialog dlg = new ComponentsDialog(parentFrame, Translate.text("Properties"), new Widget[]{radiusField, typeChoice}, new String[]{Translate.text("Radius"), Translate.text("lightType")});
            if (!dlg.clickedOk()) {
                return;
            }
            ProceduralPointLight.this.setParameters(ProceduralPointLight.this.getColor(), ProceduralPointLight.this.getIntensity(), typeChoice.getSelectedIndex(), ProceduralPointLight.this.getDecayRate());
            ProceduralPointLight.this.setRadius(radiusField.getValue());
        }
    }

    public static class ProceduralLightKeyframe
    implements Keyframe {
        private final ProceduralPointLight light;
        public HashMap<TextureParameter, Double> paramValues;
        public double radius;

        public ProceduralLightKeyframe(ProceduralPointLight light) {
            this.light = light;
            this.paramValues = new HashMap();
            for (int i = 0; i < light.parameters.length; ++i) {
                this.paramValues.put(light.parameters[i], light.parameterValues[i]);
            }
            this.radius = light.getRadius();
        }

        public Keyframe duplicate() {
            return this.duplicate(this.light);
        }

        public Keyframe duplicate(Object owner) {
            ProceduralLightKeyframe key = new ProceduralLightKeyframe((ProceduralPointLight)((ObjectInfo)owner).getObject());
            key.paramValues.clear();
            for (Map.Entry<TextureParameter, Double> entry : this.paramValues.entrySet()) {
                key.paramValues.put(entry.getKey(), entry.getValue());
            }
            key.radius = this.radius;
            return key;
        }

        public double[] getGraphValues() {
            double[] values = new double[this.light.parameters.length + 1];
            for (int i = 0; i < this.light.parameters.length; ++i) {
                TextureParameter param = this.light.parameters[i];
                values[i] = this.paramValues.containsKey(param) ? this.paramValues.get(param) : param.defaultVal;
            }
            values[values.length - 1] = this.radius;
            return values;
        }

        public void setGraphValues(double[] values) {
            this.paramValues.clear();
            for (int i = 0; i < this.light.parameters.length; ++i) {
                this.paramValues.put(this.light.parameters[i], values[i]);
            }
            this.radius = values[values.length - 1];
        }

        public Keyframe blend(Keyframe o2, double weight1, double weight2) {
            ProceduralLightKeyframe k2 = (ProceduralLightKeyframe)o2;
            ProceduralLightKeyframe key = new ProceduralLightKeyframe(this.light);
            key.radius = weight1 * this.radius + weight2 * k2.radius;
            for (TextureParameter param : this.light.parameters) {
                double val1 = this.paramValues.containsKey(param) ? this.paramValues.get(param) : param.defaultVal;
                double val2 = k2.paramValues.containsKey(param) ? k2.paramValues.get(param) : param.defaultVal;
                key.paramValues.put(param, weight1 * val1 + weight2 * val2);
            }
            return key;
        }

        public Keyframe blend(Keyframe o2, Keyframe o3, double weight1, double weight2, double weight3) {
            ProceduralLightKeyframe k2 = (ProceduralLightKeyframe)o2;
            ProceduralLightKeyframe k3 = (ProceduralLightKeyframe)o3;
            ProceduralLightKeyframe key = new ProceduralLightKeyframe(this.light);
            key.radius = weight1 * this.radius + weight2 * k2.radius + weight3 * k3.radius;
            for (TextureParameter param : this.light.parameters) {
                double val1 = this.paramValues.containsKey(param) ? this.paramValues.get(param) : param.defaultVal;
                double val2 = k2.paramValues.containsKey(param) ? k2.paramValues.get(param) : param.defaultVal;
                double val3 = k3.paramValues.containsKey(param) ? k3.paramValues.get(param) : param.defaultVal;
                key.paramValues.put(param, weight1 * val1 + weight2 * val2 + weight3 * val3);
            }
            return key;
        }

        public Keyframe blend(Keyframe o2, Keyframe o3, Keyframe o4, double weight1, double weight2, double weight3, double weight4) {
            ProceduralLightKeyframe k2 = (ProceduralLightKeyframe)o2;
            ProceduralLightKeyframe k3 = (ProceduralLightKeyframe)o3;
            ProceduralLightKeyframe k4 = (ProceduralLightKeyframe)o4;
            ProceduralLightKeyframe key = new ProceduralLightKeyframe(this.light);
            key.radius = weight1 * this.radius + weight2 * k2.radius + weight3 * k3.radius + weight4 * k4.radius;
            for (TextureParameter param : this.light.parameters) {
                double val1 = this.paramValues.containsKey(param) ? this.paramValues.get(param) : param.defaultVal;
                double val2 = k2.paramValues.containsKey(param) ? k2.paramValues.get(param) : param.defaultVal;
                double val3 = k3.paramValues.containsKey(param) ? k3.paramValues.get(param) : param.defaultVal;
                double val4 = k4.paramValues.containsKey(param) ? k4.paramValues.get(param) : param.defaultVal;
                key.paramValues.put(param, weight1 * val1 + weight2 * val2 + weight3 * val3 + weight4 * val4);
            }
            return key;
        }

        public boolean equals(Keyframe k) {
            if (!(k instanceof ProceduralLightKeyframe)) {
                return false;
            }
            ProceduralLightKeyframe key = (ProceduralLightKeyframe)k;
            if (key.radius != this.radius) {
                return false;
            }
            for (TextureParameter param : this.light.parameters) {
                double val2;
                double val1 = this.paramValues.containsKey(param) ? this.paramValues.get(param) : param.defaultVal;
                double d = val2 = key.paramValues.containsKey(param) ? key.paramValues.get(param) : param.defaultVal;
                if (val1 == val2) continue;
                return false;
            }
            return true;
        }

        public void writeToStream(DataOutputStream out) throws IOException {
            out.writeDouble(this.radius);
            for (TextureParameter param : this.light.parameters) {
                double val = this.paramValues.containsKey(param) ? this.paramValues.get(param) : param.defaultVal;
                out.writeDouble(val);
            }
        }

        public ProceduralLightKeyframe(DataInputStream in, Object parent) throws IOException {
            this((ProceduralPointLight)((ObjectInfo)parent).getObject());
            this.radius = in.readDouble();
            for (TextureParameter param : this.light.parameters) {
                this.paramValues.put(param, in.readDouble());
            }
        }
    }
}

