/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.object;

import artofillusion.Camera;
import artofillusion.RenderingMesh;
import artofillusion.Scene;
import artofillusion.ViewerCanvas;
import artofillusion.WireframeMesh;
import artofillusion.animation.distortion.Distortion;
import artofillusion.animation.distortion.TransformDistortion;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.Texture;
import artofillusion.texture.UniformTexture;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.util.Enumeration;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectCollection
extends Object3D {
    protected Vector<ObjectInfo> cachedObjects;
    protected BoundingBox cachedBounds;
    protected double lastTime;
    protected CoordinateSystem lastCoords;
    protected Scene lastScene;
    protected ObjectInfo lastInfo;
    protected boolean usesTime;
    protected boolean usesCoords;
    protected Distortion previousDistortion;

    public ObjectCollection() {
    }

    public ObjectCollection(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        super(in, theScene);
    }

    public synchronized Enumeration<ObjectInfo> getObjects(ObjectInfo info, boolean interactive, Scene scene) {
        if (interactive && this.cachedObjects != null && info.getDistortion() == this.previousDistortion) {
            return this.cachedObjects.elements();
        }
        Vector<ObjectInfo> objectVec = new Vector<ObjectInfo>();
        Enumeration<ObjectInfo> objects = this.enumerateObjects(info, interactive, scene);
        while (objects.hasMoreElements()) {
            ObjectInfo childInfo = objects.nextElement();
            this.applyDistortion(info, childInfo);
            objectVec.add(childInfo);
        }
        if (!interactive) {
            return objectVec.elements();
        }
        this.cachedObjects = objectVec;
        this.previousDistortion = info.getDistortion();
        return this.cachedObjects.elements();
    }

    protected abstract Enumeration<ObjectInfo> enumerateObjects(ObjectInfo var1, boolean var2, Scene var3);

    private void applyDistortion(ObjectInfo thisInfo, ObjectInfo childInfo) {
        childInfo.clearDistortion();
        if (thisInfo.isDistorted()) {
            Distortion d;
            Distortion first = d = thisInfo.getDistortion().duplicate();
            while (first.getPreviousDistortion() != null) {
                first = first.getPreviousDistortion();
            }
            first.setPreviousDistortion(new TransformDistortion(childInfo.getCoords().fromLocal()));
            childInfo.setDistortion(d);
            childInfo.addDistortion(new TransformDistortion(childInfo.getCoords().toLocal()));
        }
    }

    @Override
    public BoundingBox getBounds() {
        if (this.cachedBounds == null) {
            if (this.lastInfo == null || this.lastScene == null) {
                return new BoundingBox(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            }
            this.sceneChanged(this.lastInfo, this.lastScene);
        }
        return this.cachedBounds;
    }

    public void setUsesTime(boolean b) {
        this.usesTime = b;
    }

    public void setUsesCoords(boolean b) {
        this.usesCoords = b;
    }

    @Override
    public boolean isClosed() {
        for (int i = 0; i < this.cachedObjects.size(); ++i) {
            ObjectInfo info = this.cachedObjects.elementAt(i);
            if (info.getObject().isClosed()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canSetMaterial() {
        return true;
    }

    @Override
    public RenderingMesh getRenderingMesh(double tol, boolean interactive, ObjectInfo info) {
        return this.convertToTriangleMesh(tol).getRenderingMesh(tol, interactive, info);
    }

    @Override
    public WireframeMesh getWireframeMesh() {
        return new WireframeMesh(new Vec3[0], new int[0], new int[0]);
    }

    @Override
    public void renderObject(ObjectInfo obj, ViewerCanvas canvas, Vec3 viewDir) {
        Camera theCamera = canvas.getCamera();
        Mat4 m = theCamera.getObjectToWorld();
        Enumeration<ObjectInfo> enm = this.getObjects(obj, true, canvas.getScene());
        while (enm.hasMoreElements()) {
            ObjectInfo info = enm.nextElement();
            CoordinateSystem coords = info.getCoords().duplicate();
            coords.transformCoordinates(m);
            theCamera.setObjectTransform(coords.fromLocal());
            info.getObject().renderObject(info, canvas, info.getCoords().toLocal().timesDirection(viewDir));
        }
    }

    @Override
    public int canConvertToTriangleMesh() {
        return 2;
    }

    @Override
    public TriangleMesh convertToTriangleMesh(double tol) {
        Vector<Vec3> allVert = new Vector<Vec3>();
        Vector<int[]> allFace = new Vector<int[]>();
        int start = 0;
        Enumeration<ObjectInfo> objects = this.getObjects(new ObjectInfo(this, this.lastCoords, ""), false, this.lastScene);
        while (objects.hasMoreElements()) {
            ObjectInfo obj = objects.nextElement();
            if (obj.getObject().canConvertToTriangleMesh() == 0) continue;
            Mat4 trans = obj.getCoords().fromLocal();
            TriangleMesh tri = obj.getObject().convertToTriangleMesh(tol);
            MeshVertex[] vert = tri.getVertices();
            for (int i = 0; i < vert.length; ++i) {
                allVert.addElement(trans.times(vert[i].r));
            }
            TriangleMesh.Face[] face = tri.getFaces();
            for (int i = 0; i < face.length; ++i) {
                allFace.addElement(new int[]{face[i].v1 + start, face[i].v2 + start, face[i].v3 + start});
            }
            start += vert.length;
        }
        if (allVert.size() == 0) {
            allVert.addElement(new Vec3());
        }
        Object[] vert = new Vec3[allVert.size()];
        allVert.copyInto(vert);
        int[][] face = new int[allFace.size()][];
        allFace.copyInto((Object[])face);
        TriangleMesh mesh = new TriangleMesh((Vec3[])vert, (int[][])face);
        mesh.copyTextureAndMaterial(this);
        if (this.getTexture() == null) {
            UniformTexture tex = new UniformTexture();
            mesh.setTexture(tex, ((Texture)tex).getDefaultMapping(mesh));
        }
        return mesh;
    }

    @Override
    public void sceneChanged(ObjectInfo info, Scene scene) {
        if (this.cachedBounds == null || this.usesTime && this.lastTime != scene.getTime() || this.usesCoords && !this.lastCoords.equals(info.getCoords())) {
            this.lastScene = scene;
            this.lastTime = scene.getTime();
            this.lastCoords = info.getCoords().duplicate();
            this.lastInfo = info;
            this.cachedObjects = null;
            Enumeration<ObjectInfo> objects = this.getObjects(info, true, scene);
            if (!objects.hasMoreElements()) {
                this.cachedBounds = new BoundingBox(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            } else {
                while (objects.hasMoreElements()) {
                    ObjectInfo obj = objects.nextElement();
                    BoundingBox bounds = obj.getBounds();
                    bounds = bounds.transformAndOutset(obj.getCoords().fromLocal());
                    if (this.cachedBounds == null) {
                        this.cachedBounds = bounds;
                        continue;
                    }
                    this.cachedBounds = this.cachedBounds.merge(bounds);
                }
            }
            info.clearCachedMeshes();
        }
    }
}

