/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.object;

import artofillusion.CurveEditorWindow;
import artofillusion.CurveViewer;
import artofillusion.MeshViewer;
import artofillusion.Property;
import artofillusion.Scene;
import artofillusion.TextureParameter;
import artofillusion.ViewerCanvas;
import artofillusion.WireframeMesh;
import artofillusion.animation.Actor;
import artofillusion.animation.Keyframe;
import artofillusion.animation.MeshGesture;
import artofillusion.animation.Skeleton;
import artofillusion.math.BoundingBox;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.ParameterValue;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.MeshEditController;
import artofillusion.ui.Translate;
import buoy.widget.RowContainer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class Curve
extends Object3D
implements Mesh {
    protected MeshVertex[] vertex;
    protected float[] smoothness;
    protected boolean closed;
    protected int smoothingMethod;
    protected WireframeMesh cachedWire;
    protected BoundingBox bounds;
    private static final Property[] PROPERTIES = new Property[]{new Property(Translate.text("menu.smoothingMethod"), new Object[]{Translate.text("menu.none"), Translate.text("menu.interpolating"), Translate.text("menu.approximating")}, Translate.text("menu.shading")), new Property(Translate.text("menu.closedEnds"), true)};

    public Curve(Vec3[] v, float[] smoothness, int smoothingMethod, boolean isClosed) {
        this.vertex = new MeshVertex[v.length];
        for (int i = 0; i < v.length; ++i) {
            this.vertex[i] = new MeshVertex(v[i]);
        }
        this.smoothness = smoothness;
        this.smoothingMethod = smoothingMethod;
        this.closed = isClosed;
    }

    public Object3D duplicate() {
        Vec3[] v = new Vec3[this.vertex.length];
        float[] s = new float[this.vertex.length];
        for (int i = 0; i < this.vertex.length; ++i) {
            v[i] = new Vec3(this.vertex[i].r);
            s[i] = this.smoothness[i];
        }
        return new Curve(v, s, this.smoothingMethod, this.closed);
    }

    public void copyObject(Object3D obj) {
        Curve cv = (Curve)obj;
        MeshVertex[] v = cv.getVertices();
        this.vertex = new MeshVertex[v.length];
        this.smoothness = new float[v.length];
        for (int i = 0; i < this.vertex.length; ++i) {
            this.vertex[i] = new MeshVertex(new Vec3(v[i].r));
            this.smoothness[i] = cv.smoothness[i];
        }
        this.smoothingMethod = cv.smoothingMethod;
        this.setClosed(cv.closed);
        this.clearCachedMesh();
    }

    protected void findBounds() {
        double maxz;
        double maxy;
        double maxx;
        this.getWireframeMesh();
        Vec3[] points = this.cachedWire.vert;
        double minx = maxx = points[0].x;
        double miny = maxy = points[0].y;
        double minz = maxz = points[0].z;
        for (int i = 1; i < points.length; ++i) {
            Vec3 v = points[i];
            if (v.x < minx) {
                minx = v.x;
            }
            if (v.x > maxx) {
                maxx = v.x;
            }
            if (v.y < miny) {
                miny = v.y;
            }
            if (v.y > maxy) {
                maxy = v.y;
            }
            if (v.z < minz) {
                minz = v.z;
            }
            if (!(v.z > maxz)) continue;
            maxz = v.z;
        }
        this.bounds = new BoundingBox(minx, maxx, miny, maxy, minz, maxz);
    }

    public BoundingBox getBounds() {
        if (this.bounds == null) {
            this.findBounds();
        }
        return this.bounds;
    }

    public MeshVertex[] getVertices() {
        return this.vertex;
    }

    public float[] getSmoothness() {
        return this.smoothness;
    }

    public int getSmoothingMethod() {
        return this.smoothingMethod;
    }

    public void movePoint(int which, Vec3 pos) {
        this.vertex[which].r = pos;
        this.clearCachedMesh();
    }

    public Vec3[] getVertexPositions() {
        Vec3[] v = new Vec3[this.vertex.length];
        for (int i = 0; i < v.length; ++i) {
            v[i] = new Vec3(this.vertex[i].r);
        }
        return v;
    }

    public void setVertexPositions(Vec3[] v) {
        for (int i = 0; i < v.length; ++i) {
            this.vertex[i].r = v[i];
        }
        this.clearCachedMesh();
    }

    public void setSmoothingMethod(int method) {
        this.smoothingMethod = method;
        this.clearCachedMesh();
    }

    public void setSmoothness(float[] s) {
        for (int i = 0; i < s.length; ++i) {
            this.smoothness[i] = s[i];
        }
        this.clearCachedMesh();
    }

    public void setShape(Vec3[] v, float[] smoothness) {
        if (v.length != this.vertex.length) {
            this.vertex = new MeshVertex[v.length];
        }
        for (int i = 0; i < v.length; ++i) {
            this.vertex[i] = new MeshVertex(v[i]);
        }
        this.smoothness = smoothness;
        this.clearCachedMesh();
    }

    public void setClosed(boolean isClosed) {
        this.closed = isClosed;
        this.clearCachedMesh();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setSize(double xsize, double ysize, double zsize) {
        Vec3 size = this.getBounds().getSize();
        double xscale = size.x == 0.0 ? 1.0 : xsize / size.x;
        double yscale = size.y == 0.0 ? 1.0 : ysize / size.y;
        double zscale = size.z == 0.0 ? 1.0 : zsize / size.z;
        for (int i = 0; i < this.vertex.length; ++i) {
            this.vertex[i].r.x *= xscale;
            this.vertex[i].r.y *= yscale;
            this.vertex[i].r.z *= zscale;
        }
        this.clearCachedMesh();
    }

    protected void clearCachedMesh() {
        this.cachedWire = null;
        this.bounds = null;
    }

    public WireframeMesh getWireframeMesh() {
        int[] to;
        int[] from;
        int i;
        if (this.cachedWire != null) {
            return this.cachedWire;
        }
        Curve subdiv = this.smoothingMethod == 0 ? this : this.subdivideCurve().subdivideCurve();
        Vec3[] vert = new Vec3[subdiv.vertex.length];
        for (i = 0; i < vert.length; ++i) {
            vert[i] = subdiv.vertex[i].r;
        }
        if (this.closed) {
            from = new int[vert.length];
            to = new int[vert.length];
            from[vert.length - 1] = vert.length - 1;
            to[vert.length - 1] = 0;
        } else {
            from = new int[vert.length - 1];
            to = new int[vert.length - 1];
        }
        for (i = 0; i < vert.length - 1; ++i) {
            from[i] = i;
            to[i] = i + 1;
        }
        this.cachedWire = new WireframeMesh(vert, from, to);
        return this.cachedWire;
    }

    public Curve subdivideCurve() {
        float[] news;
        Vec3[] newpos;
        if (this.vertex.length < 2) {
            return (Curve)this.duplicate();
        }
        if (this.vertex.length == 2) {
            Vec3[] newpos2 = new Vec3[]{new Vec3(this.vertex[0].r), this.vertex[0].r.plus(this.vertex[1].r).times(0.5), new Vec3(this.vertex[1].r)};
            float[] news2 = new float[]{this.smoothness[0], (this.smoothness[0] + this.smoothness[1]) * 0.5f, this.smoothness[1]};
            return new Curve(newpos2, news2, this.smoothingMethod, this.closed);
        }
        Vec3[] v = new Vec3[this.vertex.length];
        for (int i = 0; i < v.length; ++i) {
            v[i] = new Vec3(this.vertex[i].r);
        }
        if (this.closed) {
            int i;
            newpos = new Vec3[v.length * 2];
            news = new float[this.smoothness.length * 2];
            if (this.smoothingMethod == 2) {
                newpos[0] = v[0];
                newpos[1] = Curve.calcInterpPoint(v, this.smoothness, v.length - 1, 0, 1, 2);
                int j = 1;
                for (i = 2; i < newpos.length; ++i) {
                    if (i % 2 == 0) {
                        newpos[i] = v[j];
                        continue;
                    }
                    newpos[i] = Curve.calcInterpPoint(v, this.smoothness, j - 1, j, (j + 1) % v.length, (j + 2) % v.length);
                    ++j;
                }
            } else {
                newpos[0] = Curve.calcApproxPoint(v, this.smoothness, v.length - 1, 0, 1);
                for (i = 1; i < v.length - 1; ++i) {
                    newpos[i * 2 - 1] = v[i].plus(v[i - 1]).times(0.5);
                    newpos[i * 2] = Curve.calcApproxPoint(v, this.smoothness, i - 1, i, i + 1);
                }
                newpos[i * 2 - 1] = v[i].plus(v[i - 1]).times(0.5);
                newpos[i * 2] = Curve.calcApproxPoint(v, this.smoothness, i - 1, i, 0);
                newpos[i * 2 + 1] = v[0].plus(v[i]).times(0.5);
            }
            for (i = 0; i < this.smoothness.length; ++i) {
                news[i * 2] = Math.min(this.smoothness[i] * 2.0f, 1.0f);
                news[i * 2 + 1] = 1.0f;
            }
        } else {
            int i;
            newpos = new Vec3[v.length * 2 - 1];
            news = new float[this.smoothness.length * 2 - 1];
            if (this.smoothingMethod == 2) {
                newpos[0] = v[0];
                newpos[1] = Curve.calcInterpPoint(v, this.smoothness, 0, 0, 1, 2);
                int j = 1;
                for (i = 2; i < newpos.length - 2; ++i) {
                    if (i % 2 == 0) {
                        newpos[i] = v[j];
                        continue;
                    }
                    newpos[i] = Curve.calcInterpPoint(v, this.smoothness, j - 1, j, j + 1, j + 2);
                    ++j;
                }
                newpos[i] = Curve.calcInterpPoint(v, this.smoothness, j - 1, j, j + 1, j + 1);
                newpos[i + 1] = v[j + 1];
            } else {
                newpos[0] = v[0];
                for (i = 1; i < v.length - 1; ++i) {
                    newpos[i * 2 - 1] = v[i].plus(v[i - 1]).times(0.5);
                    newpos[i * 2] = Curve.calcApproxPoint(v, this.smoothness, i - 1, i, i + 1);
                }
                newpos[i * 2 - 1] = v[i].plus(v[i - 1]).times(0.5);
                newpos[i * 2] = v[i];
            }
            for (i = 0; i < this.smoothness.length - 1; ++i) {
                news[i * 2] = Math.min(this.smoothness[i] * 2.0f, 1.0f);
                news[i * 2 + 1] = 1.0f;
            }
            news[i * 2] = Math.min(this.smoothness[i] * 2.0f, 1.0f);
        }
        return new Curve(newpos, news, this.smoothingMethod, this.closed);
    }

    public Curve subdivideCurve(int times) {
        Curve c = this;
        for (int i = 0; i < times; ++i) {
            c = c.subdivideCurve();
        }
        return c;
    }

    public static Vec3 calcInterpPoint(Vec3[] v, float[] s, int i, int j, int k, int m) {
        double w1 = -0.0625 * (double)s[j];
        double w2 = 0.5 - w1;
        double w4 = -0.0625 * (double)s[k];
        double w3 = 0.5 - w4;
        return new Vec3(w1 * v[i].x + w2 * v[j].x + w3 * v[k].x + w4 * v[m].x, w1 * v[i].y + w2 * v[j].y + w3 * v[k].y + w4 * v[m].y, w1 * v[i].z + w2 * v[j].z + w3 * v[k].z + w4 * v[m].z);
    }

    public static Vec3 calcApproxPoint(Vec3[] v, float[] s, int i, int j, int k) {
        double w1 = 0.125 * (double)s[j];
        double w2 = 1.0 - 2.0 * w1;
        return new Vec3(w1 * v[i].x + w2 * v[j].x + w1 * v[k].x, w1 * v[i].y + w2 * v[j].y + w1 * v[k].y, w1 * v[i].z + w2 * v[j].z + w1 * v[k].z);
    }

    public boolean canSetTexture() {
        return false;
    }

    public int canConvertToTriangleMesh() {
        if (this.closed) {
            return 1;
        }
        return 0;
    }

    public TriangleMesh convertToTriangleMesh(double tol) {
        TriangleMesh mesh = this.triangulateCurve();
        if (mesh != null) {
            mesh = TriangleMesh.optimizeMesh(mesh);
        }
        return mesh;
    }

    private TriangleMesh triangulateCurve() {
        double dir;
        int i;
        Vec3[] v = new Vec3[this.vertex.length];
        Vec3 size = this.getBounds().getSize();
        Vec2[] v2 = new Vec2[this.vertex.length];
        int[] index = new int[this.vertex.length];
        int[][] faces = new int[this.vertex.length - 2][3];
        int j = size.x > size.y ? (size.y > size.z ? 2 : 1) : (size.x > size.z ? 2 : 0);
        for (i = 0; i < this.vertex.length; ++i) {
            v[i] = this.vertex[i].r;
            v2[i] = this.vertex[i].r.dropAxis(j);
        }
        int min = 0;
        for (i = 1; i < v2.length; ++i) {
            if (!(v2[i].x < v2[min].x)) continue;
            min = i;
        }
        for (i = 0; i < index.length; ++i) {
            index[i] = i;
        }
        int current = min;
        do {
            if ((dir = this.triangleDirection(v2, index, v2.length, current)) != 0.0 || (current = (current + 1) % index.length) != min) continue;
            return null;
        } while (dir == 0.0);
        int count = index.length;
        for (i = 0; i < this.vertex.length - 2; ++i) {
            boolean inside;
            double dir2;
            j = current;
            do {
                dir2 = this.triangleDirection(v2, index, count, current);
                inside = this.containsPoints(v2, index, count, current);
                if (!(dir2 * dir < 0.0) && !inside || (current = (current + 1) % count) != j) continue;
                return null;
            } while (dir2 * dir < 0.0 || inside);
            faces[i][0] = current == 0 ? index[count - 1] : index[current - 1];
            faces[i][1] = index[current];
            faces[i][2] = current == count - 1 ? index[0] : index[current + 1];
            for (j = current; j < count - 1; ++j) {
                index[j] = index[j + 1];
            }
            current = (current + 1) % --count;
        }
        TriangleMesh mesh = new TriangleMesh(v, faces);
        TriangleMesh.Vertex[] vert = (TriangleMesh.Vertex[])mesh.getVertices();
        for (i = 0; i < vert.length; ++i) {
            vert[i].smoothness = this.smoothness[i];
        }
        mesh.setSmoothingMethod(this.smoothingMethod);
        return mesh;
    }

    double triangleDirection(Vec2[] v2, int[] index, int count, int which) {
        Vec2 va = which == 0 ? v2[index[which]].minus(v2[index[count - 1]]) : v2[index[which]].minus(v2[index[which - 1]]);
        Vec2 vb = which == count - 1 ? v2[index[which]].minus(v2[index[0]]) : v2[index[which]].minus(v2[index[which + 1]]);
        return va.cross(vb);
    }

    boolean containsPoints(Vec2[] v2, int[] index, int count, int which) {
        int prev = which == 0 ? count - 1 : which - 1;
        int next = which == count - 1 ? 0 : which + 1;
        Vec2 va = v2[index[which]].minus(v2[index[prev]]);
        Vec2 vb = v2[index[which]].minus(v2[index[next]]);
        double a = va.cross(vb);
        va.scale(1.0 / a);
        vb.scale(1.0 / a);
        for (int i = 0; i < count; ++i) {
            double c;
            Vec2 v;
            double b;
            if (i == prev || i == which || i == next || !((a = 1.0 - (b = vb.cross(v = v2[index[i]].minus(v2[index[which]]))) - (c = v.cross(va))) >= 0.0) || !(a <= 1.0) || !(b >= 0.0) || !(b <= 1.0) || !(c >= 0.0) || !(c <= 1.0)) continue;
            return true;
        }
        return false;
    }

    public Vec3[] getNormals() {
        Vec3[] norm = new Vec3[this.vertex.length];
        for (int i = 0; i < norm.length; ++i) {
            norm[i] = Vec3.vz();
        }
        return norm;
    }

    public boolean isEditable() {
        return true;
    }

    public Skeleton getSkeleton() {
        return null;
    }

    public void setSkeleton(Skeleton s) {
    }

    public void edit(EditingWindow parent, ObjectInfo info, Runnable cb) {
        CurveEditorWindow ed = new CurveEditorWindow(parent, "Curve object '" + info.getName() + "'", info, cb, true);
        ed.setVisible(true);
    }

    public void editGesture(EditingWindow parent, ObjectInfo info, Runnable cb, ObjectInfo realObject) {
        CurveEditorWindow ed = new CurveEditorWindow(parent, "Gesture '" + info.getName() + "'", info, cb, false);
        ViewerCanvas[] views = ed.getAllViews();
        for (int i = 0; i < views.length; ++i) {
            ((MeshViewer)views[i]).setScene(parent.getScene(), realObject);
        }
        ed.setVisible(true);
    }

    public MeshViewer createMeshViewer(MeshEditController controller, RowContainer options) {
        return new CurveViewer(controller, options);
    }

    public Curve(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        super(in, theScene);
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.vertex = new MeshVertex[in.readInt()];
        this.smoothness = new float[this.vertex.length];
        for (int i = 0; i < this.vertex.length; ++i) {
            this.vertex[i] = new MeshVertex(new Vec3(in));
            this.smoothness[i] = in.readFloat();
        }
        this.closed = in.readBoolean();
        this.smoothingMethod = in.readInt();
    }

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        super.writeToFile(out, theScene);
        out.writeShort(0);
        out.writeInt(this.vertex.length);
        for (int i = 0; i < this.vertex.length; ++i) {
            this.vertex[i].r.writeToFile(out);
            out.writeFloat(this.smoothness[i]);
        }
        out.writeBoolean(this.closed);
        out.writeInt(this.smoothingMethod);
    }

    public Property[] getProperties() {
        return (Property[])PROPERTIES.clone();
    }

    public Object getPropertyValue(int index) {
        if (index == 0) {
            if (this.smoothingMethod == 0) {
                return PROPERTIES[0].getAllowedValues()[0];
            }
            return PROPERTIES[0].getAllowedValues()[this.smoothingMethod - 1];
        }
        return this.closed;
    }

    public void setPropertyValue(int index, Object value) {
        if (index == 0) {
            Object[] values = PROPERTIES[0].getAllowedValues();
            for (int i = 0; i < values.length; ++i) {
                if (!values[i].equals(value)) continue;
                this.setSmoothingMethod(i == 0 ? 0 : i + 1);
            }
        } else {
            this.setClosed((Boolean)value);
        }
    }

    public Keyframe getPoseKeyframe() {
        return new CurveKeyframe(this);
    }

    public void applyPoseKeyframe(Keyframe k) {
        CurveKeyframe key = (CurveKeyframe)k;
        for (int i = 0; i < this.vertex.length; ++i) {
            this.vertex[i].r.set(key.vertPos[i]);
            this.smoothness[i] = key.vertSmoothness[i];
        }
        this.cachedWire = null;
        this.bounds = null;
    }

    public boolean canConvertToActor() {
        return true;
    }

    public Object3D getPosableObject() {
        Curve m = (Curve)this.duplicate();
        return new Actor(m);
    }

    public static class CurveKeyframe
    extends MeshGesture {
        Vec3[] vertPos;
        float[] vertSmoothness;
        Curve curve;

        public CurveKeyframe(Curve curve) {
            this.curve = curve;
            this.vertPos = new Vec3[curve.vertex.length];
            this.vertSmoothness = new float[curve.vertex.length];
            for (int i = 0; i < this.vertPos.length; ++i) {
                this.vertPos[i] = new Vec3(curve.vertex[i].r);
                this.vertSmoothness[i] = curve.smoothness[i];
            }
        }

        private CurveKeyframe() {
        }

        protected Mesh getMesh() {
            return this.curve;
        }

        protected Vec3[] getVertexPositions() {
            return this.vertPos;
        }

        protected void setVertexPositions(Vec3[] pos) {
            this.vertPos = pos;
        }

        public Skeleton getSkeleton() {
            return null;
        }

        public void setSkeleton(Skeleton s) {
        }

        public Keyframe duplicate() {
            return this.duplicate(this.curve);
        }

        public Keyframe duplicate(Object owner) {
            CurveKeyframe k = new CurveKeyframe();
            k.curve = owner instanceof Curve ? (Curve)owner : (Curve)((ObjectInfo)owner).getObject();
            k.vertPos = new Vec3[this.vertPos.length];
            k.vertSmoothness = new float[this.vertSmoothness.length];
            for (int i = 0; i < this.vertPos.length; ++i) {
                k.vertPos[i] = new Vec3(this.vertPos[i]);
                k.vertSmoothness[i] = this.vertSmoothness[i];
            }
            return k;
        }

        public double[] getGraphValues() {
            return new double[0];
        }

        public void setGraphValues(double[] values) {
        }

        public Keyframe blend(Keyframe o2, double weight1, double weight2) {
            return null;
        }

        public Keyframe blend(Keyframe o2, Keyframe o3, double weight1, double weight2, double weight3) {
            return null;
        }

        public Keyframe blend(Keyframe o2, Keyframe o3, Keyframe o4, double weight1, double weight2, double weight3, double weight4) {
            return null;
        }

        public void blendSurface(MeshGesture average, MeshGesture[] p, double[] weight) {
            int i;
            super.blendSurface(average, p, weight);
            CurveKeyframe avg = (CurveKeyframe)average;
            for (i = 0; i < weight.length; ++i) {
                CurveKeyframe key = (CurveKeyframe)p[i];
                for (int j = 0; j < this.vertSmoothness.length; ++j) {
                    int n = j;
                    avg.vertSmoothness[n] = avg.vertSmoothness[n] + (float)(weight[i] * (double)(key.vertSmoothness[j] - this.vertSmoothness[j]));
                }
            }
            for (i = 0; i < this.vertSmoothness.length; ++i) {
                if ((double)avg.vertSmoothness[i] < 0.0) {
                    avg.vertSmoothness[i] = 0.0f;
                }
                if (!((double)avg.vertSmoothness[i] > 1.0)) continue;
                avg.vertSmoothness[i] = 1.0f;
            }
        }

        public boolean equals(Keyframe k) {
            if (!(k instanceof CurveKeyframe)) {
                return false;
            }
            CurveKeyframe key = (CurveKeyframe)k;
            for (int i = 0; i < this.vertPos.length; ++i) {
                if (!this.vertPos[i].equals(key.vertPos[i])) {
                    return false;
                }
                if (this.vertSmoothness[i] == key.vertSmoothness[i]) continue;
                return false;
            }
            return true;
        }

        public void textureChanged(TextureParameter[] oldParams, TextureParameter[] newParams) {
        }

        public ParameterValue getTextureParameter(TextureParameter p) {
            return null;
        }

        public void setTextureParameter(TextureParameter p, ParameterValue value) {
        }

        public void writeToStream(DataOutputStream out) throws IOException {
            out.writeShort(0);
            out.writeInt(this.vertPos.length);
            for (int i = 0; i < this.vertPos.length; ++i) {
                this.vertPos[i].writeToFile(out);
                out.writeFloat(this.vertSmoothness[i]);
            }
        }

        public CurveKeyframe(DataInputStream in, Object parent) throws IOException, InvalidObjectException {
            this();
            short version = in.readShort();
            if (version != 0) {
                throw new InvalidObjectException("");
            }
            this.curve = (Curve)parent;
            int numVert = in.readInt();
            this.vertPos = new Vec3[numVert];
            this.vertSmoothness = new float[numVert];
            for (int i = 0; i < numVert; ++i) {
                this.vertPos[i] = new Vec3(in);
                this.vertSmoothness[i] = in.readFloat();
            }
        }
    }
}

