/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.image.filter;

import artofillusion.Property;
import artofillusion.Scene;
import artofillusion.image.ComplexImage;
import artofillusion.image.filter.ImageFilter;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.RGBColor;
import artofillusion.object.SceneCamera;
import artofillusion.ui.Translate;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class OutlineFilter
extends ImageFilter {
    private static final byte NONE = 0;
    private static final byte CENTER = 1;
    private static final byte UP = 2;
    private static final byte DOWN = 3;
    private static final byte LEFT = 4;
    private static final byte RIGHT = 5;

    public String getName() {
        return Translate.text("Outline");
    }

    public int getDesiredComponents() {
        return 23;
    }

    public void filterImage(ComplexImage image, Scene scene, SceneCamera camera, CoordinateSystem cameraPos) {
        if (!image.hasFloatData(16)) {
            return;
        }
        double thickness = (Double)this.getPropertyValue(0);
        if (thickness <= 0.0) {
            return;
        }
        float[][] masks = new float[][]{null, this.createMask(thickness, 0.0, 0.0), this.createMask(thickness, 0.0, -0.5), this.createMask(thickness, 0.0, 0.5), this.createMask(thickness, -0.5, 0.0), this.createMask(thickness, 0.5, 0.0)};
        float[] outline = this.findOutline(image, masks);
        RGBColor color = (RGBColor)this.getPropertyValue(3);
        this.applyOutline(image, 4, outline, color.getRed());
        this.applyOutline(image, 2, outline, color.getGreen());
        this.applyOutline(image, 1, outline, color.getBlue());
    }

    private float[] findOutline(ComplexImage image, float[][] masks) {
        int i;
        int j;
        int i2;
        int width = image.getWidth();
        int height = image.getHeight();
        byte[] edgeType = new byte[width * height];
        for (i2 = 0; i2 < width; ++i2) {
            for (j = 0; j < height; ++j) {
                float depth = image.getPixelComponent(i2, j, 16);
                if (i2 > 0 && i2 < width - 1 && this.isOutline(image.getPixelComponent(i2 - 1, j, 16), depth, image.getPixelComponent(i2 + 1, j, 16))) {
                    edgeType[i2 + j * width] = 1;
                    continue;
                }
                if (j <= 0 || j >= height - 1 || !this.isOutline(image.getPixelComponent(i2, j - 1, 16), depth, image.getPixelComponent(i2, j + 1, 16))) continue;
                edgeType[i2 + j * width] = 1;
            }
        }
        for (i2 = 1; i2 < width - 1; ++i2) {
            for (j = 1; j < height - 1; ++j) {
                if (edgeType[i2 + j * width] == 0) continue;
                int count = 0;
                for (int k = -1; k < 2; ++k) {
                    for (int m = -1; m < 2; ++m) {
                        if (edgeType[i2 + k + (j + m) * width] == 0) continue;
                        ++count;
                    }
                }
                if (count != 3) continue;
                if (edgeType[i2 - 1 + j * width] != 0) {
                    if (edgeType[i2 + 1 + (j - 1) * width] != 0) {
                        edgeType[i2 + j * width] = 2;
                        continue;
                    }
                    if (edgeType[i2 + 1 + (j + 1) * width] == 0) continue;
                    edgeType[i2 + j * width] = 3;
                    continue;
                }
                if (edgeType[i2 + 1 + j * width] != 0) {
                    if (edgeType[i2 - 1 + (j - 1) * width] != 0) {
                        edgeType[i2 + j * width] = 2;
                        continue;
                    }
                    if (edgeType[i2 - 1 + (j + 1) * width] == 0) continue;
                    edgeType[i2 + j * width] = 3;
                    continue;
                }
                if (edgeType[i2 + (j - 1) * width] != 0) {
                    if (edgeType[i2 - 1 + (j + 1) * width] != 0) {
                        edgeType[i2 + j * width] = 4;
                        continue;
                    }
                    if (edgeType[i2 + 1 + (j + 1) * width] == 0) continue;
                    edgeType[i2 + j * width] = 5;
                    continue;
                }
                if (edgeType[i2 + (j + 1) * width] == 0) continue;
                if (edgeType[i2 - 1 + (j - 1) * width] != 0) {
                    edgeType[i2 + j * width] = 4;
                    continue;
                }
                if (edgeType[i2 + 1 + (j - 1) * width] == 0) continue;
                edgeType[i2 + j * width] = 5;
            }
        }
        Thread currentThread = Thread.currentThread();
        float[] outline = new float[width * height];
        int[] maskWidth = new int[masks.length];
        for (i = 1; i < masks.length; ++i) {
            maskWidth[i] = (int)Math.sqrt(masks[i].length);
        }
        for (i = 0; i < width; ++i) {
            if (currentThread.isInterrupted()) {
                return outline;
            }
            for (int j2 = 0; j2 < height; ++j2) {
                byte type = edgeType[i + j2 * width];
                if (type == 0) continue;
                this.drawOutlineSpot(i, j2, outline, width, height, masks[type], maskWidth[type], 1.0f);
            }
        }
        return outline;
    }

    private boolean isOutline(float d1, float d2, float d3) {
        double changeCutoff = (Double)this.getPropertyValue(1);
        double relCutoff = (Double)this.getPropertyValue(2);
        if (d1 > 1000000.0f) {
            d1 = 1000000.0f;
        }
        if (d2 > 1000000.0f) {
            d2 = 1000000.0f;
        }
        if (d3 > 1000000.0f) {
            d3 = 1000000.0f;
        }
        if ((double)(d2 - d1) < (double)d2 * relCutoff && (double)(d2 - d3) < (double)d2 * relCutoff) {
            return false;
        }
        return (2.0 * (double)d2 - (double)d1 - (double)d3) / (double)d2 > changeCutoff;
    }

    private void drawOutlineSpot(int i, int j, float[] outline, int width, int height, float[] mask, int maskWidth, float fraction) {
        int radius = (maskWidth - 1) / 2;
        int basex = i - radius;
        int basey = j - radius;
        int xstart = basex < 0 ? -basex : 0;
        int ystart = basey < 0 ? -basey : 0;
        int xend = basex + maskWidth >= width ? width - basex : maskWidth;
        int yend = basey + maskWidth >= height ? height - basey : maskWidth;
        for (int y = ystart; y < yend; ++y) {
            int maskBase = y * maskWidth;
            int imageBase = basex + (basey + y) * width;
            for (int x = xstart; x < xend; ++x) {
                float val = mask[maskBase + x] * fraction;
                if (!(outline[imageBase + x] < val)) continue;
                outline[imageBase + x] = val;
            }
        }
    }

    private void applyOutline(ComplexImage image, int component, float[] outline, float color) {
        int width = image.getWidth();
        int height = image.getHeight();
        float[] pixel = new float[width * height];
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                float fract = outline[j * width + i];
                pixel[j * width + i] = fract * color + (1.0f - fract) * image.getPixelComponent(i, j, component);
            }
        }
        image.setComponentValues(component, pixel);
    }

    private float[] createMask(double thickness, double xoffset, double yoffset) {
        int size = (int)Math.ceil(thickness - 0.001);
        if (size % 2 == 0) {
            ++size;
        }
        double radius = 0.5 * thickness - 0.25;
        double radius2 = radius + 0.5;
        int last = size - 1;
        int center = last / 2;
        float[] mask = new float[size * size];
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                float val;
                double dy2;
                double dy1;
                double dx2;
                double dx1;
                if (i < center) {
                    dx1 = (double)center + xoffset - (double)i - 0.5;
                    dx2 = (double)center + xoffset - (double)i + 0.5;
                } else if (i == center) {
                    dx1 = dx2 = Math.abs(xoffset);
                } else {
                    dx1 = (double)(i - center) - xoffset - 0.5;
                    dx2 = (double)(i - center) - xoffset + 0.5;
                }
                if (j < center) {
                    dy1 = (double)center + yoffset - (double)j - 0.5;
                    dy2 = (double)center + yoffset - (double)j + 0.5;
                } else if (j == center) {
                    dy1 = dy2 = Math.abs(yoffset);
                } else {
                    dy1 = (double)(j - center) - yoffset - 0.5;
                    dy2 = (double)(j - center) - yoffset + 0.5;
                }
                double dist1 = Math.sqrt(dx1 * dx1 + dy1 * dy1);
                double dist2 = Math.sqrt(dx2 * dx2 + dy2 * dy2);
                mask[i + j * size] = val = 0.5f * (this.calcMaskValue(radius, dist1, dist2) + this.calcMaskValue(radius2, dist1, dist2));
            }
        }
        return mask;
    }

    private float calcMaskValue(double radius, double dist1, double dist2) {
        if (dist1 > radius) {
            return 0.0f;
        }
        if (dist2 < radius) {
            return 1.0f;
        }
        return (float)((radius - dist1) / (dist2 - dist1));
    }

    public Property[] getProperties() {
        return new Property[]{new Property(Translate.text("Thickness"), 0.0, Double.MAX_VALUE, 3.0), new Property(Translate.text("Change Cutoff"), 0.0, Double.MAX_VALUE, 0.01), new Property(Translate.text("Distance Cutoff"), 0.0, Double.MAX_VALUE, 0.01), new Property(Translate.text("Color"), new RGBColor(0.0, 0.0, 0.0))};
    }

    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
        out.writeShort(0);
        out.writeDouble((Double)this.getPropertyValue(0));
        out.writeDouble((Double)this.getPropertyValue(1));
        out.writeDouble((Double)this.getPropertyValue(2));
        RGBColor color = (RGBColor)this.getPropertyValue(3);
        out.writeDouble(color.getRed());
        out.writeDouble(color.getGreen());
        out.writeDouble(color.getBlue());
    }

    public void initFromStream(DataInputStream in, Scene theScene) throws IOException {
        short version = in.readShort();
        if (version != 0) {
            throw new IOException("Unknown version " + version);
        }
        this.setPropertyValue(0, in.readDouble());
        this.setPropertyValue(1, in.readDouble());
        this.setPropertyValue(2, in.readDouble());
        this.setPropertyValue(3, new RGBColor(in.readDouble(), in.readDouble(), in.readDouble()));
    }
}

