/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.image.filter;

import artofillusion.Property;
import artofillusion.Scene;
import artofillusion.TextureParameter;
import artofillusion.image.ComplexImage;
import artofillusion.math.CoordinateSystem;
import artofillusion.object.SceneCamera;
import artofillusion.ui.PropertyEditor;
import artofillusion.ui.UIUtilities;
import buoy.event.ValueChangedEvent;
import buoy.widget.BLabel;
import buoy.widget.BOutline;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.Widget;
import java.awt.Insets;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.swing.border.EmptyBorder;

public abstract class ImageFilter {
    @Deprecated
    protected double[] paramValue;
    private Object[] propertyValue;

    public ImageFilter() {
        Property[] properties = this.getProperties();
        this.propertyValue = new Object[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            this.propertyValue[i] = properties[i].getDefaultValue();
        }
        TextureParameter[] param = this.getParameters();
        this.paramValue = new double[param.length];
        for (int i = 0; i < param.length; ++i) {
            this.paramValue[i] = param[i].defaultVal;
        }
    }

    public abstract String getName();

    public int getDesiredComponents() {
        return 7;
    }

    public abstract void filterImage(ComplexImage var1, Scene var2, SceneCamera var3, CoordinateSystem var4);

    public ImageFilter duplicate() {
        try {
            ImageFilter f = (ImageFilter)this.getClass().newInstance();
            f.copy(this);
            return f;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void copy(ImageFilter f) {
        int i;
        this.paramValue = new double[f.paramValue.length];
        for (i = 0; i < this.paramValue.length; ++i) {
            this.paramValue[i] = f.paramValue[i];
        }
        this.propertyValue = new Object[f.propertyValue.length];
        for (i = 0; i < this.propertyValue.length; ++i) {
            this.propertyValue[i] = f.propertyValue[i];
        }
    }

    @Deprecated
    public TextureParameter[] getParameters() {
        return new TextureParameter[0];
    }

    @Deprecated
    public double[] getParameterValues() {
        double[] val = new double[this.paramValue.length];
        System.arraycopy(this.paramValue, 0, val, 0, val.length);
        return val;
    }

    @Deprecated
    public void setParameterValue(int index, double value) {
        this.paramValue[index] = value;
        this.propertyValue[index] = value;
    }

    public Property[] getProperties() {
        TextureParameter[] parameters = this.getParameters();
        Property[] properties = new Property[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            properties[i] = new Property(parameters[i].name, parameters[i].minVal, parameters[i].maxVal, parameters[i].defaultVal);
        }
        return properties;
    }

    public Object getPropertyValue(int index) {
        if (index < this.paramValue.length) {
            return this.paramValue[index];
        }
        return this.propertyValue[index];
    }

    public void setPropertyValue(int index, Object value) {
        this.propertyValue[index] = value;
        if (value instanceof Number && this.paramValue.length > index) {
            this.paramValue[index] = ((Number)value).doubleValue();
        }
    }

    public abstract void writeToStream(DataOutputStream var1, Scene var2) throws IOException;

    public abstract void initFromStream(DataInputStream var1, Scene var2) throws IOException;

    public Widget getConfigPanel(final Runnable changeCallback) {
        Property[] properties = this.getProperties();
        FormContainer form = new FormContainer(2, properties.length);
        LayoutInfo leftLayout = new LayoutInfo(LayoutInfo.EAST, LayoutInfo.NONE, new Insets(0, 0, 0, 5), null);
        LayoutInfo rightLayout = new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, null, null);
        for (int i = 0; i < properties.length; ++i) {
            PropertyEditor editor = new PropertyEditor(properties[i], this.getPropertyValue(i));
            if (editor.getLabel() != null) {
                form.add(new BLabel(editor.getLabel() + ": "), 0, i, leftLayout);
            }
            Widget w = editor.getWidget();
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class EditorListener {
                private int which;
                private PropertyEditor editor;

                public EditorListener(int which, PropertyEditor editor) {
                    this.which = which;
                    this.editor = editor;
                }

                void processEvent() {
                    ImageFilter.this.setPropertyValue(this.which, this.editor.getValue());
                    changeCallback.run();
                }
            }
            w.addEventLink(ValueChangedEvent.class, new EditorListener(i, editor));
            form.add(w, 1, i, rightLayout);
        }
        UIUtilities.applyBackground(form, null);
        BOutline border = new BOutline(form, new EmptyBorder(3, 3, 3, 3));
        border.setBackground(null);
        return border;
    }
}

