/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.image;

import artofillusion.image.ImageMap;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec2;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class HDRImage
extends ImageMap {
    private int[] width;
    private int[] height;
    private byte[][][] maps;
    private float[] average;
    private double[] xscale;
    private double[] yscale;
    private double[] scale;
    private double[] scaleMult;
    private Image preview;

    public HDRImage(byte[] r, byte[] g, byte[] b, byte[] e, int xres, int yres) {
        this.buildMipMaps(r, g, b, e, xres, yres);
        this.findAverage();
        this.createPreview();
    }

    private void buildMipMaps(byte[] r, byte[] g, byte[] b, byte[] e, int w, int h) {
        int k;
        int j;
        int i;
        int h1;
        int w1;
        byte[][] map0 = new byte[][]{r, g, b, e};
        for (w1 = 2; w1 < w; w1 *= 2) {
        }
        for (h1 = 2; h1 < h; h1 *= 2) {
        }
        float wratio = (float)(w1 /= 2) / (float)w;
        float hratio = (float)(h1 /= 2) / (float)h;
        if (w > 1 && (double)wratio > 0.75) {
            w1 /= 2;
            wratio = (float)((double)wratio * 0.5);
        }
        if (h > 1 && (double)hratio > 0.75) {
            h1 /= 2;
            hratio = (float)((double)hratio * 0.5);
        }
        int num = 0;
        while (1 << num < w1 && 1 << num < h1) {
            ++num;
        }
        num += 2;
        if (w == 1 || h == 1) {
            num = 1;
        }
        this.maps = new byte[num][][];
        this.width = new int[num];
        this.height = new int[num];
        this.scale = new double[num];
        this.xscale = new double[num];
        this.yscale = new double[num];
        this.scaleMult = new double[num - 1];
        this.maps[0] = map0;
        this.width[0] = w;
        this.height[0] = h;
        this.scale[0] = 1.0 / (double)Math.min(w, h);
        if (num > 1) {
            this.width[1] = w1;
            this.height[1] = h1;
            this.scale[1] = 1.0 / (double)Math.min(w1, h1);
            this.maps[1] = new byte[4][w1 * h1];
            float widthScale = (float)w / (float)w1;
            float heightScale = (float)h / (float)h1;
            for (i = 0; i < 4; ++i) {
                byte[] componentMap0 = this.maps[0][i];
                byte[] componentMap1 = this.maps[1][i];
                for (j = 0; j < h1; ++j) {
                    int pos1 = j * w1;
                    float pos0 = (int)((float)j * heightScale) * w;
                    for (k = 0; k < w1; ++k) {
                        componentMap1[pos1++] = componentMap0[(int)pos0];
                        pos0 += widthScale;
                    }
                }
            }
        }
        RGBColor avg = new RGBColor();
        RGBColor tempColor = new RGBColor();
        for (i = 2; i < num; ++i) {
            w = this.width[i] = this.width[i - 1] / 2;
            h = this.height[i] = this.height[i - 1] / 2;
            this.scale[i] = 2.0 * this.scale[i - 1];
            this.maps[i] = new byte[4][w * h];
            for (k = 0; k < w; ++k) {
                for (int m = 0; m < h; ++m) {
                    j = 2 * k + 4 * w * m;
                    tempColor.setERGB(this.maps[i - 1][0][j], this.maps[i - 1][1][j], this.maps[i - 1][2][j], this.maps[i - 1][3][j]);
                    avg.copy(tempColor);
                    j = 2 * k + 1 + 4 * w * m;
                    tempColor.setERGB(this.maps[i - 1][0][j], this.maps[i - 1][1][j], this.maps[i - 1][2][j], this.maps[i - 1][3][j]);
                    avg.add(tempColor);
                    j = 2 * k + 2 * w * (2 * m + 1);
                    tempColor.setERGB(this.maps[i - 1][0][j], this.maps[i - 1][1][j], this.maps[i - 1][2][j], this.maps[i - 1][3][j]);
                    avg.add(tempColor);
                    j = 2 * k + 1 + 2 * w * (2 * m + 1);
                    tempColor.setERGB(this.maps[i - 1][0][j], this.maps[i - 1][1][j], this.maps[i - 1][2][j], this.maps[i - 1][3][j]);
                    avg.add(tempColor);
                    avg.scale(0.25);
                    int ergb = avg.getERGB();
                    this.maps[i][0][k + w * m] = (byte)(ergb >> 16 & 0xFF);
                    this.maps[i][1][k + w * m] = (byte)(ergb >> 8 & 0xFF);
                    this.maps[i][2][k + w * m] = (byte)(ergb & 0xFF);
                    this.maps[i][3][k + w * m] = (byte)(ergb >> 24 & 0xFF);
                }
            }
        }
        for (i = 0; i < num - 1; ++i) {
            this.scaleMult[i] = 1.0 / (this.scale[i + 1] - this.scale[i]);
        }
        for (i = 0; i < num; ++i) {
            this.xscale[i] = this.width[i];
            this.yscale[i] = this.height[i];
        }
    }

    private void findAverage() {
        byte[][] map = this.maps[this.maps.length - 1];
        RGBColor avg = new RGBColor();
        RGBColor tempColor = new RGBColor();
        int len = map[0].length;
        for (int i = 0; i < len; ++i) {
            tempColor.setERGB(map[0][i], map[1][i], map[2][i], map[3][i]);
            avg.add(tempColor);
        }
        avg.scale(1.0 / (double)len);
        this.average = new float[]{avg.getRed(), avg.getGreen(), avg.getBlue()};
    }

    private void createPreview() {
        int h;
        int w;
        if (this.width[0] <= 50 && this.height[0] <= 50) {
            w = this.width[0];
            h = this.height[0];
        } else if (this.width[0] < this.height[0]) {
            w = (int)((float)(this.width[0] * 50) / (float)this.height[0]);
            h = 50;
        } else {
            w = 50;
            h = (int)((float)(this.height[0] * 50) / (float)this.width[0]);
        }
        int[] data = new int[w * h];
        float xstep = (float)this.width[0] / (float)w;
        float ystep = (float)this.height[0] / (float)h;
        byte[][] map0 = this.maps[0];
        RGBColor tempColor = new RGBColor();
        for (int i = 0; i < h; ++i) {
            float pos = (int)((float)i * ystep) * this.width[0];
            int base = i * w;
            for (int j = 0; j < w; ++j) {
                int ipos = (int)pos;
                tempColor.setERGB(map0[0][ipos], map0[1][ipos], map0[2][ipos], map0[3][ipos]);
                data[base + j] = tempColor.getARGB();
                pos += xstep;
            }
        }
        MemoryImageSource src = new MemoryImageSource(w, h, data, 0, w);
        this.preview = Toolkit.getDefaultToolkit().createImage(src);
    }

    public int getWidth() {
        return this.width[0];
    }

    public int getHeight() {
        return this.height[0];
    }

    public int getComponentCount() {
        return 3;
    }

    public float getComponent(int component, boolean wrapx, boolean wrapy, double x, double y, double xsize, double ysize) {
        if (component > 2) {
            return 1.0f;
        }
        double size = xsize * this.xscale[0] > ysize * this.yscale[0] ? xsize : ysize;
        y = 1.0 - y;
        if (size <= this.scale[0]) {
            return this.getMapComponent(component, 0, wrapx, wrapy, x, y);
        }
        if (size >= this.scale[this.maps.length - 1]) {
            return this.average[component];
        }
        int which = 0;
        while (size > this.scale[which + 1]) {
            ++which;
        }
        float frac = (float)((size - this.scale[which]) * this.scaleMult[which]);
        return (1.0f - frac) * this.getMapComponent(component, which, wrapx, wrapy, x, y) + frac * this.getMapComponent(component, which + 1, wrapx, wrapy, x, y);
    }

    private float getMapComponent(int component, int which, boolean wrapx, boolean wrapy, double x, double y) {
        int j2;
        int i2;
        int w = this.width[which];
        int h = this.height[which];
        byte[][] map = this.maps[which];
        float frac1 = (float)(x * this.xscale[which]);
        int i1 = (int)frac1;
        frac1 -= (float)i1;
        if (i1 >= w - 1) {
            i1 = w - 1;
            i2 = wrapx ? 0 : i1;
        } else {
            i2 = i1 + 1;
        }
        float frac2 = (float)(y * this.yscale[which]);
        int j1 = (int)frac2;
        frac2 -= (float)j1;
        if (j1 >= h - 1) {
            j1 = h - 1;
            j2 = wrapy ? 0 : j1;
        } else {
            j2 = j1 + 1;
        }
        int ind1 = i1 + j1 * w;
        int ind2 = i1 + j2 * w;
        int ind3 = i2 + j1 * w;
        int ind4 = i2 + j2 * w;
        float w1 = (1.0f - frac1) * (1.0f - frac2);
        float w2 = (1.0f - frac1) * frac2;
        float w3 = frac1 * (1.0f - frac2);
        float w4 = frac1 * frac2;
        float value1 = (float)(map[component][ind1] & 0xFF) * RGBColor.ERGB_EXP_SCALE[map[3][ind1] & 0xFF];
        float value2 = (float)(map[component][ind2] & 0xFF) * RGBColor.ERGB_EXP_SCALE[map[3][ind2] & 0xFF];
        float value3 = (float)(map[component][ind3] & 0xFF) * RGBColor.ERGB_EXP_SCALE[map[3][ind3] & 0xFF];
        float value4 = (float)(map[component][ind4] & 0xFF) * RGBColor.ERGB_EXP_SCALE[map[3][ind4] & 0xFF];
        return value1 * w1 + value2 * w2 + value3 * w3 + value4 * w4;
    }

    public float getAverageComponent(int component) {
        if (component >= 3) {
            return 0.0f;
        }
        return this.average[component];
    }

    public void getColor(RGBColor theColor, boolean wrapx, boolean wrapy, double x, double y, double xsize, double ysize) {
        double size = xsize * this.xscale[0] > ysize * this.yscale[0] ? xsize : ysize;
        y = 1.0 - y;
        if (size <= this.scale[0]) {
            this.getMapColor(theColor, 0, wrapx, wrapy, x, y);
            return;
        }
        if (size >= this.scale[this.maps.length - 1]) {
            this.getMapColor(theColor, this.maps.length - 1, wrapx, wrapy, x, y);
            return;
        }
        int which = 0;
        while (size > this.scale[which + 1]) {
            ++which;
        }
        float frac = (float)((size - this.scale[which]) * this.scaleMult[which]);
        RGBColor tempColor = new RGBColor();
        this.getMapColor(tempColor, which, wrapx, wrapy, x, y);
        this.getMapColor(theColor, which + 1, wrapx, wrapy, x, y);
        tempColor.scale(1.0f - frac);
        theColor.scale(frac);
        theColor.add(tempColor);
    }

    private void getMapColor(RGBColor theColor, int which, boolean wrapx, boolean wrapy, double x, double y) {
        int j2;
        int i2;
        int w = this.width[which];
        int h = this.height[which];
        byte[][] map = this.maps[which];
        float frac1 = (float)(x * this.xscale[which]);
        int i1 = (int)frac1;
        frac1 -= (float)i1;
        if (i1 >= w - 1) {
            i1 = w - 1;
            i2 = wrapx ? 0 : i1;
        } else {
            i2 = i1 + 1;
        }
        float frac2 = (float)(y * this.yscale[which]);
        int j1 = (int)frac2;
        frac2 -= (float)j1;
        if (j1 >= h - 1) {
            j1 = h - 1;
            j2 = wrapy ? 0 : j1;
        } else {
            j2 = j1 + 1;
        }
        int ind1 = i1 + j1 * w;
        int ind2 = i1 + j2 * w;
        int ind3 = i2 + j1 * w;
        int ind4 = i2 + j2 * w;
        float w1 = (1.0f - frac1) * (1.0f - frac2);
        float w2 = (1.0f - frac1) * frac2;
        float w3 = frac1 * (1.0f - frac2);
        float w4 = frac1 * frac2;
        theColor.setERGB(map[0][ind1], map[1][ind1], map[2][ind1], map[3][ind1]);
        theColor.scale(w1);
        RGBColor tempColor = new RGBColor();
        tempColor.setERGB(map[0][ind2], map[1][ind2], map[2][ind2], map[3][ind2]);
        tempColor.scale(w2);
        theColor.add(tempColor);
        tempColor.setERGB(map[0][ind3], map[1][ind3], map[2][ind3], map[3][ind3]);
        tempColor.scale(w3);
        theColor.add(tempColor);
        tempColor.setERGB(map[0][ind4], map[1][ind4], map[2][ind4], map[3][ind4]);
        tempColor.scale(w4);
        theColor.add(tempColor);
    }

    public void getGradient(Vec2 grad, int component, boolean wrapx, boolean wrapy, double x, double y, double xsize, double ysize) {
        double size = xsize * this.xscale[0] > ysize * this.yscale[0] ? xsize : ysize;
        y = 1.0 - y;
        if (size <= this.scale[0]) {
            this.getMapGradient(grad, component, 0, wrapx, wrapy, x, y);
            return;
        }
        if (size >= this.scale[this.maps.length - 1]) {
            grad.set(0.0, 0.0);
            return;
        }
        int which = 0;
        while (size > this.scale[which + 1]) {
            ++which;
        }
        double frac = (float)((size - this.scale[which]) * this.scaleMult[which]);
        Vec2 tempVec = new Vec2();
        this.getMapGradient(grad, component, which, wrapx, wrapy, x, y);
        this.getMapGradient(tempVec, component, which + 1, wrapx, wrapy, x, y);
        grad.scale(1.0 - frac);
        tempVec.scale(frac);
        grad.add(tempVec);
        grad.y = -grad.y;
    }

    private void getMapGradient(Vec2 grad, int component, int which, boolean wrapx, boolean wrapy, double x, double y) {
        int j2;
        int i2;
        int w = this.width[which];
        int h = this.height[which];
        byte[][] map = this.maps[which];
        double frac1 = x * this.xscale[which];
        int i1 = (int)frac1;
        frac1 -= (double)i1;
        if (i1 >= w - 1) {
            i1 = w - 1;
            i2 = wrapx ? 0 : i1;
        } else {
            i2 = i1 + 1;
        }
        double frac2 = y * this.yscale[which];
        int j1 = (int)frac2;
        frac2 -= (double)j1;
        if (j1 >= h - 1) {
            j1 = h - 1;
            j2 = wrapy ? 0 : j1;
        } else {
            j2 = j1 + 1;
        }
        int ind1 = i1 + j1 * w;
        int ind2 = i1 + j2 * w;
        int ind3 = i2 + j1 * w;
        int ind4 = i2 + j2 * w;
        double v1 = (float)(map[component][ind1] & 0xFF) * RGBColor.ERGB_EXP_SCALE[map[3][ind1] & 0xFF];
        double v2 = (float)(map[component][ind2] & 0xFF) * RGBColor.ERGB_EXP_SCALE[map[3][ind2] & 0xFF];
        double v3 = (float)(map[component][ind3] & 0xFF) * RGBColor.ERGB_EXP_SCALE[map[3][ind3] & 0xFF];
        double v4 = (float)(map[component][ind4] & 0xFF) * RGBColor.ERGB_EXP_SCALE[map[3][ind4] & 0xFF];
        grad.x = ((v3 - v1) * (1.0 - frac2) + (v4 - v2) * frac2) * this.xscale[which];
        grad.y = ((v2 - v1) * (1.0 - frac1) + (v4 - v3) * frac1) * this.yscale[which];
    }

    public Image getPreview() {
        return this.preview;
    }

    public HDRImage(DataInputStream in) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("Illegal version for HDRImage");
        }
        int w = in.readInt();
        int h = in.readInt();
        byte[][] map = new byte[4][];
        for (int i = 0; i < 4; ++i) {
            map[i] = new byte[w * h];
            in.readFully(map[i]);
        }
        this.buildMipMaps(map[0], map[1], map[2], map[3], w, h);
        this.findAverage();
        this.createPreview();
    }

    public void writeToStream(DataOutputStream out) throws IOException {
        out.writeShort(0);
        out.writeInt(this.width[0]);
        out.writeInt(this.height[0]);
        for (int i = 0; i < 4; ++i) {
            out.write(this.maps[0][i]);
        }
    }
}

