/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation.distortion;

import artofillusion.LayoutWindow;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.animation.Keyframe;
import artofillusion.animation.ScalarKeyframe;
import artofillusion.animation.Smoothness;
import artofillusion.animation.Timecourse;
import artofillusion.animation.Track;
import artofillusion.animation.WeightTrack;
import artofillusion.animation.distortion.TwistDistortion;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import buoy.event.ValueChangedEvent;
import buoy.widget.BCheckBox;
import buoy.widget.BComboBox;
import buoy.widget.BLabel;
import buoy.widget.BTextField;
import buoy.widget.Widget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class TwistTrack
extends Track {
    ObjectInfo info;
    Timecourse tc;
    int axis;
    int smoothingMethod;
    WeightTrack theWeight;
    boolean worldCoords;
    boolean forward;

    public TwistTrack(ObjectInfo info) {
        super("Twist");
        this.info = info;
        this.tc = new Timecourse(new Keyframe[0], new double[0], new Smoothness[0]);
        this.smoothingMethod = 2;
        this.theWeight = new WeightTrack(this);
        this.axis = 1;
        this.forward = true;
        this.worldCoords = false;
    }

    public void apply(double time) {
        ScalarKeyframe angle = (ScalarKeyframe)this.tc.evaluate(time, this.smoothingMethod);
        if (angle == null || angle.val == 0.0) {
            return;
        }
        double weight = this.theWeight.getWeight(time);
        if (weight == 0.0) {
            return;
        }
        if (this.worldCoords) {
            this.info.addDistortion(new TwistDistortion(this.axis, angle.val * weight, this.forward, this.info.getCoords().fromLocal(), this.info.getCoords().toLocal()));
        } else {
            this.info.addDistortion(new TwistDistortion(this.axis, angle.val * weight, this.forward, null, null));
        }
    }

    public Track duplicate(Object obj) {
        TwistTrack t = new TwistTrack((ObjectInfo)obj);
        t.name = this.name;
        t.enabled = this.enabled;
        t.quantized = this.quantized;
        t.axis = this.axis;
        t.forward = this.forward;
        t.smoothingMethod = this.smoothingMethod;
        t.worldCoords = this.worldCoords;
        t.tc = this.tc.duplicate((ObjectInfo)obj);
        t.theWeight = (WeightTrack)this.theWeight.duplicate(t);
        return t;
    }

    public void copy(Track tr) {
        TwistTrack t = (TwistTrack)tr;
        this.name = t.name;
        this.enabled = t.enabled;
        this.quantized = t.quantized;
        this.axis = t.axis;
        this.forward = t.forward;
        this.smoothingMethod = t.smoothingMethod;
        this.worldCoords = t.worldCoords;
        this.tc = t.tc.duplicate(this.info);
        this.theWeight = (WeightTrack)t.theWeight.duplicate(this);
    }

    public double[] getKeyTimes() {
        return this.tc.getTimes();
    }

    public Timecourse getTimecourse() {
        return this.tc;
    }

    public void setKeyframe(double time, Keyframe k, Smoothness s) {
        this.tc.addTimepoint(k, time, s);
    }

    public Keyframe setKeyframe(double time, Scene sc) {
        Keyframe k = this.tc.evaluate(time, this.smoothingMethod);
        k = k == null ? new ScalarKeyframe(0.0) : k.duplicate();
        this.tc.addTimepoint(k, time, new Smoothness());
        return k;
    }

    public int moveKeyframe(int which, double time) {
        return this.tc.moveTimepoint(which, time);
    }

    public void deleteKeyframe(int which) {
        this.tc.removeTimepoint(which);
    }

    public boolean isNullTrack() {
        return this.tc.getTimes().length == 0;
    }

    public Track[] getSubtracks() {
        return new Track[]{this.theWeight};
    }

    public boolean canAcceptAsParent(Object obj) {
        return obj instanceof ObjectInfo;
    }

    public Object getParent() {
        return this.info;
    }

    public void setParent(Object obj) {
        this.info = (ObjectInfo)obj;
    }

    public int getSmoothingMethod() {
        return this.smoothingMethod;
    }

    public void setSmoothingMethod(int method) {
        this.smoothingMethod = method;
    }

    public String[] getValueNames() {
        return new String[]{"Twist Angle"};
    }

    public double[] getDefaultGraphValues() {
        return new double[]{0.0};
    }

    public double[][] getValueRange() {
        return new double[][]{{-1.7976931348623157E308, Double.MAX_VALUE}};
    }

    public ObjectInfo[] getDependencies() {
        return new ObjectInfo[0];
    }

    public void deleteDependencies(ObjectInfo obj) {
    }

    public void writeToStream(DataOutputStream out, Scene scene) throws IOException {
        double[] t = this.tc.getTimes();
        Smoothness[] s = this.tc.getSmoothness();
        Keyframe[] v = this.tc.getValues();
        out.writeShort(0);
        out.writeUTF(this.name);
        out.writeBoolean(this.enabled);
        out.writeInt(this.smoothingMethod);
        out.writeInt(this.axis);
        out.writeBoolean(this.forward);
        out.writeInt(t.length);
        for (int i = 0; i < t.length; ++i) {
            out.writeDouble(t[i]);
            ((ScalarKeyframe)v[i]).writeToStream(out);
            s[i].writeToStream(out);
        }
        this.theWeight.writeToStream(out, scene);
    }

    public void initFromStream(DataInputStream in, Scene scene) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.name = in.readUTF();
        this.enabled = in.readBoolean();
        this.smoothingMethod = in.readInt();
        this.axis = in.readInt();
        this.forward = in.readBoolean();
        int keys = in.readInt();
        double[] t = new double[keys];
        Smoothness[] s = new Smoothness[keys];
        Keyframe[] v = new Keyframe[keys];
        for (int i = 0; i < keys; ++i) {
            t[i] = in.readDouble();
            v[i] = new ScalarKeyframe(in, this.info);
            s[i] = new Smoothness(in);
        }
        this.tc = new Timecourse(v, t, s);
        this.theWeight.initFromStream(in, scene);
    }

    public void editKeyframe(LayoutWindow win, int which) {
        ScalarKeyframe key = (ScalarKeyframe)this.tc.getValues()[which];
        Smoothness s = this.tc.getSmoothness()[which];
        double time = this.tc.getTimes()[which];
        ValueField angleField = new ValueField(key.val, 0, 5);
        ValueField timeField = new ValueField(time, 0, 5);
        ValueSlider s1Slider = new ValueSlider(0.0, 1.0, 100, s.getLeftSmoothness());
        final ValueSlider s2Slider = new ValueSlider(0.0, 1.0, 100, s.getRightSmoothness());
        final BCheckBox sameBox = new BCheckBox(Translate.text("separateSmoothness"), !s.isForceSame());
        sameBox.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                s2Slider.setEnabled(sameBox.getState());
            }
        });
        s2Slider.setEnabled(sameBox.getState());
        ComponentsDialog dlg = new ComponentsDialog(win, Translate.text("editKeyframe"), new Widget[]{angleField, timeField, sameBox, new BLabel(Translate.text("Smoothness") + ':'), s1Slider, s2Slider}, new String[]{Translate.text("twistAngle"), Translate.text("Time"), null, null, "(" + Translate.text("left") + ")", "(" + Translate.text("right") + ")"});
        if (!dlg.clickedOk()) {
            return;
        }
        win.setUndoRecord(new UndoRecord(win, false, 12, new Object[]{this, this.duplicate(this.info)}));
        key.val = angleField.getValue();
        if (sameBox.getState()) {
            s.setSmoothness(s1Slider.getValue(), s2Slider.getValue());
        } else {
            s.setSmoothness(s1Slider.getValue());
        }
        this.moveKeyframe(which, timeField.getValue());
    }

    public void edit(LayoutWindow win) {
        BCheckBox reverseBox = new BCheckBox(Translate.text("reverseTwistDirection"), !this.forward);
        BTextField nameField = new BTextField(this.getName());
        BComboBox smoothChoice = new BComboBox(new String[]{Translate.text("Discontinuous"), Translate.text("Linear"), Translate.text("Interpolating"), Translate.text("Approximating")});
        smoothChoice.setSelectedIndex(this.smoothingMethod);
        BComboBox axisChoice = new BComboBox(new String[]{"X", "Y", "Z"});
        axisChoice.setSelectedIndex(this.axis);
        BComboBox coordsChoice = new BComboBox(new String[]{Translate.text("Local"), Translate.text("World")});
        coordsChoice.setSelectedIndex(this.worldCoords ? 1 : 0);
        ComponentsDialog dlg = new ComponentsDialog(win, Translate.text("twistTrackTitle"), new Widget[]{nameField, smoothChoice, axisChoice, reverseBox, coordsChoice}, new String[]{Translate.text("trackName"), Translate.text("SmoothingMethod"), Translate.text("twistAxis"), "", Translate.text("CoordinateSystem")});
        if (!dlg.clickedOk()) {
            return;
        }
        win.setUndoRecord(new UndoRecord(win, false, 2, new Object[]{this.info, this.info.duplicate()}));
        this.setName(nameField.getText());
        this.smoothingMethod = smoothChoice.getSelectedIndex();
        this.axis = axisChoice.getSelectedIndex();
        this.forward = !reverseBox.getState();
        this.worldCoords = coordsChoice.getSelectedIndex() == 1;
    }
}

