/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation.distortion;

import artofillusion.LayoutWindow;
import artofillusion.MeshViewer;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.animation.Actor;
import artofillusion.animation.Keyframe;
import artofillusion.animation.Smoothness;
import artofillusion.animation.Timecourse;
import artofillusion.animation.Track;
import artofillusion.animation.WeightTrack;
import artofillusion.animation.distortion.SkeletonShapeDistortion;
import artofillusion.animation.distortion.SkeletonShapeEditorWindow;
import artofillusion.animation.distortion.SkeletonShapeKeyframe;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.Translate;
import buoy.widget.BCheckBox;
import buoy.widget.BComboBox;
import buoy.widget.BTextField;
import buoy.widget.Widget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class SkeletonShapeTrack
extends Track {
    private ObjectInfo info;
    private Timecourse tc;
    private int smoothingMethod;
    private boolean useGestures;
    private WeightTrack theWeight;

    public SkeletonShapeTrack(ObjectInfo info) {
        super("Skeleton Shape");
        this.info = info;
        this.tc = new Timecourse(new Keyframe[0], new double[0], new Smoothness[0]);
        this.smoothingMethod = 2;
        this.useGestures = true;
        this.theWeight = new WeightTrack(this);
    }

    public boolean getUseGestures() {
        return this.useGestures;
    }

    public void setUseGestures(boolean use) {
        this.useGestures = use;
    }

    public void apply(double time) {
        SkeletonShapeKeyframe key = (SkeletonShapeKeyframe)this.tc.evaluate(time, this.smoothingMethod);
        if (key == null) {
            return;
        }
        double weight = this.theWeight.getWeight(time);
        Actor actor = null;
        if (this.useGestures) {
            actor = Actor.getActor(this.info.getObject());
        }
        if (weight > 0.0) {
            this.info.addDistortion(new SkeletonShapeDistortion(key.getSkeleton().duplicate(), weight, actor));
        }
    }

    public Track duplicate(Object obj) {
        SkeletonShapeTrack t = new SkeletonShapeTrack((ObjectInfo)obj);
        t.name = this.name;
        t.enabled = this.enabled;
        t.quantized = this.quantized;
        t.smoothingMethod = this.smoothingMethod;
        t.useGestures = this.useGestures;
        t.tc = this.tc.duplicate(((ObjectInfo)obj).getObject());
        t.theWeight = (WeightTrack)this.theWeight.duplicate(t);
        return t;
    }

    public void copy(Track tr) {
        SkeletonShapeTrack t = (SkeletonShapeTrack)tr;
        this.name = t.name;
        this.enabled = t.enabled;
        this.quantized = t.quantized;
        this.smoothingMethod = t.smoothingMethod;
        this.useGestures = t.useGestures;
        this.tc = t.tc.duplicate(this.info.getObject());
        this.theWeight = (WeightTrack)t.theWeight.duplicate(this);
    }

    public double[] getKeyTimes() {
        return this.tc.getTimes();
    }

    public Timecourse getTimecourse() {
        return this.tc;
    }

    public void setKeyframe(double time, Keyframe k, Smoothness s) {
        this.tc.addTimepoint(k, time, s);
    }

    public Keyframe setKeyframe(double time, Scene sc) {
        Keyframe k = this.tc.evaluate(time, this.smoothingMethod);
        k = k == null ? new SkeletonShapeKeyframe(this.info.getObject(), this.info.getObject().getSkeleton().duplicate()) : k.duplicate();
        this.tc.addTimepoint(k, time, new Smoothness());
        return k;
    }

    public int moveKeyframe(int which, double time) {
        return this.tc.moveTimepoint(which, time);
    }

    public void deleteKeyframe(int which) {
        this.tc.removeTimepoint(which);
    }

    public boolean isNullTrack() {
        return this.tc.getTimes().length == 0;
    }

    public Track[] getSubtracks() {
        return new Track[]{this.theWeight};
    }

    public boolean canAcceptAsParent(Object obj) {
        return obj instanceof ObjectInfo && ((ObjectInfo)obj).getSkeleton() != null;
    }

    public Object getParent() {
        return this.info;
    }

    public void setParent(Object obj) {
        this.info = (ObjectInfo)obj;
    }

    public int getSmoothingMethod() {
        return this.smoothingMethod;
    }

    public void setSmoothingMethod(int method) {
        this.smoothingMethod = method;
    }

    public String[] getValueNames() {
        return new String[0];
    }

    public double[] getDefaultGraphValues() {
        return new double[0];
    }

    public double[][] getValueRange() {
        return new double[][]{{-1.7976931348623157E308, Double.MAX_VALUE}};
    }

    public ObjectInfo[] getDependencies() {
        return new ObjectInfo[0];
    }

    public void deleteDependencies(ObjectInfo obj) {
    }

    public void writeToStream(DataOutputStream out, Scene scene) throws IOException {
        double[] t = this.tc.getTimes();
        Smoothness[] s = this.tc.getSmoothness();
        Keyframe[] v = this.tc.getValues();
        out.writeShort(0);
        out.writeUTF(this.name);
        out.writeBoolean(this.enabled);
        out.writeInt(this.smoothingMethod);
        out.writeBoolean(this.useGestures);
        out.writeInt(t.length);
        for (int i = 0; i < t.length; ++i) {
            out.writeDouble(t[i]);
            v[i].writeToStream(out);
            s[i].writeToStream(out);
        }
        this.theWeight.writeToStream(out, scene);
    }

    public void initFromStream(DataInputStream in, Scene scene) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.name = in.readUTF();
        this.enabled = in.readBoolean();
        this.smoothingMethod = in.readInt();
        this.useGestures = in.readBoolean();
        int keys = in.readInt();
        double[] t = new double[keys];
        Smoothness[] s = new Smoothness[keys];
        Keyframe[] v = new Keyframe[keys];
        for (int i = 0; i < keys; ++i) {
            t[i] = in.readDouble();
            v[i] = new SkeletonShapeKeyframe(in, this.info.getObject());
            s[i] = new Smoothness(in);
        }
        this.tc = new Timecourse(v, t, s);
        this.theWeight.initFromStream(in, scene);
    }

    public void editKeyframe(final LayoutWindow win, int which) {
        SkeletonShapeEditorWindow ed = new SkeletonShapeEditorWindow(win, Translate.text("editKeyframe"), this, which, new Runnable(){

            public void run() {
                win.getScore().tracksModified(true);
            }
        });
        ViewerCanvas[] views = ed.getAllViews();
        for (int i = 0; i < views.length; ++i) {
            ((MeshViewer)views[i]).setScene(win.getScene(), this.info);
        }
        ed.setVisible(true);
    }

    public void edit(LayoutWindow win) {
        BTextField nameField = new BTextField(this.getName());
        BComboBox smoothChoice = new BComboBox(new String[]{Translate.text("Discontinuous"), Translate.text("Linear"), Translate.text("Interpolating"), Translate.text("Approximating")});
        smoothChoice.setSelectedIndex(this.smoothingMethod);
        BCheckBox gesturesBox = new BCheckBox(Translate.text("useGesturesToShapeMesh"), this.useGestures);
        gesturesBox.setEnabled(Actor.getActor(this.info.getObject()) != null);
        ComponentsDialog dlg = new ComponentsDialog(win, Translate.text("skeletonShapeTrackTitle"), new Widget[]{nameField, smoothChoice, gesturesBox}, new String[]{Translate.text("trackName"), Translate.text("SmoothingMethod"), null});
        if (!dlg.clickedOk()) {
            return;
        }
        win.setUndoRecord(new UndoRecord(win, false, 2, new Object[]{this.info, this.info.duplicate()}));
        this.setName(nameField.getText());
        this.smoothingMethod = smoothChoice.getSelectedIndex();
        this.useGestures = gesturesBox.getState();
    }
}

