/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation.distortion;

import artofillusion.animation.Actor;
import artofillusion.animation.Keyframe;
import artofillusion.animation.Skeleton;
import artofillusion.object.Object3D;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class SkeletonShapeKeyframe
implements Keyframe {
    private Object3D object;
    private Skeleton skeleton;

    public SkeletonShapeKeyframe(Object3D owner, Skeleton s) {
        this.object = owner;
        this.skeleton = s;
    }

    public Object3D getObject() {
        return this.object;
    }

    public Skeleton getSkeleton() {
        return this.skeleton;
    }

    public Keyframe duplicate() {
        return new SkeletonShapeKeyframe(this.object, this.skeleton.duplicate());
    }

    public Keyframe duplicate(Object owner) {
        return new SkeletonShapeKeyframe((Object3D)owner, this.skeleton.duplicate());
    }

    public double[] getGraphValues() {
        return new double[0];
    }

    public void setGraphValues(double[] values) {
    }

    public Keyframe blend(Keyframe o2, double weight1, double weight2) {
        return this.blend(new Keyframe[]{this, o2}, new double[]{weight1, weight2});
    }

    public Keyframe blend(Keyframe o2, Keyframe o3, double weight1, double weight2, double weight3) {
        return this.blend(new Keyframe[]{this, o2, o3}, new double[]{weight1, weight2, weight3});
    }

    public Keyframe blend(Keyframe o2, Keyframe o3, Keyframe o4, double weight1, double weight2, double weight3, double weight4) {
        return this.blend(new Keyframe[]{this, o2, o3, o4}, new double[]{weight1, weight2, weight3, weight4});
    }

    private Keyframe blend(Keyframe[] key, double[] weight) {
        Actor actor = Actor.getActor(this.object);
        Skeleton base = actor != null ? actor.getGesture(0).getSkeleton() : this.object.getSkeleton();
        Skeleton[] toBlend = new Skeleton[key.length];
        for (int i = 0; i < key.length; ++i) {
            toBlend[i] = ((SkeletonShapeKeyframe)key[i]).skeleton;
        }
        Skeleton average = base.duplicate();
        base.blend(average, toBlend, weight);
        return new SkeletonShapeKeyframe(this.object, average);
    }

    public boolean equals(Keyframe k) {
        if (!(k instanceof SkeletonShapeKeyframe)) {
            return false;
        }
        return this.skeleton.equals(((SkeletonShapeKeyframe)k).skeleton);
    }

    public void writeToStream(DataOutputStream out) throws IOException {
        out.writeShort(0);
        this.skeleton.writeToStream(out);
    }

    public SkeletonShapeKeyframe(DataInputStream in, Object parent) throws IOException {
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.object = (Object3D)parent;
        this.skeleton = new Skeleton(in);
    }
}

