/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation.distortion;

import artofillusion.animation.Actor;
import artofillusion.animation.Gesture;
import artofillusion.animation.Keyframe;
import artofillusion.animation.distortion.Distortion;
import artofillusion.object.Mesh;
import artofillusion.object.Object3D;

public class PoseDistortion
extends Distortion {
    private double weight;
    private Keyframe pose;
    private Actor actor;
    private boolean relative;

    public PoseDistortion(double weight, Keyframe pose, Actor actor, boolean relative) {
        this.weight = weight;
        this.pose = pose;
        this.actor = actor;
        this.relative = relative;
    }

    public boolean isIdenticalTo(Distortion d) {
        if (!(d instanceof PoseDistortion)) {
            return false;
        }
        PoseDistortion s = (PoseDistortion)d;
        if (this.previous != null && !this.previous.isIdenticalTo(s.previous)) {
            return false;
        }
        if (this.previous == null && s.previous != null) {
            return false;
        }
        if (this.weight != s.weight) {
            return false;
        }
        return this.pose.equals(s.pose);
    }

    public Distortion duplicate() {
        PoseDistortion d = new PoseDistortion(this.weight, this.pose.duplicate(), this.actor, this.relative);
        if (this.previous != null) {
            d.previous = this.previous.duplicate();
        }
        return d;
    }

    public Mesh transform(Mesh obj) {
        if (this.previous != null) {
            obj = this.previous.transform(obj);
        }
        try {
            Keyframe base;
            Keyframe toApply = this.pose;
            if (this.actor != null && this.pose instanceof Actor.ActorKeyframe) {
                base = this.actor.getGesture(0);
                Gesture current = (Gesture)((Object3D)((Object)obj)).getPoseKeyframe();
                Gesture poseGesture = (Gesture)((Actor.ActorKeyframe)this.pose).createObjectKeyframe(this.actor);
                toApply = this.relative ? base.blend(new Gesture[]{current, poseGesture}, new double[]{1.0, this.weight}) : (this.weight < 1.0 ? base.blend(new Gesture[]{current, poseGesture}, new double[]{1.0 - this.weight, this.weight}) : poseGesture);
            } else {
                base = ((Object3D)((Object)obj)).getPoseKeyframe();
                toApply = this.pose;
                if (this.relative) {
                    toApply = base.blend(toApply, 1.0, this.weight);
                } else if (this.weight < 1.0) {
                    toApply = base.blend(toApply, 1.0 - this.weight, this.weight);
                }
            }
            Object3D newmesh = obj.duplicate();
            newmesh.applyPoseKeyframe(toApply);
            return (Mesh)((Object)newmesh);
        }
        catch (ClassCastException ex) {
            return obj;
        }
    }
}

