/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ArtOfIllusion;
import artofillusion.Camera;
import artofillusion.RenderingMesh;
import artofillusion.Scene;
import artofillusion.WireframeMesh;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.ObjectInfo;
import artofillusion.object.SceneCamera;
import artofillusion.ui.ActionProcessor;
import artofillusion.ui.EditingTool;
import artofillusion.ui.PopupMenuManager;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.view.CanvasDrawer;
import artofillusion.view.GLCanvasDrawer;
import artofillusion.view.SoftwareCanvasDrawer;
import artofillusion.view.VertexShader;
import artofillusion.view.ViewChangedEvent;
import artofillusion.view.ViewerControl;
import buoy.event.MouseClickedEvent;
import buoy.event.MouseDraggedEvent;
import buoy.event.MouseMovedEvent;
import buoy.event.MousePressedEvent;
import buoy.event.MouseReleasedEvent;
import buoy.event.MouseScrolledEvent;
import buoy.event.WidgetMouseEvent;
import buoy.widget.BStandardDialog;
import buoy.widget.CustomWidget;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ViewerCanvas
extends CustomWidget {
    protected Camera theCamera;
    protected ObjectInfo boundCamera;
    protected EditingTool currentTool;
    protected EditingTool activeTool;
    protected EditingTool metaTool;
    protected EditingTool altTool;
    protected PopupMenuManager popupManager;
    protected int renderMode;
    protected int gridSubdivisions;
    protected int orientation;
    protected double gridSpacing;
    protected double scale;
    protected boolean perspective;
    protected boolean hideBackfaces;
    protected boolean showGrid;
    protected boolean snapToGrid;
    protected boolean drawFocus;
    protected boolean showTemplate;
    protected boolean showAxes;
    protected ActionProcessor mouseProcessor;
    protected Image templateImage;
    protected Image renderedImage;
    protected CanvasDrawer drawer;
    protected Dimension prefSize;
    protected Map<ViewerControl, Widget> controlMap;
    protected Vec3 rotationCenter;
    protected final ViewChangedEvent viewChangedEvent;
    private static boolean openGLAvailable;
    private static List<ViewerControl> controls;
    public static Color backgroundColor;
    public static Color lineColor;
    public static Color handleColor;
    public static Color highlightColor;
    public static Color specialHighlightColor;
    public static Color disabledColor;
    public static Color surfaceColor;
    public static RGBColor surfaceRGBColor;
    public static RGBColor transparentColor;
    public static RGBColor lowValueColor;
    public static RGBColor highValueColor;
    public static final int RENDER_WIREFRAME = 0;
    public static final int RENDER_FLAT = 1;
    public static final int RENDER_SMOOTH = 2;
    public static final int RENDER_TEXTURED = 3;
    public static final int RENDER_TRANSPARENT = 4;
    public static final int RENDER_RENDERED = 5;
    public static final int VIEW_FRONT = 0;
    public static final int VIEW_BACK = 1;
    public static final int VIEW_LEFT = 2;
    public static final int VIEW_RIGHT = 3;
    public static final int VIEW_TOP = 4;
    public static final int VIEW_BOTTOM = 5;
    public static final int VIEW_OTHER = Integer.MAX_VALUE;

    public ViewerCanvas() {
        this(ArtOfIllusion.getPreferences().getUseOpenGL() && openGLAvailable);
    }

    public ViewerCanvas(boolean useOpenGL) {
        CoordinateSystem coords = new CoordinateSystem(new Vec3(0.0, 0.0, 20.0), new Vec3(0.0, 0.0, -1.0), Vec3.vy());
        this.viewChangedEvent = new ViewChangedEvent(this);
        this.controlMap = new HashMap<ViewerControl, Widget>();
        this.theCamera = new Camera();
        this.theCamera.setCameraCoordinates(coords);
        this.setBackground(backgroundColor);
        if (useOpenGL) {
            try {
                this.drawer = new GLCanvasDrawer(this);
                this.component = ((GLCanvasDrawer)this.drawer).getGLCanvas();
            }
            catch (Throwable t) {
                System.out.println("Error creating GLCanvasDrawer: " + t);
                openGLAvailable = false;
            }
        }
        if (this.drawer == null) {
            this.drawer = new SoftwareCanvasDrawer(this);
        }
        this.setFocusable(true);
        this.prefSize = new Dimension(0, 0);
        this.addEventLink(MousePressedEvent.class, (Object)this, "processMousePressed");
        this.addEventLink(MouseReleasedEvent.class, (Object)this, "processMouseReleased");
        this.addEventLink(MouseDraggedEvent.class, (Object)this, "processMouseDragged");
        this.addEventLink(MouseMovedEvent.class, (Object)this, "processMouseDragged");
        this.addEventLink(MouseScrolledEvent.class, (Object)this, "processMouseScrolled");
        this.addEventLink(MouseClickedEvent.class, (Object)this, "showPopupIfNeeded");
        this.getComponent().addComponentListener(new ComponentListener(){

            public void componentResized(ComponentEvent componentEvent) {
                ViewerCanvas.this.viewChanged(false);
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentShown(ComponentEvent componentEvent) {
            }

            public void componentHidden(ComponentEvent componentEvent) {
            }
        });
        this.orientation = 0;
        this.perspective = false;
        this.scale = 100.0;
    }

    public CanvasDrawer getCanvasDrawer() {
        return this.drawer;
    }

    protected void buildChoices(RowContainer row) {
        for (int i = 0; i < controls.size(); ++i) {
            Widget w = controls.get(i).createWidget(this);
            if (w == null) continue;
            row.add(w);
            this.controlMap.put(controls.get(i), w);
        }
        this.viewChanged(false);
    }

    private void processMousePressed(WidgetMouseEvent ev) {
        if (this.mouseProcessor != null) {
            this.mouseProcessor.stopProcessing();
        }
        this.mousePressed(ev);
        this.mouseProcessor = new ActionProcessor();
    }

    private void processMouseDragged(final WidgetMouseEvent ev) {
        if (this.mouseProcessor != null) {
            this.mouseProcessor.addEvent(new Runnable(){

                public void run() {
                    ViewerCanvas.this.mouseDragged(ev);
                }
            });
        }
    }

    private void processMouseReleased(WidgetMouseEvent ev) {
        if (this.mouseProcessor != null) {
            this.mouseProcessor.stopProcessing();
            this.mouseProcessor = null;
            this.mouseReleased(ev);
        }
    }

    protected void processMouseScrolled(MouseScrolledEvent ev) {
        int amount = ev.getWheelRotation();
        if (!ev.isAltDown()) {
            amount *= 10;
        }
        if (ArtOfIllusion.getPreferences().getReverseZooming()) {
            amount *= -1;
        }
        if (this.isPerspective()) {
            CoordinateSystem coords = this.theCamera.getCameraCoordinates();
            Vec3 delta = coords.getZDirection().times(-0.1 * (double)amount);
            coords.setOrigin(coords.getOrigin().plus(delta));
            this.theCamera.setCameraCoordinates(coords);
            this.viewChanged(false);
            this.repaint();
        } else {
            this.setScale(this.getScale() * Math.pow(0.99, amount));
        }
    }

    protected void mousePressed(WidgetMouseEvent ev) {
    }

    protected void mouseDragged(WidgetMouseEvent ev) {
    }

    protected void mouseReleased(WidgetMouseEvent ev) {
    }

    @Override
    public void setPreferredSize(Dimension size) {
        this.prefSize = new Dimension(size);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.prefSize);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public ActionProcessor getActionProcessor() {
        return this.mouseProcessor;
    }

    public Camera getCamera() {
        return this.theCamera;
    }

    public Scene getScene() {
        return null;
    }

    public void setTool(EditingTool tool) {
        this.currentTool = tool;
        this.repaint();
    }

    public EditingTool getCurrentTool() {
        return this.currentTool;
    }

    public void setMetaTool(EditingTool tool) {
        this.metaTool = tool;
    }

    public void setAltTool(EditingTool tool) {
        this.altTool = tool;
    }

    public void setPerspective(boolean perspective) {
        this.perspective = perspective;
        this.viewChanged(false);
        this.repaint();
    }

    public boolean isPerspective() {
        if (this.boundCamera != null && this.boundCamera.getObject() instanceof SceneCamera) {
            return ((SceneCamera)this.boundCamera.getObject()).isPerspective();
        }
        return this.perspective;
    }

    public double getScale() {
        if (this.isPerspective()) {
            return 100.0;
        }
        return this.scale;
    }

    public void setScale(double scale) {
        if (scale > 0.0) {
            this.scale = scale;
        }
        this.viewChanged(false);
        this.repaint();
    }

    public boolean getDrawFocus() {
        return this.drawFocus;
    }

    public void setDrawFocus(boolean draw) {
        this.drawFocus = draw;
    }

    public boolean getShowAxes() {
        return this.showAxes;
    }

    public void setShowAxes(boolean show) {
        this.showAxes = show;
        this.viewChanged(false);
    }

    public boolean getTemplateShown() {
        return this.showTemplate;
    }

    public void setShowTemplate(boolean show) {
        this.showTemplate = show;
        this.viewChanged(false);
    }

    public Image getTemplateImage() {
        return this.templateImage;
    }

    public void setTemplateImage(Image im) {
        this.templateImage = im;
        this.drawer.setTemplateImage(im);
        this.viewChanged(false);
    }

    public void setTemplateImage(File f) throws InterruptedException {
        Image im = Toolkit.getDefaultToolkit().getImage(f.getAbsolutePath());
        MediaTracker mt = new MediaTracker(this.getComponent());
        mt.addImage(im, 0);
        mt.waitForID(0);
        if (mt.isErrorID(0)) {
            throw new InterruptedException();
        }
        this.setTemplateImage(im);
    }

    public Vec3 getRotationCenter() {
        return this.rotationCenter;
    }

    public void setRotationCenter(Vec3 rotationCenter) {
        this.rotationCenter = rotationCenter;
    }

    public Vec3 getDefaultRotationCenter() {
        CoordinateSystem coords = this.theCamera.getCameraCoordinates();
        double distToCenter = -coords.getZDirection().dot(coords.getOrigin());
        return coords.getOrigin().plus(coords.getZDirection().times(distToCenter));
    }

    public void setPopupMenuManager(PopupMenuManager manager) {
        this.popupManager = manager;
    }

    protected void showPopupIfNeeded(WidgetMouseEvent ev) {
        if (this.popupManager != null && ev instanceof MouseClickedEvent && ev.getButton() == 3 && ev.getClickCount() == 1) {
            Point pos = ev.getPoint();
            this.popupManager.showPopupMenu(this, pos.x, pos.y);
        }
    }

    public void adjustCamera(boolean perspective) {
        Rectangle bounds = this.getBounds();
        double scale = this.getScale();
        if (this.boundCamera != null && this.boundCamera.getObject() instanceof SceneCamera) {
            this.theCamera.setScreenTransform(((SceneCamera)this.boundCamera.getObject()).getScreenTransform(bounds.width, bounds.height), bounds.width, bounds.height);
        } else if (perspective) {
            this.theCamera.setScreenParams(0.0, scale, bounds.width, bounds.height);
        } else {
            this.theCamera.setScreenParamsParallel(scale, bounds.width, bounds.height);
        }
    }

    public ObjectInfo getBoundCamera() {
        return this.boundCamera;
    }

    public void setBoundCamera(ObjectInfo boundCamera) {
        this.boundCamera = boundCamera;
    }

    public void setGrid(double spacing, int subdivisions, boolean show, boolean snap) {
        this.gridSpacing = spacing;
        this.gridSubdivisions = subdivisions;
        this.showGrid = show;
        this.snapToGrid = snap;
        if (snap) {
            this.theCamera.setGrid(spacing / (double)subdivisions);
        } else {
            this.theCamera.setGrid(0.0);
        }
        this.viewChanged(false);
    }

    public boolean getShowGrid() {
        return this.showGrid;
    }

    public boolean getSnapToGrid() {
        return this.snapToGrid;
    }

    public double getGridSpacing() {
        return this.gridSpacing;
    }

    public int getSnapToSubdivisions() {
        return this.gridSubdivisions;
    }

    public void frameBox(BoundingBox bb) {
        double minScale;
        if (this.boundCamera != null) {
            return;
        }
        Rectangle bounds = this.getBounds();
        if (this.isPerspective()) {
            this.theCamera.setScreenParams(0.0, 100.0, bounds.width, bounds.height);
        } else {
            this.theCamera.setScreenParamsParallel(100.0, bounds.width, bounds.height);
        }
        double startDist = 20.0 + Math.max(Math.max(bb.maxx - bb.minx, bb.maxy - bb.miny), bb.maxz - bb.minz);
        CoordinateSystem coords = this.theCamera.getCameraCoordinates();
        Vec3 boxCenter = bb.getCenter();
        coords.setOrigin(boxCenter.minus(coords.getZDirection().times(startDist)));
        this.theCamera.setCameraCoordinates(coords);
        this.theCamera.setObjectTransform(Mat4.identity());
        Rectangle screenBounds = this.theCamera.findScreenBounds(bb);
        double scalex = (double)bounds.width / (double)screenBounds.width;
        double scaley = (double)bounds.height / (double)screenBounds.height;
        double d = minScale = scalex < scaley ? scalex : scaley;
        if (this.isPerspective()) {
            coords.setOrigin(boxCenter.minus(coords.getZDirection().times(1.1 * startDist / minScale)));
            this.setScale(100.0);
        } else {
            this.setScale(minScale * 100.0);
        }
        this.theCamera.setCameraCoordinates(coords);
    }

    public void prepareCameraForRendering() {
        if (this.boundCamera != null) {
            this.boundCamera.getCoords().copyCoords(this.theCamera.getCameraCoordinates());
        }
        this.adjustCamera(this.isPerspective());
    }

    public abstract double[] estimateDepthRange();

    public void viewChanged(boolean selectionOnly) {
        this.dispatchEvent(this.viewChangedEvent);
    }

    public synchronized void updateImage() {
        block17: {
            Rectangle bounds = this.getBounds();
            if (bounds.height <= 0) {
                return;
            }
            if (!this.showGrid) break block17;
            float scale1 = 0.0029411765f;
            float scale2 = 9.803922E-4f;
            Color majorColor = new Color((float)lineColor.getRed() * scale1 + (float)backgroundColor.getRed() * scale2, (float)lineColor.getGreen() * scale1 + (float)backgroundColor.getGreen() * scale2, (float)lineColor.getBlue() * scale1 + (float)backgroundColor.getBlue() * scale2);
            Color minorColor = new Color((float)lineColor.getRed() * scale2 + (float)backgroundColor.getRed() * scale1, (float)lineColor.getGreen() * scale2 + (float)backgroundColor.getGreen() * scale1, (float)lineColor.getBlue() * scale2 + (float)backgroundColor.getBlue() * scale1);
            if (!this.isPerspective()) {
                int lineIndex;
                Vec2 v1 = this.theCamera.getViewToScreen().timesXY(new Vec3());
                Vec2 v2 = this.theCamera.getViewToScreen().timesXY(new Vec3(this.gridSpacing, this.gridSpacing, 1.0));
                Vec2 v3 = this.theCamera.getWorldToScreen().timesXY(new Vec3());
                Vec3 horizDir = this.theCamera.getViewToWorld().timesDirection(Vec3.vx());
                Vec3 vertDir = this.theCamera.getViewToWorld().timesDirection(Vec3.vy());
                double horizSign = Math.abs(horizDir.x) >= Math.abs(horizDir.y) && Math.abs(horizDir.x) >= Math.abs(horizDir.z) ? (double)(horizDir.x > 0.0 ? -1 : 1) : (Math.abs(horizDir.y) >= Math.abs(horizDir.x) && Math.abs(horizDir.y) >= Math.abs(horizDir.z) ? (double)(horizDir.y > 0.0 ? -1 : 1) : (double)(horizDir.z > 0.0 ? -1 : 1));
                double vertSign = Math.abs(vertDir.x) >= Math.abs(vertDir.y) && Math.abs(vertDir.x) >= Math.abs(vertDir.z) ? (double)(vertDir.x > 0.0 ? -1 : 1) : (Math.abs(vertDir.y) >= Math.abs(vertDir.x) && Math.abs(vertDir.y) >= Math.abs(vertDir.z) ? (double)(vertDir.y > 0.0 ? -1 : 1) : (double)(vertDir.z > 0.0 ? -1 : 1));
                int decimals = 2;
                if (Math.abs(this.gridSpacing - (double)Math.round(this.gridSpacing)) < 1.0E-5) {
                    decimals = 0;
                } else if (Math.abs(10.0 * this.gridSpacing - (double)Math.round(10.0 * this.gridSpacing)) < 1.0E-5) {
                    decimals = 1;
                }
                NumberFormat format = NumberFormat.getNumberInstance();
                format.setMinimumFractionDigits(decimals);
                format.setMaximumFractionDigits(decimals);
                FontMetrics fm = this.getComponent().getFontMetrics(this.getComponent().getFont());
                int ascent = fm.getMaxAscent();
                double space = Math.abs(v1.x - v2.x);
                int origin = (int)v3.x;
                double pos = Math.IEEEremainder(v3.x, space);
                if (pos < 0.0) {
                    pos += space;
                }
                int numberInterval = 1;
                if (space < 10.0) {
                    numberInterval = 5;
                } else if (space < 25.0) {
                    numberInterval = 2;
                }
                while ((int)pos < bounds.width) {
                    int x;
                    this.drawVRule(x, (x = (int)pos) == origin ? majorColor : minorColor);
                    lineIndex = (int)Math.round((pos - v3.x) / space);
                    if (lineIndex % numberInterval == 0) {
                        this.drawString(format.format((double)lineIndex * this.gridSpacing * horizSign), x + 3, ascent + 3, lineColor);
                    }
                    pos += space;
                }
                space = Math.abs(v1.y - v2.y);
                origin = (int)v3.y;
                pos = Math.IEEEremainder(v3.y, space);
                if (pos < 0.0) {
                    pos += space;
                }
                while ((int)pos < bounds.height) {
                    int y;
                    this.drawHRule(y, (y = (int)pos) == origin ? majorColor : minorColor);
                    lineIndex = (int)Math.round((pos - v3.y) / space);
                    if (lineIndex % numberInterval == 0) {
                        this.drawString(format.format((double)lineIndex * this.gridSpacing * vertSign), 3, y + ascent + 3, lineColor);
                    }
                    pos += space;
                }
            } else {
                Vec3 end2;
                Vec3 end1;
                int i;
                this.theCamera.setObjectTransform(Mat4.identity());
                int size = (int)Math.max(10.0, 10.0 / this.gridSpacing);
                for (i = -size; i <= size; ++i) {
                    end1 = new Vec3((double)i * this.gridSpacing, 0.0, (double)(-size) * this.gridSpacing);
                    end2 = new Vec3((double)i * this.gridSpacing, 0.0, (double)size * this.gridSpacing);
                    this.renderLine(end1, end2, this.theCamera, i == 0 ? majorColor : minorColor);
                }
                for (i = -size; i <= size; ++i) {
                    end1 = new Vec3((double)(-size) * this.gridSpacing, 0.0, (double)i * this.gridSpacing);
                    end2 = new Vec3((double)size * this.gridSpacing, 0.0, (double)i * this.gridSpacing);
                    this.renderLine(end1, end2, this.theCamera, i == 0 ? majorColor : minorColor);
                }
            }
        }
    }

    protected void drawCoordinateAxes() {
        int y;
        int x;
        Vec2 labelPos;
        Vec2 dir;
        Rectangle bounds = this.getBounds();
        int axisLength = 50;
        if (axisLength * 5 > bounds.width) {
            axisLength = bounds.width / 5;
        }
        if (axisLength * 5 > bounds.height) {
            axisLength = bounds.height / 5;
        }
        double len = (double)axisLength / this.getScale();
        Vec2 offset = new Vec2(0.5 * (double)bounds.width - (double)axisLength - 15.0, 0.5 * (double)bounds.height - (double)axisLength - 15.0);
        CoordinateSystem cameraCoords = this.theCamera.getCameraCoordinates();
        Vec3 center = cameraCoords.getOrigin().plus(cameraCoords.getZDirection().times(this.theCamera.getDistToScreen()));
        Vec3 xpos = center.plus(new Vec3(len, 0.0, 0.0));
        Vec3 ypos = center.plus(new Vec3(0.0, len, 0.0));
        Vec3 zpos = center.plus(new Vec3(0.0, 0.0, len));
        Vec2 screenCenter = this.theCamera.getWorldToScreen().timesXY(center).plus(offset);
        Vec2 screenX = this.theCamera.getWorldToScreen().timesXY(xpos).plus(offset);
        Vec2 screenY = this.theCamera.getWorldToScreen().timesXY(ypos).plus(offset);
        Vec2 screenZ = this.theCamera.getWorldToScreen().timesXY(zpos).plus(offset);
        Point centerPoint = new Point((int)Math.round(screenCenter.x), (int)Math.round(screenCenter.y));
        this.drawLine(centerPoint, new Point((int)screenX.x, (int)screenX.y), lineColor);
        this.drawLine(centerPoint, new Point((int)screenY.x, (int)screenY.y), lineColor);
        this.drawLine(centerPoint, new Point((int)screenZ.x, (int)screenZ.y), lineColor);
        if (screenX.minus(screenCenter).length() > 2.0) {
            dir = screenX.minus(screenCenter);
            labelPos = screenX.plus(dir.times(8.0 / dir.length()));
            x = (int)labelPos.x;
            y = (int)labelPos.y;
            this.drawLine(new Point(x - 4, y - 4), new Point(x + 4, y + 4), lineColor);
            this.drawLine(new Point(x - 4, y + 4), new Point(x + 4, y - 4), lineColor);
        }
        if (screenY.minus(screenCenter).length() > 2.0) {
            dir = screenY.minus(screenCenter);
            labelPos = screenY.plus(dir.times(8.0 / dir.length()));
            x = (int)labelPos.x;
            y = (int)labelPos.y;
            this.drawLine(new Point(x - 4, y - 4), new Point(x, y), lineColor);
            this.drawLine(new Point(x + 4, y - 4), new Point(x, y), lineColor);
            this.drawLine(new Point(x, y), new Point(x, y + 4), lineColor);
        }
        if (screenZ.minus(screenCenter).length() > 2.0) {
            dir = screenZ.minus(screenCenter);
            labelPos = screenZ.plus(dir.times(8.0 / dir.length()));
            x = (int)labelPos.x;
            y = (int)labelPos.y;
            this.drawLine(new Point(x - 4, y - 4), new Point(x + 4, y - 4), lineColor);
            this.drawLine(new Point(x + 4, y - 4), new Point(x - 4, y + 4), lineColor);
            this.drawLine(new Point(x - 4, y + 4), new Point(x + 4, y + 4), lineColor);
        }
    }

    public int getRenderMode() {
        return this.renderMode;
    }

    public void setRenderMode(int mode) {
        if (mode == 5 && this.currentTool != null) {
            for (ViewerCanvas view : this.currentTool.getWindow().getAllViews()) {
                if (view == this || view.getRenderMode() != 5) continue;
                new BStandardDialog("", Translate.text("renderedModeMultipleViews"), BStandardDialog.ERROR).showMessageDialog(UIUtilities.findWindow(this));
                return;
            }
        }
        this.renderMode = mode;
        this.renderedImage = null;
        this.viewChanged(false);
        this.repaint();
    }

    void moveToGrid(WidgetMouseEvent e) {
        Point pos = e.getPoint();
        if (!this.snapToGrid || this.isPerspective()) {
            return;
        }
        Vec3 v = this.theCamera.convertScreenToWorld(pos, this.theCamera.getDistToScreen());
        Vec2 v2 = this.theCamera.getWorldToScreen().timesXY(v);
        e.translatePoint((int)v2.x - pos.x, (int)v2.y - pos.y);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int which) {
        this.orientation = which;
        if (which > 5 && which != Integer.MAX_VALUE) {
            return;
        }
        CoordinateSystem coords = this.theCamera.getCameraCoordinates();
        double dist = this.theCamera.getDistToScreen();
        Vec3 center = coords.getOrigin().plus(coords.getZDirection().times(dist));
        if (which == 0) {
            center.z += dist;
            coords = new CoordinateSystem(center, new Vec3(0.0, 0.0, -1.0), Vec3.vy());
        } else if (which == 1) {
            center.z -= dist;
            coords = new CoordinateSystem(center, Vec3.vz(), Vec3.vy());
        } else if (which == 2) {
            center.x -= dist;
            coords = new CoordinateSystem(center, Vec3.vx(), Vec3.vy());
        } else if (which == 3) {
            center.x += dist;
            coords = new CoordinateSystem(center, new Vec3(-1.0, 0.0, 0.0), Vec3.vy());
        } else if (which == 4) {
            center.y += dist;
            coords = new CoordinateSystem(center, new Vec3(0.0, -1.0, 0.0), new Vec3(0.0, 0.0, -1.0));
        } else if (which == 5) {
            center.y -= dist;
            coords = new CoordinateSystem(center, Vec3.vy(), Vec3.vz());
        }
        this.theCamera.setCameraCoordinates(coords);
        this.viewChanged(false);
        this.repaint();
    }

    public void copyOrientationFromCamera() {
        if (this.boundCamera == null) {
            return;
        }
        CoordinateSystem coords = this.theCamera.getCameraCoordinates();
        coords.copyCoords(this.boundCamera.getCoords());
        this.theCamera.setCameraCoordinates(coords);
    }

    public void drawDraggedShape(Shape shape) {
        this.drawer.drawDraggedShape(shape);
    }

    public void drawBorder() {
        this.drawer.drawBorder();
    }

    public void drawHRule(int y, Color color) {
        this.drawer.drawHRule(y, color);
    }

    public void drawVRule(int x, Color color) {
        this.drawer.drawVRule(x, color);
    }

    public void drawBox(int x, int y, int width, int height, Color color) {
        this.drawer.drawBox(x, y, width, height, color);
    }

    public void drawBoxes(List<Rectangle> box, Color color) {
        if (box.size() > 0) {
            this.drawer.drawBoxes(box, color);
        }
    }

    public void renderBox(int x, int y, int width, int height, double depth, Color color) {
        this.drawer.renderBox(x, y, width, height, depth, color);
    }

    public void renderBoxes(List<Rectangle> box, List<Double> depth, Color color) {
        if (box.size() > 0) {
            this.drawer.renderBoxes(box, depth, color);
        }
    }

    public void drawLine(Point p1, Point p2, Color color) {
        this.drawer.drawLine(p1, p2, color);
    }

    public void renderLine(Vec3 p1, Vec3 p2, Camera cam, Color color) {
        this.drawer.renderLine(p1, p2, cam, color);
    }

    public void renderLine(Vec2 p1, double zf1, Vec2 p2, double zf2, Camera cam, Color color) {
        this.drawer.renderLine(p1, zf1, p2, zf2, cam, color);
    }

    public void renderWireframe(WireframeMesh mesh, Camera cam, Color color) {
        this.drawer.renderWireframe(mesh, cam, color);
    }

    public void renderMeshTransparent(RenderingMesh mesh, VertexShader shader, Camera cam, Vec3 viewDir, boolean[] hideFace) {
        this.drawer.renderMeshTransparent(mesh, shader, cam, viewDir, hideFace);
    }

    public void renderMesh(RenderingMesh mesh, VertexShader shader, Camera cam, boolean closed, boolean[] hideFace) {
        this.drawer.renderMesh(mesh, shader, cam, closed, hideFace);
    }

    public void drawString(String text, int x, int y, Color color) {
        this.drawer.drawString(text, x, y, color);
    }

    public void drawImage(Image image, int x, int y) {
        this.drawer.drawImage(image, x, y);
    }

    public void renderImage(Image image, Vec3 p1, Vec3 p2, Vec3 p3, Vec3 p4) {
        this.drawer.renderImage(image, p1, p2, p3, p4, this.theCamera);
    }

    public void drawShape(Shape shape, Color color) {
        this.drawer.drawShape(shape, color);
    }

    public void fillShape(Shape shape, Color color) {
        this.drawer.fillShape(shape, color);
    }

    public static boolean isOpenGLAvailable() {
        return openGLAvailable;
    }

    public static List getViewerControls() {
        return Collections.unmodifiableList(controls);
    }

    public static void addViewerControl(ViewerControl control) {
        controls.add(control);
    }

    public static void addViewerControl(int index, ViewerControl control) {
        controls.add(index, control);
    }

    public static void removeViewerControl(ViewerControl control) {
        controls.remove(control);
    }

    public Map getViewerControlWidgets() {
        return Collections.unmodifiableMap(this.controlMap);
    }

    static {
        controls = new ArrayList<ViewerControl>();
        try {
            Class.forName("javax.media.opengl.GLCanvas");
            openGLAvailable = true;
        }
        catch (Throwable t) {
            System.out.println("Error loading GLCanvas class: " + t);
            System.out.println("java.library.path: " + System.getProperty("java.library.path"));
        }
    }
}

