/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ArtOfIllusion;
import artofillusion.ListChangeListener;
import artofillusion.MaterialPreviewer;
import artofillusion.PluginRegistry;
import artofillusion.Scene;
import artofillusion.image.ImageMap;
import artofillusion.material.Material;
import artofillusion.texture.Texture;
import artofillusion.texture.UniformTexture;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import buoy.event.MouseClickedEvent;
import buoy.event.SelectionChangedEvent;
import buoy.event.ValueChangedEvent;
import buoy.event.WindowClosingEvent;
import buoy.widget.BButton;
import buoy.widget.BComboBox;
import buoy.widget.BDialog;
import buoy.widget.BFileChooser;
import buoy.widget.BLabel;
import buoy.widget.BOutline;
import buoy.widget.BRadioButton;
import buoy.widget.BScrollPane;
import buoy.widget.BSeparator;
import buoy.widget.BStandardDialog;
import buoy.widget.BTree;
import buoy.widget.BorderContainer;
import buoy.widget.ColumnContainer;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RadioButtonGroup;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TexturesAndMaterialsDialog
extends BDialog {
    Scene theScene;
    EditingWindow parentFrame;
    BTree libraryList;
    File libraryFile;
    Scene selectedScene;
    Texture selectedTexture;
    Material selectedMaterial;
    SceneTreeNode selectedSceneNode;
    int insertLocation;
    BButton duplicateButton;
    BButton deleteButton;
    BButton editButton;
    BButton loadLibButton;
    BButton saveLibButton;
    BButton deleteLibButton;
    BButton newFileButton;
    BButton includeFileButton;
    BButton closeButton;
    BComboBox typeChoice;
    BRadioButton showTexturesButton;
    BRadioButton showMaterialsButton;
    BRadioButton showBothButton;
    List<Texture> textureTypes = PluginRegistry.getPlugins(Texture.class);
    List<Material> materialTypes = PluginRegistry.getPlugins(Material.class);
    MaterialPreviewer matPre;
    BLabel matInfo;
    File mainFolder;
    private boolean showTextures;
    private boolean showMaterials;
    private final ArrayList<Object> rootNodes;
    private static DataFlavor TextureFlavor = new DataFlavor(Texture.class, "Texture");
    private static DataFlavor MaterialFlavor = new DataFlavor(Material.class, "Material");
    ListChangeListener listListener = new ListChangeListener(){

        public void itemAdded(int index, Object obj) {
            ((SceneTreeModel)TexturesAndMaterialsDialog.this.libraryList.getModel()).rebuildScenes(null);
        }

        public void itemChanged(int index, Object obj) {
            ((SceneTreeModel)TexturesAndMaterialsDialog.this.libraryList.getModel()).rebuildScenes(null);
        }

        public void itemRemoved(int index, Object obj) {
            ((SceneTreeModel)TexturesAndMaterialsDialog.this.libraryList.getModel()).rebuildScenes(null);
        }
    };

    public TexturesAndMaterialsDialog(EditingWindow frame, Scene aScene) {
        super(frame.getFrame(), Translate.text("texturesTitle"), false);
        Method mtd;
        this.parentFrame = frame;
        this.theScene = aScene;
        this.theScene.addMaterialListener(this.listListener);
        this.theScene.addTextureListener(this.listListener);
        this.mainFolder = new File(ArtOfIllusion.APP_DIRECTORY, "Textures and Materials");
        BorderContainer content = new BorderContainer();
        this.setContent(BOutline.createEmptyBorder(content, UIUtilities.getStandardDialogInsets()));
        this.libraryList = new BTree();
        this.libraryList.setMultipleSelectionEnabled(false);
        this.libraryList.addEventLink(SelectionChangedEvent.class, (Object)this, "doSelectionChanged");
        this.libraryList.addEventLink(MouseClickedEvent.class, (Object)this, "mouseClicked");
        this.libraryList.getComponent().setDragEnabled(true);
        this.libraryList.getComponent().setDropMode(DropMode.ON);
        this.libraryList.getComponent().setTransferHandler(new DragHandler());
        this.libraryList.setRootNodeShown(false);
        BScrollPane listWrapper = new BScrollPane(this.libraryList, BScrollPane.SCROLLBAR_AS_NEEDED, BScrollPane.SCROLLBAR_AS_NEEDED);
        listWrapper.setBackground(this.libraryList.getBackground());
        listWrapper.setForceWidth(true);
        listWrapper.setPreferredViewSize(new Dimension(250, 250));
        FormContainer leftPanel = new FormContainer(new double[]{1.0}, new double[]{1.0, 0.0, 0.0, 0.0});
        leftPanel.setDefaultLayout(new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE));
        leftPanel.add(listWrapper, 0, 0, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH));
        RadioButtonGroup group = new RadioButtonGroup();
        this.showTexturesButton = new BRadioButton(Translate.text("showTextures"), false, group);
        leftPanel.add(this.showTexturesButton, 0, 1);
        this.showMaterialsButton = new BRadioButton(Translate.text("showMaterials"), false, group);
        leftPanel.add(this.showMaterialsButton, 0, 2);
        this.showBothButton = new BRadioButton(Translate.text("showBoth"), true, group);
        leftPanel.add(this.showBothButton, 0, 3);
        group.addEventLink(SelectionChangedEvent.class, (Object)this, "filterChanged");
        content.add(leftPanel, BorderContainer.WEST);
        BorderContainer matBox = new BorderContainer();
        Texture tx0 = this.theScene.getTexture(0);
        this.matPre = new MaterialPreviewer(tx0, null, 300, 300);
        matBox.add(this.matPre, BorderContainer.CENTER);
        ColumnContainer infoBox = new ColumnContainer();
        this.matInfo = new BLabel();
        BOutline matBorder = BOutline.createEmptyBorder(this.matInfo, 3);
        infoBox.add(matBorder);
        infoBox.setDefaultLayout(new LayoutInfo(LayoutInfo.WEST, LayoutInfo.BOTH));
        matBox.add(infoBox, BorderContainer.SOUTH);
        content.add(matBox, BorderContainer.CENTER);
        ColumnContainer buttons = new ColumnContainer();
        buttons.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.HORIZONTAL, null, null));
        content.add(buttons, BorderContainer.EAST);
        buttons.add(new BLabel(Translate.text("sceneFunctions"), BLabel.CENTER));
        this.typeChoice = new BComboBox();
        this.typeChoice.add(Translate.text("button.new") + "...");
        for (Texture tex : this.textureTypes) {
            try {
                mtd = tex.getClass().getMethod("getTypeName", null);
                this.typeChoice.add((String)mtd.invoke(null, null) + " texture");
            }
            catch (Exception ex) {}
        }
        for (Material mat : this.materialTypes) {
            try {
                mtd = mat.getClass().getMethod("getTypeName", null);
                this.typeChoice.add((String)mtd.invoke(null, null) + " material");
            }
            catch (Exception ex) {}
        }
        this.typeChoice.addEventLink(ValueChangedEvent.class, (Object)this, "doNew");
        buttons.add(this.typeChoice);
        this.duplicateButton = Translate.button("duplicate", "...", this, "doCopy");
        buttons.add(this.duplicateButton);
        this.deleteButton = Translate.button("delete", "...", this, "doDelete");
        buttons.add(this.deleteButton);
        this.editButton = Translate.button("edit", "...", this, "doEdit");
        buttons.add(this.editButton);
        buttons.add(new BSeparator());
        buttons.add(new BLabel(Translate.text("libraryFunctions"), BLabel.CENTER));
        this.loadLibButton = Translate.button("loadFromLibrary", this, "doLoadFromLibrary");
        buttons.add(this.loadLibButton);
        this.saveLibButton = Translate.button("saveToLibrary", this, "doSaveToLibrary");
        buttons.add(this.saveLibButton);
        this.deleteLibButton = Translate.button("deleteFromLibrary", this, "doDeleteFromLibrary");
        buttons.add(this.deleteLibButton);
        this.newFileButton = Translate.button("newLibraryFile", this, "doNewLib");
        buttons.add(this.newFileButton);
        this.includeFileButton = Translate.button("showExternalFile", this, "doIncludeLib");
        buttons.add(this.includeFileButton);
        buttons.add(new BSeparator());
        this.closeButton = Translate.button("close", this, "dispose");
        buttons.add(this.closeButton);
        this.hilightButtons();
        this.addEventLink(WindowClosingEvent.class, (Object)this, "dispose");
        this.rootNodes = new ArrayList();
        this.showTextures = true;
        this.showMaterials = true;
        this.rootNodes.add(new SceneTreeNode(null, this.theScene));
        for (File file : this.mainFolder.listFiles()) {
            if (file.isDirectory()) {
                this.rootNodes.add(new FolderTreeNode(file));
                continue;
            }
            if (!file.getName().endsWith(".aoi")) continue;
            this.rootNodes.add(new SceneTreeNode(file));
        }
        this.libraryList.setModel(new SceneTreeModel());
        this.setSelection(this.libraryList.getRootNode(), this.theScene, this.theScene.getDefaultTexture());
        this.pack();
        UIUtilities.centerDialog(this, this.parentFrame.getFrame());
        this.setVisible(true);
    }

    private String getTypeName(Object item) {
        String typeName = "";
        try {
            Method mtd = item.getClass().getMethod("getTypeName", null);
            typeName = (String)mtd.invoke(null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return typeName;
    }

    public void doSelectionChanged() {
        TreePath selection = this.libraryList.getSelectedNode();
        Texture oldTexture = this.selectedTexture;
        Material oldMaterial = this.selectedMaterial;
        this.selectedTexture = null;
        this.selectedMaterial = null;
        this.insertLocation = -1;
        if (selection != null && this.libraryList.isLeafNode(selection)) {
            TreePath parentNode = this.libraryList.getParentNode(selection);
            SceneTreeNode sceneNode = (SceneTreeNode)parentNode.getLastPathComponent();
            try {
                this.selectedSceneNode = sceneNode;
                this.selectedScene = sceneNode.getScene();
                this.libraryFile = sceneNode.file;
                Object node = selection.getLastPathComponent();
                if (node instanceof TextureTreeNode) {
                    this.selectedTexture = this.selectedScene.getTexture(((TextureTreeNode)node).index);
                    if (this.selectedTexture != oldTexture) {
                        this.matPre.setTexture(this.selectedTexture, this.selectedTexture.getDefaultMapping(this.matPre.getObject().getObject()));
                        this.matPre.setMaterial(null, null);
                        this.matPre.render();
                        this.setInfoText(Translate.text("textureName") + " " + this.selectedTexture.getName(), Translate.text("textureType") + " " + this.getTypeName(this.selectedTexture));
                    }
                } else {
                    this.selectedMaterial = this.selectedScene.getMaterial(((MaterialTreeNode)node).index);
                    if (this.selectedMaterial != oldMaterial) {
                        UniformTexture tex = UniformTexture.invisibleTexture();
                        this.matPre.setTexture(tex, ((Texture)tex).getDefaultMapping(this.matPre.getObject().getObject()));
                        this.matPre.setMaterial(this.selectedMaterial, this.selectedMaterial.getDefaultMapping(this.matPre.getObject().getObject()));
                        this.matPre.render();
                        this.setInfoText(Translate.text("materialName") + " " + this.selectedMaterial.getName(), Translate.text("materialType") + " " + this.getTypeName(this.selectedMaterial));
                    }
                }
            }
            catch (IOException ex) {
                new BStandardDialog("", Translate.text("errorLoadingFile") + ": " + ex.getLocalizedMessage(), BStandardDialog.ERROR).showMessageDialog(this);
            }
        }
        if (this.selectedTexture == null && this.selectedMaterial == null) {
            UniformTexture tex = UniformTexture.invisibleTexture();
            this.matPre.setTexture(tex, ((Texture)tex).getDefaultMapping(this.matPre.getObject().getObject()));
            this.matPre.setMaterial(null, null);
            this.matPre.render();
            this.setInfoText(Translate.text("noSelection"), "&nbsp;");
        }
        this.hilightButtons();
    }

    private boolean setSelection(TreePath node, Scene scene, Object object) {
        Object value = node.getLastPathComponent();
        if (value instanceof FolderTreeNode && !this.libraryList.isNodeExpanded(node)) {
            return false;
        }
        TreeModel model = this.libraryList.getModel();
        int numChildren = model.getChildCount(value);
        if (value instanceof SceneTreeNode) {
            SceneTreeNode stn = (SceneTreeNode)value;
            if (stn.scene == null || stn.scene.get() != scene) {
                return false;
            }
            for (int i = 0; i < numChildren; ++i) {
                Object child = model.getChild(value, i);
                if ((!(child instanceof TextureTreeNode) || scene.getTexture(((TextureTreeNode)child).index) != object) && (!(child instanceof MaterialTreeNode) || scene.getMaterial(((MaterialTreeNode)child).index) != object)) continue;
                this.libraryList.setNodeSelected(node.pathByAddingChild(child), true);
                this.doSelectionChanged();
                return true;
            }
            return false;
        }
        for (int i = 0; i < numChildren; ++i) {
            if (!this.setSelection(node.pathByAddingChild(model.getChild(value, i)), scene, object)) continue;
            return true;
        }
        return false;
    }

    public void hilightButtons() {
        if (this.selectedTexture == null && this.selectedMaterial == null) {
            this.duplicateButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.editButton.setEnabled(false);
            this.loadLibButton.setEnabled(false);
            this.saveLibButton.setEnabled(false);
            this.deleteLibButton.setEnabled(false);
        } else {
            this.hiLight(this.selectedScene == this.theScene);
        }
    }

    private void hiLight(boolean h) {
        this.duplicateButton.setEnabled(h);
        this.deleteButton.setEnabled(h);
        this.editButton.setEnabled(h);
        this.loadLibButton.setEnabled(!h);
        this.saveLibButton.setEnabled(h);
        this.deleteLibButton.setEnabled(!h);
    }

    public void mouseClicked(MouseClickedEvent ev) {
        if (ev.getClickCount() == 2) {
            this.doEdit();
        } else if (ev.getClickCount() == 1) {
            this.doSelectionChanged();
        }
    }

    private void filterChanged(SelectionChangedEvent ev) {
        if (ev.getWidget() == this.showTexturesButton) {
            this.showTextures = true;
            this.showMaterials = false;
        } else if (ev.getWidget() == this.showMaterialsButton) {
            this.showTextures = false;
            this.showMaterials = true;
        } else {
            this.showTextures = true;
            this.showMaterials = true;
        }
        ((SceneTreeModel)this.libraryList.getModel()).resetFilter();
    }

    public void doNew() {
        int newType = this.typeChoice.getSelectedIndex() - 1;
        if (newType >= 0) {
            if (newType >= this.textureTypes.size()) {
                int j = 0;
                String name = "";
                while (this.theScene.getMaterial(name = "Untitled " + ++j) != null) {
                }
                try {
                    Material mat = (Material)this.materialTypes.get(newType - this.textureTypes.size()).getClass().newInstance();
                    mat.setName(name);
                    this.theScene.addMaterial(mat);
                    mat.edit(this.parentFrame.getFrame(), this.theScene);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this.parentFrame.setModified();
                this.selectLastCurrentMaterial();
            } else {
                int j = 0;
                String name = "";
                while (this.theScene.getTexture(name = "Untitled " + ++j) != null) {
                }
                try {
                    Texture tex = (Texture)this.textureTypes.get(newType).getClass().newInstance();
                    tex.setName(name);
                    this.theScene.addTexture(tex);
                    tex.edit(this.parentFrame.getFrame(), this.theScene);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this.parentFrame.setModified();
                this.selectLastCurrentTexture();
            }
            this.typeChoice.setSelectedIndex(0);
        }
    }

    public void doCopy() {
        if (this.selectedTexture != null) {
            String name = new BStandardDialog("", Translate.text("newTexName"), BStandardDialog.PLAIN).showInputDialog(this, null, "");
            if (name == null) {
                return;
            }
            Texture tex = this.selectedTexture.duplicate();
            tex.setName(name);
            this.theScene.addTexture(tex);
            this.parentFrame.setModified();
            this.selectLastCurrentTexture();
        } else if (this.selectedMaterial != null) {
            String name = new BStandardDialog("", Translate.text("newMatName"), BStandardDialog.PLAIN).showInputDialog(this, null, "");
            if (name == null) {
                return;
            }
            Material mat = this.selectedMaterial.duplicate();
            mat.setName(name);
            this.theScene.addMaterial(mat);
            this.parentFrame.setModified();
            this.selectLastCurrentMaterial();
        }
    }

    public void doDelete() {
        if (this.selectedTexture != null) {
            String[] options = new String[]{Translate.text("button.ok"), Translate.text("button.cancel")};
            int choice = new BStandardDialog("", Translate.text("deleteTexture", this.selectedTexture.getName()), BStandardDialog.PLAIN).showOptionDialog(this, options, options[1]);
            if (choice == 0) {
                this.theScene.removeTexture(this.theScene.indexOf(this.selectedTexture));
                this.parentFrame.setModified();
                this.setSelection(this.libraryList.getRootNode(), this.theScene, this.theScene.getDefaultTexture());
            }
        } else if (this.selectedMaterial != null) {
            String[] options = new String[]{Translate.text("button.ok"), Translate.text("button.cancel")};
            int choice = new BStandardDialog("", Translate.text("deleteMaterial", this.selectedMaterial.getName()), BStandardDialog.PLAIN).showOptionDialog(this, options, options[1]);
            if (choice == 0) {
                this.theScene.removeMaterial(this.theScene.indexOf(this.selectedMaterial));
                this.parentFrame.setModified();
                this.setSelection(this.libraryList.getRootNode(), this.theScene, this.theScene.getDefaultTexture());
            }
        }
    }

    public void doEdit() {
        if (this.selectedScene != this.theScene) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (this.selectedTexture != null) {
            Texture tex = this.selectedTexture;
            tex.edit(this.parentFrame.getFrame(), this.theScene);
            tex.assignNewID();
            this.theScene.changeTexture(this.theScene.indexOf(tex));
            this.parentFrame.setModified();
        } else if (this.selectedMaterial != null) {
            Material mat = this.selectedMaterial;
            mat.edit(this.parentFrame.getFrame(), this.theScene);
            mat.assignNewID();
            this.theScene.changeMaterial(this.theScene.indexOf(mat));
            this.parentFrame.setModified();
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void doLoadFromLibrary() {
        if (this.selectedTexture != null) {
            Texture newTexture = this.selectedTexture.duplicate();
            this.theScene.addTexture(newTexture, this.insertLocation == -1 ? this.theScene.getNumTextures() : this.insertLocation);
            this.parentFrame.setModified();
            for (int i = 0; i < this.selectedScene.getNumImages(); ++i) {
                ImageMap image = this.selectedScene.getImage(i);
                if (!this.selectedTexture.usesImage(image)) continue;
                this.theScene.addImage(image);
            }
            this.parentFrame.updateImage();
            this.setSelection(this.libraryList.getRootNode(), this.theScene, newTexture);
        } else if (this.selectedMaterial != null) {
            Material newMaterial = this.selectedMaterial.duplicate();
            this.theScene.addMaterial(newMaterial, this.insertLocation == -1 ? this.theScene.getNumMaterials() : this.insertLocation);
            this.parentFrame.setModified();
            for (int i = 0; i < this.selectedScene.getNumImages(); ++i) {
                ImageMap image = this.selectedScene.getImage(i);
                if (!this.selectedMaterial.usesImage(image)) continue;
                this.theScene.addImage(image);
            }
            this.parentFrame.updateImage();
            this.setSelection(this.libraryList.getRootNode(), this.theScene, newMaterial);
        }
        this.hilightButtons();
    }

    public void doSaveToLibrary() {
        BFileChooser fcOut;
        String itemText = this.selectedTexture != null ? "selectSceneToSaveTexture" : "selectSceneToSaveMaterial";
        if ((this.selectedTexture != null || this.selectedMaterial != null) && (fcOut = new BFileChooser(BFileChooser.OPEN_FILE, Translate.text(itemText), this.mainFolder)).showDialog(this)) {
            this.saveToFile(fcOut.getSelectedFile());
        }
    }

    private void saveToFile(File saveFile) {
        if (saveFile.exists()) {
            try {
                Scene saveScene = new Scene(saveFile, true);
                if (this.selectedTexture != null) {
                    Texture newTexture = this.selectedTexture.duplicate();
                    saveScene.addTexture(newTexture, this.insertLocation == -1 ? saveScene.getNumTextures() : this.insertLocation);
                    for (int i = 0; i < this.selectedScene.getNumImages(); ++i) {
                        ImageMap image = this.selectedScene.getImage(i);
                        if (!this.selectedTexture.usesImage(image)) continue;
                        saveScene.addImage(image);
                    }
                    saveScene.writeToFile(saveFile);
                } else if (this.selectedMaterial != null) {
                    Material newMaterial = this.selectedMaterial.duplicate();
                    saveScene.addMaterial(newMaterial, this.insertLocation == -1 ? saveScene.getNumMaterials() : this.insertLocation);
                    for (int i = 0; i < this.selectedScene.getNumImages(); ++i) {
                        ImageMap image = this.selectedScene.getImage(i);
                        if (!this.selectedMaterial.usesImage(image)) continue;
                        saveScene.addImage(image);
                    }
                    saveScene.writeToFile(saveFile);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        ((SceneTreeModel)this.libraryList.getModel()).rebuildScenes(saveFile);
    }

    public void doDeleteFromLibrary() {
        if (this.selectedScene == null || this.selectedScene == this.theScene) {
            return;
        }
        try {
            if (this.selectedTexture != null) {
                String[] options = new String[]{Translate.text("button.ok"), Translate.text("button.cancel")};
                int choice = new BStandardDialog("", Translate.text("deleteTexture", this.selectedTexture.getName()), BStandardDialog.PLAIN).showOptionDialog(this, options, options[1]);
                if (choice == 0) {
                    int texIndex = this.selectedScene.indexOf(this.selectedTexture);
                    this.selectedScene.removeTexture(texIndex);
                    this.selectedScene.writeToFile(this.libraryFile);
                    ((SceneTreeModel)this.libraryList.getModel()).rebuildScenes(this.libraryFile);
                    this.setSelection(this.libraryList.getRootNode(), this.theScene, this.theScene.getDefaultTexture());
                }
            } else if (this.selectedMaterial != null) {
                String[] options = new String[]{Translate.text("button.ok"), Translate.text("button.cancel")};
                int choice = new BStandardDialog("", Translate.text("deleteMaterial", this.selectedMaterial.getName()), BStandardDialog.PLAIN).showOptionDialog(this, options, options[1]);
                if (choice == 0) {
                    int matIndex = this.selectedScene.indexOf(this.selectedMaterial);
                    this.selectedScene.removeMaterial(matIndex);
                    this.selectedScene.writeToFile(this.libraryFile);
                    ((SceneTreeModel)this.libraryList.getModel()).rebuildScenes(this.libraryFile);
                    this.setSelection(this.libraryList.getRootNode(), this.theScene, this.theScene.getDefaultTexture());
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void doNewLib() {
        BFileChooser fcNew = new BFileChooser(BFileChooser.SAVE_FILE, Translate.text("selectNewLibraryName"), this.mainFolder);
        if (fcNew.showDialog(this)) {
            File saveFile = fcNew.getSelectedFile();
            if (!saveFile.exists()) {
                try {
                    new Scene().writeToFile(saveFile);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                ((SceneTreeModel)this.libraryList.getModel()).rebuildLibrary();
            } else {
                BStandardDialog d = new BStandardDialog("", Translate.text("fileAlreadyExists"), BStandardDialog.ERROR);
                d.showMessageDialog(this);
            }
        }
    }

    public void doIncludeLib() {
        File inputFile;
        BFileChooser fcInc = new BFileChooser(BFileChooser.OPEN_FILE, Translate.text("selectExternalFile"));
        if (fcInc.showDialog(this) && (inputFile = fcInc.getSelectedFile()).exists()) {
            ((SceneTreeModel)this.libraryList.getModel()).addScene(inputFile);
        }
    }

    public void dispose() {
        this.theScene.removeMaterialListener(this.listListener);
        this.theScene.removeTextureListener(this.listListener);
        super.dispose();
    }

    private void setInfoText(String line1, String line2) {
        String s = "<html><p>" + line1 + "</p><p>" + line2 + "</p></html>";
        this.matInfo.setText(s);
    }

    private void selectLastCurrentTexture() {
        TreePath r = this.libraryList.getRootNode();
        TreePath current = this.libraryList.getChildNode(r, 0);
        this.libraryList.setNodeExpanded(current, true);
        int lastIndex = this.libraryList.getChildNodeCount(current) - this.theScene.getNumMaterials() - 1;
        this.libraryList.setNodeSelected(this.libraryList.getChildNode(current, lastIndex), true);
        this.doSelectionChanged();
    }

    private void selectLastCurrentMaterial() {
        TreePath r = this.libraryList.getRootNode();
        TreePath current = this.libraryList.getChildNode(r, 0);
        this.libraryList.setNodeExpanded(current, true);
        int lastIndex = this.libraryList.getChildNodeCount(current) - 1;
        this.libraryList.setNodeSelected(this.libraryList.getChildNode(current, lastIndex), true);
        this.doSelectionChanged();
    }

    private class DragTransferable
    implements Transferable {
        private Object data;
        private DataFlavor[] flavors;

        public DragTransferable(Object data) {
            this.data = data;
            this.flavors = new DataFlavor[]{DataFlavor.stringFlavor, data instanceof Texture ? TextureFlavor : MaterialFlavor};
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (dataFlavor == DataFlavor.stringFlavor) {
                return this.data.toString();
            }
            return this.data;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            for (DataFlavor flavor : this.flavors) {
                if (flavor != dataFlavor) continue;
                return true;
            }
            return false;
        }
    }

    private class DragHandler
    extends TransferHandler {
        private DragHandler() {
        }

        public int getSourceActions(JComponent jComponent) {
            return 1;
        }

        public boolean canImport(TransferHandler.TransferSupport transferSupport) {
            SceneTreeNode sceneNode = this.findDropLocation(transferSupport);
            if (sceneNode == null) {
                return false;
            }
            if (sceneNode == TexturesAndMaterialsDialog.this.selectedSceneNode) {
                int current = -1;
                try {
                    if (TexturesAndMaterialsDialog.this.selectedTexture != null) {
                        current = TexturesAndMaterialsDialog.this.selectedSceneNode.getScene().indexOf(TexturesAndMaterialsDialog.this.selectedTexture);
                    } else if (TexturesAndMaterialsDialog.this.selectedMaterial != null) {
                        current = TexturesAndMaterialsDialog.this.selectedSceneNode.getScene().indexOf(TexturesAndMaterialsDialog.this.selectedMaterial);
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    return false;
                }
                if (TexturesAndMaterialsDialog.this.insertLocation == -1 || TexturesAndMaterialsDialog.this.insertLocation == current) {
                    return false;
                }
            }
            transferSupport.setShowDropLocation(true);
            return true;
        }

        protected Transferable createTransferable(JComponent jComponent) {
            if (TexturesAndMaterialsDialog.this.selectedTexture != null) {
                return new DragTransferable(TexturesAndMaterialsDialog.this.selectedTexture);
            }
            if (TexturesAndMaterialsDialog.this.selectedMaterial != null) {
                return new DragTransferable(TexturesAndMaterialsDialog.this.selectedMaterial);
            }
            return null;
        }

        public boolean importData(TransferHandler.TransferSupport transferSupport) {
            SceneTreeNode sceneNode = this.findDropLocation(transferSupport);
            if (sceneNode == null) {
                return false;
            }
            try {
                Scene destScene = sceneNode.getScene();
                if (sceneNode == TexturesAndMaterialsDialog.this.selectedSceneNode) {
                    Scene saveScene;
                    Scene scene = saveScene = destScene == TexturesAndMaterialsDialog.this.theScene ? TexturesAndMaterialsDialog.this.theScene : new Scene(sceneNode.file, true);
                    if (TexturesAndMaterialsDialog.this.selectedTexture != null) {
                        saveScene.reorderTexture(destScene.indexOf(TexturesAndMaterialsDialog.this.selectedTexture), TexturesAndMaterialsDialog.this.insertLocation);
                    } else if (TexturesAndMaterialsDialog.this.selectedMaterial != null) {
                        saveScene.reorderMaterial(destScene.indexOf(TexturesAndMaterialsDialog.this.selectedMaterial), TexturesAndMaterialsDialog.this.insertLocation);
                    }
                    if (destScene != TexturesAndMaterialsDialog.this.theScene) {
                        saveScene.writeToFile(sceneNode.file);
                    }
                    ((SceneTreeModel)TexturesAndMaterialsDialog.this.libraryList.getModel()).rebuildScenes(null);
                } else if (destScene == TexturesAndMaterialsDialog.this.theScene) {
                    TexturesAndMaterialsDialog.this.doLoadFromLibrary();
                } else {
                    TexturesAndMaterialsDialog.this.saveToFile(sceneNode.file);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            return true;
        }

        private SceneTreeNode findDropLocation(TransferHandler.TransferSupport transferSupport) {
            TreePath location = TexturesAndMaterialsDialog.this.libraryList.findNode(transferSupport.getDropLocation().getDropPoint());
            if (location == null) {
                return null;
            }
            TexturesAndMaterialsDialog.this.insertLocation = -1;
            if (TexturesAndMaterialsDialog.this.selectedTexture != null && location.getLastPathComponent() instanceof TextureTreeNode) {
                TexturesAndMaterialsDialog.this.insertLocation = ((TextureTreeNode)location.getLastPathComponent()).index;
            }
            if (TexturesAndMaterialsDialog.this.selectedMaterial != null && location.getLastPathComponent() instanceof MaterialTreeNode) {
                TexturesAndMaterialsDialog.this.insertLocation = ((MaterialTreeNode)location.getLastPathComponent()).index;
            }
            for (Object node : location.getPath()) {
                if (!(node instanceof SceneTreeNode)) continue;
                return (SceneTreeNode)node;
            }
            return null;
        }
    }

    private class SceneTreeModel
    implements TreeModel {
        private ArrayList<TreeModelListener> listeners = new ArrayList();
        private DefaultMutableTreeNode root = new DefaultMutableTreeNode();

        private SceneTreeModel() {
        }

        public void addTreeModelListener(TreeModelListener listener) {
            this.listeners.add(listener);
        }

        public void removeTreeModelListener(TreeModelListener listener) {
            this.listeners.remove(listener);
        }

        public Object getRoot() {
            return this.root;
        }

        public Object getChild(Object o, int i) {
            if (o == this.root) {
                return TexturesAndMaterialsDialog.this.rootNodes.get(i);
            }
            if (o instanceof FolderTreeNode) {
                return ((FolderTreeNode)o).getChildren().get(i);
            }
            SceneTreeNode node = (SceneTreeNode)o;
            node.ensureChildrenValid();
            if (TexturesAndMaterialsDialog.this.showTextures) {
                if (i < node.textures.size()) {
                    return node.textures.get(i);
                }
                i -= node.textures.size();
            }
            return node.materials.get(i);
        }

        public int getChildCount(Object o) {
            if (o == this.root) {
                return TexturesAndMaterialsDialog.this.rootNodes.size();
            }
            if (o instanceof FolderTreeNode) {
                return ((FolderTreeNode)o).getChildren().size();
            }
            if (!(o instanceof SceneTreeNode)) {
                return 0;
            }
            SceneTreeNode node = (SceneTreeNode)o;
            node.ensureChildrenValid();
            int count = 0;
            if (TexturesAndMaterialsDialog.this.showTextures) {
                count += node.textures.size();
            }
            if (TexturesAndMaterialsDialog.this.showMaterials) {
                count += node.materials.size();
            }
            return count;
        }

        public boolean isLeaf(Object o) {
            return o != this.root && !(o instanceof FolderTreeNode) && !(o instanceof SceneTreeNode);
        }

        public void valueForPathChanged(TreePath treePath, Object o) {
        }

        public int getIndexOfChild(Object o, Object o1) {
            if (o == this.root) {
                return TexturesAndMaterialsDialog.this.rootNodes.indexOf(o1);
            }
            if (o instanceof FolderTreeNode) {
                return ((FolderTreeNode)o).getChildren().indexOf(o1);
            }
            SceneTreeNode node = (SceneTreeNode)o;
            node.ensureChildrenValid();
            int texIndex = node.textures.indexOf(o1);
            if (texIndex > -1) {
                return texIndex;
            }
            int matIndex = node.materials.indexOf(o1);
            if (matIndex > -1) {
                return matIndex + (TexturesAndMaterialsDialog.this.showTextures ? node.textures.size() : 0);
            }
            return -1;
        }

        void rebuildNode(Object node, File file) {
            if (node instanceof SceneTreeNode) {
                SceneTreeNode sct = (SceneTreeNode)node;
                if (file == null || file.equals(sct.file)) {
                    sct.textures = null;
                    sct.materials = null;
                    if (sct.file != null) {
                        sct.scene = null;
                    }
                }
                return;
            }
            if (node instanceof FolderTreeNode && ((FolderTreeNode)node).children == null) {
                return;
            }
            int numChildren = this.getChildCount(node);
            for (int i = 0; i < numChildren; ++i) {
                this.rebuildNode(this.getChild(node, i), file);
            }
        }

        void rebuildScenes(final File file) {
            this.updateTree(new Runnable(){

                public void run() {
                    SceneTreeModel.this.rebuildNode(SceneTreeModel.this.root, file);
                }
            });
        }

        void rebuildLibrary() {
            this.updateTree(new Runnable(){

                public void run() {
                    ((FolderTreeNode)((TexturesAndMaterialsDialog)TexturesAndMaterialsDialog.this).rootNodes.get((int)1)).children = null;
                }
            });
        }

        void resetFilter() {
            this.updateTree(null);
        }

        void addScene(final File file) {
            this.updateTree(new Runnable(){

                public void run() {
                    TexturesAndMaterialsDialog.this.rootNodes.add(new SceneTreeNode(file));
                }
            });
        }

        void updateTree(Runnable updater) {
            ArrayList<TreePath> expanded = Collections.list(TexturesAndMaterialsDialog.this.libraryList.getComponent().getExpandedDescendants(TexturesAndMaterialsDialog.this.libraryList.getRootNode()));
            if (updater != null) {
                updater.run();
            }
            Object selection = TexturesAndMaterialsDialog.this.selectedTexture == null ? TexturesAndMaterialsDialog.this.selectedMaterial : TexturesAndMaterialsDialog.this.selectedTexture;
            TreeModelEvent ev = new TreeModelEvent((Object)this, new TreePath(this.root));
            for (TreeModelListener listener : this.listeners) {
                listener.treeStructureChanged(ev);
            }
            for (TreePath path : expanded) {
                TexturesAndMaterialsDialog.this.libraryList.setNodeExpanded(path, true);
            }
            if (selection != null) {
                TexturesAndMaterialsDialog.this.setSelection(new TreePath(this.root), TexturesAndMaterialsDialog.this.selectedScene, selection);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FolderTreeNode {
        final File file;
        ArrayList<Object> children;

        FolderTreeNode(File file) {
            this.file = file;
        }

        ArrayList<Object> getChildren() {
            if (this.children == null) {
                this.children = new ArrayList();
                for (File f : this.file.listFiles()) {
                    if (f.isDirectory()) {
                        this.children.add(new FolderTreeNode(f));
                        continue;
                    }
                    if (!f.getName().endsWith(".aoi")) continue;
                    this.children.add(new SceneTreeNode(f));
                }
            }
            return this.children;
        }

        public String toString() {
            return this.file.getName();
        }
    }

    private class SceneTreeNode {
        ArrayList<TextureTreeNode> textures;
        ArrayList<MaterialTreeNode> materials;
        SoftReference<Scene> scene;
        final File file;

        SceneTreeNode(File file) {
            this.file = file;
        }

        SceneTreeNode(File file, Scene scene) {
            this.file = file;
            this.scene = new SoftReference<Scene>(scene);
        }

        void ensureChildrenValid() {
            if (this.textures == null) {
                try {
                    int i;
                    Scene theScene = this.getScene();
                    this.textures = new ArrayList();
                    for (i = 0; i < theScene.getNumTextures(); ++i) {
                        this.textures.add(new TextureTreeNode(this, i));
                    }
                    this.materials = new ArrayList();
                    for (i = 0; i < theScene.getNumMaterials(); ++i) {
                        this.materials.add(new MaterialTreeNode(this, i));
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }

        Scene getScene() throws IOException {
            Scene theScene;
            if (this.scene != null && (theScene = this.scene.get()) != null) {
                return theScene;
            }
            theScene = new Scene(this.file, true);
            this.scene = new SoftReference<Scene>(theScene);
            return theScene;
        }

        public String toString() {
            if (this.file == null) {
                return Translate.text("currentScene");
            }
            return this.file.getName().substring(0, this.file.getName().length() - 4);
        }
    }

    private class MaterialTreeNode {
        int index;
        String name;
        SceneTreeNode scene;

        MaterialTreeNode(SceneTreeNode scene, int index) throws IOException {
            this.scene = scene;
            this.index = index;
            this.name = scene.getScene().getMaterial(index).getName();
        }

        public String toString() {
            return this.name;
        }
    }

    private class TextureTreeNode {
        int index;
        String name;
        SceneTreeNode scene;

        TextureTreeNode(SceneTreeNode scene, int index) throws IOException {
            this.scene = scene;
            this.index = index;
            this.name = scene.getScene().getTexture(index).getName();
        }

        public String toString() {
            return this.name;
        }
    }
}

