/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ApplicationPreferences;
import artofillusion.ArtOfIllusion;
import artofillusion.PluginRegistry;
import artofillusion.Renderer;
import artofillusion.ViewerCanvas;
import artofillusion.keystroke.KeystrokePreferencesPanel;
import artofillusion.ui.PanelDialog;
import artofillusion.ui.ThemeManager;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueField;
import buoy.event.ValueChangedEvent;
import buoy.widget.BCheckBox;
import buoy.widget.BComboBox;
import buoy.widget.BFrame;
import buoy.widget.BStandardDialog;
import buoy.widget.BTabbedPane;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.Widget;
import buoy.widget.WindowWidget;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;

public class PreferencesWindow {
    private BComboBox defaultRendChoice;
    private BComboBox objectRendChoice;
    private BComboBox texRendChoice;
    private BComboBox localeChoice;
    private BComboBox themeChoice;
    private BComboBox colorChoice;
    private BComboBox toolChoice;
    private ValueField interactiveTolField;
    private ValueField undoField;
    private BCheckBox glBox;
    private BCheckBox backupBox;
    private BCheckBox reverseZoomBox;
    private List<ThemeManager.ThemeInfo> themes;
    private static int lastTab;

    public PreferencesWindow(BFrame parent) {
        BTabbedPane tabs = new BTabbedPane();
        tabs.add(this.createGeneralPanel(), Translate.text("general"));
        KeystrokePreferencesPanel keystrokePanel = new KeystrokePreferencesPanel();
        tabs.add(keystrokePanel, Translate.text("shortcuts"));
        tabs.setSelectedTab(lastTab);
        boolean done = false;
        while (!done) {
            PanelDialog dlg = new PanelDialog((WindowWidget)parent, Translate.text("prefsTitle"), tabs);
            lastTab = tabs.getSelectedTab();
            if (!dlg.clickedOk()) {
                return;
            }
            done = true;
            if (!(this.interactiveTolField.getValue() < 0.01)) continue;
            String[] options = new String[]{Translate.text("button.ok"), Translate.text("button.cancel")};
            int choice = new BStandardDialog("", Translate.text("lowSurfErrorWarning"), BStandardDialog.WARNING).showOptionDialog(parent, options, options[0]);
            if (choice != 1) continue;
            done = false;
        }
        ApplicationPreferences prefs = ArtOfIllusion.getPreferences();
        Locale[] languages = Translate.getAvailableLocales();
        List<Renderer> renderers = PluginRegistry.getPlugins(Renderer.class);
        if (renderers.size() > 0) {
            prefs.setDefaultRenderer(renderers.get(this.defaultRendChoice.getSelectedIndex()));
            prefs.setObjectPreviewRenderer(renderers.get(this.objectRendChoice.getSelectedIndex()));
            prefs.setTexturePreviewRenderer(renderers.get(this.texRendChoice.getSelectedIndex()));
        }
        prefs.setInteractiveSurfaceError(this.interactiveTolField.getValue());
        prefs.setUndoLevels((int)this.undoField.getValue());
        if (!prefs.getLocale().equals(languages[this.localeChoice.getSelectedIndex()])) {
            new BStandardDialog("", UIUtilities.breakString(Translate.text("languageChangedWarning")), BStandardDialog.INFORMATION).showMessageDialog(parent);
        }
        if (prefs.getUseOpenGL() != this.glBox.getState()) {
            new BStandardDialog("", UIUtilities.breakString(Translate.text("glChangedWarning")), BStandardDialog.INFORMATION).showMessageDialog(parent);
        }
        if (!ThemeManager.getSelectedTheme().getName().equals(this.themeChoice.getSelectedValue())) {
            new BStandardDialog("", UIUtilities.breakString(Translate.text("themeChangedWarning")), BStandardDialog.INFORMATION).showMessageDialog(parent);
        }
        prefs.setLocale(languages[this.localeChoice.getSelectedIndex()]);
        prefs.setUseOpenGL(this.glBox.getState());
        prefs.setKeepBackupFiles(this.backupBox.getState());
        prefs.setReverseZooming(this.reverseZoomBox.getState());
        prefs.setUseCompoundMeshTool(this.toolChoice.getSelectedIndex() == 1);
        ThemeManager.setSelectedTheme(this.themes.get(this.themeChoice.getSelectedIndex()));
        ThemeManager.setSelectedColorSet(ThemeManager.getSelectedTheme().getColorSets()[this.colorChoice.getSelectedIndex()]);
        prefs.savePreferences();
        keystrokePanel.saveChanges();
    }

    private BComboBox getRendererChoice(Renderer selected) {
        List<Renderer> renderers = PluginRegistry.getPlugins(Renderer.class);
        BComboBox c = new BComboBox();
        for (Renderer r : renderers) {
            c.add(r.getName());
        }
        if (selected != null) {
            c.setSelectedValue(selected.getName());
        }
        return c;
    }

    private Widget createGeneralPanel() {
        ApplicationPreferences prefs = ArtOfIllusion.getPreferences();
        this.defaultRendChoice = this.getRendererChoice(prefs.getDefaultRenderer());
        this.objectRendChoice = this.getRendererChoice(prefs.getObjectPreviewRenderer());
        this.texRendChoice = this.getRendererChoice(prefs.getTexturePreviewRenderer());
        this.interactiveTolField = new ValueField(prefs.getInteractiveSurfaceError(), 3);
        this.undoField = new ValueField(prefs.getUndoLevels(), 7);
        this.glBox = new BCheckBox(Translate.text("useOpenGL"), prefs.getUseOpenGL());
        this.glBox.setEnabled(ViewerCanvas.isOpenGLAvailable());
        this.backupBox = new BCheckBox(Translate.text("keepBackupFiles"), prefs.getKeepBackupFiles());
        this.reverseZoomBox = new BCheckBox(Translate.text("reverseScrollWheelZooming"), prefs.getReverseZooming());
        List allThemes = ThemeManager.getThemes();
        this.themes = new ArrayList<ThemeManager.ThemeInfo>();
        for (int i = 0; i < allThemes.size(); ++i) {
            ThemeManager.ThemeInfo theme = (ThemeManager.ThemeInfo)allThemes.get(i);
            if (!theme.selectable) continue;
            this.themes.add(theme);
        }
        Collections.sort(this.themes, new Comparator<ThemeManager.ThemeInfo>(){

            @Override
            public int compare(ThemeManager.ThemeInfo o1, ThemeManager.ThemeInfo o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        Object[] themeNames = new String[this.themes.size()];
        for (int i = 0; i < themeNames.length; ++i) {
            themeNames[i] = this.themes.get(i).getName();
        }
        this.themeChoice = new BComboBox(themeNames);
        ThemeManager.ThemeInfo selectedTheme = ThemeManager.getSelectedTheme();
        this.themeChoice.setSelectedValue(selectedTheme.getName());
        this.colorChoice = new BComboBox();
        this.buildColorSetMenu(selectedTheme);
        this.themeChoice.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                PreferencesWindow.this.buildColorSetMenu((ThemeManager.ThemeInfo)PreferencesWindow.this.themes.get(PreferencesWindow.this.themeChoice.getSelectedIndex()));
            }
        });
        ThemeManager.ColorSet[] colorSets = selectedTheme.getColorSets();
        for (int i = 0; i < colorSets.length; ++i) {
            if (colorSets[i] != ThemeManager.getSelectedColorSet()) continue;
            this.colorChoice.setSelectedIndex(i);
        }
        this.toolChoice = new BComboBox(new String[]{Translate.text("Move"), Translate.text("compoundMoveScaleRotate")});
        this.toolChoice.setSelectedIndex(prefs.getUseCompoundMeshTool() ? 1 : 0);
        this.localeChoice = new BComboBox();
        Locale[] languages = Translate.getAvailableLocales();
        for (int i = 0; i < languages.length; ++i) {
            this.localeChoice.add(languages[i].getDisplayName(prefs.getLocale()));
            if (!prefs.getLocale().equals(languages[i])) continue;
            this.localeChoice.setSelectedIndex(i);
        }
        FormContainer panel = new FormContainer(2, 12);
        panel.setColumnWeight(1, 1.0);
        LayoutInfo labelLayout = new LayoutInfo(LayoutInfo.EAST, LayoutInfo.NONE, new Insets(2, 0, 2, 5), null);
        LayoutInfo widgetLayout = new LayoutInfo(LayoutInfo.WEST, LayoutInfo.BOTH, new Insets(2, 0, 2, 0), null);
        LayoutInfo centerLayout = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(2, 0, 2, 0), null);
        panel.add(Translate.label("defaultRenderer"), 0, 0, labelLayout);
        panel.add(Translate.label("objPreviewRenderer"), 0, 1, labelLayout);
        panel.add(Translate.label("texPreviewRenderer"), 0, 2, labelLayout);
        panel.add(Translate.label("selectedTheme"), 0, 3, labelLayout);
        panel.add(Translate.label("themeColorSet"), 0, 4, labelLayout);
        panel.add(Translate.label("defaultMeshEditingTool"), 0, 5, labelLayout);
        panel.add(Translate.label("interactiveSurfError"), 0, 6, labelLayout);
        panel.add(Translate.label("maxUndoLevels"), 0, 7, labelLayout);
        panel.add(Translate.label("language"), 0, 11, labelLayout);
        panel.add(this.defaultRendChoice, 1, 0, widgetLayout);
        panel.add(this.objectRendChoice, 1, 1, widgetLayout);
        panel.add(this.texRendChoice, 1, 2, widgetLayout);
        panel.add(this.themeChoice, 1, 3, widgetLayout);
        panel.add(this.colorChoice, 1, 4, widgetLayout);
        panel.add(this.toolChoice, 1, 5, widgetLayout);
        panel.add(this.interactiveTolField, 1, 6, widgetLayout);
        panel.add(this.undoField, 1, 7, widgetLayout);
        panel.add(this.reverseZoomBox, 0, 8, 2, 1, centerLayout);
        panel.add(this.glBox, 0, 9, 2, 1, centerLayout);
        panel.add(this.backupBox, 0, 10, 2, 1, centerLayout);
        panel.add(this.localeChoice, 1, 11, widgetLayout);
        return panel;
    }

    private void buildColorSetMenu(ThemeManager.ThemeInfo theme) {
        ThemeManager.ColorSet[] colorSets = theme.getColorSets();
        Object[] names = new String[colorSets.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = colorSets[i].getName();
        }
        this.colorChoice.setContents(names);
    }
}

