/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.MeshEditorWindow;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.math.BoundingBox;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.ui.Compound3DManipulator;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.MeshEditController;
import artofillusion.ui.MeshEditingTool;
import artofillusion.ui.Translate;
import buoy.event.KeyPressedEvent;
import buoy.event.ToolTipEvent;
import buoy.event.WidgetMouseEvent;
import buoy.widget.BToolTip;

public class MoveScaleRotateMeshTool
extends MeshEditingTool {
    private boolean dragInProgress;
    private Vec3[] baseVertPos;
    private UndoRecord undo;
    private final Compound3DManipulator manipulator;
    private boolean tooltipsEnabled;
    private boolean tooltipsAdded;
    private static BToolTip ROTATE_TIP = new BToolTip(Translate.text("moveScaleRotateMeshTool.rotateTipText"));
    private static BToolTip MOVE_TIP = new BToolTip(Translate.text("moveScaleRotateMeshTool.moveTipText"));
    private static BToolTip SCALE_TIP = new BToolTip(Translate.text("moveScaleRotateMeshTool.scaleTipText"));

    public MoveScaleRotateMeshTool(EditingWindow fr, MeshEditController controller) {
        super(fr, controller);
        this.initButton("moveScaleRotate");
        this.manipulator = new Compound3DManipulator();
        this.manipulator.addEventLink(Compound3DManipulator.HandlePressedEvent.class, (Object)this, "handlePressed");
        this.manipulator.addEventLink(Compound3DManipulator.HandleDraggedEvent.class, (Object)this, "handleDragged");
        this.manipulator.addEventLink(Compound3DManipulator.HandleReleasedEvent.class, (Object)this, "handleReleased");
    }

    public int whichClicks() {
        return 5;
    }

    public boolean allowSelectionChanges() {
        return !this.dragInProgress;
    }

    public String getToolTipText() {
        return Translate.text("moveScaleRotateMeshTool.tipText");
    }

    public void drawOverlay(ViewerCanvas view) {
        BoundingBox selectionBounds = this.findSelectionBounds(view.getCamera());
        if (!this.dragInProgress && this.manipulator.getViewMode() == Compound3DManipulator.NPQ_MODE && selectionBounds != null) {
            Vec3 updir;
            Vec3 avgNorm = new Vec3();
            int[] selection = this.controller.getSelectionDistance();
            Mesh mesh = (Mesh)((Object)this.controller.getObject().getObject());
            Vec3[] normal = mesh.getNormals();
            for (int i = 0; i < selection.length; ++i) {
                if (selection[i] != 0) continue;
                avgNorm.add(normal[i]);
            }
            avgNorm.normalize();
            if (avgNorm.length2() == 0.0) {
                avgNorm = Vec3.vx();
            }
            updir = Math.abs((updir = Vec3.vx()).dot(avgNorm)) < 0.9 ? avgNorm.cross(updir) : avgNorm.cross(Vec3.vy());
            updir.normalize();
            this.manipulator.setNPQAxes(avgNorm, updir, avgNorm.cross(updir));
        }
        this.manipulator.draw(view, selectionBounds);
        if (!this.dragInProgress) {
            if (selectionBounds != null) {
                this.theWindow.setHelpText(Translate.text("moveScaleRotateMeshTool.helpText"));
            } else {
                this.theWindow.setHelpText(Translate.text("moveScaleRotateMeshTool.errorText"));
            }
        }
    }

    public void mousePressed(WidgetMouseEvent e, ViewerCanvas view) {
        BoundingBox selectionBounds = this.findSelectionBounds(view.getCamera());
        this.dragInProgress = false;
        if (selectionBounds != null) {
            this.dragInProgress = this.manipulator.mousePressed(e, view, selectionBounds);
        }
    }

    public void mousePressedOnHandle(WidgetMouseEvent e, ViewerCanvas view, int obj, int handle) {
        Mesh mesh = (Mesh)((Object)this.controller.getObject().getObject());
        Vec3 vert = mesh.getVertices()[handle].r;
        BoundingBox selectionBounds = this.findSelectionBounds(view.getCamera());
        if (selectionBounds != null) {
            this.manipulator.mousePressedOnHandle(e, view, selectionBounds, vert);
            this.dragInProgress = true;
        }
    }

    public void mouseDragged(WidgetMouseEvent e, ViewerCanvas view) {
        this.manipulator.mouseDragged(e, view);
    }

    public void mouseReleased(WidgetMouseEvent e, ViewerCanvas view) {
        this.manipulator.mouseReleased(e, view);
    }

    protected void handlePressed(Compound3DManipulator.HandlePressedEvent ev) {
        Mesh mesh = (Mesh)((Object)this.controller.getObject().getObject());
        this.baseVertPos = mesh.getVertexPositions();
    }

    protected void handleDragged(Compound3DManipulator.HandleDraggedEvent ev) {
        if (this.undo == null) {
            Mesh mesh = (Mesh)((Object)this.controller.getObject().getObject());
            this.undo = new UndoRecord(this.theWindow, false, 13, new Object[]{mesh, mesh.getVertexPositions()});
        }
        this.transformMesh(ev.getTransform());
        this.theWindow.updateImage();
        if (ev.getHandleType() == Compound3DManipulator.MOVE) {
            Vec3 drag = ev.getTransform().times(new Vec3());
            this.theWindow.setHelpText(Translate.text("reshapeMeshTool.dragText", (double)Math.round(drag.x * 100000.0) / 100000.0 + ", " + (double)Math.round(drag.y * 100000.0) / 100000.0 + ", " + (double)Math.round(drag.z * 100000.0) / 100000.0));
        } else if (ev.getHandleType() == Compound3DManipulator.ROTATE) {
            this.theWindow.setHelpText(Translate.text("rotateMeshTool.dragText", Double.toString((double)Math.round(ev.getRotationAngle() * 100000.0 * 180.0 / Math.PI) / 100000.0)));
        } else if (ev.getAxis() == Compound3DManipulator.UV && !ev.getMouseEvent().isShiftDown()) {
            this.theWindow.setHelpText(Translate.text("scaleMeshTool.dragText", (double)Math.round(ev.getPrimaryScale() * 100000.0) / 100000.0 + ", " + (double)Math.round(ev.getSecondaryScale() * 100000.0) / 100000.0));
        } else {
            this.theWindow.setHelpText(Translate.text("scaleMeshTool.dragText", Double.toString((double)Math.round(ev.getPrimaryScale() * 100000.0) / 100000.0)));
        }
    }

    protected void handleReleased(Compound3DManipulator.HandleReleasedEvent ev) {
        if (this.undo != null) {
            this.theWindow.setUndoRecord(this.undo);
        }
        this.theWindow.updateImage();
        this.undo = null;
        this.baseVertPos = null;
        this.dragInProgress = false;
    }

    private void transformMesh(Mat4 transform) {
        int i;
        int[] selected = this.controller.getSelectionDistance();
        Vec3[] v = new Vec3[this.baseVertPos.length];
        for (i = 0; i < v.length; ++i) {
            v[i] = selected[i] == 0 ? transform.times(this.baseVertPos[i]).minus(this.baseVertPos[i]) : new Vec3();
        }
        if (this.theFrame instanceof MeshEditorWindow) {
            ((MeshEditorWindow)this.theFrame).adjustDeltas(v);
        }
        for (i = 0; i < v.length; ++i) {
            v[i].add(this.baseVertPos[i]);
        }
        Mesh mesh = (Mesh)((Object)this.controller.getObject().getObject());
        mesh.setVertexPositions(v);
        this.controller.objectChanged();
    }

    public void keyPressed(KeyPressedEvent e, ViewerCanvas view) {
        int i;
        double dy;
        double dx;
        if (e.getKeyCode() == 87) {
            Compound3DManipulator.ViewMode mode = this.manipulator.getViewMode();
            if (mode == Compound3DManipulator.XYZ_MODE) {
                this.manipulator.setViewMode(Compound3DManipulator.UV_MODE);
            } else if (mode == Compound3DManipulator.UV_MODE) {
                this.manipulator.setViewMode(Compound3DManipulator.NPQ_MODE);
            } else {
                this.manipulator.setViewMode(Compound3DManipulator.XYZ_MODE);
            }
            this.theWindow.updateImage();
            return;
        }
        if (e.getKeyCode() == 112) {
            boolean bl = this.tooltipsEnabled = !this.tooltipsEnabled;
            if (this.tooltipsEnabled && !this.tooltipsAdded) {
                ViewerCanvas[] allViews = ((MeshEditorWindow)this.theWindow).getAllViews();
                for (int i2 = 0; i2 < allViews.length; ++i2) {
                    allViews[i2].addEventLink(ToolTipEvent.class, (Object)this, "showToolTip");
                }
                this.tooltipsAdded = true;
            }
            if (!this.tooltipsEnabled) {
                BToolTip.hide();
            }
            return;
        }
        Mesh mesh = (Mesh)((Object)this.controller.getObject().getObject());
        int[] selectDist = this.controller.getSelectionDistance();
        int key = e.getKeyCode();
        if (key == 38) {
            dx = 0.0;
            dy = -1.0;
        } else if (key == 40) {
            dx = 0.0;
            dy = 1.0;
        } else if (key == 37) {
            dx = -1.0;
            dy = 0.0;
        } else if (key == 39) {
            dx = 1.0;
            dy = 0.0;
        } else {
            return;
        }
        e.consume();
        this.baseVertPos = mesh.getVertexPositions();
        for (i = 0; i < this.baseVertPos.length && selectDist[i] != 0; ++i) {
        }
        if (i == this.baseVertPos.length) {
            return;
        }
        if (view.getSnapToGrid()) {
            double scale = view.getGridSpacing() * view.getScale();
            if (!e.isAltDown()) {
                scale /= (double)view.getSnapToSubdivisions();
            }
            dx *= scale;
            dy *= scale;
        } else if (e.isAltDown()) {
            dx *= 10.0;
            dy *= 10.0;
        }
        Vec3 drag = e.isControlDown() ? view.getCamera().getCameraCoordinates().getZDirection().times(-dy * 0.01) : view.getCamera().findDragVector(this.baseVertPos[i], dx, dy);
        this.theWindow.setUndoRecord(new UndoRecord(this.theWindow, false, 13, new Object[]{mesh, this.baseVertPos}));
        this.transformMesh(Mat4.translation(drag.x, drag.y, drag.z));
        this.theWindow.updateImage();
    }

    private void showToolTip(ToolTipEvent ev) {
        if (!this.tooltipsEnabled) {
            return;
        }
        ViewerCanvas view = (ViewerCanvas)ev.getWidget();
        Compound3DManipulator.HandleType type = this.manipulator.getHandleTypeAtLocation(ev.getPoint(), view, this.findSelectionBounds(view.getCamera()));
        if (type == Compound3DManipulator.MOVE) {
            MOVE_TIP.processEvent(ev);
        } else if (type == Compound3DManipulator.ROTATE) {
            ROTATE_TIP.processEvent(ev);
        } else if (type == Compound3DManipulator.SCALE) {
            SCALE_TIP.processEvent(ev);
        } else {
            BToolTip.hide();
        }
    }
}

