/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.MeshViewer;
import artofillusion.ObjectEditorWindow;
import artofillusion.Scene;
import artofillusion.TextureParameter;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.animation.Joint;
import artofillusion.animation.JointEditorDialog;
import artofillusion.animation.Skeleton;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.FacetedMesh;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.texture.FaceParameterValue;
import artofillusion.texture.FaceVertexParameterValue;
import artofillusion.texture.LayeredMapping;
import artofillusion.texture.LayeredTexture;
import artofillusion.texture.ParameterValue;
import artofillusion.texture.Texture;
import artofillusion.texture.VertexParameterValue;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.MeshEditController;
import artofillusion.ui.ObjectTreeElement;
import artofillusion.ui.PanelDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.TreeElement;
import artofillusion.ui.TreeList;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import buoy.event.CommandEvent;
import buoy.event.ValueChangedEvent;
import buoy.event.WidgetEvent;
import buoy.widget.BButton;
import buoy.widget.BCheckBoxMenuItem;
import buoy.widget.BComboBox;
import buoy.widget.BLabel;
import buoy.widget.BList;
import buoy.widget.BMenu;
import buoy.widget.BMenuItem;
import buoy.widget.BScrollPane;
import buoy.widget.BStandardDialog;
import buoy.widget.ColumnContainer;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import buoy.widget.WindowWidget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.Vector;

public abstract class MeshEditorWindow
extends ObjectEditorWindow
implements MeshEditController,
EditingWindow {
    protected Mesh oldMesh;
    protected BMenu viewMenu;
    protected BMenu colorSurfaceMenu;
    protected BMenuItem undoItem;
    protected BMenuItem redoItem;
    protected BMenuItem templateItem;
    protected BMenuItem axesItem;
    protected BMenuItem splitViewItem;
    protected BCheckBoxMenuItem[] displayItem;
    protected BCheckBoxMenuItem[] coordsItem;
    protected BCheckBoxMenuItem[] showItem;
    protected BCheckBoxMenuItem[] colorSurfaceItem;
    protected int meshTension;
    protected int tensionDistance;
    protected static int lastMeshTension = 2;
    protected static int lastTensionDistance = 0;
    protected static final double[] tensionArray = new double[]{5.0, 3.0, 2.0, 1.0, 0.5};
    protected static byte[] lastRenderMode = new byte[]{4, 4, 4, 4};
    protected static boolean[] lastShowMesh = new boolean[]{true, true, true, true};
    protected static boolean[] lastShowSurface = new boolean[]{true, true, true, true};
    protected static boolean[] lastShowSkeleton = new boolean[]{true, true, true, true};
    protected static boolean[] lastShowScene = new boolean[]{false, false, false, false};
    protected static boolean lastFreehand;
    protected static boolean lastUseWorldCoords;

    public MeshEditorWindow(EditingWindow parent, String title, ObjectInfo obj) {
        super(parent, title, obj);
        this.initialize();
        this.oldMesh = (Mesh)((Object)obj.getObject());
        this.meshTension = lastMeshTension;
        this.tensionDistance = lastTensionDistance;
    }

    public void dispose() {
        for (int i = 0; i < this.theView.length; ++i) {
            MeshEditorWindow.lastRenderMode[i] = (byte)this.theView[i].getRenderMode();
        }
        this.savePreferences();
        super.dispose();
    }

    protected ViewerCanvas createViewerCanvas(int index, RowContainer controls) {
        MeshViewer view = ((Mesh)((Object)this.objInfo.getObject())).createMeshViewer(this, controls);
        view.setRenderMode(lastRenderMode[index]);
        view.setMeshVisible(lastShowMesh[index]);
        view.setSurfaceVisible(lastShowSurface[index]);
        view.setSkeletonVisible(lastShowSkeleton[index]);
        view.setSceneVisible(lastShowScene[index]);
        view.setUseWorldCoords(lastUseWorldCoords);
        return view;
    }

    protected void createViewMenu() {
        this.viewMenu = Translate.menu("view");
        this.menubar.add(this.viewMenu);
        BMenu displayMenu = Translate.menu("displayMode");
        this.viewMenu.add(displayMenu);
        this.displayItem = new BCheckBoxMenuItem[6];
        MeshViewer view = (MeshViewer)this.theView[this.currentView];
        this.displayItem[0] = Translate.checkboxMenuItem("wireframeDisplay", this, "displayModeChanged", view.getRenderMode() == 0);
        displayMenu.add(this.displayItem[0]);
        this.displayItem[1] = Translate.checkboxMenuItem("shadedDisplay", this, "displayModeChanged", view.getRenderMode() == 1);
        displayMenu.add(this.displayItem[1]);
        this.displayItem[2] = Translate.checkboxMenuItem("smoothDisplay", this, "displayModeChanged", view.getRenderMode() == 2);
        displayMenu.add(this.displayItem[2]);
        this.displayItem[3] = Translate.checkboxMenuItem("texturedDisplay", this, "displayModeChanged", view.getRenderMode() == 3);
        displayMenu.add(this.displayItem[3]);
        this.displayItem[4] = Translate.checkboxMenuItem("transparentDisplay", this, "displayModeChanged", view.getRenderMode() == 4);
        displayMenu.add(this.displayItem[4]);
        this.displayItem[5] = Translate.checkboxMenuItem("renderedDisplay", this, "displayModeChanged", view.getRenderMode() == 5);
        displayMenu.add(this.displayItem[5]);
        if (this.getObject().getObject().canSetTexture()) {
            this.colorSurfaceMenu = this.createColorSurfaceMenu();
            this.viewMenu.add(this.colorSurfaceMenu);
        }
        this.viewMenu.add(this.createShowMenu());
        BMenu coordsMenu = Translate.menu("coordinateSystem");
        this.viewMenu.add(coordsMenu);
        this.coordsItem = new BCheckBoxMenuItem[2];
        this.coordsItem[0] = Translate.checkboxMenuItem("localCoords", this, "coordinateSystemChanged", !view.getUseWorldCoords());
        coordsMenu.add(this.coordsItem[0]);
        this.coordsItem[1] = Translate.checkboxMenuItem("sceneCoords", this, "coordinateSystemChanged", view.getUseWorldCoords());
        coordsMenu.add(this.coordsItem[1]);
        this.splitViewItem = Translate.menuItem(this.numViewsShown == 1 ? "fourViews" : "oneView", this, "toggleViewsCommand");
        this.viewMenu.add(this.splitViewItem);
        this.viewMenu.add(Translate.menuItem("grid", this, "setGridCommand"));
        this.axesItem = Translate.menuItem(view.getShowAxes() ? "hideCoordinateAxes" : "showCoordinateAxes", this, "showAxesCommand");
        this.viewMenu.add(this.axesItem);
        this.templateItem = Translate.menuItem("showTemplate", this, "showTemplateCommand");
        this.viewMenu.add(this.templateItem);
        this.viewMenu.add(Translate.menuItem("setTemplate", this, "setTemplateCommand"));
    }

    protected BMenu createShowMenu() {
        BMenu menu = Translate.menu("show");
        this.showItem = new BCheckBoxMenuItem[4];
        MeshViewer view = (MeshViewer)this.theView[this.currentView];
        this.showItem[0] = Translate.checkboxMenuItem("controlMesh", this, "shownItemChanged", view.getMeshVisible());
        menu.add(this.showItem[0]);
        this.showItem[1] = Translate.checkboxMenuItem("surface", this, "shownItemChanged", view.getSurfaceVisible());
        menu.add(this.showItem[1]);
        this.showItem[2] = Translate.checkboxMenuItem("skeleton", this, "shownItemChanged", view.getSkeletonVisible());
        menu.add(this.showItem[2]);
        this.showItem[3] = Translate.checkboxMenuItem("entireScene", this, "shownItemChanged", view.getSceneVisible());
        menu.add(this.showItem[3]);
        return menu;
    }

    protected BMenu createColorSurfaceMenu() {
        BMenu menu = Translate.menu("colorSurfaceBy");
        TextureParameter[] params = this.getObject().getObject().getParameters();
        int numParams = params == null ? 0 : params.length;
        this.colorSurfaceItem = new BCheckBoxMenuItem[numParams + 2];
        MeshViewer view = (MeshViewer)this.theView[this.currentView];
        this.colorSurfaceItem[0] = Translate.checkboxMenuItem("default", this, "surfaceColoringChanged", view.getSurfaceTextureParameter() == null);
        menu.add(this.colorSurfaceItem[0]);
        this.colorSurfaceItem[1] = Translate.checkboxMenuItem("boneWeight", this, "surfaceColoringChanged", view.getSurfaceTextureParameter() == this.getJointWeightParam());
        menu.add(this.colorSurfaceItem[1]);
        BMenu paramMenu = Translate.menu("parameter");
        menu.add(paramMenu);
        for (int i = 0; i < numParams; ++i) {
            BCheckBoxMenuItem bCheckBoxMenuItem = new BCheckBoxMenuItem(params[i].name, view.getSurfaceTextureParameter() == params[i]);
            this.colorSurfaceItem[i + 2] = bCheckBoxMenuItem;
            paramMenu.add(bCheckBoxMenuItem);
            this.colorSurfaceItem[i + 2].addEventLink(CommandEvent.class, (Object)this, "surfaceColoringChanged");
        }
        return menu;
    }

    protected void loadPreferences() {
        super.loadPreferences();
        lastRenderMode = this.preferences.getByteArray("displayMode", lastRenderMode);
        lastFreehand = this.preferences.getBoolean("freehandSelection", lastFreehand);
        lastShowMesh = this.loadBooleanArrayPreference("showControlMesh", lastShowMesh);
        lastShowScene = this.loadBooleanArrayPreference("showScene", lastShowScene);
        lastShowSkeleton = this.loadBooleanArrayPreference("showSkeleton", lastShowSkeleton);
        lastShowSurface = this.loadBooleanArrayPreference("showSurface", lastShowSurface);
        lastUseWorldCoords = this.preferences.getBoolean("useSceneCoords", lastUseWorldCoords);
        lastMeshTension = this.preferences.getInt("meshTension", lastMeshTension);
        lastTensionDistance = this.preferences.getInt("meshTensionDistance", lastTensionDistance);
    }

    protected void savePreferences() {
        super.savePreferences();
        this.preferences.putByteArray("displayMode", lastRenderMode);
        this.preferences.putBoolean("freehandSelection", lastFreehand);
        this.saveBooleanArrayPreference("showControlMesh", lastShowMesh);
        this.saveBooleanArrayPreference("showScene", lastShowScene);
        this.saveBooleanArrayPreference("showSkeleton", lastShowSkeleton);
        this.saveBooleanArrayPreference("showSurface", lastShowSurface);
        this.preferences.putBoolean("useSceneCoords", lastUseWorldCoords);
        this.preferences.putInt("meshTension", lastMeshTension);
        this.preferences.putInt("meshTensionDistance", lastTensionDistance);
    }

    public abstract void setMesh(Mesh var1);

    public abstract boolean[] getSelection();

    public abstract void setSelection(boolean[] var1);

    public abstract int[] getSelectionDistance();

    public void objectChanged() {
        this.getObject().clearCachedMeshes();
        for (ViewerCanvas view : this.theView) {
            view.viewChanged(false);
        }
    }

    public Scene getScene() {
        return ((MeshViewer)this.theView[this.currentView]).getScene();
    }

    public void undoCommand() {
        super.undoCommand();
        this.setMesh((Mesh)((Object)this.getObject().getObject()));
        for (ViewerCanvas view : this.theView) {
            view.viewChanged(false);
        }
    }

    public void redoCommand() {
        super.redoCommand();
        this.setMesh((Mesh)((Object)this.getObject().getObject()));
        for (ViewerCanvas view : this.theView) {
            view.viewChanged(false);
        }
    }

    public void updateMenus() {
        MeshViewer view = (MeshViewer)this.theView[this.currentView];
        this.undoItem.setEnabled(this.undoStack.canUndo());
        this.redoItem.setEnabled(this.undoStack.canRedo());
        this.templateItem.setEnabled(view.getTemplateImage() != null);
        this.templateItem.setText(view.getTemplateShown() ? Translate.text("menu.hideTemplate") : Translate.text("menu.showTemplate"));
        this.splitViewItem.setText(this.numViewsShown == 1 ? Translate.text("menu.fourViews") : Translate.text("menu.oneView"));
        this.axesItem.setText(Translate.text(view.getShowAxes() ? "menu.hideCoordinateAxes" : "menu.showCoordinateAxes"));
        this.displayItem[0].setState(view.getRenderMode() == 0);
        this.displayItem[1].setState(view.getRenderMode() == 1);
        this.displayItem[2].setState(view.getRenderMode() == 2);
        this.displayItem[3].setState(view.getRenderMode() == 3);
        this.displayItem[4].setState(view.getRenderMode() == 4);
        this.displayItem[5].setState(view.getRenderMode() == 5);
        if (this.showItem[0] != null) {
            this.showItem[0].setState(view.getMeshVisible());
        }
        if (this.showItem[1] != null) {
            this.showItem[1].setState(view.getSurfaceVisible());
        }
        if (this.showItem[2] != null) {
            this.showItem[2].setState(view.getSkeletonVisible());
        }
        if (this.showItem[3] != null) {
            this.showItem[3].setState(view.getSceneVisible());
        }
        if (this.colorSurfaceMenu != null) {
            this.colorSurfaceMenu.setEnabled(view.getRenderMode() == 2 || view.getRenderMode() == 3);
        }
        if (this.colorSurfaceItem != null) {
            this.colorSurfaceItem[0].setState(view.getSurfaceTextureParameter() == null);
            this.colorSurfaceItem[1].setState(view.getSurfaceTextureParameter() == this.getJointWeightParam());
            TextureParameter[] params = this.getObject().getObject().getParameters();
            for (int i = 2; i < this.colorSurfaceItem.length; ++i) {
                this.colorSurfaceItem[i].setState(view.getSurfaceTextureParameter() == params[i - 2]);
            }
        }
    }

    private void displayModeChanged(WidgetEvent ev) {
        Widget source = ev.getWidget();
        for (int i = 0; i < this.displayItem.length; ++i) {
            this.displayItem[i].setState(source == this.displayItem[i]);
        }
        if (source == this.displayItem[0]) {
            this.theView[this.currentView].setRenderMode(0);
        } else if (source == this.displayItem[1]) {
            this.theView[this.currentView].setRenderMode(1);
        } else if (source == this.displayItem[2]) {
            this.theView[this.currentView].setRenderMode(2);
        } else if (source == this.displayItem[3]) {
            this.theView[this.currentView].setRenderMode(3);
        } else if (source == this.displayItem[4]) {
            this.theView[this.currentView].setRenderMode(4);
        } else if (source == this.displayItem[5]) {
            this.theView[this.currentView].setRenderMode(5);
        }
        this.savePreferences();
        this.updateMenus();
    }

    private void coordinateSystemChanged(WidgetEvent ev) {
        int i;
        Widget source = ev.getWidget();
        for (i = 0; i < this.coordsItem.length; ++i) {
            this.coordsItem[i].setState(source == this.coordsItem[i]);
        }
        lastUseWorldCoords = source == this.coordsItem[1];
        for (i = 0; i < this.theView.length; ++i) {
            ((MeshViewer)this.theView[i]).setUseWorldCoords(lastUseWorldCoords);
        }
        this.savePreferences();
        this.updateImage();
    }

    private void shownItemChanged(WidgetEvent ev) {
        Widget source = ev.getWidget();
        MeshViewer view = (MeshViewer)this.theView[this.currentView];
        if (source == this.showItem[0]) {
            MeshEditorWindow.lastShowMesh[this.currentView] = this.showItem[0].getState();
            view.setMeshVisible(MeshEditorWindow.lastShowMesh[this.currentView]);
        } else if (source == this.showItem[1]) {
            MeshEditorWindow.lastShowSurface[this.currentView] = this.showItem[1].getState();
            view.setSurfaceVisible(MeshEditorWindow.lastShowSurface[this.currentView]);
        } else if (source == this.showItem[2]) {
            MeshEditorWindow.lastShowSkeleton[this.currentView] = this.showItem[2].getState();
            view.setSkeletonVisible(MeshEditorWindow.lastShowSkeleton[this.currentView]);
        } else if (source == this.showItem[3]) {
            MeshEditorWindow.lastShowScene[this.currentView] = this.showItem[3].getState();
            view.setSceneVisible(MeshEditorWindow.lastShowScene[this.currentView]);
        }
        this.savePreferences();
        this.updateImage();
    }

    private void surfaceColoringChanged(WidgetEvent ev) {
        Widget source = ev.getWidget();
        MeshViewer view = (MeshViewer)this.theView[this.currentView];
        for (int i = 0; i < this.colorSurfaceItem.length; ++i) {
            if (source != this.colorSurfaceItem[i]) continue;
            if (i == 0) {
                view.setSurfaceTextureParameter(null);
                continue;
            }
            if (i == 1) {
                view.setSurfaceTextureParameter(this.getJointWeightParam());
                continue;
            }
            view.setSurfaceTextureParameter(this.getObject().getObject().getParameters()[i - 2]);
        }
        this.savePreferences();
        this.updateImage();
        this.updateMenus();
    }

    public boolean isFreehand() {
        return ((MeshViewer)this.theView[0]).getFreehandSelection();
    }

    public void setFreehand(boolean freehand) {
        lastFreehand = freehand;
        for (int i = 0; i < this.theView.length; ++i) {
            ((MeshViewer)this.theView[i]).setFreehandSelection(freehand);
        }
        this.savePreferences();
    }

    public void setPointsCommand() {
        ComponentsDialog dlg;
        String title;
        ValueField zField;
        ValueField yField;
        ValueField xField;
        int i;
        int j = 0;
        int num = 0;
        final Mesh theMesh = (Mesh)((Object)this.getObject().getObject());
        Mesh oldMesh = (Mesh)((Object)theMesh.duplicate());
        Skeleton s = theMesh.getSkeleton();
        Joint[] jt = null;
        final int[] selectDist = this.getSelectionDistance();
        final MeshViewer view = (MeshViewer)this.theView[this.currentView];
        final CoordinateSystem coords = view.thisObjectInScene.getCoords();
        final MeshVertex[] vert = theMesh.getVertices();
        final Vec3[] points = new Vec3[vert.length];
        ValueSlider weightSlider = null;
        BComboBox jointChoice = null;
        double weight = -1.0;
        int joint = -2;
        for (i = 0; i < selectDist.length; ++i) {
            if (selectDist[i] != 0) continue;
            ++num;
            j = i;
            if (weight == -1.0) {
                weight = vert[i].ikWeight;
            } else if (vert[i].ikWeight != weight) {
                weight = Double.NaN;
            }
            if (joint == -2) {
                joint = vert[i].ikJoint;
                continue;
            }
            if (vert[i].ikJoint == joint) continue;
            joint = -3;
        }
        if (num == 0) {
            return;
        }
        if (num == 1) {
            Vec3 pos = vert[j].r;
            if (view.getUseWorldCoords() && coords != null) {
                pos = coords.fromLocal().times(pos);
            }
            xField = new ValueField(pos.x, 0, 5);
            yField = new ValueField(pos.y, 0, 5);
            zField = new ValueField(pos.z, 0, 5);
            title = Translate.text("editVertSingle");
        } else {
            xField = new ValueField(Double.NaN, 0, 5);
            yField = new ValueField(Double.NaN, 0, 5);
            zField = new ValueField(Double.NaN, 0, 5);
            title = Translate.text("editVertMultiple");
        }
        Object listener = new Object(){

            void processEvent() {
                for (int i = 0; i < selectDist.length; ++i) {
                    points[i] = vert[i].r;
                    if (selectDist[i] != 0) continue;
                    if (view.getUseWorldCoords() && coords != null) {
                        coords.fromLocal().transform(points[i]);
                    }
                    if (!Double.isNaN(xField.getValue())) {
                        points[i].x = xField.getValue();
                    }
                    if (!Double.isNaN(yField.getValue())) {
                        points[i].y = yField.getValue();
                    }
                    if (!Double.isNaN(zField.getValue())) {
                        points[i].z = zField.getValue();
                    }
                    if (!view.getUseWorldCoords() || coords == null) continue;
                    coords.toLocal().transform(points[i]);
                }
                theMesh.setVertexPositions(points);
                MeshEditorWindow.this.setMesh(theMesh);
                MeshEditorWindow.this.updateImage();
            }
        };
        xField.addEventLink(ValueChangedEvent.class, listener);
        yField.addEventLink(ValueChangedEvent.class, listener);
        zField.addEventLink(ValueChangedEvent.class, listener);
        if (s == null) {
            dlg = new ComponentsDialog(this, title, new Widget[]{xField, yField, zField}, new String[]{"X", "Y", "Z"});
        } else {
            weightSlider = new ValueSlider(0.0, 1.0, 100, weight);
            jointChoice = new BComboBox();
            jointChoice.add(Translate.text("none"));
            jt = s.getJoints();
            for (i = 0; i < jt.length; ++i) {
                jointChoice.add(jt[i].name);
            }
            if (joint == -3) {
                jointChoice.add("");
            }
            jointChoice.setSelectedIndex(0);
            for (i = 0; i < jt.length; ++i) {
                if (jt[i].id != joint) continue;
                jointChoice.setSelectedIndex(i + 1);
            }
            if (joint == -3) {
                jointChoice.setSelectedIndex(jt.length + 1);
            }
            dlg = new ComponentsDialog(this, title, new Widget[]{xField, yField, zField, jointChoice, weightSlider}, new String[]{"X", "Y", "Z", Translate.text("ikBone"), Translate.text("ikWeight")});
        }
        if (dlg.clickedOk()) {
            for (i = 0; i < selectDist.length; ++i) {
                if (selectDist[i] != 0) continue;
                if (weightSlider != null && !Double.isNaN(weightSlider.getValue())) {
                    vert[i].ikWeight = weightSlider.getValue();
                }
                if (jointChoice == null) continue;
                if (jointChoice.getSelectedIndex() == 0) {
                    vert[i].ikJoint = -1;
                    continue;
                }
                if (jointChoice.getSelectedIndex() > jt.length) continue;
                vert[i].ikJoint = jt[jointChoice.getSelectedIndex() - 1].id;
            }
            this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, oldMesh}));
        } else {
            theMesh.copyObject((Object3D)((Object)oldMesh));
            this.setMesh(theMesh);
            this.updateImage();
        }
    }

    public void transformPointsCommand() {
        int i;
        Mesh theMesh = (Mesh)((Object)this.getObject().getObject());
        int[] selectDist = this.getSelectionDistance();
        MeshVertex[] vert = theMesh.getVertices();
        Vec3[] points = new Vec3[vert.length];
        MeshViewer view = (MeshViewer)this.theView[this.currentView];
        CoordinateSystem coords = view.thisObjectInScene.getCoords();
        for (i = 0; i < selectDist.length && selectDist[i] == -1; ++i) {
        }
        if (i == selectDist.length) {
            return;
        }
        FormContainer content = new FormContainer(4, 5);
        LayoutInfo eastLayout = new LayoutInfo(LayoutInfo.EAST, LayoutInfo.NONE, new Insets(0, 0, 0, 5), null);
        content.add(Translate.label("Move"), 0, 1, eastLayout);
        content.add(Translate.label("Rotate"), 0, 2, eastLayout);
        content.add(Translate.label("Scale"), 0, 3, eastLayout);
        content.add(new BLabel("X"), 1, 0);
        content.add(new BLabel("Y"), 2, 0);
        content.add(new BLabel("Z"), 3, 0);
        ValueField[] fields = new ValueField[9];
        for (i = 0; i < 9; ++i) {
            fields[i] = new ValueField(Double.NaN, 0);
            content.add(fields[i], i % 3 + 1, i / 3 + 1);
        }
        RowContainer row = new RowContainer();
        content.add(row, 0, 4, 4, 1);
        row.add(Translate.label("transformAround"));
        BComboBox centerChoice = new BComboBox(new String[]{Translate.text("centerOfSelection"), Translate.text("objectOrigin")});
        row.add(centerChoice);
        PanelDialog dlg = new PanelDialog((WindowWidget)this, Translate.text("transformPoints"), content);
        if (!dlg.clickedOk()) {
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 13, new Object[]{theMesh, theMesh.getVertexPositions()}));
        double[] val = new double[9];
        for (i = 0; i < val.length; ++i) {
            val[i] = fields[i].getValue();
            if (!Double.isNaN(val[i])) continue;
            val[i] = i < 6 ? 0.0 : 1.0;
        }
        Mat4 m = Mat4.translation(val[0], val[1], val[2]);
        m = m.times(Mat4.xrotation(val[3] * Math.PI / 180.0));
        m = m.times(Mat4.yrotation(val[4] * Math.PI / 180.0));
        m = m.times(Mat4.zrotation(val[5] * Math.PI / 180.0));
        m = m.times(Mat4.scale(val[6], val[7], val[8]));
        if (view.getUseWorldCoords() && coords != null) {
            m = coords.toLocal().times(m).times(coords.fromLocal());
        }
        if (centerChoice.getSelectedIndex() == 0) {
            Vec3 center = new Vec3();
            int j = 0;
            for (i = 0; i < selectDist.length; ++i) {
                if (selectDist[i] != 0) continue;
                center.add(vert[i].r);
                ++j;
            }
            center.scale(1.0 / (double)j);
            m = Mat4.translation(center.x, center.y, center.z).times(m).times(Mat4.translation(-center.x, -center.y, -center.z));
        }
        for (i = 0; i < selectDist.length; ++i) {
            points[i] = vert[i].r;
            if (selectDist[i] != 0) continue;
            points[i] = m.times(points[i]);
        }
        theMesh.setVertexPositions(points);
        this.setMesh(theMesh);
        this.updateImage();
    }

    public void randomizeCommand() {
        int i;
        Mesh theMesh = (Mesh)((Object)this.getObject().getObject());
        int[] selectDist = this.getSelectionDistance();
        MeshViewer view = (MeshViewer)this.theView[this.currentView];
        CoordinateSystem coords = view.thisObjectInScene.getCoords();
        MeshVertex[] vert = theMesh.getVertices();
        Vec3[] points = new Vec3[vert.length];
        for (i = 0; i < selectDist.length && selectDist[i] == -1; ++i) {
        }
        if (i == selectDist.length) {
            return;
        }
        ValueField xfield = new ValueField(0.0, 0);
        ValueField yfield = new ValueField(0.0, 0);
        ValueField zfield = new ValueField(0.0, 0);
        ComponentsDialog dlg = new ComponentsDialog(this, "Maximum random displacement:", new Widget[]{xfield, yfield, zfield}, new String[]{"X", "Y", "Z"});
        if (!dlg.clickedOk()) {
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 13, new Object[]{theMesh, theMesh.getVertexPositions()}));
        for (i = 0; i < selectDist.length; ++i) {
            points[i] = vert[i].r;
            if (selectDist[i] != 0) continue;
            if (view.getUseWorldCoords() && coords != null) {
                coords.fromLocal().transform(points[i]);
            }
            points[i].x += (1.0 - 2.0 * Math.random()) * xfield.getValue();
            points[i].y += (1.0 - 2.0 * Math.random()) * yfield.getValue();
            points[i].z += (1.0 - 2.0 * Math.random()) * zfield.getValue();
            if (!view.getUseWorldCoords() || coords == null) continue;
            coords.toLocal().transform(points[i]);
        }
        theMesh.setVertexPositions(points);
        this.setMesh(theMesh);
        this.updateImage();
    }

    public void centerCommand() {
        Mesh theMesh = (Mesh)((Object)this.getObject().getObject());
        MeshVertex[] vert = theMesh.getVertices();
        MeshViewer view = (MeshViewer)this.theView[this.currentView];
        CoordinateSystem coords = view.thisObjectInScene.getCoords();
        Vec3 center = theMesh.getBounds().getCenter();
        Vec3[] points = new Vec3[vert.length];
        this.setUndoRecord(new UndoRecord(this, false, 13, new Object[]{theMesh, theMesh.getVertexPositions()}));
        if (view.getUseWorldCoords() && coords != null) {
            coords.fromLocal().transform(center);
            coords.toLocal().transformDirection(center);
        }
        for (int i = 0; i < vert.length; ++i) {
            points[i] = vert[i].r.minus(center);
        }
        theMesh.setVertexPositions(points);
        Skeleton skeleton = theMesh.getSkeleton();
        if (skeleton != null) {
            Joint[] joint = skeleton.getJoints();
            for (int i = 0; i < joint.length; ++i) {
                joint[i].coords.setOrigin(joint[i].coords.getOrigin().minus(center));
            }
        }
        this.setMesh(theMesh);
        this.updateImage();
    }

    public void setTensionCommand() {
        ValueField distanceField = new ValueField((double)this.tensionDistance, 5);
        BComboBox tensionChoice = new BComboBox(new String[]{Translate.text("VeryLow"), Translate.text("Low"), Translate.text("Medium"), Translate.text("High"), Translate.text("VeryHigh")});
        tensionChoice.setSelectedIndex(this.meshTension);
        ComponentsDialog dlg = new ComponentsDialog(this, Translate.text("setTensionTitle"), new Widget[]{distanceField, tensionChoice}, new String[]{Translate.text("maxDistance"), Translate.text("Tension")});
        if (!dlg.clickedOk()) {
            return;
        }
        lastTensionDistance = this.tensionDistance = (int)distanceField.getValue();
        lastMeshTension = this.meshTension = tensionChoice.getSelectedIndex();
        this.savePreferences();
    }

    public double getMeshTension() {
        return tensionArray[this.meshTension];
    }

    public int getTensionDistance() {
        return this.tensionDistance;
    }

    public TextureParameter getFaceIndexParameter() {
        return null;
    }

    public TextureParameter getJointWeightParam() {
        return null;
    }

    public boolean isExtraParameter(TextureParameter param) {
        return param == this.getFaceIndexParameter() || param == this.getJointWeightParam();
    }

    public void setParametersCommand() {
        if (this.getSelectionMode() == 0) {
            this.setVertexParametersCommand();
        } else if (this.getSelectionMode() == 2) {
            this.setFaceParametersCommand();
        }
    }

    protected void setVertexParametersCommand() {
        PanelDialog dlg;
        int k;
        int i;
        int j;
        ObjectInfo info = this.getObject();
        Mesh theMesh = (Mesh)((Object)info.getObject());
        final MeshVertex[] vert = theMesh.getVertices();
        TextureParameter[] param = info.getObject().getParameters();
        final ParameterValue[] paramValue = info.getObject().getParameterValues();
        int[] paramIndex = null;
        final int[] selectDist = this.getSelectionDistance();
        for (j = 0; j < selectDist.length && selectDist[j] != 0; ++j) {
        }
        if (j == selectDist.length) {
            return;
        }
        if (param != null) {
            int num = 0;
            for (i = 0; i < param.length; ++i) {
                if (!(paramValue[i] instanceof VertexParameterValue) || this.isExtraParameter(param[i])) continue;
                ++num;
            }
            paramIndex = new int[num];
            i = 0;
            for (k = 0; k < param.length; ++k) {
                if (!(paramValue[k] instanceof VertexParameterValue) || this.isExtraParameter(param[k])) continue;
                paramIndex[i++] = k;
            }
        }
        if (paramIndex == null || paramIndex.length == 0) {
            new BStandardDialog("", Translate.text("noPerVertexParams"), BStandardDialog.INFORMATION).showMessageDialog(this);
            return;
        }
        double[] value = new double[paramIndex.length];
        for (i = 0; i < paramIndex.length; ++i) {
            double[] currentVal = ((VertexParameterValue)paramValue[paramIndex[i]]).getValue();
            value[i] = currentVal[j];
            for (k = j; k < selectDist.length; ++k) {
                if (selectDist[k] != 0 || currentVal[k] == value[i]) continue;
                value[i] = Double.NaN;
            }
        }
        Widget[] editWidget = new Widget[paramIndex.length];
        ColumnContainer content = new ColumnContainer();
        content.setDefaultLayout(new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, null, null));
        LayoutInfo indent1 = new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, new Insets(0, 10, 0, 0), null);
        LayoutInfo indent2 = new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, new Insets(0, 20, 0, 0), null);
        RowContainer coordsPanel = null;
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ResetButton
        extends BButton {
            VertexParameterValue xparamVal;
            VertexParameterValue yparamVal;
            VertexParameterValue zparamVal;
            double[] xvalList;
            double[] yvalList;
            double[] zvalList;
            ValueField xfield;
            ValueField yfield;
            ValueField zfield;

            public ResetButton() {
                super(Translate.text("Reset"));
                this.addEventLink(CommandEvent.class, this);
            }

            public void addParam(int index, int type, ValueField field) {
                if (type == 1) {
                    this.xparamVal = (VertexParameterValue)paramValue[index];
                    this.xvalList = this.xparamVal.getValue();
                    this.xfield = field;
                } else if (type == 2) {
                    this.yparamVal = (VertexParameterValue)paramValue[index];
                    this.yvalList = this.yparamVal.getValue();
                    this.yfield = field;
                } else if (type == 3) {
                    this.zparamVal = (VertexParameterValue)paramValue[index];
                    this.zvalList = this.zparamVal.getValue();
                    this.zfield = field;
                }
            }

            private void processEvent() {
                BStandardDialog dlg = new BStandardDialog("", Translate.text("resetCoordsToPos"), BStandardDialog.QUESTION);
                String[] options = new String[]{Translate.text("button.ok"), Translate.text("button.cancel")};
                int choice = dlg.showOptionDialog(this, options, options[0]);
                if (choice == 1) {
                    return;
                }
                double xval = Double.NaN;
                double yval = Double.NaN;
                double zval = Double.NaN;
                for (int ind = 0; ind < selectDist.length; ++ind) {
                    if (selectDist[ind] != 0) continue;
                    if (this.xparamVal != null) {
                        this.xvalList[ind] = vert[ind].r.x;
                        if (Double.isNaN(xval)) {
                            xval = vert[ind].r.x;
                            this.xfield.setValue(xval);
                        } else if (xval != vert[ind].r.x) {
                            this.xfield.setValue(Double.NaN);
                        }
                    }
                    if (this.yparamVal != null) {
                        this.yvalList[ind] = vert[ind].r.y;
                        if (Double.isNaN(yval)) {
                            yval = vert[ind].r.y;
                            this.yfield.setValue(yval);
                        } else if (yval != vert[ind].r.y) {
                            this.yfield.setValue(Double.NaN);
                        }
                    }
                    if (this.zparamVal == null) continue;
                    this.zvalList[ind] = vert[ind].r.z;
                    if (Double.isNaN(zval)) {
                        zval = vert[ind].r.z;
                        this.zfield.setValue(zval);
                        continue;
                    }
                    if (zval == vert[ind].r.z) continue;
                    this.zfield.setValue(Double.NaN);
                }
                if (this.xparamVal != null) {
                    this.xparamVal.setValue(this.xvalList);
                }
                if (this.yparamVal != null) {
                    this.yparamVal.setValue(this.yvalList);
                }
                if (this.zparamVal != null) {
                    this.zparamVal.setValue(this.zvalList);
                }
            }
        }
        ResetButton reset = null;
        if (info.getObject().getTexture() instanceof LayeredTexture) {
            LayeredMapping map = (LayeredMapping)info.getObject().getTextureMapping();
            Texture[] layer = map.getLayers();
            for (k = 0; k < layer.length; ++k) {
                coordsPanel = null;
                content.add(new BLabel(Translate.text("layerLabel", Integer.toString(k + 1), layer[k].getName())));
                TextureParameter[] layerParam = map.getLayerParameters(k);
                boolean any = false;
                for (i = 0; i < paramIndex.length; ++i) {
                    int m;
                    TextureParameter pm = param[paramIndex[i]];
                    for (m = 0; m < layerParam.length && !layerParam[m].equals(pm); ++m) {
                    }
                    if (m == layerParam.length) continue;
                    any = true;
                    editWidget[i] = pm.getEditingWidget(value[i]);
                    if (pm.type == 0) {
                        RowContainer row = new RowContainer();
                        row.add(new BLabel(pm.name));
                        row.add(editWidget[i]);
                        content.add(row, indent1);
                        if (coordsPanel != null) {
                            coordsPanel.add(reset);
                        }
                        coordsPanel = null;
                        reset = null;
                        continue;
                    }
                    if (coordsPanel == null) {
                        coordsPanel = new RowContainer();
                        content.add(Translate.label("texMappingCoords"), indent1);
                        content.add(coordsPanel, indent2);
                        coordsPanel.add(new BLabel(pm.name));
                        coordsPanel.add(editWidget[i]);
                        reset = new ResetButton();
                        reset.addParam(paramIndex[i], pm.type, (ValueField)editWidget[i]);
                        continue;
                    }
                    coordsPanel.add(new BLabel(pm.name));
                    coordsPanel.add(editWidget[i]);
                    reset.addParam(paramIndex[i], pm.type, (ValueField)editWidget[i]);
                }
                if (coordsPanel != null) {
                    coordsPanel.add(reset);
                }
                if (any) continue;
                content.add(Translate.label("noLayerPerVertexParams"), indent1);
            }
        } else {
            content.add(new BLabel(Translate.text("Texture") + ": " + info.getObject().getTexture().getName()));
            for (i = 0; i < paramIndex.length; ++i) {
                TextureParameter pm = param[paramIndex[i]];
                editWidget[i] = pm.getEditingWidget(value[i]);
                if (pm.type == 0) {
                    RowContainer row = new RowContainer();
                    row.add(new BLabel(pm.name));
                    row.add(editWidget[i]);
                    content.add(row, indent1);
                    if (coordsPanel != null) {
                        coordsPanel.add(reset);
                    }
                    coordsPanel = null;
                    coordsPanel = null;
                    continue;
                }
                if (coordsPanel == null) {
                    coordsPanel = new RowContainer();
                    content.add(Translate.label("texMappingCoords"), indent1);
                    content.add(coordsPanel, indent2);
                    coordsPanel.add(new BLabel(pm.name));
                    coordsPanel.add(editWidget[i]);
                    reset = new ResetButton();
                    reset.addParam(paramIndex[i], pm.type, (ValueField)editWidget[i]);
                    continue;
                }
                coordsPanel.add(new BLabel(pm.name));
                coordsPanel.add(editWidget[i]);
                reset.addParam(paramIndex[i], pm.type, (ValueField)editWidget[i]);
            }
            if (coordsPanel != null) {
                coordsPanel.add(reset);
            }
        }
        if (!(dlg = new PanelDialog((WindowWidget)this, Translate.text("texParamsForSelectedPoints"), content)).clickedOk()) {
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        for (j = 0; j < editWidget.length; ++j) {
            double d = editWidget[j] instanceof ValueField ? ((ValueField)editWidget[j]).getValue() : ((ValueSlider)editWidget[j]).getValue();
            if (Double.isNaN(d)) continue;
            double[] val = ((VertexParameterValue)paramValue[paramIndex[j]]).getValue();
            for (i = 0; i < selectDist.length; ++i) {
                if (selectDist[i] != 0) continue;
                val[i] = d;
            }
            ((VertexParameterValue)paramValue[paramIndex[j]]).setValue(val);
        }
        info.getObject().setParameterValues(paramValue);
        info.clearCachedMeshes();
        this.updateImage();
    }

    protected void setFaceParametersCommand() {
        PanelDialog dlg;
        FormContainer content;
        int k;
        int i;
        int j;
        FacetedMesh theMesh = (FacetedMesh)((Object)this.objInfo.getObject());
        TextureParameter[] param = this.objInfo.getObject().getParameters();
        ParameterValue[] paramValue = this.objInfo.getObject().getParameterValues();
        boolean[] selected = this.getSelection();
        int[] paramIndex = null;
        for (j = 0; j < selected.length && !selected[j]; ++j) {
        }
        if (j == selected.length) {
            return;
        }
        if (param != null) {
            int num = 0;
            for (i = 0; i < param.length; ++i) {
                if (!(paramValue[i] instanceof FaceParameterValue) && !(paramValue[i] instanceof FaceVertexParameterValue) || this.isExtraParameter(param[i])) continue;
                ++num;
            }
            paramIndex = new int[num];
            i = 0;
            for (k = 0; k < param.length; ++k) {
                if (!(paramValue[k] instanceof FaceParameterValue) && !(paramValue[k] instanceof FaceVertexParameterValue) || this.isExtraParameter(param[k])) continue;
                paramIndex[i++] = k;
            }
        }
        if (paramIndex == null || paramIndex.length == 0) {
            new BStandardDialog("", Translate.text("noPerFaceParams"), BStandardDialog.INFORMATION).showMessageDialog(this);
            return;
        }
        double[][] value = new double[paramIndex.length][];
        for (i = 0; i < paramIndex.length; ++i) {
            if (paramValue[paramIndex[i]] instanceof FaceParameterValue) {
                double[] currentVal = ((FaceParameterValue)paramValue[paramIndex[i]]).getValue();
                double commonVal = currentVal[j];
                for (k = j; k < selected.length; ++k) {
                    if (!selected[k] || currentVal[k] == commonVal) continue;
                    commonVal = Double.NaN;
                }
                value[i] = new double[]{commonVal};
                continue;
            }
            FaceVertexParameterValue fvpv = (FaceVertexParameterValue)paramValue[paramIndex[i]];
            double[] commonVal = new double[]{fvpv.getValue(j, 0), fvpv.getValue(j, 1), fvpv.getValue(j, 2)};
            for (k = j; k < selected.length; ++k) {
                if (!selected[k]) continue;
                if (fvpv.getValue(k, 0) != commonVal[0]) {
                    commonVal[0] = Double.NaN;
                }
                if (fvpv.getValue(k, 1) != commonVal[1]) {
                    commonVal[1] = Double.NaN;
                }
                if (fvpv.getValue(k, 2) == commonVal[2]) continue;
                commonVal[2] = Double.NaN;
            }
            value[i] = commonVal;
        }
        Widget[][] editWidget = new Widget[paramIndex.length][3];
        LayoutInfo leftLayout = new LayoutInfo(LayoutInfo.EAST, LayoutInfo.NONE, new Insets(0, 10, 0, 5), null);
        if (this.objInfo.getObject().getTexture() instanceof LayeredTexture) {
            LayeredMapping map = (LayeredMapping)this.objInfo.getObject().getTextureMapping();
            Texture[] layer = map.getLayers();
            content = new FormContainer(2, paramIndex.length * 3 + layer.length);
            content.setDefaultLayout(new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, null, null));
            int line = 0;
            for (k = 0; k < layer.length; ++k) {
                content.add(new BLabel(Translate.text("layerLabel", Integer.toString(k + 1), layer[k].getName())), 0, line++, 2, 1);
                TextureParameter[] layerParam = map.getLayerParameters(k);
                boolean any = false;
                for (i = 0; i < paramIndex.length; ++i) {
                    int m;
                    TextureParameter pm = param[paramIndex[i]];
                    for (m = 0; m < layerParam.length && !layerParam[m].equals(pm); ++m) {
                    }
                    if (m == layerParam.length) continue;
                    any = true;
                    for (m = 0; m < value[i].length; ++m) {
                        editWidget[i][m] = pm.getEditingWidget(value[i][m]);
                        content.add(new BLabel(m == 0 ? pm.name : ""), 0, line, leftLayout);
                        content.add(editWidget[i][m], 1, line++);
                    }
                }
                if (any) continue;
                content.add(Translate.label("noLayerPerFaceParams"), 0, line++, 2, 1, new LayoutInfo());
            }
        } else {
            content = new FormContainer(2, paramIndex.length * 3 + 1);
            content.setDefaultLayout(new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, null, null));
            content.add(new BLabel(Translate.text("Texture") + ": " + this.objInfo.getObject().getTexture().getName()), 0, 0);
            int line = 1;
            for (i = 0; i < paramIndex.length; ++i) {
                TextureParameter pm = param[paramIndex[i]];
                for (int m = 0; m < value[i].length; ++m) {
                    editWidget[i][m] = pm.getEditingWidget(value[i][m]);
                    content.add(new BLabel(m == 0 ? pm.name : ""), 0, line, leftLayout);
                    content.add(editWidget[i][m], 1, line++);
                }
            }
        }
        if (!(dlg = new PanelDialog((WindowWidget)this, Translate.text("texParamsForSelectedFaces"), content)).clickedOk()) {
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        for (j = 0; j < editWidget.length; ++j) {
            if (paramValue[paramIndex[j]] instanceof FaceParameterValue) {
                double d = editWidget[j][0] instanceof ValueField ? ((ValueField)editWidget[j][0]).getValue() : ((ValueSlider)editWidget[j][0]).getValue();
                if (Double.isNaN(d)) continue;
                double[] val = ((FaceParameterValue)paramValue[paramIndex[j]]).getValue();
                for (i = 0; i < selected.length; ++i) {
                    if (!selected[i]) continue;
                    val[i] = d;
                }
                ((FaceParameterValue)paramValue[paramIndex[j]]).setValue(val);
                continue;
            }
            double[] d = editWidget[j][0] instanceof ValueField ? new double[]{((ValueField)editWidget[j][0]).getValue(), ((ValueField)editWidget[j][1]).getValue(), ((ValueField)editWidget[j][2]).getValue()} : new double[]{((ValueSlider)editWidget[j][0]).getValue(), ((ValueSlider)editWidget[j][1]).getValue(), ((ValueSlider)editWidget[j][2]).getValue()};
            FaceVertexParameterValue fvpv = (FaceVertexParameterValue)paramValue[paramIndex[j]];
            for (i = 0; i < selected.length; ++i) {
                if (!selected[i]) continue;
                for (int m = 0; m < 3; ++m) {
                    if (Double.isNaN(d[m])) continue;
                    fvpv.setValue(i, m, d[m]);
                }
            }
        }
        ((Object3D)((Object)theMesh)).setParameterValues(paramValue);
        this.objInfo.clearCachedMeshes();
        this.updateImage();
    }

    public abstract void deleteCommand();

    public void deleteJointCommand() {
        Mesh theMesh = (Mesh)((Object)this.getObject().getObject());
        Skeleton s = theMesh.getSkeleton();
        if (s == null) {
            return;
        }
        MeshViewer view = (MeshViewer)this.theView[this.currentView];
        Joint j = s.getJoint(view.getSelectedJoint());
        if (j == null) {
            return;
        }
        String[] options = new String[]{Translate.text("Yes"), Translate.text("No")};
        BStandardDialog dlg = new BStandardDialog("", Translate.text(j.children.length == 0 ? "deleteBone" : "deleteBoneAndChildren", j.name), BStandardDialog.QUESTION);
        if (dlg.showOptionDialog(this, options, options[1]) == 1) {
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 14, new Object[]{theMesh.getSkeleton(), theMesh.getSkeleton().duplicate()}));
        s.deleteJoint(view.getSelectedJoint());
        for (int i = 0; i < this.theView.length; ++i) {
            ((MeshViewer)this.theView[i]).setSelectedJoint(j.parent == null ? -1 : j.parent.id);
        }
        this.updateImage();
        this.updateMenus();
    }

    public void setJointParentCommand() {
        Mesh theMesh = (Mesh)((Object)this.getObject().getObject());
        Skeleton s = theMesh.getSkeleton();
        if (s == null) {
            return;
        }
        Joint j = s.getJoint(((MeshViewer)this.theView[this.currentView]).getSelectedJoint());
        if (j == null) {
            return;
        }
        Joint[] joint = s.getJoints();
        boolean[] isChild = new boolean[joint.length];
        this.markChildJoints(s, j, isChild);
        Vector<Joint> options = new Vector<Joint>();
        for (int i = 0; i < isChild.length; ++i) {
            if (isChild[i]) continue;
            options.addElement(joint[i]);
        }
        BList ls = new BList();
        ls.setMultipleSelectionEnabled(false);
        ls.add("(" + Translate.text("None") + ")");
        ls.setSelected(0, true);
        for (int i = 0; i < options.size(); ++i) {
            ls.add(((Joint)options.elementAt((int)i)).name);
            if (options.elementAt(i) != j.parent) continue;
            ls.setSelected(i + 1, true);
        }
        ComponentsDialog dlg = new ComponentsDialog(this, Translate.text("selectParentBone", j.name), new Widget[]{UIUtilities.createScrollingList(ls)}, new String[]{null});
        if (!dlg.clickedOk() || ls.getSelectedIndex() == -1) {
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 14, new Object[]{theMesh.getSkeleton(), theMesh.getSkeleton().duplicate()}));
        if (ls.getSelectedIndex() == 0) {
            s.setJointParent(j, null);
        } else {
            s.setJointParent(j, (Joint)options.elementAt(ls.getSelectedIndex() - 1));
        }
        if (j.parent != null) {
            Vec3 ydir;
            Vec3 xdir;
            Vec3 oldZdir = j.coords.getZDirection();
            Vec3 oldYdir = j.coords.getUpDirection();
            Vec3 oldXdir = oldYdir.cross(oldZdir);
            Vec3 zdir = j.coords.getOrigin().minus(j.parent.coords.getOrigin());
            j.length.pos = zdir.length();
            zdir.normalize();
            if (Math.abs(oldXdir.dot(zdir)) < Math.abs(oldYdir.dot(zdir))) {
                xdir = oldXdir.minus(zdir.times(oldXdir.dot(zdir)));
                xdir.normalize();
                ydir = zdir.cross(xdir);
            } else {
                ydir = oldYdir.minus(zdir.times(oldYdir.dot(zdir)));
                ydir.normalize();
                xdir = ydir.cross(zdir);
            }
            j.coords.setOrientation(zdir, ydir);
            j.calcAnglesFromCoords(false);
            for (int i = 0; i < j.children.length; ++i) {
                j.children[i].calcAnglesFromCoords(false);
            }
        } else {
            j.calcAnglesFromCoords(false);
        }
        this.updateImage();
        this.updateMenus();
    }

    private void markChildJoints(Skeleton s, Joint j, boolean[] isChild) {
        isChild[s.findJointIndex((int)j.id)] = true;
        for (int i = 0; i < j.children.length; ++i) {
            this.markChildJoints(s, j.children[i], isChild);
        }
    }

    public void editJointCommand() {
        Mesh theMesh = (Mesh)((Object)this.getObject().getObject());
        Skeleton s = theMesh.getSkeleton();
        if (s == null) {
            return;
        }
        Joint j = s.getJoint(((MeshViewer)this.theView[this.currentView]).getSelectedJoint());
        if (j == null) {
            return;
        }
        new JointEditorDialog(this, j.id);
        this.updateImage();
        this.updateMenus();
    }

    public void bindSkeletonCommand() {
        int i;
        int j;
        Mesh theMesh = (Mesh)((Object)this.getObject().getObject());
        Skeleton s = theMesh.getSkeleton();
        if (s == null) {
            return;
        }
        int[] selected = this.getSelectionDistance();
        for (j = 0; j < selected.length && selected[j] != 0; ++j) {
        }
        if (j == selected.length) {
            return;
        }
        ValueSlider blendSlider = new ValueSlider(0.0, 1.0, 100, 0.5);
        ComponentsDialog dlg = new ComponentsDialog(this, Translate.text("bindPointsToSkeleton"), new Widget[]{blendSlider}, new String[]{Translate.text("ikWeightBlending")});
        if (!dlg.clickedOk()) {
            return;
        }
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{theMesh, theMesh.duplicate()}));
        double blend = blendSlider.getValue();
        Joint[] joint = s.getJoints();
        Vec3[] axis = new Vec3[joint.length];
        for (i = 0; i < joint.length; ++i) {
            if (joint[i].parent == null || joint[i].length.pos == 0.0) continue;
            axis[i] = joint[i].coords.getZDirection();
            axis[i] = axis[i].times(1.0 / axis[i].length());
        }
        MeshVertex[] vert = theMesh.getVertices();
        double[] dist = new double[joint.length];
        for (i = 0; i < selected.length; ++i) {
            if (selected[i] != 0) continue;
            int nearest = -1;
            for (j = 0; j < joint.length; ++j) {
                dist[j] = this.distToBone(vert[i].r, joint[j], axis[j]);
                if (nearest != -1 && !(dist[j] < dist[nearest])) continue;
                nearest = j;
            }
            if (nearest == -1) continue;
            int second = -1;
            if (joint[nearest].parent != null) {
                second = s.findJointIndex(joint[nearest].parent.id);
            }
            for (j = 0; j < joint[nearest].children.length; ++j) {
                int k = s.findJointIndex(joint[nearest].children[j].id);
                if (k == -1 || second != -1 && !(dist[k] < dist[second])) continue;
                second = k;
            }
            if (second == -1) {
                vert[i].ikJoint = joint[nearest].id;
                vert[i].ikWeight = 1.0;
            } else if (joint[nearest].parent != null && joint[second].id == joint[nearest].parent.id) {
                vert[i].ikJoint = joint[nearest].id;
                double ratio = dist[nearest] / dist[second];
                vert[i].ikWeight = ratio <= 1.0 - blend ? 1.0 : 0.5 + 0.5 * (1.0 - ratio) / blend;
            } else {
                double ratio = dist[nearest] / dist[second];
                if (ratio <= 1.0 - blend) {
                    vert[i].ikJoint = joint[nearest].id;
                    vert[i].ikWeight = 1.0;
                } else {
                    vert[i].ikJoint = joint[second].id;
                    vert[i].ikWeight = 0.5 - 0.5 * (1.0 - ratio) / blend;
                }
            }
            vert[i].ikWeight = 0.001 * (double)Math.round(vert[i].ikWeight * 1000.0);
        }
    }

    private double distToBone(Vec3 v, Joint j, Vec3 axis) {
        Vec3 end = j.coords.getOrigin();
        if (axis == null) {
            return end.distance(v);
        }
        Vec3 base = j.parent.coords.getOrigin();
        Vec3 diff = v.minus(base);
        double dot = diff.dot(axis);
        if (dot < 0.0) {
            return base.distance(v);
        }
        if (dot > j.length.pos) {
            return end.distance(v);
        }
        diff.subtract(axis.times(dot));
        return diff.length();
    }

    protected void importSkeletonCommand() {
        TreeList tree = new TreeList(this);
        tree.setPreferredSize(new Dimension(130, 100));
        tree.setAllowMultiple(false);
        tree.setUpdateEnabled(false);
        Scene theScene = this.getScene();
        for (int i = 0; i < theScene.getNumObjects(); ++i) {
            ObjectInfo info = theScene.getObject(i);
            if (info.getParent() != null) continue;
            class TreeElem
            extends ObjectTreeElement {
                public TreeElem(ObjectInfo info, TreeElement parent, TreeList tree) {
                    super(info, parent, tree, false);
                    this.selectable = info != ((MeshViewer)MeshEditorWindow.this.theView[MeshEditorWindow.this.currentView]).thisObjectInScene && info.getSkeleton() != null;
                    for (int i = 0; i < info.getChildren().length; ++i) {
                        this.children.addElement(new TreeElem(info.getChildren()[i], this, tree));
                    }
                }

                public boolean isGray() {
                    return !this.selectable;
                }

                public boolean canAcceptAsParent(TreeElement el) {
                    return false;
                }
            }
            tree.addElement(new TreeElem(info, null, tree));
        }
        tree.setUpdateEnabled(true);
        tree.setBackground(Color.white);
        BScrollPane sp = new BScrollPane(tree, BScrollPane.SCROLLBAR_ALWAYS, BScrollPane.SCROLLBAR_ALWAYS);
        sp.getVerticalScrollBar().setUnitIncrement(10);
        sp.setForceWidth(true);
        sp.setForceHeight(true);
        ComponentsDialog dlg = new ComponentsDialog(this, Translate.text("selectImportSkeleton"), new Widget[]{sp}, new String[]{null});
        if (!dlg.clickedOk() || tree.getSelectedObjects().length == 0) {
            return;
        }
        Mesh theMesh = (Mesh)((Object)this.getObject().getObject());
        this.setUndoRecord(new UndoRecord(this, false, 14, new Object[]{theMesh.getSkeleton(), theMesh.getSkeleton().duplicate()}));
        ObjectInfo info = (ObjectInfo)tree.getSelectedObjects()[0];
        theMesh.getSkeleton().addAllJoints(info.getObject().getSkeleton());
        this.updateImage();
        this.updateMenus();
    }

    public void renderPreviewCommand() {
        ((MeshViewer)this.theView[this.currentView]).previewObject();
    }

    public abstract void adjustDeltas(Vec3[] var1);
}

