/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.widget.BButton;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;

public abstract class WindowWidget
extends WidgetContainer {
    protected Widget content;
    protected Dimension lastSize;
    private Boolean mockVisible;
    private BButton defaultButton;
    private static ThreadLocal encodingInProgress = new ThreadLocal();

    public Window getComponent() {
        return (Window)this.component;
    }

    public void setBounds(Rectangle bounds) {
        if (encodingInProgress.get() != Boolean.TRUE && !this.getComponent().isDisplayable()) {
            this.getComponent().addNotify();
        }
        this.lastSize = new Dimension(bounds.width, bounds.height);
        this.getComponent().setBounds(bounds);
    }

    public Widget getContent() {
        return this.content;
    }

    public void setContent(Widget contentWidget) {
        if (this.content != null) {
            this.remove(this.content);
        }
        this.content = contentWidget;
        if (this.content != null) {
            if (this.content.getParent() != null) {
                this.content.getParent().remove(this.content);
            }
            JComponent contentPane = (JComponent)((RootPaneContainer)((Object)this.getComponent())).getContentPane();
            contentPane.add(this.content.getComponent());
            this.setAsParent(this.content);
        }
    }

    public void pack() {
        if (!this.getComponent().isDisplayable()) {
            this.getComponent().addNotify();
        }
        JComponent contentPane = (JComponent)((RootPaneContainer)((Object)this.getComponent())).getContentPane();
        if (this.content == null) {
            contentPane.setPreferredSize(new Dimension(0, 0));
        } else {
            contentPane.setPreferredSize(this.content.getPreferredSize());
        }
        Dimension prefSize = this.getPreferredSize();
        Rectangle bounds = this.getBounds();
        this.setBounds(new Rectangle(bounds.x, bounds.y, prefSize.width, prefSize.height));
    }

    public void layoutChildren() {
        if (this.content != null) {
            Container contentPane = ((RootPaneContainer)((Object)this.getComponent())).getContentPane();
            contentPane.validate();
            Dimension max = this.content.getMaximumSize();
            Dimension total = contentPane.getSize();
            this.content.getComponent().setBounds(0, 0, Math.min(max.width, total.width), Math.min(max.height, total.height));
            if (this.content instanceof WidgetContainer) {
                ((WidgetContainer)this.content).layoutChildren();
            }
        }
    }

    public void dispose() {
        this.getComponent().dispose();
    }

    public void toFront() {
        this.getComponent().toFront();
    }

    public void toBack() {
        this.getComponent().toBack();
    }

    public boolean isVisible() {
        if (this.mockVisible != null) {
            return this.mockVisible;
        }
        return this.getComponent().isVisible();
    }

    public void setVisible(boolean visible) {
        if (encodingInProgress.get() == Boolean.TRUE) {
            this.mockVisible = visible ? Boolean.TRUE : Boolean.FALSE;
            return;
        }
        super.setVisible(visible);
    }

    public BButton getDefaultButton() {
        return this.defaultButton;
    }

    public void setDefaultButton(BButton button) {
        this.defaultButton = button;
        this.getRootPane().setDefaultButton(button == null ? null : button.getComponent());
    }

    protected abstract JRootPane getRootPane();
}

