/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.event.CommandEvent;
import buoy.widget.Widget;
import buoy.xml.WidgetEncoder;
import buoy.xml.delegate.StaticFieldDelegate;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;

public class BButton
extends Widget {
    public static final Position CENTER = new Position(0);
    public static final Position NORTH = new Position(1);
    public static final Position SOUTH = new Position(2);
    public static final Position WEST = new Position(4);
    public static final Position EAST = new Position(8);
    public static final Position NORTHEAST = new Position(BButton.NORTH.value + BButton.EAST.value);
    public static final Position SOUTHEAST = new Position(BButton.SOUTH.value + BButton.EAST.value);
    public static final Position NORTHWEST = new Position(BButton.NORTH.value + BButton.WEST.value);
    public static final Position SOUTHWEST = new Position(BButton.SOUTH.value + BButton.WEST.value);

    public BButton() {
        this.component = this.createComponent();
        this.getComponent().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                BButton.this.dispatchEvent(new CommandEvent(BButton.this, ev.getWhen(), ev.getModifiers(), ((JButton)BButton.this.component).getActionCommand()));
            }
        });
    }

    public BButton(String text) {
        this();
        this.getComponent().setText(text);
    }

    public BButton(Icon icon) {
        this();
        this.getComponent().setIcon(icon);
    }

    public BButton(String text, Icon icon) {
        this();
        this.getComponent().setText(text);
        this.getComponent().setIcon(icon);
    }

    protected JButton createComponent() {
        return new JButton();
    }

    public JButton getComponent() {
        return (JButton)this.component;
    }

    public String getText() {
        return this.getComponent().getText();
    }

    public void setText(String text) {
        this.getComponent().setText(text);
        this.invalidateSize();
    }

    public Icon getIcon() {
        return this.getComponent().getIcon();
    }

    public void setIcon(Icon icon) {
        this.getComponent().setIcon(icon);
        this.invalidateSize();
    }

    public String getActionCommand() {
        return this.getComponent().getActionCommand();
    }

    public void setActionCommand(String command) {
        this.getComponent().setActionCommand(command);
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Position getTextPosition() {
        int hpos = this.getComponent().getHorizontalTextPosition();
        int vpos = this.getComponent().getVerticalTextPosition();
        return Position.get(hpos, vpos);
    }

    public void setTextPosition(Position position) {
        int pos = position.value;
        JButton jb = this.getComponent();
        if ((pos & BButton.NORTH.value) != 0) {
            jb.setVerticalTextPosition(1);
        } else if ((pos & BButton.SOUTH.value) != 0) {
            jb.setVerticalTextPosition(3);
        } else {
            jb.setVerticalTextPosition(0);
        }
        if ((pos & BButton.EAST.value) != 0) {
            jb.setHorizontalTextPosition(4);
        } else if ((pos & BButton.WEST.value) != 0) {
            jb.setHorizontalTextPosition(2);
        } else {
            jb.setHorizontalTextPosition(0);
        }
        this.invalidateSize();
    }

    static {
        WidgetEncoder.setPersistenceDelegate(Position.class, new StaticFieldDelegate(BButton.class));
    }

    public static class Position {
        protected int value;

        private Position(int value) {
            this.value = value;
        }

        private static Position get(int hpos, int vpos) {
            switch (hpos) {
                case 2: {
                    switch (vpos) {
                        case 1: {
                            return NORTHWEST;
                        }
                        case 3: {
                            return SOUTHWEST;
                        }
                    }
                    return WEST;
                }
                case 4: {
                    switch (vpos) {
                        case 1: {
                            return NORTHEAST;
                        }
                        case 3: {
                            return SOUTHEAST;
                        }
                    }
                    return EAST;
                }
            }
            switch (vpos) {
                case 1: {
                    return NORTH;
                }
                case 3: {
                    return SOUTH;
                }
            }
            return CENTER;
        }
    }
}

