package rescue.gui;

import rescue.*;
import rescue.panels.*;

import javax.swing.JFrame;
import javax.swing.JDialog;
import java.awt.event.WindowEvent;
import java.awt.Dimension;
import java.awt.BorderLayout;
import javax.swing.JPanel;
import java.awt.Canvas;
import java.awt.Rectangle;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import javax.swing.UIManager;
import java.awt.Dimension;
import java.awt.Toolkit;

import java.io.FileReader;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JOptionPane;

import java.io.FileWriter;
import java.io.BufferedWriter;
import java.io.PrintWriter;

import java.awt.Color;
import java.awt.GridBagConstraints;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.JRootPane;

import java.awt.Image;
import java.util.Vector;
import java.awt.event.KeyEvent;
import java.awt.event.KeyAdapter;

import java.io.File;
import java.awt.image.BufferedImage;
import java.awt.FlowLayout;

import javax.swing.JInternalFrame;
import javax.swing.JDesktopPane;
import javax.swing.JToolBar;
import javax.swing.JCheckBoxMenuItem;
import java.awt.Component;
import javax.swing.ImageIcon;
import java.awt.Window;

/**
 * <p> Rescue GUI </p>
 * @author Yura Mamyrin
 */

public class RescueGUI extends JFrame implements ActionListener, RescueListener, Runnable {

    private static final String NAME="Rescue! Max";

    private RunRescue rescue;
    private Component bigmap;
    private Vector panels;

    private Component[] inGameMenus;
    private Component[] outGameMenus;
    private Vector Windows;

    private JDesktopPane desktop;
    private JMenu windowsMenu;

//    private boolean mode;

    public RescueGUI(RunRescue rr) {
	super("Rescue! Max");

//	mode=false;

	setIconImage(Toolkit.getDefaultToolkit().getImage( this.getClass().getResource("icon.png") ));

	rescue = rr;

	JButton button;

	inGameMenus = new Component[9];
	outGameMenus = new Component[6];

	desktop = new JDesktopPane();

	desktop.setDragMode(JDesktopPane.LIVE_DRAG_MODE);

	// ############# DO TOOLBAR
	JToolBar mainToolbar = new JToolBar();
	mainToolbar.setRollover(true);

	button = new JButton("New Game");
	button.setActionCommand("new");
	button.addActionListener(this);
	mainToolbar.add(button);
	outGameMenus[2]=button;

	button = new JButton("Pause ON/OFF");
	button.setActionCommand("pause");
	button.addActionListener(this);
	mainToolbar.add(button);
	inGameMenus[8]=button;

	button = new JButton("End Game");
	button.setActionCommand("end");
	button.addActionListener(this);
	mainToolbar.add(button);
	inGameMenus[2]=button;

	mainToolbar.addSeparator();

	button = new JButton("Preferences...");
	button.setActionCommand("preferences");
	button.addActionListener(this);
	mainToolbar.add(button);
	outGameMenus[3]=button;

	button = new JButton("Mission Setup...");
	button.setActionCommand("mission");
	button.addActionListener(this);
	mainToolbar.add(button);
	outGameMenus[4]=button;
/*
	button = new JButton("High Scores");
	button.setActionCommand("scores");
	button.addActionListener(this);
	mainToolbar.add(button);
*/
	mainToolbar.addSeparator();

	button = new JButton("Quit");
	button.setActionCommand("quit");
	button.addActionListener(this);
	mainToolbar.add(button);

	button = new JButton("Help");
	button.setActionCommand("help");
	button.addActionListener(this);
	mainToolbar.add(button);

	button = new JButton("About");
	button.setActionCommand("about");
	button.addActionListener(this);
	mainToolbar.add(button);

	//JLabel versionLabel = new JLabel("  " +NAME + " Version " + RunRescue.VERSION);
	//mainToolbar.add(versionLabel);




	// ############ DO MENU
	setJMenuBar( createMenuBar() );




	getContentPane().add(mainToolbar, java.awt.BorderLayout.NORTH );
	getContentPane().add(desktop, java.awt.BorderLayout.CENTER);

	//setContentPane(desktop);

        //pack();
	//setSize(750,620);// not really should be here


	for(int i=0; i< inGameMenus.length ; i++) {
	    inGameMenus[i].setEnabled(false);
	}

        addWindowListener(
            new java.awt.event.WindowAdapter() {
                public void windowClosing(java.awt.event.WindowEvent evt) {
                    exitForm(evt);
                }
            }
	);
    }

    public void newGame(MissionLoader cm) {

	Vector w = cm.getWindows();

	bigmap = cm.getBigMap();
	panels = cm.getPanels();

	Windows = new Vector();
	String name;
	JMenuItem menuItem;

	JFrame main=null;

	for(int i=0; i< w.size() ; i++) {

	    name = ((ContainerPanel)w.elementAt(i)).getName();

	    if ( rescue.getMode() ) {

		Window frame;

		if (i==0) {

		    main = new JFrame(name);

		    // YURA:TODO while i still have not fixed the resizing
		    main.setResizable(false);

		    main.setIconImage( getIconImage() );
		    frame = main;

		    main.setContentPane( (ContainerPanel)w.elementAt(i) );

		}
		else {

		    frame = new JDialog(main,name);

		    // YURA:TODO while i still have not fixed the resizing
		    ((JDialog)frame).setResizable(false);

		    ((JDialog)frame).setContentPane( (ContainerPanel)w.elementAt(i) );

		}


		frame.setLocation( ((ContainerPanel)w.elementAt(i)).getPreferredLocation() );
		frame.pack();



		frame.addWindowListener(
		    new java.awt.event.WindowAdapter() {
			public void windowClosing(java.awt.event.WindowEvent evt) {
			    //System.out.print("EXIT\n");
			    rescue.closeCurrentMission();
			}
		    }
		);

		Windows.add(frame);

	    }
	    else {

		SFrame sframe = new SFrame( name ,(ContainerPanel)w.elementAt(i) );
		sframe.pack();

		// YURA:TODO while i still have not fixed the resizing
		sframe.setResizable(false);

		sframe.setDefaultCloseOperation(javax.swing.WindowConstants.HIDE_ON_CLOSE);
		sframe.setFrameIcon( new ImageIcon( getIconImage() ) );

		Windows.add( sframe );

		desktop.add( sframe );


		menuItem = new JMenuItem(name);
		//menuItem.setMnemonic(KeyEvent.VK_U);
		menuItem.setActionCommand("window "+i);
		menuItem.addActionListener(this);

		windowsMenu.add(menuItem);
	    }

	}

	if ( rescue.getMode() ) {

	    Window a;

	    for(int i=0; i< Windows.size() ; i++) {

		a = ((Window)Windows.elementAt(i));

		a.setVisible(true);

	    }

	    // does not work at the beggining of the game
	    setVisible(false);

	}
	else {

	    windowsMenu.addSeparator();

	    menuItem = new JMenuItem("Use Default Positions");
            menuItem.setMnemonic(KeyEvent.VK_U);
            //menuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
            //        KeyEvent.VK_N, ActionEvent.ALT_MASK));
            menuItem.setActionCommand("w default");
            menuItem.addActionListener(this);
	    windowsMenu.add(menuItem);
	    //menu.setEnabled(false);

	    defaultWindowPositions();

	    for(int i=0; i< inGameMenus.length ; i++) {
		inGameMenus[i].setEnabled(true);
	    }
	    for(int i=0; i< outGameMenus.length ; i++) {
		outGameMenus[i].setEnabled(false);
	    }

	}

	repaint();

    }
    public void closeGame() {

	if ( rescue.getMode() ) {

	    for(int i=0; i< Windows.size() ; i++) {

		((Window)Windows.elementAt(i)).setVisible(false);
		((Window)Windows.elementAt(i)).dispose();

	    }

	    setVisible(true);

	}
	else {

	    for(int i=0; i< Windows.size() ; i++) {

		((SFrame)Windows.elementAt(i)).dispose();

		desktop.remove( ((SFrame)Windows.elementAt(i)) );

	    }

	    windowsMenu.removeAll();

	    for(int i=0; i< inGameMenus.length ; i++) {
		inGameMenus[i].setEnabled(false);
	    }
	    for(int i=0; i< outGameMenus.length ; i++) {
		outGameMenus[i].setEnabled(true);
	    }

	}

	Windows = null;
	bigmap = null;

    }

    public void dead() {

	new Thread(this).start();
    }

    public void run() {

	try {
		Thread.sleep(1000);

	} catch (InterruptedException e) {}

	JFrame frame=this;

	if ( rescue.getMode() ) {

		frame = (JFrame)Windows.elementAt(0);

	}

	JOptionPane.showMessageDialog(frame, "You are dead!" , "Dead", JOptionPane.PLAIN_MESSAGE );

	rescue.closeCurrentMission();

    }

    // YURA: This method ONLY works when mode is FALSE
    public void defaultWindowPositions() {

	SFrame a;

	for(int i=0; i< Windows.size() ; i++) {

	    a = ((SFrame)Windows.elementAt(i));

	    a.setLocation( a.getPreferredLocation() );
	    a.setSize( a.getPreferredSize() );
	    a.setVisible(true);
	    try { a.setIcon( false ); } catch (Exception e) {}

	}

    }

    protected JMenuBar createMenuBar() {

        JMenuBar menuBar = new JMenuBar();

        //Set up the lone menu.
        JMenu menu;
        JMenuItem menuItem;
        JMenuItem menuItem2;







	menu = new JMenu("Game");
        menu.setMnemonic(KeyEvent.VK_G);

	menuItem = new JMenuItem("New");
        menuItem.setMnemonic(KeyEvent.VK_N);
        //menuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        //        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        menuItem.setActionCommand("new");
        menuItem.addActionListener(this);
	menu.add(menuItem);
	outGameMenus[0]=menuItem;

	menuItem = new JMenuItem("Pause");
        menuItem.setMnemonic(KeyEvent.VK_P);
        //menuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        //        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        menuItem.setActionCommand("pause");
        menuItem.addActionListener(this);
	menu.add(menuItem);
	inGameMenus[6]=menuItem;

	menuItem = new JMenuItem("End");
        menuItem.setMnemonic(KeyEvent.VK_E);
        //menuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        //        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        menuItem.setActionCommand("end");
        menuItem.addActionListener(this);
	menu.add(menuItem);
	inGameMenus[7]=menuItem;

	menu.addSeparator();

	menuItem = new JMenuItem("Preferences...");
        menuItem.setMnemonic(KeyEvent.VK_P);
        //menuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        //        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        menuItem.setActionCommand("preferences");
        menuItem.addActionListener(this);
	menu.add(menuItem);
	outGameMenus[5]=menuItem;

	menuItem = new JMenuItem("Mission Setup...");
        menuItem.setMnemonic(KeyEvent.VK_M);
        //menuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        //        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        menuItem.setActionCommand("mission");
        menuItem.addActionListener(this);
	menu.add(menuItem);
	outGameMenus[1]=menuItem;
/*
	menuItem = new JMenuItem("High Scores");
        menuItem.setMnemonic(KeyEvent.VK_H);
        //menuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        //        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        menuItem.setActionCommand("scores");
        menuItem.addActionListener(this);
	menu.add(menuItem);
*/
	menu.addSeparator();

        menuItem = new JMenuItem("Quit");
        menuItem.setMnemonic(KeyEvent.VK_Q);
        //menuItem.setAccelerator(KeyStroke.getKeyStroke(
        //        KeyEvent.VK_Q, ActionEvent.ALT_MASK));
        menuItem.setActionCommand("quit");
        menuItem.addActionListener(this);
	menu.add(menuItem);

        menuBar.add(menu);







	menu = new JMenu("Select");
        menu.setMnemonic(KeyEvent.VK_S);

	menuItem = new JMenuItem("All");
        menuItem.setMnemonic(KeyEvent.VK_A);
        //menuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        //        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        menuItem.setActionCommand("s all");
        menuItem.addActionListener(this);
	menu.add(menuItem);


	menuItem = new JMenuItem("Enemies");
        menuItem.setMnemonic(KeyEvent.VK_E);
        //menuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        //        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        menuItem.setActionCommand("s enemies");
        menuItem.addActionListener(this);
	menu.add(menuItem);


	menuItem = new JMenuItem("Manual");
        menuItem.setMnemonic(KeyEvent.VK_M);
        //menuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        //        KeyEvent.VK_M, ActionEvent.ALT_MASK));
        menuItem.setActionCommand("s manual");
        menuItem.addActionListener(this);
	menu.add(menuItem);

        menuBar.add(menu);
	inGameMenus[0]=menu;







	menu = new JMenu("Options");
        menu.setMnemonic(KeyEvent.VK_O);

	menuItem = new JMenu("Sound");
        menuItem.setMnemonic(KeyEvent.VK_S);
        //menuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        //        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        //menuItem.setActionCommand("s");
        //menuItem.addActionListener(this);
	menu.add(menuItem);

		//menuItem2





/*
	menuItem = new JMenu("Game Speed");
        menuItem.setMnemonic(KeyEvent.VK_G);
        //menuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        //        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        //menuItem.setActionCommand("g");
        //menuItem.addActionListener(this);
	menu.add(menuItem);

		//menuItem2
*/
	menu.addSeparator();

	menuItem = new JMenuItem("Heads Up Display");
        menuItem.setMnemonic(KeyEvent.VK_U);
        //menuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        //        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        menuItem.setActionCommand("heads");
        menuItem.addActionListener(this);
	menu.add(menuItem);

        menuBar.add(menu);
	inGameMenus[1]=menu;






/*
	menu = new JMenu("Computer");
        menu.setMnemonic(KeyEvent.VK_C);

	menuItem = new JMenu("Find");
        menuItem.setMnemonic(KeyEvent.VK_F);
        //menuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        //        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        //menuItem.setActionCommand("auto shields");
        //menuItem.addActionListener(this);
	menu.add(menuItem);

		menuItem2 = new JMenuItem("Nearest Outpost");
        	menuItem2.setMnemonic(KeyEvent.VK_O);
        	//menuItem2.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        	//        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        	menuItem2.setActionCommand("f outpost");
        	menuItem2.addActionListener(this);
		menuItem.add(menuItem2);

		menuItem2 = new JMenuItem("Nearest Starbase");
        	menuItem2.setMnemonic(KeyEvent.VK_S);
        	//menuItem2.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        	//        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        	menuItem2.setActionCommand("f starbase");
        	menuItem2.addActionListener(this);
		menuItem.add(menuItem2);

		menuItem2 = new JMenuItem("Nearest Enemy");
        	menuItem2.setMnemonic(KeyEvent.VK_E);
        	//menuItem2.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        	//        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        	menuItem2.setActionCommand("f enemy");
        	menuItem2.addActionListener(this);
		menuItem.add(menuItem2);

		menuItem2 = new JMenuItem("Nearest Wormhole");
        	menuItem2.setMnemonic(KeyEvent.VK_W);
        	//menuItem2.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        	//        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        	menuItem2.setActionCommand("f wormhole");
        	menuItem2.addActionListener(this);
		menuItem.add(menuItem2);

		((JMenu)menuItem).addSeparator();

		menuItem2 = new JCheckBoxMenuItem("Find Only Active Outposts");
        	menuItem2.setMnemonic(KeyEvent.VK_W);
        	//menuItem2.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        	//        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        	menuItem2.setActionCommand("f active");
        	menuItem2.addActionListener(this);
		menuItem.add(menuItem2);

	menuItem = new JMenu("Chase");
        menuItem.setMnemonic(KeyEvent.VK_C);
        //menuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        //        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        //menuItem.setActionCommand("auto shields");
        //menuItem.addActionListener(this);
	menu.add(menuItem);

		menuItem2 = new JMenuItem("Nearest Enemy");
        	menuItem2.setMnemonic(KeyEvent.VK_O);
        	//menuItem2.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        	//        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        	menuItem2.setActionCommand("c nearest");
        	menuItem2.addActionListener(this);
		menuItem.add(menuItem2);

		menuItem2 = new JMenuItem("Weakest Enemy");
        	menuItem2.setMnemonic(KeyEvent.VK_W);
        	//menuItem2.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        	//        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        	menuItem2.setActionCommand("c weakest");
        	menuItem2.addActionListener(this);
		menuItem.add(menuItem2);

		menuItem2 = new JMenuItem("Strongest Enemy");
        	menuItem2.setMnemonic(KeyEvent.VK_S);
        	//menuItem2.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        	//        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        	menuItem2.setActionCommand("c strongest");
        	menuItem2.addActionListener(this);
		menuItem.add(menuItem2);

		menuItem2 = new JMenuItem("Nearest Asteroid");
        	menuItem2.setMnemonic(KeyEvent.VK_W);
        	//menuItem2.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        	//        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        	menuItem2.setActionCommand("c asteroid");
        	menuItem2.addActionListener(this);
		menuItem.add(menuItem2);

		((JMenu)menuItem).addSeparator();

		menuItem2 = new JCheckBoxMenuItem("Fly With Nearest Friendly");
        	menuItem2.setMnemonic(KeyEvent.VK_F);
        	//menuItem2.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        	//        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        	menuItem2.setActionCommand("c fly");
        	menuItem2.addActionListener(this);
		menuItem.add(menuItem2);

	menu.addSeparator();

	menuItem = new JCheckBoxMenuItem("Auto Snap-On Shields");
        menuItem.setMnemonic(KeyEvent.VK_S);
        //menuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        //        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        menuItem.setActionCommand("auto shields");
        menuItem.addActionListener(this);
	menu.add(menuItem);

	menuItem = new JCheckBoxMenuItem("Auto Select Nearest Enemy");
        menuItem.setMnemonic(KeyEvent.VK_N);
        //menuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        //        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        menuItem.setActionCommand("auto enemy");
        menuItem.addActionListener(this);
	menu.add(menuItem);

	menu.addSeparator();

	menuItem = new JMenuItem("Set Auto-Destruct");
        menuItem.setMnemonic(KeyEvent.VK_A);
        //menuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        //        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        menuItem.setActionCommand("destruct");
        menuItem.addActionListener(this);
	menu.add(menuItem);

        menuBar.add(menu);
	inGameMenus[9]=menu; // when uncomenting this remember to set inGameMenus to have 10 elements
*/





	menu = new JMenu("Starfleet");
        menu.setMnemonic(KeyEvent.VK_S);

	menuItem = new JMenuItem("Dock With Starbase");
        menuItem.setMnemonic(KeyEvent.VK_W);
        //menuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        //        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        menuItem.setActionCommand("dock");
        menuItem.addActionListener(this);
	menu.add(menuItem);



	menuItem = new JMenuItem("Board Ship");
        menuItem.setMnemonic(KeyEvent.VK_B);
        //menuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        //        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        menuItem.setActionCommand("board");
        menuItem.addActionListener(this);
	menu.add(menuItem);



	menu.addSeparator();

	menuItem = new JMenuItem("Beam Team Down");
        menuItem.setMnemonic(KeyEvent.VK_D);
        //menuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        //        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        menuItem.setActionCommand("down");
        menuItem.addActionListener(this);
	menu.add(menuItem);

	menuItem = new JMenuItem("Beam Team Up");
        menuItem.setMnemonic(KeyEvent.VK_U);
        //menuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        //        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        menuItem.setActionCommand("up");
        menuItem.addActionListener(this);
	menu.add(menuItem);

	menu.addSeparator();

	menuItem = new JMenu("Evasive Maneuvers");
        menuItem.setMnemonic(KeyEvent.VK_E);
        //menuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        //        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        //menuItem.setActionCommand("auto shields");
        //menuItem.addActionListener(this);
	menu.add(menuItem);


		menuItem2 = new JMenuItem("Sequence Alpha 7");
        	menuItem2.setMnemonic(KeyEvent.VK_7);
        	//menuItem2.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        	//        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        	menuItem2.setActionCommand("evasive 1");
        	menuItem2.addActionListener(this);
		menuItem.add(menuItem2);

		menuItem2 = new JMenuItem("Sequence Omega 8");
        	menuItem2.setMnemonic(KeyEvent.VK_8);
        	//menuItem2.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        	//        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        	menuItem2.setActionCommand("evasive 2");
        	menuItem2.addActionListener(this);
		menuItem.add(menuItem2);

		menuItem2 = new JMenuItem("Sequence Delta 9");
        	menuItem2.setMnemonic(KeyEvent.VK_9);
        	//menuItem2.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        	//        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        	menuItem2.setActionCommand("evasive 3");
        	menuItem2.addActionListener(this);
		menuItem.add(menuItem2);


/*	// YURA:TODO DO THE COMUNICATION SYSTEM
	menu.addSeparator();

	menuItem = new JMenuItem("Communicate...");
        menuItem.setMnemonic(KeyEvent.VK_C);
        //menuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        //        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        menuItem.setActionCommand("communicate");
        menuItem.addActionListener(this);
	menu.add(menuItem);

	menuItem = new JMenuItem("Send Distress Signal");
        menuItem.setMnemonic(KeyEvent.VK_S);
        //menuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        //        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        menuItem.setActionCommand("distress");
        menuItem.addActionListener(this);
	menu.add(menuItem);
*/
        menuBar.add(menu);
	inGameMenus[3]=menu;







	menu = new JMenu("Engineering");
        menu.setMnemonic(KeyEvent.VK_E);
/*
	menuItem = new JCheckBoxMenuItem("Auto Prioritize Repairs");
        menuItem.setMnemonic(KeyEvent.VK_P);
        //menuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        //        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        menuItem.setActionCommand("prioritize");
        menuItem.addActionListener(this);
	menu.add(menuItem);

	menuItem = new JCheckBoxMenuItem("Recharge Phaser Banks");
        menuItem.setMnemonic(KeyEvent.VK_R);
        //menuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        //        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        menuItem.setActionCommand("recharge");
        menuItem.addActionListener(this);
	menu.add(menuItem);

	menu.addSeparator();
*/
	menuItem = new JMenuItem("Divert Phaser Energy");
        menuItem.setMnemonic(KeyEvent.VK_D);
        //menuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        //        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        menuItem.setActionCommand("divert");
        menuItem.addActionListener(this);
	menu.add(menuItem);

	menu.addSeparator();

	menuItem = new JMenuItem("Use Reserve Energy");
        menuItem.setMnemonic(KeyEvent.VK_U);
        //menuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        //        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        menuItem.setActionCommand("reserve");
        menuItem.addActionListener(this);
	menu.add(menuItem);

        menuBar.add(menu);
	inGameMenus[4]=menu;







	menu = new JMenu("Window");
        menu.setMnemonic(KeyEvent.VK_W);

	windowsMenu = menu;

        menuBar.add(menu);
	inGameMenus[5]=menu;






	menu = new JMenu("Help");
        menu.setMnemonic(KeyEvent.VK_H);

	menuItem = new JMenuItem("Help...");
        menuItem.setMnemonic(KeyEvent.VK_H);
        //menuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        //        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        menuItem.setActionCommand("help");
        menuItem.addActionListener(this);
	menu.add(menuItem);


	menuItem = new JMenuItem("About Rescue!");
        menuItem.setMnemonic(KeyEvent.VK_R);
        //menuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        //        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        menuItem.setActionCommand("aboutr");
        menuItem.addActionListener(this);
	menu.add(menuItem);


	menuItem = new JMenuItem("About Rescue! Max");
        menuItem.setMnemonic(KeyEvent.VK_A);
        //menuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(
        //        KeyEvent.VK_N, ActionEvent.ALT_MASK));
        menuItem.setActionCommand("about");
        menuItem.addActionListener(this);
	menu.add(menuItem);

        menuBar.add(menu);







        return menuBar;
    }

    /**
     * Exit the Application
     */
    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    private int counter=0;
    public void update() {

	try { // this is here so that a error in the gui updating does not crash the game

	    bigmap.repaint();

	    counter++;

	    if (counter>=10 || rescue.getPause() ) {

		for(int i=0; i< panels.size() ; i++) {
		    ((Component)panels.elementAt(i)).list();
		}
		counter=0;
	    }
	}
	catch(Exception e) {

	    System.out.print("error updating gui: "+e.getMessage()+"\n");

	    //e.printStackTrace();

	    counter=0;
	}

    }

    public void actionPerformed(ActionEvent e) {

	if (e.getActionCommand().equals("new")) {

	    rescue.loadCurrentMission();
	    return;

	}
	else if (e.getActionCommand().equals("end")) {

	    rescue.closeCurrentMission();
	    return;

	}
	else if (e.getActionCommand().equals("pause")) {

	    rescue.pause();
	    return;

	}
	else if (e.getActionCommand().equals("quit")) {

	    System.exit(0);
	    // return; // in case this is ever made into a applet

	}
	else if (e.getActionCommand().equals("zoomin")) {

	    rescue.zoom(true);

	}
	else if (e.getActionCommand().equals("zoomout")) {

	    rescue.zoom(false);

	}

	else if (e.getActionCommand().equals("s all")) {

	    rescue.setSelect( RunRescue.SELECT_ALL );

	}
	else if (e.getActionCommand().equals("s enemies")) {

	    rescue.setSelect( RunRescue.SELECT_ENEMIES );

	}
	else if (e.getActionCommand().equals("s manual")) {

	    rescue.setSelect( RunRescue.SELECT_MANUAL );

	}

	else if (e.getActionCommand().equals("heads")) {

	    rescue.headsUpDisplay();

	}
	else if (e.getActionCommand().equals("dock")) {

	    rescue.shipDock();

	}
	else if (e.getActionCommand().equals("board")) {

	    rescue.shipBoard();

	}
	else if (e.getActionCommand().equals("down")) {

	    rescue.shipBeamDown();

	}
	else if (e.getActionCommand().equals("up")) {

	    rescue.shipBeamUp();

	}
	else if (e.getActionCommand().equals("w default")) {

	    defaultWindowPositions();
	    return;
	}
	else if (e.getActionCommand().equals("mission")) {

	    MissionSetup mDialog = new MissionSetup(this, true, rescue );

	    mDialog.setVisible(true);
	    return;
	}
	else if (e.getActionCommand().equals("preferences")) {

	    PrefDialog aboutDialog = new PrefDialog(this, true, rescue, this);
	    Dimension frameSize = getSize();
	    Dimension aboutSize = aboutDialog.getPreferredSize();
	    int x = getLocation().x + (frameSize.width - aboutSize.width) / 2;
	    int y = getLocation().y + (frameSize.height - aboutSize.height) / 2;
	    if (x < 0) x = 0;
	    if (y < 0) y = 0;
	    aboutDialog.setLocation(x, y);

	    aboutDialog.setVisible(true);
	    return;
	}
	else if (e.getActionCommand().equals("about")) {

	    AboutDialog aboutDialog = new AboutDialog(this, true, NAME, RunRescue.VERSION );
	    Dimension frameSize = getSize();
	    Dimension aboutSize = aboutDialog.getPreferredSize();
	    int x = getLocation().x + (frameSize.width - aboutSize.width) / 2;
	    int y = getLocation().y + (frameSize.height - aboutSize.height) / 2;
	    if (x < 0) x = 0;
	    if (y < 0) y = 0;
	    aboutDialog.setLocation(x, y);

	    aboutDialog.setVisible(true);
	    return;
	}
	else if (e.getActionCommand().equals("aboutr")) {

	    JDialog aboutDialog = new JDialog( (JFrame)this,"Rescue!",true);

	    aboutDialog.getContentPane().add( new JLabel(new javax.swing.ImageIcon( this.getClass().getResource("credits.png") )) );
	    aboutDialog.setResizable(false);
	    aboutDialog.pack();

	    Dimension frameSize = getSize();
	    Dimension aboutSize = aboutDialog.getPreferredSize();
	    int x = getLocation().x + (frameSize.width - aboutSize.width) / 2;
	    int y = getLocation().y + (frameSize.height - aboutSize.height) / 2;
	    if (x < 0) x = 0;
	    if (y < 0) y = 0;
	    aboutDialog.setLocation(x, y);

	    aboutDialog.setVisible(true);
	    return;
	}
	else if (e.getActionCommand().equals("divert")) {

	    rescue.getShip().divertPhaser();

	}
	else if (e.getActionCommand().equals("reserve")) {

	    rescue.getShip().useReserve();

	}
	else if (e.getActionCommand().equals("help")) {

	    rescue.help();
	    return;
	}
	else if (e.getActionCommand().startsWith("evasive ")) {

	    int i = Integer.parseInt( e.getActionCommand().substring(8) );

	    rescue.getShip().setEvasive(i);

	}
	else if (e.getActionCommand().startsWith("window ")) {

	    int i = Integer.parseInt( e.getActionCommand().substring(7) );

	    ((SFrame)Windows.elementAt(i)).setVisible(true);
	    try { ((SFrame)Windows.elementAt(i)).setIcon( false ); ((SFrame)Windows.elementAt(i)).setSelected(true); } catch (Exception a) {}

	    return;

	}
	else {

	    System.out.print("unknown command "+e.getActionCommand()+"\n");
	    return;
	}

	rescue.updateGUI();

    }

    /**
     * This runs the program
     * @param argv
     */
    public static void main(String[] argv) {

	SimplePrintStream.catchErrors();

	SplashScreen ss = new SplashScreen();
	ss.setVisible(true);

	// set up system Look&Feel
	try {

/*	    // YURA gtk theme just fucks things up in the mission setup dialog

	    String os = System.getProperty("os.name");
	    String jv = System.getProperty("java.version");

            if ( jv.startsWith("1.4.2") && os != null && os.startsWith("Linux")) {
		UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
	    }
	    else {
		UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
	    }
*/

	    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());


	}
	catch (Exception e) {
	    e.printStackTrace();
	}

	RunRescue rr=null;

	try {

	    rr = new RunRescue();

	} catch(Exception e) {

	    StackTraceElement[] st = e.getStackTrace();

	    String info="";

	    for (int i = 0; i < st.length ; i++) {
		info = info + st[i] + "\n";
	    }

	    JOptionPane.showMessageDialog(null, "Error Loading default config file: " + e.getMessage() + "\n\n" + e.toString() + "\n" + info, "Load error!", JOptionPane.ERROR_MESSAGE );
	    System.exit(0);

	}

	if (rr!=null) {

	    RescueGUI gui = new RescueGUI(rr);

	    //rr.addRescueListener(gui);

            //Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            //Dimension frameSize = gui.getSize();
            //frameSize.height = ((frameSize.height > screenSize.height) ? screenSize.height : frameSize.height);
            //frameSize.width = ((frameSize.width > screenSize.width) ? screenSize.width : frameSize.width);
            //gui.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);

	    // getMaximizedBounds ?

	    gui.setExtendedState( JFrame.MAXIMIZED_BOTH );
            gui.setVisible(true);
	    Dimension d = gui.getSize();
	    gui.setExtendedState( JFrame.NORMAL );
	    gui.setSize(d);

	    rr.addRescueListener(gui);

	    ss.setVisible(false);
	    ss.dispose();

	    // after gui is created this thread becomes the main game thread
	    rr.run();

	}

    }

}
