package rescue;

import rescue.panels.*;
import rescue.spaceobjects.*;

import rescue.qdxml.DocHandler;
import rescue.qdxml.QDParser;

import java.util.Hashtable;
import java.util.Enumeration;

import java.io.FileReader;
import java.io.File;
import java.util.Vector;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JToolBar;
import javax.swing.JButton;
import javax.swing.JTextArea;
import javax.swing.JScrollPane;
import java.awt.Color;

/** 
  This class is the most basic possible
  implementation of the DocHandler class.
  It simply reports all events to System.out
  as they occur.
*/
public class MissionLoader implements DocHandler {

    private Vector MissionObjects;
    private Vector MissionWindows;
    //private MissionObject player;
    private Component bigmap;
    private String missionName;
    private RunRescue rescue;
    private Vector containers;
    private Vector panels;

    private MissionObject cmo;
    private ContainerPanel cmf;
    private InterfacePanel cip;
    private JToolBar ctb;
    private String path;

    private boolean cluster;
    private boolean external;

    private ShipsPanel shiplist;
    private ShipsPanel baselist;

    private ShipInfoPanel shipinfo;

    private JukeBox jukebox;

    public MissionLoader(String file,RunRescue r) throws Exception {

	jukebox = new JukeBox();

	rescue = r;

	MissionObjects = new Vector();
	MissionWindows = new Vector();
	containers = new Vector();
	panels = new Vector();

	File f = new File(file);
	path = f.getParent();

	//System.out.print(path+"\n");

	FileReader fr = new FileReader(f);
	QDParser.parse(this,fr);
	fr.close();

    }

    public ImageObject[] getSpaceObjects(Vector t) throws Exception {

	int a=0;
	for(int i=0; i< MissionObjects.size(); i++) {

	    a = a + ((MissionObject)MissionObjects.elementAt(i)).getNumber();

	}


	//Vector v = new Vector();
	ImageObject[] v = new ImageObject[a];

	a=0;
	for(int i=0; i< MissionObjects.size(); i++) {

	    a = ((MissionObject)MissionObjects.elementAt(i)).makeSpaceObjects(v,cluster,a,t);

	}

	// go though all the MissionObjects and set the Likes for all the Objects in that MissionObject
	for(int i=0; i< MissionObjects.size(); i++) {

	    ((MissionObject)MissionObjects.elementAt(i)).setLikes(v);

	}

	// since a new game is being started make sure that the current jukebox is from this mission
	jukebox.load();

	return v;

    }

    public boolean getExternal() {
	return external;
    }

    public void setExternal(boolean a) {
	external=a;
    }

    public String getMissionName() {
	return missionName;
    }

    public MissionObject getPlayerObject() { // this just gets the last object used (should be the player)
	return cmo;
    }
    public Vector getMissionObjects() {
	return MissionObjects;
    }
    public Component getBigMap() {
	return bigmap;
    }
    public Vector getPanels() {
	return panels;
    }

    public Vector getWindows() {
	return MissionWindows;
    }


    public ShipsPanel getShipList() {
	return shiplist;
    }
    public ShipsPanel getBaseList() {
	return baselist;
    }


    public void startElement(String elem,Hashtable h) throws Exception {
        //System.out.println("        start elem: "+elem);

	int mode=0;

	// ############### THESE SHOULD BE IN ORDER!!!!

	if (elem.equals("object")) {
	    mode=1;
	}
	else if (elem.equals("like")) {
	    mode=2;
	}
	else if (elem.equals("name")) {
	    mode=3;
	}
	else if (elem.equals("mission")) {
	    mode=4;
	}
	else if (elem.equals("options")) {
	    mode=5;
	}
	else if (elem.equals("preset")) {
	    mode=6;
	}

	// ############### INFO
	else if (elem.equals("maxtotalenergy")) {
	    mode=7;
	}
	else if (elem.equals("maxphaserbanks")) {
	    mode=8;
	}
	else if (elem.equals("maxtorpedosleft")) {
	    mode=9;
	}
	else if (elem.equals("maxshieldpower")) {
	    mode=10;
	}
	else if (elem.equals("maxwarp")) {
	    mode=11;
	}
	else if (elem.equals("maximpulse")) {
	    mode=12;
	}
	else if (elem.equals("jump")) {
	    mode=13;
	}
	else if (elem.equals("turn")) {
	    mode=14;
	}
	else if (elem.equals("maxphaserintensity")) {
	    mode=15;
	}
	else if (elem.equals("maxtorpedosalvo")) {
	    mode=16;
	}
	else if (elem.equals("maxtractorpower")) {
	    mode=17;
	}
	else if (elem.equals("maxcloakpower")) {
	    mode=18;
	}

	else if (elem.equals("spaceObjects")) {
	    mode=19;
	}

	// ############### END INFO - START GUI


	else if (elem.equals("container")) {
	    mode=101;
	}
	else if (elem.equals("toolbar")) {
	    mode=102;
	}
	else if (elem.equals("bigmap")) {
	    mode=103;
	}
	else if (elem.equals("button")) {
	    mode=104;
	}
	else if (elem.equals("separator")) {
	    mode=105;
	}
	else if (elem.equals("smallmap")) {
	    mode=106;
	}
	else if (elem.equals("text")) {
	    mode=107;
	}
	else if (elem.equals("shiplist")) {
	    mode=108;
	}
	else if (elem.equals("panel")) {
	    mode=109;
	}
	else if (elem.equals("image")) {
	    mode=110;
	}
	else if (elem.equals("color")) {
	    mode=111;
	}
	else if (elem.equals("infotext")) {
	    mode=112;
	}
	else if (elem.equals("infobar")) {
	    mode=113;
	}
	else if (elem.equals("baselist")) {
	    mode=114;
	}
	else if (elem.equals("shipinfo")) {
	    mode=115;
	}
	else if (elem.equals("guitheme")) {
	    mode=116;
	}
	else if (elem.equals("sound")) {
	    mode=117;
	}
	else if (elem.equals("names") || elem.equals("info") || elem.equals("likes") || elem.equals("sounds")) {
	    return;
	}
	else {
	    throw new Exception("unknown tag in xml file: "+elem);
	}

        Enumeration e = h.keys();
	String[] vals = new String[h.size()];
        while(e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = (String)h.get(key);
            //System.out.println("            "+key+" = "+val);

	    if (mode==4) {
		if (key.equals("name")) { vals[0]=val; }
	    }
	    else if (mode==1) {
		if (key.equals("name")) { vals[0]=val; }
		else if (key.equals("image")) { vals[1]=val; }
		else if (key.equals("number")) { vals[2]=val; }
		else if (key.equals("type")) { vals[3]=val; }
		else if (key.equals("small")) { vals[4]=val; }
		else if (key.equals("info")) { vals[5]=val; }
	    }
	    else if (mode==2) {
		if (key.equals("who")) { vals[0]=val; }
		else if (key.equals("amount")) { vals[1]=val; }
	    }
	    else if (mode==3) {
		if (key.equals("value")) { vals[0]=val; }
		else if (key.equals("image")) { vals[1]=val; }
	    }
	    else if (mode==5) {
		if (key.equals("min")) { vals[0]=val; }
		else if (key.equals("max")) { vals[1]=val; }
	    }
	    else if (mode==6) {
		if (key.equals("name")) { vals[0]=val; }
		else if (key.equals("value")) { vals[1]=val; }
	    }
	    else if (mode==7 || mode==8 || mode==9 || mode==10 || mode==11 || mode==12 || mode==13 || mode==14 || mode==15 || mode==16 || mode==17 || mode==18) {
		if (key.equals("value")) { vals[0]=val; }
	    }
	    else if (mode==19) {
		if (key.equals("cluster")) { vals[0]=val; }
	    }
	    else if (mode==102 || mode==103 || mode==106 || mode==107 || mode==109 || mode==101 || mode==108 || mode==114 || mode==115) {
		if (key.equals("constraints")) { vals[0]=val; }
		else if (key.equals("name")) { vals[0]=val; }
		else if (key.equals("x")) { vals[1]=val; }
		else if (key.equals("y")) { vals[2]=val; }
		else if (key.equals("w")) { vals[1]=val; }
		else if (key.equals("h")) { vals[2]=val; }

		// new type of panel creation
		else if (key.equals("nob")) { vals[1]=val; }
		else if (key.equals("on")) { vals[2]=val; }
		else if (key.equals("off")) { vals[3]=val; }
		else if (key.equals("up")) { vals[4]=val; }
		else if (key.equals("down")) { vals[5]=val; }
		else if (key.equals("map")) { vals[6]=val; }

	    }
	    else if (mode==104) {
		if (key.equals("name")) { vals[0]=val; }
		else if (key.equals("action")) { vals[1]=val; }
	    }
	    else if (mode==110) {
		if (key.equals("on")) { vals[0]=val; }
		else if (key.equals("off")) { vals[1]=val; }
		else if (key.equals("up")) { vals[2]=val; }
		else if (key.equals("down")) { vals[3]=val; }
		else if (key.equals("map")) { vals[4]=val; }
		else if (key.equals("nob")) { vals[5]=val; }
	    }
	    else if (mode==111) {
		if (key.equals("value")) { vals[0]=val; }
		else if (key.equals("action")) { vals[1]=val; }
		else if (key.equals("tooltip")) { vals[2]=val; }
	    }
	    else if (mode==112) {
		if (key.equals("type")) { vals[0]=val; }
		else if (key.equals("x")) { vals[1]=val; }
		else if (key.equals("y")) { vals[2]=val; }
		else if (key.equals("w")) { vals[3]=val; }
		else if (key.equals("h")) { vals[4]=val; }
		else if (key.equals("lx")) { vals[5]=val; }
		else if (key.equals("ly")) { vals[6]=val; }
		else if (key.equals("color")) { vals[7]=val; }
	    }
	    else if (mode==113) {
		if (key.equals("type")) { vals[0]=val; }
		else if (key.equals("x")) { vals[1]=val; }
		else if (key.equals("y")) { vals[2]=val; }
		else if (key.equals("w")) { vals[3]=val; }
		else if (key.equals("h")) { vals[4]=val; }
		else if (key.equals("direction")) { vals[5]=val; }
	    }
	    else if (mode==116) {
		if (key.equals("external")) { vals[0]=val; }
	    }
	    else if (mode==117) {
		if (key.equals("name")) { vals[0]=val; }
		else if (key.equals("file")) { vals[1]=val; }
	    }

        }

	if (mode==4) {
	    missionName=vals[0];
	}
	else if (mode==1) {
	    cmo = new MissionObject(vals[0],path+"/"+vals[1],path+"/"+vals[4],(vals.length==6)?(path+"/"+vals[5]):(null),vals[2],vals[3]);
	    MissionObjects.add( cmo );
	    //if (vals[3].equals("player")) { player=cmo; }
	}
	else if (mode==2) {
	    cmo.addLike(vals[0],vals[1]);
	}
	else if (mode==3) {
	    cmo.addName(vals[0], (( vals.length>1 )?( path+"/"+vals[1] ):( null )) );
	}
	else if (mode==5) {
	    cmo.setMinMax(vals[0],vals[1]);
	}
	else if (mode==6) {
	    cmo.setPreset(vals[0],vals[1]);
	}


	else if (mode==7) {
	    cmo.setInfoMaxTotalEnergy(vals[0]);
	}
	else if (mode==8) {
	    cmo.setInfoMaxPhaserBanks(vals[0]);
	}
	else if (mode==9) {
	    cmo.setInfoMaxTorpedosLeft(vals[0]);
	}
	else if (mode==10) {
	    cmo.setInfoMaxShieldPower(vals[0]);
	}

	else if (mode==11) {
	    cmo.setInfoWarp(vals[0]);
	}
	else if (mode==12) {
	    cmo.setInfoImpulse(vals[0]);
	}
	else if (mode==13) {
	    cmo.setInfoJump(vals[0]);
	}
	else if (mode==14) {
	    cmo.setInfoTurn(vals[0]);
	}
	else if (mode==15) {
	    cmo.setInfoPhaser(vals[0]);
	}
	else if (mode==16) {
	    cmo.setInfoTorpedos(vals[0]);
	}
	else if (mode==17) {
	    cmo.setInfoTractor(vals[0]);
	}
	else if (mode==18) {
	    cmo.setInfoCloak(vals[0]);
	}
	else if (mode==19) {

	    if (vals[0].equals("yes")) { cluster=true; }
	    else if (vals[0].equals("no")) { cluster=false; }
	    else { throw new Exception("unexpected value for cluster: "+vals[0]); }

	}
	else if (mode==101) {
	    if (cmf!=null) { containers.add(cmf); }

	    if (containers.isEmpty()) {
		cmf = new ContainerPanel(vals[0],vals[1],vals[2]);
		MissionWindows.add( cmf );
	    }
	    else {
		cmf = new ContainerPanel();
		((ContainerPanel)containers.lastElement()).add(cmf,vals[0]);
	    }
	}
	else if (mode==102) {
	    ctb = new JToolBar();
	    ctb.setRollover(true);
	    cmf.add(ctb, vals[0]);
	}


	else if (mode==103) {
	    cmf.add( bigmap = new BigMapPanel(rescue,Integer.parseInt(vals[1]),Integer.parseInt(vals[2])) , vals[0]);
	}
	else if (mode==106) {
	    SmallMapPanel tmp = new SmallMapPanel(rescue,Integer.parseInt(vals[1]),Integer.parseInt(vals[2]));
	    panels.add(tmp);
	    cmf.add( tmp , vals[0]);
	}
	else if (mode==109) {

	    if (vals.length==3) { cip = new InterfacePanel(rescue,Integer.parseInt(vals[1]),Integer.parseInt(vals[2])); }
	    else if (vals.length==7) {

		cip = new InterfacePanel(rescue);

	        cip.setupImages(path+"/"+vals[2],path+"/"+vals[3],path+"/"+vals[4],path+"/"+vals[5],path+"/"+vals[6],Integer.parseInt(vals[1]));

	    }
	    else { throw new Exception("abnormal number of parameters for panel creation.\nonly 3 or 7 is allowed"); }

	    panels.add(cip);
	    cmf.add( cip , vals[0]);
	}
	else if (mode==108) {
	    shiplist = new ShipsPanel(rescue,Integer.parseInt(vals[1]),Integer.parseInt(vals[2]),1);
	    panels.add(shiplist);
	    cmf.add( shiplist , vals[0]);
	}
	else if (mode==114) {
	    baselist = new ShipsPanel(rescue,Integer.parseInt(vals[1]),Integer.parseInt(vals[2]),2);
	    panels.add(baselist);
	    cmf.add( baselist , vals[0]);
	}

	else if (mode==104) {
	    JButton button = new JButton(vals[0]);
	    button.setActionCommand(vals[1]);
	    if (ctb!=null) { ctb.add( button ); }
	}
	else if (mode==105) {
	    if (ctb!=null) { ctb.addSeparator(); }
	}
	else if (mode==107) {

	    JTextArea text = new JTextArea("Welcome to Rescue! Max");
	    text.setBorder(null);
	    text.setBackground( Color.BLACK );
	    text.setForeground( Color.WHITE );
	    JScrollPane textScroll = new JScrollPane(text);
	    textScroll.setBorder(null);

	    Dimension size = new Dimension(Integer.parseInt(vals[1]),Integer.parseInt(vals[2]));

	    textScroll.setPreferredSize(size);
	    textScroll.setMinimumSize(size);
	    textScroll.setMaximumSize(size);

	    cmf.add( textScroll , vals[0]);

	}
	else if (mode==110) {

	    cip.setupImages(path+"/"+vals[0],path+"/"+vals[1],path+"/"+vals[2],path+"/"+vals[3],path+"/"+vals[4],Integer.parseInt(vals[5]));

	}
	else if (mode==111) {
	    cip.setCommandValue(vals[1],Integer.parseInt(vals[0]), ((vals.length>2)?(vals[2]):(null)) );
	}
	else if (mode==112) {
	    cip.setInfoText(vals[0],Integer.parseInt(vals[1]),Integer.parseInt(vals[2]),Integer.parseInt(vals[3]),Integer.parseInt(vals[4]),Integer.parseInt(vals[5]),Integer.parseInt(vals[6]),( (vals.length>7)?(getColor(vals[7])):(Color.BLACK) ) );
	}
	else if (mode==113) {
	    cip.setInfoBar(vals[0],Integer.parseInt(vals[1]),Integer.parseInt(vals[2]),Integer.parseInt(vals[3]),Integer.parseInt(vals[4]),vals[5] );
	}
	else if (mode==115) {
	    shipinfo = new ShipInfoPanel(Integer.parseInt(vals[1]),Integer.parseInt(vals[2]),rescue);
	    panels.add(shipinfo);
	    cmf.add( shipinfo , vals[0]);
	}
	else if (mode==116) {

	    if (vals[0].equals("yes")) { external=true; }
	    else if (vals[0].equals("no")) { external=false; }
	    else { throw new Exception("unexpected value for external: "+vals[0]); }

	}
	else if (mode==117) {

	    // dont want to be using old files any more as of 1.0.0.2 coz of new features
	    //if (vals.length == 0) { return; } // this is here for compatibility with the old mission files

	    jukebox.setUpSound( vals[0], path+"/"+vals[1] );
	}

    }



    public void endElement(String elem) {
        //System.out.println("        end elem: "+elem);

	//if (elem.equals("object")) {
	    //cmo=null; // SHOULD not be here as then the last object is not remembered
	//}
	if (elem.equals("container")) {
	    cmf=null;
	    if (!containers.isEmpty()) { cmf = (ContainerPanel)containers.lastElement(); containers.remove(cmf); }
	}
	else if (elem.equals("panel")) {
	    cip=null;
	}
	else if (elem.equals("toolbar")) {
	    ctb=null;
	}
    }



    public void text(String text) {
        //System.out.println("                text: "+text);
    }

    // Implementation of DocHandler is below this line
    public void startDocument() {
        //System.out.println("    start document");
    }
    public void endDocument() {
        //System.out.println("    end document");
    }

    public boolean getCluster() {
	return cluster;
    }

    public void setCluster(boolean a) {
	cluster=a;
    }

    public ShipInfoPanel getShipInfoPanel() {
	return shipinfo;
    }

    public static Color getColor(String s) throws Exception {

	if (s.equals("black"))      { return Color.BLACK; }
	if (s.equals("blue"))       { return Color.BLUE; }
	if (s.equals("cyan"))       { return Color.CYAN; }
	if (s.equals("darkgray"))   { return Color.DARK_GRAY; }
	if (s.equals("gray"))       { return Color.GRAY; }
	if (s.equals("green"))      { return Color.GREEN; }
	if (s.equals("lightgray"))  { return Color.LIGHT_GRAY; }
	if (s.equals("magenta"))    { return Color.MAGENTA; }
	if (s.equals("orange"))     { return Color.ORANGE; }
	if (s.equals("pink"))       { return Color.PINK; }
	if (s.equals("red"))        { return Color.RED; }
	if (s.equals("white"))      { return Color.WHITE; }
	if (s.equals("yellow"))     { return Color.YELLOW; }

	throw new Exception("unknown color "+s);
    }

}
