package rescue;

import sun.audio.*;
import java.io.FileInputStream;

public class JukeBox { // extends Thread

    public static JukeBox me;

    public static final int MOUSE_CLICK=0;
    public static final int WELCOME=1;
    public static final int MUSIC = 101;
    public static final int BACKGROUND = 102;

    public static void play(int a) { // this is used for all sounds
	me.playSound(a);
    }

    public static void stop(int a) { // this is used for sounds that are looped
	me.stopSound(a);
    }

    //################################ NON STATIC STUFF

    private ContinuousAudioDataStream music;
    private ContinuousAudioDataStream background;

    private AudioDataStream mouseclick;
    private AudioDataStream welcome;

    public void load() {
	me=this;

    }

    public void setUpSound(String a, String b) throws Exception { // ,String type

	AudioStream z = new AudioStream(new FileInputStream(b));

	if ( a.equals("music") || a.equals("background") ) { // looped sound

	    ContinuousAudioDataStream c = new ContinuousAudioDataStream( z.getData() );

	    if (a.equals("music")) {

		music = c;

	    }
	    else if (a.equals("background")) {

		background = c;

	    }

	}
	else {

	    AudioDataStream c = new AudioDataStream( z.getData() );

	    if (a.equals("mouseclick")) {

		mouseclick = c;

	    }
	    else if (a.equals("welcome")) {

		welcome = c;

	    }
	    else {

		throw new Exception("unknown sound name "+a);

	    }

	}

    }



    public AudioDataStream getSound(int a) {

	if (a==MOUSE_CLICK) {

	    return mouseclick;

	}
	else if (a==WELCOME) {

	    return welcome;

	}

	return null;

    }

    public ContinuousAudioDataStream getContinuousSound(int a) {

	if (a==MUSIC) {

	    return music;

	}
	else if (a==BACKGROUND) {

	    return background;

	}

	return null;

    }



    public void playSound(int a) {

	AudioDataStream b = getSound(a);
	ContinuousAudioDataStream c = getContinuousSound(a);

	if (b!=null) {
	    AudioPlayer.player.stop(b);
	    b.reset();
	    AudioPlayer.player.start(b);
	}
	else if (c!=null) {

	    AudioPlayer.player.start(c);
	}

    }

    public void stopSound(int a) {

	ContinuousAudioDataStream c = getContinuousSound(a);

	if (c!=null) {

	    AudioPlayer.player.stop( c );
	}
    }

}
