/*
 * Decompiled with CFR 0.152.
 */
package rescue.spaceobjects;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.Vector;
import rescue.JukeBox;
import rescue.RunRescue;
import rescue.spaceobjects.Base;
import rescue.spaceobjects.ImageObject;
import rescue.spaceobjects.MannedObject;

public class Ship
extends MannedObject {
    protected int systemWarpDrive = 0;
    protected int systemImpulseDrive = 0;
    protected boolean jump;
    protected boolean turn;
    protected Point autoImpulse;
    protected Point autoWarp;
    protected double manualImpulse = 0.0;
    protected double manualWarp = 0.0;
    protected int impulseSpeed;
    protected int warpSpeed;
    protected int speed = 0;
    protected double direction = 0.0;
    protected boolean autoImpulseOn = true;
    protected boolean autoWarpOn = true;
    protected boolean impulseOn = false;
    protected boolean warpOn = false;
    protected boolean stop = true;
    private int counter = 0;
    private int warpWormUpTime = 50;
    private int warpTurnSpeed = 25;
    protected MannedObject owner;
    protected int warpFactor;
    protected double impulseFactor;
    protected int evasive;
    protected boolean player;
    protected int systemLongRangeScan = 0;
    protected int systemSensorScan = 0;
    private int INFOmax_warp;
    private double INFOmax_impulse;
    private int SensorScan;
    private int fixPriority = 0;
    private boolean leftright;
    private int shootcounter = 0;

    public Ship(int n, String string, String string2, int n2, int n3, ImageObject[] imageObjectArray, BufferedImage bufferedImage, BufferedImage bufferedImage2, BufferedImage bufferedImage3, BufferedImage bufferedImage4, Vector vector) {
        super(n, string, string2, n2, n3, imageObjectArray, bufferedImage, bufferedImage2, bufferedImage3, bufferedImage4, vector);
    }

    public void setOwner(MannedObject mannedObject) {
        this.owner = mannedObject;
    }

    public void adjustSpeed(int n, int n2, double d) {
        if (d != this.direction && this.speed < 100 && this.speed > 0 && !Double.isNaN(d)) {
            if (this.turn) {
                double d2 = RunRescue.getTurn(d, this.direction);
                double d3 = Math.toRadians((double)(d2 > 0.0 ? 30 : -30) * (1.0 / ((double)this.speed * 3.0)));
                if (d3 > 0.0 && d3 > d2 || d3 < 0.0 && d3 < d2) {
                    d3 = d2;
                }
                this.direction += d3;
                if (this.direction < 0.0) {
                    this.direction += Math.toRadians(360.0);
                } else if (this.direction >= Math.toRadians(360.0)) {
                    this.direction -= Math.toRadians(360.0);
                }
            } else {
                this.direction = d;
            }
        }
        if (!this.stop && this.jump && this.warpOn && n < this.speed) {
            this.stop = true;
        } else if (!(this.stop || this.jump && !this.impulseOn || n >= Math.max(this.speed * this.speed / 2, 1))) {
            this.stop = true;
        }
        if (this.stop && this.speed > 0) {
            if (this.warpOn && this.jump) {
                this.speed = 1;
                this.counter = 0;
            }
            --this.speed;
        } else if ((this.direction - d > Math.toRadians(5.0) || this.direction - d < Math.toRadians(-5.0)) && (this.impulseOn && this.speed > 1 || this.warpOn && this.speed > this.warpTurnSpeed)) {
            if (this.warpOn && this.jump) {
                this.speed = this.warpTurnSpeed + 1;
            }
            --this.speed;
        } else if (this.speed > n2) {
            this.speed = this.warpOn && this.jump ? n2 : --this.speed;
        } else if (!this.stop && this.speed < n2) {
            if (this.warpOn && this.jump) {
                if (this.counter < this.warpWormUpTime) {
                    ++this.counter;
                    ++this.speed;
                } else if ((int)(this.direction * 1000.0) == (int)(d * 1000.0)) {
                    this.speed = n2;
                }
            } else {
                ++this.speed;
            }
        }
        if (this.stop && this.speed == 0 && this.impulseOn) {
            this.impulseOn = false;
            this.evasive = 0;
            if (this.player) {
                JukeBox.stop(102);
            }
        } else if (this.stop && this.speed == 0 && this.warpOn) {
            this.warpOn = false;
            if (this.player) {
                JukeBox.stop(102);
            }
        }
    }

    public int getSpeed() {
        return this.speed;
    }

    public void advanceShipLocation() {
        int n;
        int n2 = n = this.impulseOn ? (int)(this.impulseFactor * 4.0) : this.warpFactor * (this.warpFactor - 1) / 2 + 3;
        if (this.owner != null) {
            int n3 = (int)this.distance(this.owner);
            if (n3 > 250 || this.owner.getSystem(10) != 0) {
                this.owner.TractorShip(null);
            } else if (this.owner instanceof Ship && ((Ship)this.owner).getSpeed() > 0) {
                Point point = ((Ship)this.owner).moveTo();
                this.translate(point.x, point.y);
            } else if (n3 > 0) {
                this.autoImpulse = this.owner;
                this.autoImpulseOn = true;
                this.impulseOn = true;
                this.stop = false;
                this.adjustSpeed(n3, 1, this.getAngle(this.owner));
                Point point = this.moveTo();
                this.translate(point.x, point.y);
            }
        } else if (this.impulseOn) {
            if ((this.totalEnergy <= n || this.systemImpulseDrive != 0 || !this.alive) && this.alive) {
                this.stop = true;
            }
            if (this.evasive == 1) {
                this.adjustSpeed(1000000, this.impulseSpeed, this.direction + Math.toRadians(1.0));
            } else if (this.evasive == 2) {
                if (this.autoImpulse == null) {
                    this.autoImpulse = new Point(this.x + 50, this.y + 50);
                }
                if (this.distance(this.autoImpulse) > 500.0) {
                    this.manualImpulse = this.getAngle(this.autoImpulse) + Math.toRadians(10.0);
                    if (this.manualImpulse > Math.toRadians(360.0)) {
                        this.manualImpulse -= Math.toRadians(360.0);
                    }
                }
                this.adjustSpeed(1000000, this.impulseSpeed, this.manualImpulse);
            } else if (this.evasive == 3) {
                int n4 = (int)Math.round(Math.toDegrees(this.direction));
                if (n4 == 0 || n4 == 90 || n4 == 180 || n4 == 270 || n4 == 360) {
                    boolean bl = this.leftright = Math.random() < 0.5;
                }
                if (this.leftright) {
                    this.adjustSpeed(1000000, this.impulseSpeed, this.direction + Math.toRadians(-1.0));
                } else {
                    this.adjustSpeed(1000000, this.impulseSpeed, this.direction + Math.toRadians(1.0));
                }
            } else if (this.autoImpulseOn) {
                this.adjustSpeed((int)this.distance(this.autoImpulse), this.impulseSpeed, this.getAngle(this.autoImpulse));
            } else {
                this.adjustSpeed(1000000, this.impulseSpeed, this.manualImpulse);
            }
            Point point = this.moveTo();
            this.translate(point.x, point.y);
            if (!this.stop && this.alive) {
                this.totalEnergy -= n;
            }
        } else if (this.warpOn) {
            if (this.totalEnergy <= n || this.systemWarpDrive != 0 || !this.alive) {
                this.stop = true;
            }
            if (this.autoWarpOn) {
                this.adjustSpeed((int)this.distance(this.autoWarp), this.warpSpeed, this.getAngle(this.autoWarp));
            } else {
                this.adjustSpeed(1000000, this.warpSpeed, this.manualWarp);
            }
            Point point = this.moveTo();
            this.translate(point.x, point.y);
            if (!this.stop) {
                this.totalEnergy -= n;
            }
        }
    }

    public Point moveTo() {
        return new Point((int)Math.round((double)this.speed * Math.sin(this.direction)), -((int)Math.round((double)this.speed * Math.cos(this.direction))));
    }

    public void fixSystems() {
        int n;
        if (this.fixPriority == 0 || this.fixPriority != 0 && this.getSystem(this.fixPriority) == 0) {
            int n2;
            int[] nArray = new int[10];
            for (n2 = 0; n2 < nArray.length; ++n2) {
                nArray[n2] = this.getSystem(n2 + 1);
            }
            n2 = nArray[0];
            int n3 = 0;
            for (int i = 1; i < nArray.length; ++i) {
                if (nArray[i] >= n2) continue;
                n2 = nArray[i];
                n3 = i;
            }
            n = n3 + 1;
        } else {
            n = this.fixPriority;
        }
        if (this.getSystem(n) < 0) {
            this.fixSystem(n);
        }
    }

    public void fixSystem(int n) {
        if (n == 1) {
            ++this.systemWarpDrive;
            return;
        }
        if (n == 2) {
            ++this.systemImpulseDrive;
            return;
        }
        if (n == 3) {
            ++this.systemPhaserBanks;
            return;
        }
        if (n == 4) {
            ++this.systemTorpedoTubes;
            return;
        }
        if (n == 5) {
            ++this.systemLongRangeScan;
            return;
        }
        if (n == 6) {
            ++this.systemSensorScan;
            return;
        }
        if (n == 7) {
            ++this.systemShields;
            return;
        }
        if (n == 8) {
            ++this.systemComputer;
            return;
        }
        if (n == 9) {
            ++this.systemTransporters;
            return;
        }
        if (n == 10) {
            ++this.systemTractorBeam;
            return;
        }
        System.out.print("ERROR, asked to fix system " + n + "\n");
    }

    public String getSystemText(int n) {
        int n2 = this.getSystem(n);
        if (n2 == 0) {
            return "OK";
        }
        return -n2 + " rpr";
    }

    public int shipGetSystem(int n) {
        if (n == 1) {
            return this.systemWarpDrive;
        }
        if (n == 2) {
            return this.systemImpulseDrive;
        }
        if (n == 5) {
            return this.systemLongRangeScan;
        }
        if (n == 6) {
            return this.systemSensorScan;
        }
        return 100;
    }

    public void setPlayer(boolean bl) {
        this.player = bl;
    }

    public void setInfo(int n, double d, int n2, int n3) {
        this.INFOmax_warp = n;
        this.INFOmax_impulse = d;
        this.jump = n2 == 1;
        this.turn = n3 == 1;
        this.warpFactor = this.INFOmax_warp;
        this.impulseFactor = this.INFOmax_impulse;
        this.warpSpeed = (int)(10.0 * Math.pow(this.warpFactor, 3.3333333333333335));
        this.impulseSpeed = (int)(10.0 * this.impulseFactor);
    }

    public int shipDamage(int n, int n2) {
        if (n == 1) {
            this.systemWarpDrive -= n2;
            if (this.systemWarpDrive < -10) {
                n2 -= this.systemWarpDrive + 10;
                this.systemWarpDrive = -10;
            }
        } else if (n == 2) {
            this.systemImpulseDrive -= n2;
            if (this.systemImpulseDrive < -10) {
                n2 -= this.systemImpulseDrive + 10;
                this.systemImpulseDrive = -10;
            }
        } else if (n == 5) {
            this.systemLongRangeScan -= n2;
            if (this.systemLongRangeScan < -10) {
                n2 -= this.systemLongRangeScan + 10;
                this.systemLongRangeScan = -10;
            }
        } else if (n == 6) {
            this.systemSensorScan -= n2;
            if (this.systemSensorScan < -10) {
                n2 -= this.systemSensorScan + 10;
                this.systemSensorScan = -10;
            }
        }
        return n2;
    }

    public int shipGetLifeInfo() {
        return this.systemWarpDrive + this.systemImpulseDrive + this.systemLongRangeScan + this.systemSensorScan;
    }

    public void drawBigShape(Graphics graphics, boolean bl) {
        if (this.player && this.autoImpulse != null) {
            graphics.setColor(Color.WHITE);
            graphics.drawLine(this.autoImpulse.x + 2, this.autoImpulse.y + 2, this.autoImpulse.x - 2, this.autoImpulse.y - 2);
            graphics.drawLine(this.autoImpulse.x + 2, this.autoImpulse.y - 2, this.autoImpulse.x - 2, this.autoImpulse.y + 2);
        }
        if (this.alive) {
            if (this.turn) {
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                graphics2D.rotate(this.direction, this.x, this.y);
                graphics2D.drawImage((Image)this.image, this.x - this.image.getWidth() / 2, this.y - this.image.getHeight() / 2, null);
            } else {
                graphics.drawImage(this.image, this.x - this.image.getWidth() / 2, this.y - this.image.getHeight() / 2, null);
            }
        }
        super.drawBigShape(graphics, bl);
    }

    public void drawSmallShape(Graphics graphics, double d, double d2, int n) {
        if (this.player) {
            graphics.setColor(Color.DARK_GRAY);
            graphics.drawOval((int)((double)this.x * d) - 4, (int)((double)this.y * d2) - 4, 8, 8);
            if (this.autoWarp != null) {
                graphics.setColor(Color.WHITE);
                graphics.drawLine((int)((double)this.autoWarp.x * d) + 1, (int)((double)this.autoWarp.y * d2) + 1, (int)((double)this.autoWarp.x * d) - 1, (int)((double)this.autoWarp.y * d2) - 1);
                graphics.drawLine((int)((double)this.autoWarp.x * d) + 1, (int)((double)this.autoWarp.y * d2) - 1, (int)((double)this.autoWarp.x * d) - 1, (int)((double)this.autoWarp.y * d2) + 1);
            }
        }
        super.drawSmallShape(graphics, d, d2, n);
    }

    public void stop() {
        this.stop = true;
    }

    public void setEvasive(int n) {
        if (!this.warpOn) {
            this.evasive = n;
            this.impulseOn = true;
            this.stop = false;
        }
    }

    public int getEvasive() {
        return this.evasive;
    }

    public void useReserve() {
        int n = this.INFOmax_totalenergy - this.totalEnergy;
        if (n >= this.reserve) {
            this.totalEnergy += this.reserve;
            this.reserve = 0;
        } else {
            this.totalEnergy += n;
            this.reserve -= n;
        }
    }

    public void divertPhaser() {
        int n = this.INFOmax_totalenergy - this.totalEnergy;
        if (n >= this.phaserBanks) {
            this.totalEnergy += this.phaserBanks;
            this.phaserBanks = 0;
        } else {
            this.totalEnergy += n;
            this.phaserBanks -= n;
        }
    }

    public void setFixPriority(int n) {
        this.fixPriority = n;
    }

    public void setScan(boolean bl) {
        if (bl && this.SensorScan < 3) {
            ++this.SensorScan;
            return;
        }
        if (!bl && this.SensorScan > 0) {
            --this.SensorScan;
            return;
        }
    }

    public void sendPeople(Ship ship) {
        ship.addPeople(this.people);
        this.people = 0;
    }

    public void shipDockWith(MannedObject mannedObject) {
        this.totalEnergy += mannedObject.getEnergy(this.INFOmax_totalenergy - this.totalEnergy);
        this.phaserBanks += mannedObject.getPhaser(this.INFOmax_phaserbanks - this.phaserBanks);
        this.torpedosLeft += mannedObject.getTorpedos(this.INFOmax_torpedosleft - this.torpedosLeft);
        if (mannedObject instanceof Base) {
            mannedObject.addPeople(this.people);
            this.people = 0;
            this.shieldPower = this.INFOmax_shieldsPower;
            for (int i = 0; this.checkFixNeeded() && i < 10; ++i) {
                this.fixSystems();
            }
        }
    }

    public void setTarget(int n) {
        this.target = n;
    }

    public void changeShields() {
        this.ShieldsUp = !this.ShieldsUp;
    }

    public void setAutoImpulse(Point point) {
        if (!this.warpOn) {
            this.autoImpulse = point;
            this.autoImpulseOn = true;
            this.evasive = 0;
        }
    }

    public void setAutoWarp(Point point) {
        this.autoWarp = point;
        this.autoWarpOn = true;
        this.evasive = 0;
    }

    public void setManImpulse(double d) {
        this.manualImpulse = d;
        this.evasive = 0;
    }

    public void setManWarp(double d) {
        this.manualWarp = d;
        this.evasive = 0;
    }

    public void setAutoImpulseOn(boolean bl) {
        if (bl && this.impulseOn && this.autoImpulse == null) {
            return;
        }
        this.autoImpulseOn = bl;
    }

    public void setAutoWarpOn(boolean bl) {
        if (bl && this.warpOn && this.autoWarp == null) {
            return;
        }
        this.autoWarpOn = bl;
    }

    public void setImpulseFactor(int n) {
        if ((double)n / 4.0 <= this.INFOmax_impulse) {
            this.impulseFactor = (double)n / 4.0;
            this.impulseSpeed = (int)(10.0 * this.impulseFactor);
        }
    }

    public void setImpulseUpDown(boolean bl) {
        if (bl && this.impulseFactor == this.INFOmax_impulse || !bl && this.impulseFactor == 0.25) {
            return;
        }
        this.impulseFactor = bl ? (this.impulseFactor += 0.25) : (this.impulseFactor -= 0.25);
        this.impulseSpeed = (int)(10.0 * this.impulseFactor);
    }

    public void setWarpFactor(int n) {
        if (n <= this.INFOmax_warp) {
            this.warpFactor = n;
            this.warpSpeed = (int)(10.0 * Math.pow(this.warpFactor, 3.3333333333333335));
        }
    }

    public void setWarpUpDown(boolean bl) {
        if (bl && this.warpFactor == this.INFOmax_warp || !bl && this.warpFactor == 1) {
            return;
        }
        this.warpFactor = bl ? ++this.warpFactor : --this.warpFactor;
        this.warpSpeed = (int)(10.0 * Math.pow(this.warpFactor, 3.3333333333333335));
    }

    public void setTorpedoSalvo(int n) {
        if (n <= this.INFOmax_torpedoSalvo) {
            this.TorpedoSalvo = n;
        }
    }

    public void setTorpedoSalvoUpDown(boolean bl) {
        if (bl && this.TorpedoSalvo < this.INFOmax_torpedoSalvo) {
            ++this.TorpedoSalvo;
        } else if (!bl && this.TorpedoSalvo > 1) {
            --this.TorpedoSalvo;
        }
    }

    public void setPhaserIntensity(int n) {
        if (n <= this.INFOmax_phaserIntensity) {
            this.phaserIntensity = n;
        }
    }

    public void setPhaserIntensityUpDown(boolean bl) {
        if (bl && this.phaserIntensity < this.INFOmax_phaserIntensity) {
            ++this.phaserIntensity;
        } else if (!bl && this.phaserIntensity > 1) {
            --this.phaserIntensity;
        }
    }

    public void setImpulseOn(boolean bl) {
        if (bl) {
            if (!(this.warpOn || this.autoImpulseOn && this.autoImpulse == null)) {
                this.impulseOn = true;
                this.stop = false;
                JukeBox.play(102);
            }
        } else if (this.impulseOn) {
            this.stop = true;
        }
    }

    public void setWarpOn(boolean bl) {
        if (bl) {
            if (!this.autoWarpOn || this.autoWarp != null) {
                this.impulseOn = false;
                this.warpOn = true;
                this.stop = false;
                JukeBox.play(102);
            }
        } else if (this.warpOn) {
            this.stop = true;
        }
    }

    public int getCondition() {
        if (this.getLifeInfo() != 0 || this.shieldPower != this.INFOmax_shieldsPower) {
            return 3;
        }
        int n = 1000;
        int n2 = this.SpaceObjects.length - 1;
        for (int i = 0; i < n2; ++i) {
            if (!(this.SpaceObjects[i] instanceof MannedObject) || !((MannedObject)this.SpaceObjects[i]).isAlive() || !(this.distance(this.SpaceObjects[i]) < (double)n) || this.SpaceObjectsLikes[i] >= 0) continue;
            return 2;
        }
        return 1;
    }

    public int getManImpulse() {
        return (int)Math.round(Math.toDegrees(this.manualImpulse));
    }

    public int getManWarp() {
        return (int)Math.round(Math.toDegrees(this.manualWarp));
    }

    public int getFixPriority() {
        return this.fixPriority;
    }

    public String getScan() {
        if (this.systemSensorScan == 0) {
            if (this.SensorScan == 0) {
                return "OFF";
            }
            if (this.SensorScan == 1) {
                return "MIN";
            }
            if (this.SensorScan == 2) {
                return "MED";
            }
            if (this.SensorScan == 3) {
                return "MAX";
            }
            return this.SensorScan + "";
        }
        return "XXX";
    }

    public int getSensorScan() {
        if (this.systemSensorScan == 0) {
            return this.SensorScan;
        }
        return 0;
    }

    public Ship getTractoredShip() {
        return this.tractoredShip;
    }

    public int getNoColonies() {
        return this.people;
    }

    public int getTarget() {
        return this.target;
    }

    public boolean getShieldsUp() {
        return this.ShieldsUp;
    }

    public double getSpeedMofC() {
        return (double)this.speed / 10.0;
    }

    public double getDirection() {
        return this.direction;
    }

    public Point getAutoImpulse() {
        return this.autoImpulse;
    }

    public Point getAutoWarp() {
        return this.autoWarp;
    }

    public boolean getAutoImpulseOn() {
        return this.autoImpulseOn;
    }

    public boolean getAutoWarpOn() {
        return this.autoWarpOn;
    }

    public String getImpulseSpeed() {
        if (this.systemImpulseDrive == 0) {
            if (this.impulseFactor == 0.25) {
                return "1/4";
            }
            if (this.impulseFactor == 0.5) {
                return "1/2";
            }
            if (this.impulseFactor == 0.75) {
                return "3/4";
            }
            if (this.impulseFactor == 1.0) {
                return "MAX";
            }
            return this.impulseFactor + "";
        }
        return "XXX";
    }

    public String getWarpSpeed() {
        if (this.systemWarpDrive == 0) {
            return this.warpFactor + "";
        }
        return "XXX";
    }

    public int getWarpFactor() {
        return this.warpFactor;
    }

    public double getImpulseFactor() {
        return this.impulseFactor;
    }

    public boolean getImpulseOn() {
        return this.impulseOn;
    }

    public boolean getWarpOn() {
        return this.warpOn;
    }

    public String getTorpedoSalvo() {
        if (this.systemTorpedoTubes == 0) {
            return this.TorpedoSalvo + "";
        }
        return "XXX";
    }

    public String getPhaserIntensity() {
        if (this.systemPhaserBanks == 0) {
            if (this.phaserIntensity == 1) {
                return "MIN";
            }
            if (this.phaserIntensity == 2) {
                return "MED";
            }
            if (this.phaserIntensity == 3) {
                return "MAX";
            }
            return this.phaserIntensity + "";
        }
        return "XXX";
    }

    public int getPhaserIntensityInt() {
        return this.phaserIntensity;
    }

    public int getTorpedoSalvoInt() {
        return this.TorpedoSalvo;
    }

    public int tractorEnergyUsed(int n) {
        if (this.SpaceObjectsLikes[this.owner.getNumber()] > 0 || this.systemImpulseDrive != 0) {
            return 10;
        }
        int n2 = (int)((double)(n - 10) * (this.distance(this.owner) / 250.0));
        if (this.totalEnergy < n2) {
            return 10;
        }
        this.totalEnergy -= n2;
        return n2 += 10;
    }

    public void advance() {
        if (this.alive && !this.player) {
            MannedObject mannedObject = null;
            int n = 0;
            int n2 = 1000000000;
            int n3 = 0;
            for (int i = 0; i < this.SpaceObjectsLikes.length; ++i) {
                n3 = this.SpaceObjectsLikes[i];
                if (!(this.SpaceObjects[i] instanceof MannedObject) || !((MannedObject)this.SpaceObjects[i]).isAlive() || n3 >= n && (n3 >= 0 || n3 > n || (int)this.distance(this.SpaceObjects[i]) >= n2)) continue;
                n = this.SpaceObjectsLikes[i];
                mannedObject = (MannedObject)this.SpaceObjects[i];
                n2 = (int)this.distance(mannedObject);
            }
            if (mannedObject != null) {
                if (n2 > 1000) {
                    if (this.impulseOn) {
                        this.impulseOn = false;
                    }
                    this.autoWarp = mannedObject;
                    this.warpOn = true;
                    this.stop = false;
                } else if (n2 > 500) {
                    if (this.warpOn) {
                        this.stop = true;
                    } else {
                        this.autoImpulse = mannedObject;
                        this.autoImpulseOn = true;
                        this.impulseOn = true;
                        this.stop = false;
                    }
                } else {
                    if (this.autoImpulseOn) {
                        this.manualImpulse = this.getAngle(mannedObject) + Math.toRadians(10.0);
                        if (this.manualImpulse > Math.toRadians(360.0)) {
                            this.manualImpulse -= Math.toRadians(360.0);
                        }
                        this.autoImpulseOn = false;
                        this.impulseOn = true;
                        this.stop = false;
                    }
                    if (this.shootcounter == 0 && n2 <= 500 && n2 > 250) {
                        this.FireTorpedo(mannedObject);
                        ++this.shootcounter;
                    } else if (this.shootcounter == 0 && n2 <= 250) {
                        this.FirePhaser(mannedObject);
                        ++this.shootcounter;
                    }
                    if (this.shootcounter != 0) {
                        ++this.shootcounter;
                    }
                    if (this.shootcounter == 100) {
                        this.shootcounter = 0;
                    }
                }
            } else {
                this.stop = true;
            }
        } else if (!this.alive && this.impulseOn && this.autoImpulseOn) {
            this.manualImpulse = this.direction;
            this.autoImpulseOn = false;
        }
        this.advanceShipLocation();
        super.advance();
    }
}

