/*
 * Decompiled with CFR 0.152.
 */
package rescue.spaceobjects;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.util.Vector;
import rescue.spaceobjects.ImageObject;
import rescue.spaceobjects.SpaceObject;

public class ParticleEffect
extends SpaceObject {
    private Color c = null;
    private boolean heavy = false;
    private double xdirection;
    private double ydirection;
    private boolean infinite = false;
    private int age = 0;
    private int number = 0;
    private int created = 0;
    private int finished = 0;
    private int release = 1;
    private double spread = 0.0;
    private Point2D attach;
    private Particle[] particles = null;
    private int attach_xoff;
    private int attach_yoff;

    public void attach(Point2D point2D, int n, int n2) {
        this.attach = point2D;
        this.attach_xoff = n;
        this.attach_yoff = n2;
    }

    public ParticleEffect(int n, int n2, ImageObject[] imageObjectArray, Vector vector, int n3, Color color, double d, double d2, double d3, int n4, boolean bl, int n5) {
        super(n, n2, imageObjectArray, vector);
        this.number = n3;
        this.release = n5;
        this.spread = d2;
        this.heavy = false;
        this.c = color;
        this.xdirection = d;
        this.ydirection = d3;
        this.age = n4;
        this.infinite = bl;
        this.particles = new Particle[n3];
    }

    public boolean finished() {
        if (this.infinite) {
            return false;
        }
        return this.finished == this.number;
    }

    public Particle makeParticle() {
        double d = Math.random() * this.xdirection + Math.random() * this.spread * 2.0 - this.spread;
        double d2 = Math.random() * this.ydirection + Math.random() * this.spread * 2.0 - this.spread;
        double d3 = this.x;
        double d4 = this.y;
        if (this.attach != null) {
            d3 = this.attach.getX() + (double)this.attach_xoff;
            d4 = this.attach.getY() + (double)this.attach_yoff;
        }
        return new Particle(d3, d4, d, d2);
    }

    public void makeParticles() {
        if (this.created < this.number) {
            int n = 0;
            while (this.created < this.number && n < this.release) {
                ++n;
                this.particles[this.created] = this.makeParticle();
                ++this.created;
            }
        }
    }

    public void drawBigShape(Graphics graphics, boolean bl) {
        graphics.setColor(this.c);
        for (int i = 0; i < this.particles.length; ++i) {
            if (this.particles[i] == null || this.particles[i].getAge() >= this.age) continue;
            this.particles[i].draw(graphics);
        }
    }

    public void advance() {
        this.makeParticles();
        for (int i = 0; i < this.particles.length; ++i) {
            if (this.particles[i] == null) continue;
            if (this.particles[i].getAge() < this.age) {
                this.particles[i].move();
                continue;
            }
            if (this.infinite) {
                this.particles[i] = this.makeParticle();
                continue;
            }
            ++this.finished;
            this.particles[i] = null;
        }
        if (this.finished()) {
            this.torpedos.remove(this);
        }
    }

    public class Particle {
        private double x;
        private double y;
        private double xdirection;
        private double ydirection;
        private int age = 0;

        public Particle(double d, double d2, double d3, double d4) {
            this.x = d;
            this.y = d2;
            this.xdirection = d3;
            this.ydirection = d4;
        }

        public void move() {
            this.x += this.xdirection;
            this.y += this.ydirection;
            ++this.age;
        }

        public int getAge() {
            return this.age;
        }

        public void draw(Graphics graphics) {
            graphics.drawRect((int)this.x, (int)this.y, 1, 1);
        }
    }
}

