/*
 * Decompiled with CFR 0.152.
 */
package rescue.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import rescue.RunRescue;
import rescue.gui.RescueGUI;

public class PrefDialog
extends JDialog
implements ActionListener {
    private RunRescue rescue;
    private RescueGUI gui;
    private JCheckBox inout;
    private JSpinner delay;

    public PrefDialog(Frame frame, boolean bl, RunRescue runRescue, RescueGUI rescueGUI) {
        super(frame, "Preferences", bl);
        this.rescue = runRescue;
        this.gui = rescueGUI;
        this.initGUI();
        this.pack();
    }

    private void initGUI() {
        this.setResizable(false);
        JButton jButton = new JButton("Cancel");
        jButton.setActionCommand("cancel");
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("OK");
        jButton2.setActionCommand("ok");
        jButton2.addActionListener(this);
        JPanel jPanel = new JPanel(new BorderLayout(20, 20));
        jPanel.add((Component)jButton, "West");
        jPanel.add((Component)jButton2, "East");
        this.inout = new JCheckBox("Use External Frames", this.rescue.getMode());
        JPanel jPanel2 = new JPanel();
        this.delay = new JSpinner();
        this.delay.setValue(new Integer(this.rescue.getDelay()));
        jPanel2.add(new JLabel("Delay in milliseconds:"));
        jPanel2.add(this.delay);
        this.getContentPane().add((Component)this.inout, "North");
        this.getContentPane().add((Component)jPanel2, "Center");
        this.getContentPane().add((Component)jPanel, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PrefDialog.this.closeDialog();
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("ok")) {
            this.rescue.setMode(this.inout.isSelected());
            this.rescue.setDelay((Integer)this.delay.getValue());
        } else if (actionEvent.getActionCommand().equals("cancel")) {
            // empty if block
        }
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

