define(["jquery",
        "core.events.bis",
        "components.tooltip",
        "text!templates/jsTooltip.htm"],
        function(jQuery, events, JSTooltip, jsTooltipText) {

        describe("components.tooltip", function() {
            var tooltip, element, clock;

            beforeEach(function() {
                setTemplates(jsTooltipText);
                element = jQuery("#sampleElement");
                tooltip = new JSTooltip($(element.get(0)), {text: "Hi all!"});
                clock = sinon.useFakeTimers();
            });

            afterEach(function() {
                tooltip.hide();
                clock.restore()
            });

            it("should create tooltip", function() {
                expect(tooltip).toBeDefined();
            });

            it("show should display tooltip", function() {
                expect(tooltip._element).toBeFalsy();

                tooltip.show();

                expect(tooltip._element).toBeDefined();
                expect(jQuery(tooltip._element)).toBeVisible();
            });

            it("hide should remove tooltip element", function() {
                tooltip.show();
                var tooltipElementId = tooltip._element.getAttribute("id");

                expect(jQuery("#" + tooltipElementId).size()).toBe(1);
                expect(jQuery(".tooltip")).toBeVisible();

                tooltip.hide();

                expect(jQuery("#" + tooltipElementId).size()).toBe(1);
                expect(jQuery(".tooltip")).not.toBeVisible();
            });

            it("mouseover should display tooltip", function() {
                expect(jQuery(".tooltip")).not.toBeVisible();

                jQuery("#sampleElement").simulate("mouseover");

                clock.tick(1000);

                expect(jQuery(".tooltip")).toBeVisible();
            });

            it("mouseout should hide tooltip", function() {
                tooltip.show();
                expect(jQuery(".tooltip")).toBeVisible();

                jQuery("#sampleElement").simulate("mouseout");

                expect(jQuery(".tooltip")).not.toBeVisible();
            });

            it("click on element should hide its tooltip", function() {
                expect(jQuery(".tooltip")).not.toBeVisible();

                tooltip.show();
                expect(jQuery(".tooltip")).toBeVisible();

                jQuery("#sampleElement").trigger("click");
                expect(jQuery(".tooltip")).not.toBeVisible();
            });

            it("cleanUp hide remove tooltip on element removal", function() {
                tooltip.show();
                var tooltipElementId = tooltip._element.getAttribute("id");

                expect(jQuery("#" + tooltipElementId).size()).toBe(1);
                expect(jQuery(".tooltip")).toBeVisible();

                jQuery("#sampleElement").remove();
                tooltipModule.cleanUp();

                expect(jQuery("#" + tooltipElementId).size()).toBe(1);
                expect(jQuery(".tooltip")).not.toBeVisible();
            });
        });
    });