define(["jquery", "underscore", "backbone", "components.systemnotificationview", "components.dialogs"],
    function ($, _, Backbone, SystemNotificationView, dialogs) {

    describe("SystemNotificationView", function () {

        beforeEach(function () {
            jasmine.getFixtures().set("<div id='controls'></div>");
        });

       describe("Rendering", function () {

            var view;

            beforeEach(function () {
                view = new SystemNotificationView({collection:new Backbone.Collection()});
            });

            describe("Show and hide functionality", function(){

                it("can show success message", function () {
                    var spy  = sinon.stub(dialogs.systemConfirm, "show");
                    view.showNotification("blablal");
                    expect(spy).toHaveBeenCalledWith("blablal", view.PSEUDO_INFINITY_DELAY);
                    dialogs.systemConfirm.show.restore();
                });

            });
       });

    });


});
