define(["jquery", "underscore", "components.authoritymodel","components.authoritypickerview", "tests/data/authority.data"],
function ($, _, AuthorityModel, AuthorityPickerView, mocks) {

    describe("Authority picker view", function () {
        var view, server, model;

        beforeEach(function () {
            sinon.stub($, "ajax");
            model = AuthorityModel.instance("rest_v2/roles");
            model.attributes.items = mocks.rolesRest.role;
            view = new AuthorityPickerView({model:model,
                customClass:"selectedRoles",
                title:"Select role"});
        });

        afterEach(function(){
            $.ajax.restore();
        });

        it("should initialize and do basic render", function () {
            expect(view.render().el).toBeTruthy();
            expect(view.render().subEl).toBeTruthy();
        });

        it("should be notified if server error occurs", function () {
            var callback = sinon.spy();

            view.on("error:server", callback);

            model.trigger("error:server");

            expect(callback.calledOnce).toBeTruthy();
        });

        it("should render options", function () {
            view.render();

            expect(view.$el.find("li").length).toEqual(0);

            model.trigger("change");

            expect(view.$el.find("li").length).toEqual(mocks.rolesRest.role.length);

        });

        it("should return list of selected elements", function () {
            view.render();

            model.trigger("change");

            jQuery(view.$el.find("li")[3]).addClass("selected");
            expect(view.getSelected().length).toEqual(1);

        });

        it("should empty array if no selected elements", function () {
            view.render();

            model.trigger("change");

            expect(view.getSelected().length).toEqual(0);
        });

        it("should trigger event that selection was changed after render", function(){
            var callback = sinon.spy();
            view.on("change:selection", callback);

            view.render();
            model.trigger("change");

            expect(callback.calledOnce).toBeTruthy();
        });

        it("should trigger event is selection was changed", function(){
            var callback = sinon.spy();
            view.on("change:selection", callback);
            var stub = sinon.stub(view, "getSelected", function(){return []});

            view.selectionFinished();

            stub.restore();
            expect(callback.calledOnce).toBeTruthy();
        });

        it("should select all", function(){

            view.render();
            model.trigger("change");

            view.selectAll();

            expect(view.getSelected().length).toEqual(mocks.rolesRest.role.length);
        });

        it("should clear all", function(){
            view.render();
            model.trigger("change");

            view.selectAll();
            view.selectNone();

            expect(view.getSelected().length).toEqual(0);
        });

        it("should select range", function(){
            view.render();
            model.trigger("change");

            view.selectRange(2, 3);

            var selected = view.getSelected();

            expect(selected.length).toEqual(2);
            expect(selected[0]).toEqual(mocks.rolesRest.role[2].name);
            expect(selected[1]).toEqual(mocks.rolesRest.role[3].name+ "|"+ mocks.rolesRest.role[3].tenantId);
        });

        it("should select item", function(){
            view.render();
            model.trigger("change");

            view.selectItem(0);

            var selected = view.getSelected();

            expect(selected.length).toEqual(1);
            expect(selected[0]).toEqual(mocks.rolesRest.role[0].name);
        });

        it("should deselect item", function(){
            view.render();
            model.trigger("change");


            view.selectItem(0);
            view.unSelectItem(0);

            var selected = view.getSelected();

            expect(selected.length).toEqual(0);
        });

    });
});