define(["jquery", "underscore", "components.ajaxdownloader"],
    function ($, _, AjaxDownloader) {

    xdescribe("Downloader", function(){

        var downloader;

        beforeEach(function(){
           jasmine.getFixtures().set("<div id='mysandbox'></div>");
           downloader = new AjaxDownloader();
        });

        it("chainable renderer", function(){
            expect(downloader.render()).toEqual(downloader);
        });

        it("should render hidden iframe with uuid", function(){
            $("#mysandbox").append(downloader.render().el);
            expect($("#mysandbox iframe")).toExist();
            expect($("#mysandbox iframe")).toHaveAttr("data-downloader-id", downloader.cid);
            expect($("#mysandbox iframe")).toBeHidden();
        });

        it("should render to body by default", function(){
            downloader.defaultLayout();
            var downloadFrame = $("body [data-downloader-id='"+downloader.cid+"']");
            expect(downloadFrame).toExist();
            downloadFrame.remove();
        });

        it("should target iframe to url by starting downloading", function(){
            downloader.start("test/url/blabla");
            expect($("[data-downloader-id='"+downloader.cid+"']")).toHaveAttr("src", "test/url/blabla");
        });

        describe("Initialization", function(){

            var defaultLayoutStub;

            beforeEach(function(){
                defaultLayoutStub = sinon.stub(AjaxDownloader.prototype, "defaultLayout");
            });

            it("should layout by initialization", function(){
                new AjaxDownloader;
                expect(defaultLayoutStub).toHaveBeenCalled();
            });

            afterEach(function(){
                defaultLayoutStub.restore();
            });
        });

    });

});
