/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * @author inesterenko
 */

define(["jquery", "app.conf.aliases", "app.conf.jrs"], function (jQuery, pathsAndAliases, jrsConfigs) {
    //merge paths and aliases with base configs
    return jQuery.extend(pathsAndAliases, {

        "tests": jrsConfigs.testPath,
        "templates": jrsConfigs.testTemplatePath,
        "lib": jrsConfigs.testLibPath,

        //Plugins aliases
        "text": jrsConfigs.testLibPath + "/text",
        "domReady": jrsConfigs.testLibPath + "/domReady",

        //Tests aliases
        "main": jrsConfigs.testPath + "../main",
        "jasmine": jrsConfigs.testLibPath + "/jasmine",
        "html.jasmine.reporter": jrsConfigs.testLibPath + "/html.jasmine.reporter",
        "custom.matchers": jrsConfigs.testLibPath + "/custom.matchers",
        "jasmine.ext": jrsConfigs.testLibPath + "/jasmine.ext",
        "junitxml.jasmine.reporter": jrsConfigs.testLibPath + "/junitxml.jasmine.reporter",
        "console.jasmine.reporter": jrsConfigs.testLibPath + "/console.jasmine.reporter",
        "jasmine-sinon": jrsConfigs.testLibPath + "/jasmine-sinon",
        "jquery.simulate" :  jrsConfigs.testLibPath + "/jquery/jquery.simulate",
        "jquery.cookies" :  jrsConfigs.testLibPath + "/jquery/jquery.cookies",

        "sinon":jrsConfigs.testLibPath + "/sinon-1.5.2",
        "sinon-ie":jrsConfigs.testLibPath + "/sinon-ie-1.5.2",
        "sinon-timers-ie":jrsConfigs.testLibPath + "/sinon-timers-ie-1.5.2",

        "ajax.mock": jrsConfigs.testLibPath + "/ajax.mock"

    });
});