/*
* Copyright (C) 2005 - 2009 Jaspersoft Corporation. All rights  reserved.
* http://www.jaspersoft.com.
*
* Unless you have purchased  a commercial license agreement from Jaspersoft,
* the following license terms  apply:
*
* This program is free software: you can redistribute it and/or  modify
* it under the terms of the GNU Affero General Public License  as
* published by the Free Software Foundation, either version 3 of  the
* License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU Affero  General Public License for more details.
*
* You should have received a copy of the GNU Affero General Public  License
* along with this program.&nbsp; If not, see <http://www.gnu.org/licenses/>.
*/
package com.jaspersoft.jasperserver.remote.resources.converters;

import com.jaspersoft.jasperserver.api.metadata.olap.domain.OlapUnit;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.client.OlapUnitImpl;
import com.jaspersoft.jasperserver.dto.resources.ClientOlapUnit;
import com.jaspersoft.jasperserver.remote.exception.IllegalParameterValueException;
import com.jaspersoft.jasperserver.remote.resources.GenericParametersReflectionHelper;
import org.testng.annotations.Test;

import static org.testng.Assert.assertEquals;
import static org.testng.Assert.assertSame;

/**
 * @author vsabadosh
 */
public class OlapUnitResourceConverterTest {
    private OlapUnitResourceConverter converter = new OlapUnitResourceConverter();
    private final String EXPECTED_MDX_QUERY = "testMdxQuery";

    @Test
    public void correctClientServerResourceType(){
        assertEquals(converter.getClientResourceType(), GenericParametersReflectionHelper.extractClientType(ClientOlapUnit.class));
        assertEquals(converter.getServerResourceType(), OlapUnit.class.getName());
    }

    @Test
    public void resourceSpecificFieldsToServer() throws Exception {
        ClientOlapUnit clientObject = new ClientOlapUnit();
        OlapUnit serverObject = new OlapUnitImpl();
        clientObject.setMdxQuery(EXPECTED_MDX_QUERY);
        final OlapUnit result = converter.resourceSpecificFieldsToServer(clientObject, serverObject);
        assertSame(result, serverObject);
        assertEquals(result.getMdxQuery(), EXPECTED_MDX_QUERY);
    }

    @Test
    public void resourceSpecificFieldsToClient(){
        ClientOlapUnit clientObject = new ClientOlapUnit();
        OlapUnit serverObject = new OlapUnitImpl();
        serverObject.setMdxQuery(EXPECTED_MDX_QUERY);
        final ClientOlapUnit result = converter.resourceSpecificFieldsToClient(clientObject, serverObject);
        assertSame(result, clientObject);
        assertEquals(result.getMdxQuery(), EXPECTED_MDX_QUERY);
    }

}
