/*
* Copyright (C) 2005 - 2009 Jaspersoft Corporation. All rights  reserved.
* http://www.jaspersoft.com.
*
* Unless you have purchased  a commercial license agreement from Jaspersoft,
* the following license terms  apply:
*
* This program is free software: you can redistribute it and/or  modify
* it under the terms of the GNU Affero General Public License  as
* published by the Free Software Foundation, either version 3 of  the
* License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU Affero  General Public License for more details.
*
* You should have received a copy of the GNU Affero General Public  License
* along with this program.&nbsp; If not, see <http://www.gnu.org/licenses/>.
*/
package com.jaspersoft.jasperserver.remote.resources.converters;

import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianConnection;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.client.MondrianConnectionImpl;
import com.jaspersoft.jasperserver.dto.resources.ClientFile;
import com.jaspersoft.jasperserver.dto.resources.ClientMondrianConnection;
import com.jaspersoft.jasperserver.dto.resources.ClientReference;
import com.jaspersoft.jasperserver.dto.resources.ClientReferenceableFile;
import com.jaspersoft.jasperserver.remote.exception.IllegalParameterValueException;
import com.jaspersoft.jasperserver.remote.resources.GenericParametersReflectionHelper;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import java.util.List;

import static org.mockito.Matchers.any;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;
import static org.testng.Assert.*;

/**
 * <p></p>
 *
 * @author Yaroslav.Kovalchyk
 * @version $Id: MondrianConnectionResourceConverterTest.java 29489 2013-03-11 15:59:46Z ztomchenco $
 */
public class MondrianConnectionResourceConverterTest {
    @InjectMocks
    private MondrianConnectionResourceConverter converter = new MondrianConnectionResourceConverter();
    @Mock
    private ResourceReferenceConverterProvider resourceReferenceConverterProvider;
    @Mock
    private ResourceReferenceConverter<ClientReferenceableFile> fileResourceReferenceConverter;
    private ArgumentCaptor<ClientReferenceRestriction> restrictionArgumentCaptor = ArgumentCaptor.forClass(ClientReferenceRestriction.class);

    @BeforeClass
    public void initConverter() {
        MockitoAnnotations.initMocks(this);
        when(resourceReferenceConverterProvider.getConverterForType(ClientReferenceableFile.class)).thenReturn(fileResourceReferenceConverter);
        when(fileResourceReferenceConverter.addReferenceRestriction(any(ClientReferenceRestriction.class))).thenReturn(fileResourceReferenceConverter);
    }

    @Test
    public void correctClientServerResourceType(){
        assertEquals(converter.getClientResourceType(), GenericParametersReflectionHelper.extractClientType(ClientMondrianConnection.class));
        assertEquals(converter.getServerResourceType(), MondrianConnection.class.getName());
    }

    @Test
    public void resourceSpecificFieldsToClient() throws Exception {
        final ClientMondrianConnection clientObject = new ClientMondrianConnection();
        final MondrianConnection serverObject = new MondrianConnectionImpl();
        final String fileReferenceUri = "/schema/reference/uri";
        final ResourceReference fileReference = new ResourceReference(fileReferenceUri);
        final ClientReference expectedClientReference = new ClientReference(fileReferenceUri);
        when(fileResourceReferenceConverter.toClient(fileReference)).thenReturn(expectedClientReference);
        serverObject.setSchema(fileReference);
        final ClientMondrianConnection result = converter.resourceSpecificFieldsToClient(clientObject, serverObject);
        assertSame(result, clientObject);
        final ClientReferenceableFile file = result.getSchema();
        assertSame(file, expectedClientReference);
        assertEquals(file.getUri(), fileReferenceUri);
    }

    @Test
    public void resourceSpecificFieldsToServer() throws Exception {
        final ClientMondrianConnection clientObject = new ClientMondrianConnection();
        final MondrianConnection serverObject = new MondrianConnectionImpl();
        final String fileReferenceUri = "/schema/reference/uri";
        final ResourceReference fileReference = new ResourceReference(fileReferenceUri);
        final ClientReference clientReference = new ClientReference(fileReferenceUri);
        when(fileResourceReferenceConverter.toServer(clientReference, null)).thenReturn(fileReference);
        clientObject.setSchema(clientReference);
        final MondrianConnection result = converter.resourceSpecificFieldsToServer(clientObject, serverObject);
        assertSame(result, serverObject);
        final ResourceReference resultReference = result.getSchema();
        assertSame(resultReference, fileReference);
        // check for additional restriction is added. References on XML files only allowed
        verify(fileResourceReferenceConverter).addReferenceRestriction(restrictionArgumentCaptor.capture());
        final List<ClientReferenceRestriction> restrictions = restrictionArgumentCaptor.getAllValues();
        assertNotNull(restrictions);
        assertEquals(restrictions.size(), 1);
        final ClientReferenceRestriction restriction = restrictions.get(0);
        assertTrue(restriction instanceof ResourceReferenceConverter.FileTypeRestriction);
        final ClientFile fileToTest = new ClientFile();
        fileToTest.setType(ClientFile.FileType.xml);
        // no exception should be here. It means restriction is set to accept XML
        restriction.validateReference(fileToTest);
    }



}
