/*
* Copyright (C) 2005 - 2012 Jaspersoft Corporation. All rights reserved.
* http://www.jaspersoft.com.
* Licensed under commercial Jaspersoft Subscription License Agreement.
*/

package com.jaspersoft.jasperserver.remote.services.async;

import com.jaspersoft.jasperserver.remote.exception.NoResultException;
import com.jaspersoft.jasperserver.remote.exception.NotReadyResultException;

/*
*  @author inesterenko
*/
public interface Task<T> {

    String INPROGRESS = "inprogress";
    String FINISHED = "finished";
    String FAILED = "failed";

    void start();

    void stop();

    String getUniqueId();

    void setUniqueId(String uuid);

    StateDto getState();

    T getResult() throws NotReadyResultException, NoResultException;

}
