/*
 * Copyright (C) 2005 - 2012 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.jaspersoft.jasperserver.dto.resources;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.List;

/**
 *
 * @author Zakhar.Tomchenco
 * @version $Id: ClientInputControl.java 29488 2013-03-11 15:58:05Z ztomchenco $
 */
@XmlRootElement(name = ResourceMediaType.INPUT_CONTROL_CLIENT_TYPE)
public class ClientInputControl extends ClientResourceLookup implements ClientReferenceableInputControl {
    private boolean mandatory;
    private boolean readOnly;
    private boolean visible;
    private byte type;
    private List<String> visibleColumns;
    private String valueColumn;

    private ClientReferenceableDataType dataType;
    private ClientReferenceableQuery query;
    private ClientReferenceableListOfValues listOfValues;

    public boolean isMandatory() {
        return mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public boolean isReadOnly() {
        return readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isVisible() {
        return visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public byte getType() {
        return type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    @XmlElementWrapper(name = "visibleColumns")
    @XmlElement(name = "visibleColumn")
    public List<String> getVisibleColumns() {
        return visibleColumns;
    }

    public void setVisibleColumns(List<String> visibleColumns) {
        this.visibleColumns = visibleColumns;
    }

    public String getValueColumn() {
        return valueColumn;
    }

    public void setValueColumn(String valueColumn) {
        this.valueColumn = valueColumn;
    }

    @XmlElements({
            @XmlElement(type = ClientReference.class, name = "dataTypeReference"),
            @XmlElement(type = ClientDataType.class, name = "localDataType")
    })
    public ClientReferenceableDataType getDataType() {
        return dataType;
    }

    public void setDataType(ClientReferenceableDataType dataType) {
        this.dataType = dataType;
    }

    @XmlElements({
        @XmlElement(type = ClientReference.class, name = "queryReference"),
        @XmlElement(type = ClientQuery.class, name = "localQuery")
    })
    public ClientReferenceableQuery getQuery() {
        return query;
    }

    public void setQuery(ClientReferenceableQuery query) {
        this.query = query;
    }

    @XmlElements({
            @XmlElement(type = ClientReference.class, name = "listOfValuesReference"),
            @XmlElement(type = ClientListOfValues.class, name = "localListOfValues")
    })
    public ClientReferenceableListOfValues getListOfValues() {
        return listOfValues;
    }

    public void setListOfValues(ClientReferenceableListOfValues listOfValues) {
        this.listOfValues = listOfValues;
    }
}
