/*
* Copyright (C) 2005 - 2009 Jaspersoft Corporation. All rights  reserved.
* http://www.jaspersoft.com.
*
* Unless you have purchased  a commercial license agreement from Jaspersoft,
* the following license terms  apply:
*
* This program is free software: you can redistribute it and/or  modify
* it under the terms of the GNU Affero General Public License  as
* published by the Free Software Foundation, either version 3 of  the
* License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU Affero  General Public License for more details.
*
* You should have received a copy of the GNU Affero General Public  License
* along with this program.&nbsp; If not, see <http://www.gnu.org/licenses/>.
*/
package com.jaspersoft.jasperserver.dto.resources;

import javax.xml.bind.annotation.XmlRootElement;

/**
 * <p></p>
 *
 * @author Yaroslav.Kovalchyk
 * @version $Id: ClientDataType.java 29352 2013-03-07 12:20:41Z ykovalchyk $
 */
@XmlRootElement(name = ResourceMediaType.DATA_TYPE_CLIENT_TYPE)
public class ClientDataType extends ClientResourceLookup implements ClientReferenceableDataType {
    private TypeOfDataType type;
    private String pattern;
    private String maxValue;
    private Boolean strictMax = false;
    private String minValue;
    private Boolean strictMin = false;
    private Integer maxLength;
    private Integer decimals;

    public Integer getMaxLength() {
        return maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public Integer getDecimals() {
        return decimals;
    }

    public void setDecimals(Integer decimals) {
        this.decimals = decimals;
    }

    public TypeOfDataType getType() {
        return type;
    }

    public void setType(TypeOfDataType type) {
        this.type = type;
    }

    public String getPattern() {
        return pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getMaxValue() {
        return maxValue;
    }

    public void setMaxValue(String maxValue) {
        this.maxValue = maxValue;
    }

    public Boolean isStrictMax() {
        return strictMax;
    }

    public void setStrictMax(Boolean strictMax) {
        this.strictMax = strictMax;
    }

    public String getMinValue() {
        return minValue;
    }

    public void setMinValue(String minValue) {
        this.minValue = minValue;
    }

    public Boolean isStrictMin() {
        return strictMin;
    }

    public void setStrictMin(Boolean strictMin) {
        this.strictMin = strictMin;
    }

    public enum TypeOfDataType{
        text, number, date, datetime,time
    }
}
