/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.context;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.Initializable;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.awareness.AbstractTilesApplicationContextFactoryAware;
import org.apache.tiles.context.AbstractTilesApplicationContextFactory;
import org.apache.tiles.reflect.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainedTilesApplicationContextFactory
extends AbstractTilesApplicationContextFactory
implements Initializable {
    public static final String FACTORY_CLASS_NAMES = "org.apache.tiles.context.ChainedTilesApplicationContextFactory.FACTORY_CLASS_NAMES";
    public static final String[] DEFAULT_FACTORY_CLASS_NAMES = new String[]{"org.apache.tiles.servlet.context.ServletTilesApplicationContextFactory", "org.apache.tiles.portlet.context.PortletTilesApplicationContextFactory"};
    private final Log log = LogFactory.getLog(ChainedTilesApplicationContextFactory.class);
    private List<AbstractTilesApplicationContextFactory> factories;

    public void setFactories(List<AbstractTilesApplicationContextFactory> factories) {
        this.factories = factories;
    }

    public void init(Map<String, String> configParameters) {
        String[] classNames = null;
        String classNamesString = configParameters.get(FACTORY_CLASS_NAMES);
        if (classNamesString != null) {
            classNames = classNamesString.split("\\s*,\\s*");
        }
        if (classNames == null || classNames.length <= 0) {
            classNames = DEFAULT_FACTORY_CLASS_NAMES;
        }
        this.factories = new ArrayList<AbstractTilesApplicationContextFactory>();
        for (int i = 0; i < classNames.length; ++i) {
            try {
                Class clazz = ClassUtil.getClass((String)classNames[i], AbstractTilesApplicationContextFactory.class);
                AbstractTilesApplicationContextFactory factory = (AbstractTilesApplicationContextFactory)clazz.newInstance();
                if (factory instanceof AbstractTilesApplicationContextFactoryAware) {
                    ((AbstractTilesApplicationContextFactoryAware)((Object)factory)).setApplicationContextFactory(this);
                }
                this.factories.add(factory);
                continue;
            }
            catch (ClassNotFoundException e) {
                this.log.warn((Object)("Cannot find TilesContextFactory class " + classNames[i]));
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Cannot find TilesContextFactory class " + classNames[i]), (Throwable)e);
                continue;
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("Cannot instantiate TilesFactoryClass " + classNames[i], e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Cannot access TilesFactoryClass " + classNames[i] + " default constructor", e);
            }
        }
    }

    @Override
    public TilesApplicationContext createApplicationContext(Object context) {
        TilesApplicationContext retValue = null;
        Iterator<AbstractTilesApplicationContextFactory> factoryIt = this.factories.iterator();
        while (factoryIt.hasNext() && retValue == null) {
            retValue = factoryIt.next().createApplicationContext(context);
        }
        if (retValue == null) {
            throw new IllegalArgumentException("Cannot find a factory to create the application context");
        }
        return retValue;
    }
}

