/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.unitils.core.UnitilsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtils {
    public static <T> T createInstanceOfType(String className, boolean bypassAccessibility) {
        try {
            Class<?> type = Class.forName(className);
            return (T)ReflectionUtils.createInstanceOfType(type, bypassAccessibility);
        }
        catch (ClassCastException e) {
            throw new UnitilsException("Class " + className + " is not of expected type.", e);
        }
        catch (NoClassDefFoundError e) {
            throw new UnitilsException("Unable to load class " + className, e);
        }
        catch (ClassNotFoundException e) {
            throw new UnitilsException("Class " + className + " not found", e);
        }
        catch (UnitilsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnitilsException("Error while instantiating class " + className, e);
        }
    }

    public static <T> T createInstanceOfType(Class<T> type, boolean bypassAccessibility) {
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(new Class[0]);
            if (bypassAccessibility) {
                constructor.setAccessible(true);
            }
            return constructor.newInstance(new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new UnitilsException("Error while trying to create object of class " + type.getName(), e.getCause());
        }
        catch (Exception e) {
            throw new UnitilsException("Error while trying to create object of class " + type.getName(), e);
        }
    }

    public static <T> T getFieldValue(Object object, Field field) {
        try {
            field.setAccessible(true);
            return (T)field.get(object);
        }
        catch (IllegalArgumentException e) {
            throw new UnitilsException("Error while trying to access field " + field, e);
        }
        catch (IllegalAccessException e) {
            throw new UnitilsException("Error while trying to access field " + field, e);
        }
    }

    public static void setFieldValue(Object object, Field field, Object value) {
        try {
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (IllegalArgumentException e) {
            throw new UnitilsException("Unable to assign the value to field: " + field.getName() + ". Ensure that this field is of the correct type.", e);
        }
        catch (IllegalAccessException e) {
            throw new UnitilsException("Error while trying to access field " + field, e);
        }
    }

    public static void setFieldAndSetterValue(Object object, Set<Field> fields, Set<Method> setterMethods, Object value) {
        for (Field field : fields) {
            try {
                ReflectionUtils.setFieldValue(object, field, value);
            }
            catch (UnitilsException e) {
                throw new UnitilsException("Unable to assign the value to field: " + field.getName() + ". Ensure that this field is of the correct type.", e);
            }
        }
        for (Method method : setterMethods) {
            if (!ReflectionUtils.isSetter(method)) {
                throw new UnitilsException("Method " + method.getName() + " is expected to be a setter method, but is not.");
            }
            try {
                ReflectionUtils.invokeMethod(object, method, value);
            }
            catch (UnitilsException e) {
                throw new UnitilsException("Unable to invoke method: " + object.getClass().getSimpleName() + "." + method.getName() + ". Ensure that " + "this method has following signature: void myMethod(ValueType value).", e);
            }
            catch (InvocationTargetException e) {
                throw new UnitilsException("Unable to invoke method: " + object.getClass().getSimpleName() + "." + method.getName() + ". Method " + "has thrown an exception.", e.getCause());
            }
        }
    }

    public static <T> T invokeMethod(Object target, Method method, Object ... arguments) throws InvocationTargetException {
        try {
            method.setAccessible(true);
            return (T)method.invoke(target, arguments);
        }
        catch (ClassCastException e) {
            throw new UnitilsException("Unable to invoke method. Unexpected return type " + method, e);
        }
        catch (IllegalArgumentException e) {
            throw new UnitilsException("Error while invoking method " + method, e);
        }
        catch (IllegalAccessException e) {
            throw new UnitilsException("Error while invoking method " + method, e);
        }
    }

    public static <T> T invokeMethodSilent(Object target, Method method, Object ... arguments) {
        try {
            return ReflectionUtils.invokeMethod(target, method, arguments);
        }
        catch (InvocationTargetException e) {
            throw new UnitilsException(e);
        }
    }

    public static Set<Field> getFieldsAssignableFrom(Class<?> clazz, Class<?> type, boolean isStatic) {
        HashSet<Field> fieldsOfType = new HashSet<Field>();
        Set<Field> allFields = ReflectionUtils.getAllFields(clazz);
        for (Field field : allFields) {
            if (!field.getType().isAssignableFrom(type) || Modifier.isStatic(field.getModifiers()) != isStatic) continue;
            fieldsOfType.add(field);
        }
        return fieldsOfType;
    }

    public static Set<Field> getFieldsOfType(Class<?> clazz, Class<?> type, boolean isStatic) {
        HashSet<Field> fields = new HashSet<Field>();
        Set<Field> allFields = ReflectionUtils.getAllFields(clazz);
        for (Field field : allFields) {
            if (!field.getType().equals(type) || isStatic != Modifier.isStatic(field.getModifiers())) continue;
            fields.add(field);
        }
        return fields;
    }

    public static Set<Method> getSettersAssignableFrom(Class<?> clazz, Class<?> type, boolean isStatic) {
        HashSet<Method> settersAssignableFrom = new HashSet<Method>();
        Set<Method> allMethods = ReflectionUtils.getAllMethods(clazz);
        for (Method method : allMethods) {
            if (!ReflectionUtils.isSetter(method) || !method.getParameterTypes()[0].isAssignableFrom(type) || isStatic != Modifier.isStatic(method.getModifiers())) continue;
            settersAssignableFrom.add(method);
        }
        return settersAssignableFrom;
    }

    public static Set<Method> getSettersOfType(Class<?> clazz, Class<?> type, boolean isStatic) {
        HashSet<Method> settersOfType = new HashSet<Method>();
        Set<Method> allMethods = ReflectionUtils.getAllMethods(clazz);
        for (Method method : allMethods) {
            if (!ReflectionUtils.isSetter(method) || !method.getParameterTypes()[0].equals(type) || isStatic != Modifier.isStatic(method.getModifiers())) continue;
            settersOfType.add(method);
        }
        return settersOfType;
    }

    public static Method getSetter(Class<?> clazz, String propertyName, boolean isStatic) {
        String setterName = "set" + StringUtils.capitalize((String)propertyName);
        Set<Method> allMethods = ReflectionUtils.getAllMethods(clazz);
        for (Method method : allMethods) {
            if (!ReflectionUtils.isSetter(method) || !setterName.equals(method.getName()) || isStatic != Modifier.isStatic(method.getModifiers()) || method.getParameterTypes().length != 1) continue;
            return method;
        }
        return null;
    }

    public static Method getGetter(Class<?> clazz, String propertyName, boolean isStatic) {
        String getterName = "get" + StringUtils.capitalize((String)propertyName);
        return ReflectionUtils.getMethod(clazz, getterName, isStatic, new Class[0]);
    }

    public static Method getGetter(Method setter, boolean isStatic) {
        if (!ReflectionUtils.isSetter(setter)) {
            return null;
        }
        String getterName = "get" + setter.getName().substring(3);
        return ReflectionUtils.getMethod(setter.getDeclaringClass(), getterName, isStatic, new Class[0]);
    }

    public static Field getFieldWithName(Class<?> clazz, String fieldName, boolean isStatic) {
        Field field;
        if (clazz == null || clazz.equals(Object.class)) {
            return null;
        }
        try {
            field = clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            field = null;
        }
        if (field != null && Modifier.isStatic(field.getModifiers()) == isStatic) {
            return field;
        }
        return ReflectionUtils.getFieldWithName(clazz.getSuperclass(), fieldName, isStatic);
    }

    public static <T extends Enum<?>> T getEnumValue(Class<T> enumClass, String enumValueName) {
        Enum[] enumValues;
        for (Enum enumValue : enumValues = (Enum[])enumClass.getEnumConstants()) {
            if (!enumValueName.equalsIgnoreCase(enumValue.name())) continue;
            return (T)enumValue;
        }
        throw new UnitilsException("Unable to find a enum value in enum: " + enumClass + ", with value name: " + enumValueName);
    }

    public static boolean isSetter(Method method) {
        String fourthLetter;
        String methodName = method.getName();
        return methodName.length() > 3 && methodName.startsWith("set") && method.getParameterTypes().length == 1 && (fourthLetter = methodName.substring(3, 4)).toUpperCase().equals(fourthLetter);
    }

    public static String getPropertyName(Method setterMethod) {
        String methodName = setterMethod.getName();
        if (methodName.length() < 4 || !methodName.startsWith("set")) {
            throw new UnitilsException("Unable to get field name for setter method " + setterMethod);
        }
        return methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
    }

    public static <T> Class<T> getClassWithName(String className) {
        try {
            return Class.forName(className);
        }
        catch (Throwable t) {
            throw new UnitilsException("Could not load class with name " + className, t);
        }
    }

    public static Method getMethod(Class<?> clazz, String methodName, boolean isStatic, Class<?> ... parameterTypes) {
        Method result;
        if (clazz == null || clazz.equals(Object.class)) {
            return null;
        }
        try {
            result = clazz.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            result = null;
        }
        if (result != null && Modifier.isStatic(result.getModifiers()) == isStatic) {
            return result;
        }
        return ReflectionUtils.getMethod(clazz.getSuperclass(), methodName, isStatic, parameterTypes);
    }

    public static Set<Method> getAllMethods(Class<?> clazz) {
        Method[] declaredMethods;
        HashSet<Method> result = new HashSet<Method>();
        if (clazz == null || clazz.equals(Object.class)) {
            return result;
        }
        for (Method declaredMethod : declaredMethods = clazz.getDeclaredMethods()) {
            if (declaredMethod.isSynthetic() || declaredMethod.isBridge()) continue;
            result.add(declaredMethod);
        }
        result.addAll(ReflectionUtils.getAllMethods(clazz.getSuperclass()));
        return result;
    }

    public static Set<Field> getAllFields(Class<?> clazz) {
        HashSet<Field> result = new HashSet<Field>();
        if (clazz == null || clazz.equals(Object.class)) {
            return result;
        }
        Field[] declaredFields = clazz.getDeclaredFields();
        result.addAll(Arrays.asList(declaredFields));
        result.addAll(ReflectionUtils.getAllFields(clazz.getSuperclass()));
        return result;
    }

    public static String getSimpleMethodName(Method method) {
        StringBuffer result = new StringBuffer();
        result.append(method.getDeclaringClass().getSimpleName());
        result.append('.');
        result.append(method.getName());
        result.append("()");
        return result.toString();
    }

    public static boolean isAssignable(Class<?> fromType, Class<?> toType) {
        if (Boolean.TYPE.equals(fromType) && Boolean.class.isAssignableFrom(toType) || Boolean.TYPE.equals(toType) && Boolean.class.isAssignableFrom(fromType)) {
            return true;
        }
        if (Character.TYPE.equals(fromType) && Character.class.isAssignableFrom(toType) || Character.TYPE.equals(toType) && Character.class.isAssignableFrom(fromType)) {
            return true;
        }
        if (Integer.TYPE.equals(fromType) && Integer.class.isAssignableFrom(toType) || Integer.TYPE.equals(toType) && Integer.class.isAssignableFrom(fromType)) {
            return true;
        }
        if (Long.TYPE.equals(fromType) && Long.class.isAssignableFrom(toType) || Long.TYPE.equals(toType) && Long.class.isAssignableFrom(fromType)) {
            return true;
        }
        if (Float.TYPE.equals(fromType) && Float.class.isAssignableFrom(toType) || Float.TYPE.equals(toType) && Float.class.isAssignableFrom(fromType)) {
            return true;
        }
        if (Double.TYPE.equals(fromType) && Double.class.isAssignableFrom(toType) || Double.TYPE.equals(toType) && Double.class.isAssignableFrom(fromType)) {
            return true;
        }
        return toType.isAssignableFrom(fromType);
    }
}

