/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.mock.argumentmatcher;

import java.util.ArrayList;
import java.util.List;
import org.unitils.core.UnitilsException;
import org.unitils.mock.argumentmatcher.ArgumentMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentMatcherRepository {
    private static ThreadLocal<ArgumentMatcherRepository> instance = new InheritableThreadLocal<ArgumentMatcherRepository>(){

        @Override
        protected ArgumentMatcherRepository initialValue() {
            return new ArgumentMatcherRepository();
        }
    };
    private List<ArgumentMatcher> argumentMatchers = new ArrayList<ArgumentMatcher>();
    private boolean acceptingArgumentMatchers = false;
    private int matchInvocationStartLineNr;
    private int matchInvocationEndLineNr;

    public static ArgumentMatcherRepository getInstance() {
        return instance.get();
    }

    public void registerArgumentMatcher(ArgumentMatcher argumentMatcher, int lineNr) {
        if (!this.acceptingArgumentMatchers) {
            throw new UnitilsException("Argument matchers cannot be used outside the context of a behavior definition or assert statement");
        }
        this.matchInvocationEndLineNr = Math.max(this.matchInvocationEndLineNr, lineNr);
        this.argumentMatchers.add(argumentMatcher);
    }

    public List<ArgumentMatcher> getArgumentMatchers() {
        return this.argumentMatchers;
    }

    public int getMatchInvocationStartLineNr() {
        return this.matchInvocationStartLineNr;
    }

    public int getMatchInvocationEndLineNr() {
        return this.matchInvocationEndLineNr;
    }

    public void registerStartOfMatchingInvocation(int lineNr) {
        this.acceptingArgumentMatchers = true;
        this.matchInvocationStartLineNr = lineNr;
        this.matchInvocationEndLineNr = lineNr;
    }

    public void registerEndOfMatchingInvocation() {
        this.argumentMatchers = new ArrayList<ArgumentMatcher>();
        this.acceptingArgumentMatchers = false;
    }
}

