/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.dbmaintainer.script;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.hibernate.lob.ReaderInputStream;
import org.unitils.core.UnitilsException;
import org.unitils.thirdparty.org.apache.commons.io.IOUtils;
import org.unitils.thirdparty.org.apache.commons.io.NullWriter;

public abstract class ScriptContentHandle {
    private MessageDigest scriptDigest;
    private Reader scriptReader;

    public Reader openScriptContentReader() {
        this.scriptDigest = this.getScriptDigest();
        this.scriptReader = new InputStreamReader(new DigestInputStream(this.getScriptInputStream(), this.scriptDigest));
        return this.scriptReader;
    }

    protected MessageDigest getScriptDigest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnitilsException(e);
        }
    }

    public String getCheckSum() {
        try {
            if (this.scriptDigest == null) {
                this.readScript();
            } else if (this.scriptReader.ready()) {
                throw new UnitilsException("Cannot obtain checksum, since a script is currently being read");
            }
            return this.getHexPresentation(this.scriptDigest.digest());
        }
        catch (IOException e) {
            throw new UnitilsException(e);
        }
    }

    protected void readScript() throws IOException {
        Reader scriptReader = this.openScriptContentReader();
        IOUtils.copy(scriptReader, (Writer)new NullWriter());
        scriptReader.close();
    }

    protected String getHexPresentation(byte[] byteArray) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < byteArray.length; ++i) {
            result.append(Integer.toString((byteArray[i] & 0xFF) + 256, 16).substring(1));
        }
        return result.toString();
    }

    protected abstract InputStream getScriptInputStream();

    public static class StringScriptContentHandle
    extends ScriptContentHandle {
        private String scriptContent;

        public StringScriptContentHandle(String scriptContent) {
            this.scriptContent = scriptContent;
        }

        protected InputStream getScriptInputStream() {
            return new ReaderInputStream((Reader)new StringReader(this.scriptContent));
        }
    }

    public static class UrlScriptContentHandle
    extends ScriptContentHandle {
        private URL url;

        public UrlScriptContentHandle(URL url) {
            this.url = url;
        }

        protected InputStream getScriptInputStream() {
            try {
                return this.url.openStream();
            }
            catch (IOException e) {
                throw new UnitilsException("Error while trying to create reader for url " + this.url, e);
            }
        }
    }
}

