/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.database;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.unitils.core.Module;
import org.unitils.core.TestListener;
import org.unitils.core.Unitils;
import org.unitils.core.dbsupport.DefaultSQLHandler;
import org.unitils.core.dbsupport.SQLHandler;
import org.unitils.core.util.ConfigUtils;
import org.unitils.database.annotations.TestDataSource;
import org.unitils.database.annotations.Transactional;
import org.unitils.database.config.DataSourceFactory;
import org.unitils.database.transaction.UnitilsTransactionManager;
import org.unitils.database.transaction.impl.UnitilsTransactionManagementConfiguration;
import org.unitils.database.util.Flushable;
import org.unitils.database.util.TransactionMode;
import org.unitils.dbmaintainer.DBMaintainer;
import org.unitils.dbmaintainer.clean.DBCleaner;
import org.unitils.dbmaintainer.clean.DBClearer;
import org.unitils.dbmaintainer.structure.ConstraintsDisabler;
import org.unitils.dbmaintainer.structure.DataSetStructureGenerator;
import org.unitils.dbmaintainer.structure.SequenceUpdater;
import org.unitils.dbmaintainer.util.DatabaseAccessing;
import org.unitils.dbmaintainer.util.DatabaseModuleConfigUtils;
import org.unitils.util.AnnotationUtils;
import org.unitils.util.ModuleUtils;
import org.unitils.util.PropertyUtils;
import org.unitils.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseModule
implements Module {
    public static final String PROPERTY_UPDATEDATABASESCHEMA_ENABLED = "updateDataBaseSchema.enabled";
    public static final String PROPERTY_WRAP_DATASOURCE_IN_TRANSACTIONAL_PROXY = "dataSource.wrapInTransactionalProxy";
    private static Log logger = LogFactory.getLog(DatabaseModule.class);
    protected Map<Class<? extends Annotation>, Map<String, String>> defaultAnnotationPropertyValues;
    protected DataSource dataSource;
    protected Properties configuration;
    protected boolean updateDatabaseSchemaEnabled;
    protected boolean wrapDataSourceInTransactionalProxy;
    protected UnitilsTransactionManager transactionManager;
    protected Set<UnitilsTransactionManagementConfiguration> transactionManagementConfigurations = new HashSet<UnitilsTransactionManagementConfiguration>();

    @Override
    public void init(Properties configuration) {
        this.configuration = configuration;
        this.defaultAnnotationPropertyValues = ModuleUtils.getAnnotationPropertyDefaults(DatabaseModule.class, configuration, Transactional.class);
        this.updateDatabaseSchemaEnabled = PropertyUtils.getBoolean(PROPERTY_UPDATEDATABASESCHEMA_ENABLED, configuration);
        this.wrapDataSourceInTransactionalProxy = PropertyUtils.getBoolean(PROPERTY_WRAP_DATASOURCE_IN_TRANSACTIONAL_PROXY, configuration);
        PlatformTransactionManager.class.getName();
    }

    @Override
    public void afterInit() {
        this.registerTransactionManagementConfiguration(new UnitilsTransactionManagementConfiguration(){

            public boolean isApplicableFor(Object testObject) {
                return true;
            }

            public PlatformTransactionManager getSpringPlatformTransactionManager(Object testObject) {
                return new DataSourceTransactionManager(DatabaseModule.this.getDataSourceAndActivateTransactionIfNeeded());
            }

            public boolean isTransactionalResourceAvailable(Object testObject) {
                return DatabaseModule.this.isDataSourceLoaded();
            }

            public Integer getPreference() {
                return 1;
            }
        });
    }

    public DataSource getTransactionalDataSourceAndActivateTransactionIfNeeded(Object testObject) {
        if (this.wrapDataSourceInTransactionalProxy) {
            return this.getTransactionManager().getTransactionalDataSource(this.getDataSourceAndActivateTransactionIfNeeded());
        }
        return this.getDataSourceAndActivateTransactionIfNeeded();
    }

    public DataSource getDataSourceAndActivateTransactionIfNeeded() {
        if (this.dataSource == null) {
            this.dataSource = this.createDataSource();
            this.activateTransactionIfNeeded();
        }
        return this.dataSource;
    }

    public DataSource getDataSource() {
        if (this.dataSource == null) {
            this.dataSource = this.createDataSource();
        }
        return this.dataSource;
    }

    public void activateTransactionIfNeeded() {
        if (this.transactionManager != null) {
            this.transactionManager.activateTransactionIfNeeded(this.getTestObject());
        }
    }

    public boolean isDataSourceLoaded() {
        return this.dataSource != null;
    }

    public UnitilsTransactionManager getTransactionManager() {
        if (this.transactionManager == null) {
            this.transactionManager = ConfigUtils.getInstanceOf(UnitilsTransactionManager.class, this.configuration, new String[0]);
            this.transactionManager.init(this.transactionManagementConfigurations);
        }
        return this.transactionManager;
    }

    public void flushDatabaseUpdates(Object testObject) {
        List<Flushable> flushables = Unitils.getInstance().getModulesRepository().getModulesOfType(Flushable.class);
        for (Flushable flushable : flushables) {
            flushable.flushDatabaseUpdates(testObject);
        }
    }

    public void updateDatabase() {
        this.updateDatabase(this.getDefaultSqlHandler());
    }

    public void updateDatabase(SQLHandler sqlHandler) {
        logger.info((Object)"Checking if database has to be updated.");
        DBMaintainer dbMaintainer = new DBMaintainer(this.configuration, sqlHandler);
        dbMaintainer.updateDatabase();
    }

    public void resetDatabaseState() {
        this.resetDatabaseState(this.getDefaultSqlHandler());
    }

    public void resetDatabaseState(SQLHandler sqlHandler) {
        DBMaintainer dbMaintainer = new DBMaintainer(this.configuration, sqlHandler);
        dbMaintainer.resetDatabaseState();
    }

    public void injectDataSource(Object testObject) {
        Set<Field> fields = AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), TestDataSource.class);
        Set<Method> methods = AnnotationUtils.getMethodsAnnotatedWith(testObject.getClass(), TestDataSource.class);
        if (fields.isEmpty() && methods.isEmpty()) {
            return;
        }
        ReflectionUtils.setFieldAndSetterValue(testObject, fields, methods, this.getTransactionalDataSourceAndActivateTransactionIfNeeded(testObject));
    }

    protected DataSource createDataSource() {
        DataSourceFactory dataSourceFactory = ConfigUtils.getConfiguredInstanceOf(DataSourceFactory.class, this.configuration, new String[0]);
        dataSourceFactory.init(this.configuration);
        DataSource dataSource = dataSourceFactory.createDataSource();
        if (this.updateDatabaseSchemaEnabled) {
            this.updateDatabase(new DefaultSQLHandler(dataSource));
        }
        return dataSource;
    }

    protected TransactionMode getTransactionMode(Object testObject, Method testMethod) {
        TransactionMode transactionMode = AnnotationUtils.getMethodOrClassLevelAnnotationProperty(Transactional.class, "value", TransactionMode.DEFAULT, testMethod, testObject.getClass());
        transactionMode = ModuleUtils.getEnumValueReplaceDefault(Transactional.class, "value", transactionMode, this.defaultAnnotationPropertyValues);
        return transactionMode;
    }

    protected void startTransactionForTestMethod(Object testObject, Method testMethod) {
        if (this.isTransactionsEnabled(testObject, testMethod)) {
            this.startTransaction(testObject);
        }
    }

    protected void endTransactionForTestMethod(Object testObject, Method testMethod) {
        if (this.isTransactionsEnabled(testObject, testMethod)) {
            if (this.getTransactionMode(testObject, testMethod) == TransactionMode.COMMIT) {
                this.commitTransaction(testObject);
            } else if (this.getTransactionMode(testObject, testMethod) == TransactionMode.ROLLBACK) {
                this.rollbackTransaction(testObject);
            }
        }
    }

    public void startTransaction(Object testObject) {
        this.getTransactionManager().startTransaction(testObject);
    }

    public void commitTransaction(Object testObject) {
        this.flushDatabaseUpdates(testObject);
        this.getTransactionManager().commit(testObject);
    }

    public void rollbackTransaction(Object testObject) {
        this.flushDatabaseUpdates(testObject);
        this.getTransactionManager().rollback(testObject);
    }

    public boolean isTransactionsEnabled(Object testObject, Method testMethod) {
        TransactionMode transactionMode = this.getTransactionMode(testObject, testMethod);
        return transactionMode != TransactionMode.DISABLED;
    }

    public void clearSchemas() {
        this.getConfiguredDatabaseTaskInstance(DBClearer.class).clearSchemas();
    }

    public void cleanSchemas() {
        this.getConfiguredDatabaseTaskInstance(DBCleaner.class).cleanSchemas();
    }

    public void disableConstraints() {
        this.getConfiguredDatabaseTaskInstance(ConstraintsDisabler.class).disableConstraints();
    }

    public void updateSequences() {
        this.getConfiguredDatabaseTaskInstance(SequenceUpdater.class).updateSequences();
    }

    public void generateDatasetDefinition() {
        this.getConfiguredDatabaseTaskInstance(DataSetStructureGenerator.class).generateDataSetStructure();
    }

    protected <T extends DatabaseAccessing> T getConfiguredDatabaseTaskInstance(Class<T> databaseTaskType) {
        return DatabaseModuleConfigUtils.getConfiguredDatabaseTaskInstance(databaseTaskType, this.configuration, this.getDefaultSqlHandler());
    }

    protected SQLHandler getDefaultSqlHandler() {
        return new DefaultSQLHandler(this.getDataSourceAndActivateTransactionIfNeeded());
    }

    public void registerTransactionManagementConfiguration(UnitilsTransactionManagementConfiguration transactionManagementConfiguration) {
        this.transactionManagementConfigurations.add(transactionManagementConfiguration);
    }

    protected Object getTestObject() {
        return Unitils.getInstance().getTestContext().getTestObject();
    }

    @Override
    public TestListener getTestListener() {
        return new DatabaseTestListener();
    }

    protected class DatabaseTestListener
    extends TestListener {
        protected DatabaseTestListener() {
        }

        public void beforeTestSetUp(Object testObject, Method testMethod) {
            DatabaseModule.this.injectDataSource(testObject);
            DatabaseModule.this.startTransactionForTestMethod(testObject, testMethod);
        }

        public void afterTestTearDown(Object testObject, Method testMethod) {
            DatabaseModule.this.endTransactionForTestMethod(testObject, testMethod);
        }
    }
}

