/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.util;

import com.vertica.util.GT;
import java.io.Serializable;
import java.util.Hashtable;

public class ServerErrorMessage
implements Serializable {
    private static final Character SEVERITY = new Character('S');
    private static final Character MESSAGE = new Character('M');
    private static final Character DETAIL = new Character('D');
    private static final Character HINT = new Character('H');
    private static final Character POSITION = new Character('P');
    private static final Character WHERE = new Character('W');
    private static final Character FILE = new Character('F');
    private static final Character LINE = new Character('L');
    private static final Character ROUTINE = new Character('R');
    private static final Character SQLSTATE = new Character('C');
    private static final Character INTERNAL_POSITION = new Character('p');
    private static final Character INTERNAL_QUERY = new Character('q');
    private final Hashtable m_mesgParts = new Hashtable();
    private final int verbosity;

    public ServerErrorMessage(String string, int n) {
        this.verbosity = n;
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        for (int i = 0; i < n2; ++i) {
            char c = cArray[i];
            if (c == '\u0000') continue;
            int n3 = ++i;
            while (cArray[i] != '\u0000' && i < n2) {
                ++i;
            }
            String string2 = new String(cArray, n3, i - n3);
            this.m_mesgParts.put(new Character(c), string2);
        }
    }

    public String getSQLState() {
        return (String)this.m_mesgParts.get(SQLSTATE);
    }

    public String getMessage() {
        return (String)this.m_mesgParts.get(MESSAGE);
    }

    public String getSeverity() {
        return (String)this.m_mesgParts.get(SEVERITY);
    }

    public String getDetail() {
        return (String)this.m_mesgParts.get(DETAIL);
    }

    public String getHint() {
        return (String)this.m_mesgParts.get(HINT);
    }

    public int getPosition() {
        return this.getIntegerPart(POSITION);
    }

    public String getWhere() {
        return (String)this.m_mesgParts.get(WHERE);
    }

    public String getFile() {
        return (String)this.m_mesgParts.get(FILE);
    }

    public int getLine() {
        return this.getIntegerPart(LINE);
    }

    public String getRoutine() {
        return (String)this.m_mesgParts.get(ROUTINE);
    }

    public String getInternalQuery() {
        return (String)this.m_mesgParts.get(INTERNAL_QUERY);
    }

    public int getInternalPosition() {
        return this.getIntegerPart(INTERNAL_POSITION);
    }

    private int getIntegerPart(Character c) {
        String string = (String)this.m_mesgParts.get(c);
        if (string == null) {
            return 0;
        }
        return Integer.parseInt(string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = (String)this.m_mesgParts.get(SEVERITY);
        if (string != null) {
            stringBuffer.append(string).append(": ");
        }
        if ((string = (String)this.m_mesgParts.get(MESSAGE)) != null) {
            stringBuffer.append(string);
        }
        if ((string = (String)this.m_mesgParts.get(DETAIL)) != null) {
            stringBuffer.append("\n  ").append(GT.tr("Detail: {0}", string));
        }
        if (this.verbosity > 0) {
            string = (String)this.m_mesgParts.get(HINT);
            if (string != null) {
                stringBuffer.append("\n  ").append(GT.tr("Hint: {0}", string));
            }
            if ((string = (String)this.m_mesgParts.get(POSITION)) != null) {
                stringBuffer.append("\n  ").append(GT.tr("Position: {0}", string));
            }
            if ((string = (String)this.m_mesgParts.get(WHERE)) != null) {
                stringBuffer.append("\n  ").append(GT.tr("Where: {0}", string));
            }
        }
        if (this.verbosity > 2) {
            String string2;
            String string3 = (String)this.m_mesgParts.get(INTERNAL_QUERY);
            if (string3 != null) {
                stringBuffer.append("\n  ").append(GT.tr("Internal Query: {0}", string3));
            }
            if ((string2 = (String)this.m_mesgParts.get(INTERNAL_POSITION)) != null) {
                stringBuffer.append("\n  ").append(GT.tr("Internal Position: {0}", string2));
            }
            String string4 = (String)this.m_mesgParts.get(FILE);
            String string5 = (String)this.m_mesgParts.get(LINE);
            String string6 = (String)this.m_mesgParts.get(ROUTINE);
            if (string4 != null || string5 != null || string6 != null) {
                stringBuffer.append("\n  ").append(GT.tr("Location: File: {0}, Routine: {1}, Line: {2}", new Object[]{string4, string6, string5}));
            }
            if ((string = (String)this.m_mesgParts.get(SQLSTATE)) != null) {
                stringBuffer.append("\n  ").append(GT.tr("Server SQLState: {0}", string));
            }
        }
        return stringBuffer.toString();
    }
}

