/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.util;

import com.vertica.util.GT;
import com.vertica.util.PSQLState;
import com.vertica.util.ServerErrorMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;

public class PSQLException
extends SQLException {
    private ServerErrorMessage _serverError;

    public PSQLException(String string, PSQLState pSQLState, Throwable throwable) {
        super(PSQLException.addCauseToMessage(string, throwable), pSQLState == null ? null : pSQLState.getState());
        this.initCause(throwable);
    }

    public PSQLException(String string, PSQLState pSQLState) {
        this(string, pSQLState, null);
    }

    public PSQLException(ServerErrorMessage serverErrorMessage) {
        this(serverErrorMessage.toString(), new PSQLState(serverErrorMessage.getSQLState()));
        this._serverError = serverErrorMessage;
    }

    public ServerErrorMessage getServerErrorMessage() {
        return this._serverError;
    }

    private static String addCauseToMessage(String string, Throwable throwable) {
        boolean bl = true;
        if (!bl && throwable != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
                printWriter.println();
                printWriter.println(GT.tr("Exception: {0}", throwable.toString()));
                printWriter.println(GT.tr("Stack Trace:"));
                throwable.printStackTrace(printWriter);
                printWriter.println(GT.tr("End of Stack Trace"));
                printWriter.flush();
                string = string + byteArrayOutputStream.toString();
                printWriter.close();
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {
                string = string + GT.tr("Exception generating stacktrace for: {0} encountered: {1}", new Object[]{throwable.toString(), iOException.toString()});
            }
        }
        return string;
    }
}

