/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.util;

import com.vertica.util.GT;
import com.vertica.util.PGobject;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;
import java.io.Serializable;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;

public class PGInterval
extends PGobject
implements Serializable,
Cloneable {
    private int years;
    private int months;
    private int days;
    private int hours;
    private int minutes;
    private double seconds;
    private static final DecimalFormat secondsFormat = new DecimalFormat("#.00####");

    public PGInterval() {
        this.setType("interval");
    }

    public PGInterval(String string) throws SQLException {
        this();
        this.setValue(string);
    }

    public PGInterval(int n, int n2, int n3, int n4, int n5, double d) {
        this();
        this.setValue(n, n2, n3, n4, n5, d);
    }

    public void setValue(String string) throws SQLException {
        boolean bl;
        boolean bl2 = bl = !string.startsWith("@");
        if (!bl && string.length() == 3 && string.charAt(2) == '0') {
            this.setValue(0, 0, 0, 0, 0, 0.0);
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        double d = 0.0;
        try {
            String string2 = null;
            string = string.replace('+', ' ').replace('@', ' ');
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            boolean bl3 = false;
            String string3 = null;
            boolean bl4 = true;
            while (stringTokenizer.hasMoreTokens() || bl3) {
                if (!bl3) {
                    string3 = stringTokenizer.nextToken();
                } else {
                    bl3 = false;
                }
                if (string2 == null) {
                    int n6;
                    int n7;
                    int n8 = string3.indexOf(58);
                    if (n8 == -1) {
                        n7 = string3.lastIndexOf(45);
                        if (n7 > 0) {
                            n6 = string3.charAt(0) == '-' ? 1 : 0;
                            n = this.nullSafeIntGet(string3.substring(n6, n7));
                            n2 = this.nullSafeIntGet(string3.substring(n7 + 1));
                            bl4 = false;
                            string2 = null;
                            continue;
                        }
                        string2 = string3;
                        continue;
                    }
                    n7 = string3.charAt(0) == '-' ? 1 : 0;
                    n4 = this.nullSafeIntGet(string3.substring(n7, n8));
                    n5 = this.nullSafeIntGet(string3.substring(n8 + 1, n8 + 3));
                    n6 = string3.indexOf(58, n8 + 1);
                    if (n6 != -1) {
                        d = this.nullSafeDoubleGet(string3.substring(n6 + 1));
                    }
                    bl4 = false;
                    string2 = null;
                    continue;
                }
                if (string3.startsWith("year")) {
                    n = this.nullSafeIntGet(string2);
                    bl4 = false;
                } else if (string3.startsWith("mon")) {
                    n2 = this.nullSafeIntGet(string2);
                    bl4 = false;
                } else if (string3.startsWith("day")) {
                    n3 = this.nullSafeIntGet(string2);
                    bl4 = false;
                } else if (string3.startsWith("hour")) {
                    n4 = this.nullSafeIntGet(string2);
                    bl4 = false;
                } else if (string3.startsWith("min")) {
                    n5 = this.nullSafeIntGet(string2);
                    bl4 = false;
                } else if (string3.startsWith("sec")) {
                    d = this.nullSafeDoubleGet(string2);
                    bl4 = false;
                } else {
                    n3 = this.nullSafeIntGet(string2);
                    bl3 = true;
                    bl4 = false;
                }
                string2 = null;
            }
            if (bl4) {
                n3 = this.nullSafeIntGet(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new PSQLException(GT.tr("Conversion of interval failed"), PSQLState.NUMERIC_CONSTANT_OUT_OF_RANGE, (Throwable)numberFormatException);
        }
        if (n < 0) {
            n = -n;
        }
        if (n2 < 0) {
            n2 = -n2;
        }
        if (n3 < 0) {
            n3 = -n3;
        }
        if (n4 < 0) {
            n4 = -n4;
        }
        if (n5 < 0) {
            n5 = -n5;
        }
        if (d < 0.0) {
            d = -d;
        }
        if (!bl && string.endsWith("ago") || bl && string.charAt(0) == '-') {
            this.setValue(-n, -n2, -n3, -n4, -n5, -d);
        } else {
            this.setValue(n, n2, n3, n4, n5, d);
        }
    }

    public void setValue(int n, int n2, int n3, int n4, int n5, double d) {
        this.setYears(n);
        this.setMonths(n2);
        this.setDays(n3);
        this.setHours(n4);
        this.setMinutes(n5);
        this.setSeconds(d);
    }

    public String getValue() {
        return this.years + " years " + this.months + " mons " + this.days + " days " + this.hours + " hours " + this.minutes + " mins " + secondsFormat.format(this.seconds) + " secs";
    }

    public int getYears() {
        return this.years;
    }

    public void setYears(int n) {
        this.years = n;
    }

    public int getMonths() {
        return this.months;
    }

    public void setMonths(int n) {
        this.months = n;
    }

    public int getDays() {
        return this.days;
    }

    public void setDays(int n) {
        this.days = n;
    }

    public int getHours() {
        return this.hours;
    }

    public void setHours(int n) {
        this.hours = n;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public void setMinutes(int n) {
        this.minutes = n;
    }

    public double getSeconds() {
        return this.seconds;
    }

    public void setSeconds(double d) {
        this.seconds = d;
    }

    public void add(Calendar calendar) {
        int n;
        int n2 = (n + ((n = (int)(this.getSeconds() * 1000000.0)) < 0 ? -500 : 500)) / 1000;
        calendar.add(14, n2);
        calendar.add(12, this.getMinutes());
        calendar.add(10, this.getHours());
        calendar.add(5, this.getDays());
        calendar.add(2, this.getMonths());
        calendar.add(1, this.getYears());
    }

    public void add(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.add(calendar);
        date.setTime(calendar.getTime().getTime());
    }

    private int nullSafeIntGet(String string) throws NumberFormatException {
        return string == null ? 0 : Integer.parseInt(string);
    }

    private double nullSafeDoubleGet(String string) throws NumberFormatException {
        return string == null ? 0.0 : Double.parseDouble(string);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof PGInterval)) {
            return false;
        }
        PGInterval pGInterval = (PGInterval)object;
        return pGInterval.years == this.years && pGInterval.months == this.months && pGInterval.days == this.days && pGInterval.hours == this.hours && pGInterval.minutes == this.minutes && Double.doubleToLongBits(pGInterval.seconds) == Double.doubleToLongBits(this.seconds);
    }

    public int hashCode() {
        return ((((((217 + (int)Double.doubleToLongBits(this.seconds)) * 31 + this.minutes) * 31 + this.hours) * 31 + this.days) * 31 + this.months) * 31 + this.years) * 31;
    }

    public Object clone() {
        return new PGInterval(this.years, this.months, this.days, this.hours, this.minutes, this.seconds);
    }

    static {
        DecimalFormatSymbols decimalFormatSymbols = secondsFormat.getDecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        secondsFormat.setDecimalFormatSymbols(decimalFormatSymbols);
    }
}

