/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.util;

public class ByteConverter {
    private ByteConverter() {
    }

    public static long int8(byte[] byArray, int n) {
        return ((long)(byArray[n + 0] & 0xFF) << 56) + ((long)(byArray[n + 1] & 0xFF) << 48) + ((long)(byArray[n + 2] & 0xFF) << 40) + ((long)(byArray[n + 3] & 0xFF) << 32) + ((long)(byArray[n + 4] & 0xFF) << 24) + ((long)(byArray[n + 5] & 0xFF) << 16) + ((long)(byArray[n + 6] & 0xFF) << 8) + (long)(byArray[n + 7] & 0xFF);
    }

    public static int int4(byte[] byArray, int n) {
        return ((byArray[n] & 0xFF) << 24) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 2] & 0xFF) << 8) + (byArray[n + 3] & 0xFF);
    }

    public static short int2(byte[] byArray, int n) {
        return (short)(((byArray[n] & 0xFF) << 8) + (byArray[n + 1] & 0xFF));
    }

    public static float float4(byte[] byArray, int n) {
        return Float.intBitsToFloat(ByteConverter.int4(byArray, n));
    }

    public static double float8(byte[] byArray, int n) {
        return Double.longBitsToDouble(ByteConverter.int8(byArray, n));
    }

    public static void int8(byte[] byArray, int n, long l) {
        byArray[n + 0] = (byte)(l >>> 56);
        byArray[n + 1] = (byte)(l >>> 48);
        byArray[n + 2] = (byte)(l >>> 40);
        byArray[n + 3] = (byte)(l >>> 32);
        byArray[n + 4] = (byte)(l >>> 24);
        byArray[n + 5] = (byte)(l >>> 16);
        byArray[n + 6] = (byte)(l >>> 8);
        byArray[n + 7] = (byte)l;
    }

    public static void int4(byte[] byArray, int n, int n2) {
        byArray[n + 0] = (byte)(n2 >>> 24);
        byArray[n + 1] = (byte)(n2 >>> 16);
        byArray[n + 2] = (byte)(n2 >>> 8);
        byArray[n + 3] = (byte)n2;
    }

    public static void int2(byte[] byArray, int n, int n2) {
        byArray[n + 0] = (byte)(n2 >>> 8);
        byArray[n + 1] = (byte)n2;
    }

    public static void float4(byte[] byArray, int n, float f) {
        ByteConverter.int4(byArray, n, Float.floatToRawIntBits(f));
    }

    public static void float8(byte[] byArray, int n, double d) {
        ByteConverter.int8(byArray, n, Double.doubleToRawLongBits(d));
    }
}

