/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc3g;

import com.vertica.core.BaseStatement;
import com.vertica.core.Field;
import com.vertica.core.Query;
import com.vertica.core.ResultCursor;
import com.vertica.core.VectorTuple;
import com.vertica.jdbc3.AbstractJdbc3ResultSet;
import com.vertica.jdbc3g.Jdbc3gArray;
import com.vertica.jdbc3g.Jdbc3gBlob;
import com.vertica.jdbc3g.Jdbc3gClob;
import com.vertica.jdbc3g.Jdbc3gResultSetMetaData;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jdbc3gResultSet
extends AbstractJdbc3ResultSet
implements ResultSet {
    Jdbc3gResultSet(Query query, BaseStatement baseStatement, Field[] fieldArray, VectorTuple vectorTuple, ResultCursor resultCursor, int n, int n2, int n3, int n4, int n5) throws SQLException {
        super(query, baseStatement, fieldArray, vectorTuple, resultCursor, n, n2, n3, n4, n5);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return new Jdbc3gResultSetMetaData(this.connection, this.fields);
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        this.checkResultSet(n);
        boolean bl = this.wasNullFlag = this.this_row[n - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        return new Jdbc3gClob(this.connection, this.getInt(n));
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        this.checkResultSet(n);
        boolean bl = this.wasNullFlag = this.this_row[n - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        return new Jdbc3gBlob(this.connection, this.getInt(n));
    }

    @Override
    public Array createArray(int n) throws SQLException {
        this.checkResultSet(n);
        return new Jdbc3gArray(this.connection, n, this.fields[n - 1], this);
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        return this.getObjectImpl(string, map);
    }

    @Override
    public Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
        return this.getObjectImpl(n, map);
    }
}

