/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc2;

import com.vertica.util.ByteConverter;
import com.vertica.util.GT;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class TimestampUtils {
    private static final int ONEDAY = 86400000;
    private StringBuffer sbuf = new StringBuffer();
    private Calendar defaultCal = new GregorianCalendar();
    private final TimeZone defaultTz = this.defaultCal.getTimeZone();
    private Calendar calCache;
    private int calCacheZone;
    private boolean min74;

    TimestampUtils(boolean bl) {
        this.min74 = bl;
    }

    private Calendar getCalendar(int n, int n2, int n3) {
        int n4 = n * (n2 * 100 + n3);
        if (this.calCache != null && this.calCacheZone == n4) {
            return this.calCache;
        }
        StringBuffer stringBuffer = new StringBuffer("GMT");
        stringBuffer.append(n < 0 ? (char)'-' : '+');
        if (n2 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n2);
        if (n3 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n3);
        TimeZone timeZone = TimeZone.getTimeZone(stringBuffer.toString());
        this.calCache = new GregorianCalendar(timeZone);
        this.calCacheZone = n4;
        return this.calCache;
    }

    private ParsedTimestamp loadCalendar(Calendar calendar, String string, String string2) throws SQLException {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        ParsedTimestamp parsedTimestamp = new ParsedTimestamp();
        try {
            int n2;
            char c;
            int n3 = TimestampUtils.skipWhitespace(cArray, 0);
            int n4 = TimestampUtils.firstNonDigit(cArray, n3);
            if (TimestampUtils.charAt(cArray, n4) == '-') {
                parsedTimestamp.hasDate = true;
                parsedTimestamp.year = TimestampUtils.number(cArray, n3, n4);
                n3 = n4 + 1;
                n4 = TimestampUtils.firstNonDigit(cArray, n3);
                parsedTimestamp.month = TimestampUtils.number(cArray, n3, n4);
                c = TimestampUtils.charAt(cArray, n4);
                if (c != '-') {
                    throw new NumberFormatException("Expected date to be dash-separated, got '" + c + "'");
                }
                n3 = n4 + 1;
                n4 = TimestampUtils.firstNonDigit(cArray, n3);
                parsedTimestamp.day = TimestampUtils.number(cArray, n3, n4);
                n3 = TimestampUtils.skipWhitespace(cArray, n4);
            }
            if (Character.isDigit(TimestampUtils.charAt(cArray, n3))) {
                parsedTimestamp.hasTime = true;
                n4 = TimestampUtils.firstNonDigit(cArray, n3);
                parsedTimestamp.hour = TimestampUtils.number(cArray, n3, n4);
                c = TimestampUtils.charAt(cArray, n4);
                if (c != ':') {
                    throw new NumberFormatException("Expected time to be colon-separated, got '" + c + "'");
                }
                n3 = n4 + 1;
                n4 = TimestampUtils.firstNonDigit(cArray, n3);
                parsedTimestamp.minute = TimestampUtils.number(cArray, n3, n4);
                c = TimestampUtils.charAt(cArray, n4);
                if (c != ':') {
                    throw new NumberFormatException("Expected time to be colon-separated, got '" + c + "'");
                }
                n3 = n4 + 1;
                n4 = TimestampUtils.firstNonDigit(cArray, n3);
                parsedTimestamp.second = TimestampUtils.number(cArray, n3, n4);
                n3 = n4;
                if (TimestampUtils.charAt(cArray, n3) == '.') {
                    n4 = TimestampUtils.firstNonDigit(cArray, n3 + 1);
                    int n5 = TimestampUtils.number(cArray, n3 + 1, n4);
                    for (n2 = n4 - (n3 + 1); n2 < 9; ++n2) {
                        n5 *= 10;
                    }
                    parsedTimestamp.nanos = n5;
                    n3 = n4;
                }
                n3 = TimestampUtils.skipWhitespace(cArray, n3);
            }
            if ((c = TimestampUtils.charAt(cArray, n3)) == '-' || c == '+') {
                int n6;
                n2 = c == '-' ? -1 : 1;
                n4 = TimestampUtils.firstNonDigit(cArray, n3 + 1);
                int n7 = TimestampUtils.number(cArray, n3 + 1, n4);
                n3 = n4;
                c = TimestampUtils.charAt(cArray, n3);
                if (c == ':') {
                    n4 = TimestampUtils.firstNonDigit(cArray, n3 + 1);
                    n6 = TimestampUtils.number(cArray, n3 + 1, n4);
                    n3 = n4;
                } else {
                    n6 = 0;
                }
                parsedTimestamp.tz = this.getCalendar(n2, n7, n6);
                n3 = TimestampUtils.skipWhitespace(cArray, n3);
            }
            if (parsedTimestamp.hasDate && n3 < n) {
                String string3 = new String(cArray, n3, n - n3);
                if (string3.startsWith("AD")) {
                    parsedTimestamp.era = 1;
                    n3 += 2;
                } else if (string3.startsWith("BC")) {
                    parsedTimestamp.era = 0;
                    n3 += 2;
                }
            }
            if (n3 < n) {
                throw new NumberFormatException("Trailing junk on timestamp: '" + new String(cArray, n3, n4 - n3) + "'");
            }
            if (!parsedTimestamp.hasTime && !parsedTimestamp.hasDate) {
                throw new NumberFormatException("Timestamp has neither date nor time");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new PSQLException(GT.tr("Bad value for type {0} : {1}", new Object[]{string2, string}), PSQLState.BAD_DATETIME_FORMAT, (Throwable)numberFormatException);
        }
        return parsedTimestamp;
    }

    private static void showParse(String string, String string2, Calendar calendar, Date date, Calendar calendar2) {
    }

    private static void showString(String string, Calendar calendar, Date date, String string2) {
    }

    public synchronized Timestamp toTimestamp(Calendar calendar, String string) throws SQLException {
        if (string == null) {
            return null;
        }
        int n = (string = string.trim()).length();
        if (n == 8 && string.equals("infinity")) {
            return new Timestamp(9223372036825200000L);
        }
        if (n == 9 && string.equals("-infinity")) {
            return new Timestamp(-9223372036832400000L);
        }
        if (calendar == null) {
            calendar = this.defaultCal;
        }
        ParsedTimestamp parsedTimestamp = this.loadCalendar(calendar, string, "timestamp");
        Calendar calendar2 = parsedTimestamp.tz == null ? calendar : parsedTimestamp.tz;
        calendar2.set(0, parsedTimestamp.era);
        calendar2.set(1, parsedTimestamp.year);
        calendar2.set(2, parsedTimestamp.month - 1);
        calendar2.set(5, parsedTimestamp.day);
        calendar2.set(11, parsedTimestamp.hour);
        calendar2.set(12, parsedTimestamp.minute);
        calendar2.set(13, parsedTimestamp.second);
        calendar2.set(14, 0);
        Timestamp timestamp = new Timestamp(calendar2.getTime().getTime());
        timestamp.setNanos(parsedTimestamp.nanos);
        TimestampUtils.showParse("timestamp", string, calendar, timestamp, calendar2);
        return timestamp;
    }

    public synchronized Time toTime(Calendar calendar, String string) throws SQLException {
        if (string == null) {
            return null;
        }
        int n = (string = string.trim()).length();
        if (n == 8 && string.equals("infinity") || n == 9 && string.equals("-infinity")) {
            throw new PSQLException(GT.tr("Infinite value found for timestamp/date. This cannot be represented as time."), PSQLState.DATETIME_OVERFLOW);
        }
        if (calendar == null) {
            calendar = this.defaultCal;
        }
        ParsedTimestamp parsedTimestamp = this.loadCalendar(calendar, string, "time");
        Calendar calendar2 = parsedTimestamp.tz == null ? calendar : parsedTimestamp.tz;
        long l = parsedTimestamp.hour * 60 * 60 * 1000 + parsedTimestamp.minute * 60 * 1000 + parsedTimestamp.second * 1000 + (parsedTimestamp.nanos + 500000) / 1000000;
        long l2 = calendar2.getTimeZone().getRawOffset();
        Time time = new Time(l -= l2);
        TimestampUtils.showParse("time", string, calendar, time, calendar2);
        return time;
    }

    public synchronized java.sql.Date toDate(Calendar calendar, String string) throws SQLException {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n == 8 && string.equals("infinity")) {
            return new java.sql.Date(9223372036825200000L);
        }
        if (n == 9 && string.equals("-infinity")) {
            return new java.sql.Date(-9223372036832400000L);
        }
        if (calendar == null) {
            calendar = this.defaultCal;
        }
        ParsedTimestamp parsedTimestamp = this.loadCalendar(calendar, string, "date");
        Calendar calendar2 = parsedTimestamp.tz == null ? calendar : parsedTimestamp.tz;
        calendar2.set(0, parsedTimestamp.era);
        calendar2.set(1, parsedTimestamp.year);
        calendar2.set(2, parsedTimestamp.month - 1);
        calendar2.set(5, parsedTimestamp.day);
        if (parsedTimestamp.hasTime) {
            calendar2.set(11, parsedTimestamp.hour);
            calendar2.set(12, parsedTimestamp.minute);
            calendar2.set(13, parsedTimestamp.second);
            calendar2.set(14, (parsedTimestamp.nanos + 500000) / 1000000);
            calendar.setTime(new java.sql.Date(calendar2.getTime().getTime()));
            calendar2 = calendar;
        }
        calendar2.set(11, 0);
        calendar2.set(12, 0);
        calendar2.set(13, 0);
        calendar2.set(14, 0);
        java.sql.Date date = new java.sql.Date(calendar2.getTime().getTime());
        TimestampUtils.showParse("date", string, calendar, date, calendar2);
        return date;
    }

    public java.sql.Date toDateBin(TimeZone timeZone, byte[] byArray) throws PSQLException {
        if (byArray.length != 8) {
            throw new PSQLException(GT.tr("Unsupported binary encoding of {0}.", "date"), PSQLState.BAD_DATETIME_FORMAT);
        }
        long l = ByteConverter.int8(byArray, 0);
        if (timeZone == null) {
            timeZone = this.defaultTz;
        }
        long l2 = (l - 2440588L) * 86400L;
        long l3 = l2 * 1000L;
        int n = timeZone.getOffset(l3);
        return new java.sql.Date(l3 - (long)n);
    }

    public Time toTimeBin(TimeZone timeZone, byte[] byArray) throws PSQLException {
        if (byArray.length != 8) {
            throw new PSQLException(GT.tr("Unsupported binary encoding of {0}.", "time"), PSQLState.BAD_DATETIME_FORMAT);
        }
        long l = ByteConverter.int8(byArray, 0);
        long l2 = l / 1000L;
        if (timeZone == null) {
            timeZone = this.defaultTz;
        }
        int n = timeZone.getOffset(l2);
        return new Time(l2 -= (long)n);
    }

    public Timestamp toTimestampBin(TimeZone timeZone, byte[] byArray, boolean bl) throws PSQLException {
        if (byArray.length != 8) {
            throw new PSQLException(GT.tr("Unsupported binary encoding of {0}.", "timestamp"), PSQLState.BAD_DATETIME_FORMAT);
        }
        long l = ByteConverter.int8(byArray, 0);
        long l2 = l / 86400000000L;
        if (l2 != 0L) {
            l -= l2 * 86400000000L;
        }
        if (l < 0L) {
            l += 86400000000L;
            --l2;
        }
        l2 += 2451545L;
        l2 -= 2440588L;
        long l3 = l / 1000000L;
        int n = (int)(l - l3 * 1000000L);
        if (n < 0) {
            --l3;
            n = (int)((long)n + 1000000L);
        }
        n *= 1000;
        long l4 = l2 * 86400L;
        long l5 = (l4 + l3) * 1000L;
        if (!bl) {
            if (timeZone == null) {
                timeZone = this.defaultTz;
            }
            l5 -= (long)timeZone.getOffset(l5);
        }
        Timestamp timestamp = new Timestamp(l5);
        timestamp.setNanos(n);
        return timestamp;
    }

    public java.sql.Date convertToDate(Timestamp timestamp, TimeZone timeZone) {
        int n;
        long l;
        long l2 = timestamp.getTime();
        if (l2 <= -9223372036832400000L || l2 >= 9223372036825200000L) {
            return new java.sql.Date(l2);
        }
        if (timeZone == null) {
            timeZone = this.defaultTz;
        }
        if ((l = l2 % 86400000L) + (long)(n = timeZone.getOffset(l2)) >= 86400000L) {
            l2 += 86400000L;
        }
        l2 -= l;
        return new java.sql.Date(l2 -= (long)n);
    }

    public Time convertToTime(Timestamp timestamp, TimeZone timeZone) {
        long l = timestamp.getTime();
        if (timeZone == null) {
            timeZone = this.defaultTz;
        }
        int n = timeZone.getOffset(l);
        long l2 = -timeZone.getOffset(l);
        long l3 = l2 + 86400000L;
        if (l < l2) {
            while ((l += 86400000L) < l2) {
            }
        } else if (l >= l3) {
            while ((l -= 86400000L) > l3) {
            }
        }
        return new Time(l);
    }

    public synchronized String toString(Calendar calendar, Timestamp timestamp) {
        if (calendar == null) {
            calendar = this.defaultCal;
        }
        calendar.setTime(timestamp);
        this.sbuf.setLength(0);
        if (timestamp.getTime() == 9223372036825200000L) {
            this.sbuf.append("infinity");
        } else if (timestamp.getTime() == -9223372036832400000L) {
            this.sbuf.append("-infinity");
        } else {
            TimestampUtils.appendDate(this.sbuf, calendar);
            this.sbuf.append(' ');
            TimestampUtils.appendTime(this.sbuf, calendar, timestamp.getNanos());
            TimestampUtils.appendTimeZone(this.sbuf, calendar);
            TimestampUtils.appendEra(this.sbuf, calendar);
        }
        TimestampUtils.showString("timestamp", calendar, timestamp, this.sbuf.toString());
        return this.sbuf.toString();
    }

    public synchronized String toString(Calendar calendar, java.sql.Date date) {
        if (calendar == null) {
            calendar = this.defaultCal;
        }
        calendar.setTime(date);
        this.sbuf.setLength(0);
        if (date.getTime() == 9223372036825200000L) {
            this.sbuf.append("infinity");
        } else if (date.getTime() == -9223372036832400000L) {
            this.sbuf.append("-infinity");
        } else {
            TimestampUtils.appendDate(this.sbuf, calendar);
            TimestampUtils.appendEra(this.sbuf, calendar);
            TimestampUtils.appendTimeZone(this.sbuf, calendar);
        }
        TimestampUtils.showString("date", calendar, date, this.sbuf.toString());
        return this.sbuf.toString();
    }

    public synchronized String toString(Calendar calendar, Time time) {
        if (calendar == null) {
            calendar = this.defaultCal;
        }
        calendar.setTime(time);
        this.sbuf.setLength(0);
        TimestampUtils.appendTime(this.sbuf, calendar, calendar.get(14) * 1000000);
        if (this.min74) {
            TimestampUtils.appendTimeZone(this.sbuf, calendar);
        }
        TimestampUtils.showString("time", calendar, time, this.sbuf.toString());
        return this.sbuf.toString();
    }

    private static void appendDate(StringBuffer stringBuffer, Calendar calendar) {
        int n;
        int n2 = calendar.get(1);
        int n3 = String.valueOf(n2).length();
        for (n = 4; n > n3; --n) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n2);
        stringBuffer.append('-');
        n = calendar.get(2) + 1;
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n);
        stringBuffer.append('-');
        int n4 = calendar.get(5);
        if (n4 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n4);
    }

    private static void appendTime(StringBuffer stringBuffer, Calendar calendar, int n) {
        int n2 = calendar.get(11);
        if (n2 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n2);
        stringBuffer.append(':');
        int n3 = calendar.get(12);
        if (n3 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n3);
        stringBuffer.append(':');
        int n4 = calendar.get(13);
        if (n4 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n4);
        char[] cArray = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0'};
        char[] cArray2 = Integer.toString(n).toCharArray();
        System.arraycopy(cArray2, 0, cArray, cArray.length - cArray2.length, cArray2.length);
        stringBuffer.append('.');
        stringBuffer.append(cArray, 0, 6);
    }

    private static void appendTimeZone(StringBuffer stringBuffer, Calendar calendar) {
        int n = (calendar.get(15) + calendar.get(16)) / 1000 / 60;
        int n2 = Math.abs(n);
        int n3 = n2 / 60;
        int n4 = n2 - n3 * 60;
        stringBuffer.append(n >= 0 ? " +" : " -");
        if (n3 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n3);
        if (n4 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n4);
    }

    private static void appendEra(StringBuffer stringBuffer, Calendar calendar) {
        if (calendar.get(0) == 0) {
            stringBuffer.append(" BC");
        }
    }

    private static int skipWhitespace(char[] cArray, int n) {
        int n2 = cArray.length;
        for (int i = n; i < n2; ++i) {
            if (Character.isSpace(cArray[i])) continue;
            return i;
        }
        return n2;
    }

    private static int firstNonDigit(char[] cArray, int n) {
        int n2 = cArray.length;
        for (int i = n; i < n2; ++i) {
            if (Character.isDigit(cArray[i])) continue;
            return i;
        }
        return n2;
    }

    private static int number(char[] cArray, int n, int n2) {
        if (n >= n2) {
            throw new NumberFormatException();
        }
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            n3 = 10 * n3 + (cArray[i] - 48);
        }
        return n3;
    }

    private static char charAt(char[] cArray, int n) {
        if (n >= 0 && n < cArray.length) {
            return cArray[n];
        }
        return '\u0000';
    }

    private static class ParsedTimestamp {
        boolean hasDate = false;
        int era = 1;
        int year = 1970;
        int month = 1;
        boolean hasTime = false;
        int day = 1;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int nanos = 0;
        Calendar tz = null;

        private ParsedTimestamp() {
        }
    }
}

