/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc2;

import com.vertica.util.GT;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EscapedFunctions {
    public static final String ABS = "abs";
    public static final String ACOS = "acos";
    public static final String ASIN = "asin";
    public static final String ATAN = "atan";
    public static final String ATAN2 = "atan2";
    public static final String CEILING = "ceiling";
    public static final String COS = "cos";
    public static final String COT = "cot";
    public static final String DEGREES = "degrees";
    public static final String EXP = "exp";
    public static final String FLOOR = "floor";
    public static final String LOG = "log";
    public static final String LOG10 = "log10";
    public static final String MOD = "mod";
    public static final String PI = "pi";
    public static final String POWER = "power";
    public static final String RADIANS = "radians";
    public static final String RAND = "rand";
    public static final String ROUND = "round";
    public static final String SIGN = "sign";
    public static final String SIN = "sin";
    public static final String SQRT = "sqrt";
    public static final String TAN = "tan";
    public static final String TRUNCATE = "truncate";
    public static final String ASCII = "ascii";
    public static final String CHAR = "char";
    public static final String CONCAT = "concat";
    public static final String INSERT = "insert";
    public static final String LCASE = "lcase";
    public static final String LEFT = "left";
    public static final String LENGTH = "length";
    public static final String LOCATE = "locate";
    public static final String LTRIM = "ltrim";
    public static final String REPEAT = "repeat";
    public static final String REPLACE = "replace";
    public static final String RIGHT = "right";
    public static final String RTRIM = "rtrim";
    public static final String SPACE = "space";
    public static final String SUBSTRING = "substring";
    public static final String UCASE = "ucase";
    public static final String CURDATE = "curdate";
    public static final String CURTIME = "curtime";
    public static final String DAYNAME = "dayname";
    public static final String DAYOFMONTH = "dayofmonth";
    public static final String DAYOFWEEK = "dayofweek";
    public static final String DAYOFYEAR = "dayofyear";
    public static final String HOUR = "hour";
    public static final String MINUTE = "minute";
    public static final String MONTH = "month";
    public static final String MONTHNAME = "monthname";
    public static final String NOW = "now";
    public static final String QUARTER = "quarter";
    public static final String SECOND = "second";
    public static final String WEEK = "week";
    public static final String YEAR = "year";
    public static final String TIMESTAMPADD = "timestampadd";
    public static final String TIMESTAMPDIFF = "timestampdiff";
    public static final String SQL_TSI_ROOT = "SQL_TSI_";
    public static final String SQL_TSI_DAY = "DAY";
    public static final String SQL_TSI_FRAC_SECOND = "FRAC_SECOND";
    public static final String SQL_TSI_HOUR = "HOUR";
    public static final String SQL_TSI_MINUTE = "MINUTE";
    public static final String SQL_TSI_MONTH = "MONTH";
    public static final String SQL_TSI_QUARTER = "QUARTER";
    public static final String SQL_TSI_SECOND = "SECOND";
    public static final String SQL_TSI_WEEK = "WEEK";
    public static final String SQL_TSI_YEAR = "YEAR";
    public static final String DATABASE = "database";
    public static final String IFNULL = "ifnull";
    public static final String USER = "user";
    private static Map functionMap = null;

    public static Method getFunction(String string) {
        if (functionMap == null) {
            Method[] methodArray = EscapedFunctions.class.getDeclaredMethods();
            functionMap = new HashMap(methodArray.length * 2);
            for (int i = 0; i < methodArray.length; ++i) {
                Method method = methodArray[i];
                if (!method.getName().startsWith("sql")) continue;
                functionMap.put(method.getName().toLowerCase(), method);
            }
        }
        return (Method)functionMap.get("sql" + string.toLowerCase());
    }

    public static String sqlceiling(List list) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ceil(");
        if (list.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", CEILING), PSQLState.SYNTAX_ERROR);
        }
        stringBuffer.append(list.get(0));
        return stringBuffer.append(')').toString();
    }

    public static String sqllog(List list) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ln(");
        if (list.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", LOG), PSQLState.SYNTAX_ERROR);
        }
        stringBuffer.append(list.get(0));
        return stringBuffer.append(')').toString();
    }

    public static String sqllog10(List list) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("log(");
        if (list.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", LOG10), PSQLState.SYNTAX_ERROR);
        }
        stringBuffer.append(list.get(0));
        return stringBuffer.append(')').toString();
    }

    public static String sqlpower(List list) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("pow(");
        if (list.size() != 2) {
            throw new PSQLException(GT.tr("{0} function takes two and only two arguments.", POWER), PSQLState.SYNTAX_ERROR);
        }
        stringBuffer.append(list.get(0)).append(',').append(list.get(1));
        return stringBuffer.append(')').toString();
    }

    public static String sqlrand(List list) throws SQLException {
        if (list.size() == 0) {
            return "random()";
        }
        if (list.size() == 1) {
            return "(setseed(" + list.get(0) + ")*0+random())";
        }
        throw new PSQLException(GT.tr("rand function only takes zero or one argument(the seed)."), PSQLState.SYNTAX_ERROR);
    }

    public static String sqltruncate(List list) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("trunc(");
        if (list.size() != 2) {
            throw new PSQLException(GT.tr("{0} function takes two and only two arguments.", TRUNCATE), PSQLState.SYNTAX_ERROR);
        }
        stringBuffer.append(list.get(0)).append(',').append(list.get(1));
        return stringBuffer.append(')').toString();
    }

    public static String sqlchar(List list) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("chr(");
        if (list.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", CHAR), PSQLState.SYNTAX_ERROR);
        }
        stringBuffer.append(list.get(0));
        return stringBuffer.append(')').toString();
    }

    public static String sqlconcat(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        for (int i = 0; i < list.size(); ++i) {
            stringBuffer.append(list.get(i));
            if (i == list.size() - 1) continue;
            stringBuffer.append(" || ");
        }
        return stringBuffer.append(')').toString();
    }

    public static String sqlinsert(List list) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("overlay(");
        if (list.size() != 4) {
            throw new PSQLException(GT.tr("{0} function takes four and only four argument.", INSERT), PSQLState.SYNTAX_ERROR);
        }
        stringBuffer.append(list.get(0)).append(" placing ").append(list.get(3));
        stringBuffer.append(" from ").append(list.get(1)).append(" for ").append(list.get(2));
        return stringBuffer.append(')').toString();
    }

    public static String sqllcase(List list) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("lower(");
        if (list.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", LCASE), PSQLState.SYNTAX_ERROR);
        }
        stringBuffer.append(list.get(0));
        return stringBuffer.append(')').toString();
    }

    public static String sqlleft(List list) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("substring(");
        if (list.size() != 2) {
            throw new PSQLException(GT.tr("{0} function takes two and only two arguments.", LEFT), PSQLState.SYNTAX_ERROR);
        }
        stringBuffer.append(list.get(0)).append(" for ").append(list.get(1));
        return stringBuffer.append(')').toString();
    }

    public static String sqllength(List list) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("length(trim(trailing from ");
        if (list.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", LENGTH), PSQLState.SYNTAX_ERROR);
        }
        stringBuffer.append(list.get(0));
        return stringBuffer.append("))").toString();
    }

    public static String sqllocate(List list) throws SQLException {
        if (list.size() == 2) {
            return "position(" + list.get(0) + " in " + list.get(1) + ")";
        }
        if (list.size() == 3) {
            String string = "position(" + list.get(0) + " in substring(" + list.get(1) + " from " + list.get(2) + "))";
            return "(" + list.get(2) + "*sign(" + string + ")+" + string + ")";
        }
        throw new PSQLException(GT.tr("{0} function takes two or three arguments.", LOCATE), PSQLState.SYNTAX_ERROR);
    }

    public static String sqlltrim(List list) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("trim(leading from ");
        if (list.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", LTRIM), PSQLState.SYNTAX_ERROR);
        }
        stringBuffer.append(list.get(0));
        return stringBuffer.append(')').toString();
    }

    public static String sqlright(List list) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("substring(");
        if (list.size() != 2) {
            throw new PSQLException(GT.tr("{0} function takes two and only two arguments.", RIGHT), PSQLState.SYNTAX_ERROR);
        }
        stringBuffer.append(list.get(0)).append(" from (length(").append(list.get(0)).append(")+1-").append(list.get(1));
        return stringBuffer.append("))").toString();
    }

    public static String sqlrtrim(List list) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("trim(trailing from ");
        if (list.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", RTRIM), PSQLState.SYNTAX_ERROR);
        }
        stringBuffer.append(list.get(0));
        return stringBuffer.append(')').toString();
    }

    public static String sqlspace(List list) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("repeat(' ',");
        if (list.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", SPACE), PSQLState.SYNTAX_ERROR);
        }
        stringBuffer.append(list.get(0));
        return stringBuffer.append(')').toString();
    }

    public static String sqlsubstring(List list) throws SQLException {
        if (list.size() == 2) {
            return "substr(" + list.get(0) + "," + list.get(1) + ")";
        }
        if (list.size() == 3) {
            return "substr(" + list.get(0) + "," + list.get(1) + "," + list.get(2) + ")";
        }
        throw new PSQLException(GT.tr("{0} function takes two or three arguments.", SUBSTRING), PSQLState.SYNTAX_ERROR);
    }

    public static String sqlucase(List list) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("upper(");
        if (list.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", UCASE), PSQLState.SYNTAX_ERROR);
        }
        stringBuffer.append(list.get(0));
        return stringBuffer.append(')').toString();
    }

    public static String sqlcurdate(List list) throws SQLException {
        if (list.size() != 0) {
            throw new PSQLException(GT.tr("{0} function doesn''t take any argument.", CURDATE), PSQLState.SYNTAX_ERROR);
        }
        return "current_date";
    }

    public static String sqlcurtime(List list) throws SQLException {
        if (list.size() != 0) {
            throw new PSQLException(GT.tr("{0} function doesn''t take any argument.", CURTIME), PSQLState.SYNTAX_ERROR);
        }
        return "current_time";
    }

    public static String sqldayname(List list) throws SQLException {
        if (list.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", DAYNAME), PSQLState.SYNTAX_ERROR);
        }
        return "to_char(" + list.get(0) + ",'Day')";
    }

    public static String sqldayofmonth(List list) throws SQLException {
        if (list.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", DAYOFMONTH), PSQLState.SYNTAX_ERROR);
        }
        return "extract(day from " + list.get(0) + ")";
    }

    public static String sqldayofweek(List list) throws SQLException {
        if (list.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", DAYOFWEEK), PSQLState.SYNTAX_ERROR);
        }
        return "extract(dow from " + list.get(0) + ")+1";
    }

    public static String sqldayofyear(List list) throws SQLException {
        if (list.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", DAYOFYEAR), PSQLState.SYNTAX_ERROR);
        }
        return "extract(doy from " + list.get(0) + ")";
    }

    public static String sqlhour(List list) throws SQLException {
        if (list.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", HOUR), PSQLState.SYNTAX_ERROR);
        }
        return "extract(hour from " + list.get(0) + ")";
    }

    public static String sqlminute(List list) throws SQLException {
        if (list.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", MINUTE), PSQLState.SYNTAX_ERROR);
        }
        return "extract(minute from " + list.get(0) + ")";
    }

    public static String sqlmonth(List list) throws SQLException {
        if (list.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", MONTH), PSQLState.SYNTAX_ERROR);
        }
        return "extract(month from " + list.get(0) + ")";
    }

    public static String sqlmonthname(List list) throws SQLException {
        if (list.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", MONTHNAME), PSQLState.SYNTAX_ERROR);
        }
        return "to_char(" + list.get(0) + ",'Month')";
    }

    public static String sqlquarter(List list) throws SQLException {
        if (list.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", QUARTER), PSQLState.SYNTAX_ERROR);
        }
        return "extract(quarter from " + list.get(0) + ")";
    }

    public static String sqlsecond(List list) throws SQLException {
        if (list.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", SECOND), PSQLState.SYNTAX_ERROR);
        }
        return "extract(second from " + list.get(0) + ")";
    }

    public static String sqlweek(List list) throws SQLException {
        if (list.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", WEEK), PSQLState.SYNTAX_ERROR);
        }
        return "extract(week from " + list.get(0) + ")";
    }

    public static String sqlyear(List list) throws SQLException {
        if (list.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", YEAR), PSQLState.SYNTAX_ERROR);
        }
        return "extract(year from " + list.get(0) + ")";
    }

    public static String sqltimestampadd(List list) throws SQLException {
        if (list.size() != 3) {
            throw new PSQLException(GT.tr("{0} function takes three and only three arguments.", TIMESTAMPADD), PSQLState.SYNTAX_ERROR);
        }
        String string = EscapedFunctions.constantToInterval(list.get(0).toString(), list.get(1).toString());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(interval ").append(string).append("+").append(list.get(2)).append(")");
        return stringBuffer.toString();
    }

    private static final String constantToInterval(String string, String string2) throws SQLException {
        if (!string.startsWith(SQL_TSI_ROOT)) {
            throw new PSQLException(GT.tr("Interval {0} not yet implemented", string), PSQLState.SYNTAX_ERROR);
        }
        String string3 = string.substring(SQL_TSI_ROOT.length());
        if (SQL_TSI_DAY.equalsIgnoreCase(string3)) {
            return "'" + string2 + " day'";
        }
        if (SQL_TSI_SECOND.equalsIgnoreCase(string3)) {
            return "'" + string2 + " second'";
        }
        if (SQL_TSI_HOUR.equalsIgnoreCase(string3)) {
            return "'" + string2 + " hour'";
        }
        if (SQL_TSI_MINUTE.equalsIgnoreCase(string3)) {
            return "'" + string2 + " minute'";
        }
        if (SQL_TSI_MONTH.equalsIgnoreCase(string3)) {
            return "'" + string2 + " month'";
        }
        if (SQL_TSI_QUARTER.equalsIgnoreCase(string3)) {
            return "'" + Integer.valueOf(string2) * 3 + " month'";
        }
        if (SQL_TSI_WEEK.equalsIgnoreCase(string3)) {
            return "'" + string2 + " week'";
        }
        if (SQL_TSI_YEAR.equalsIgnoreCase(string3)) {
            return "'" + string2 + " year'";
        }
        if (SQL_TSI_FRAC_SECOND.equalsIgnoreCase(string3)) {
            throw new PSQLException(GT.tr("Interval {0} not yet implemented", "SQL_TSI_FRAC_SECOND"), PSQLState.SYNTAX_ERROR);
        }
        throw new PSQLException(GT.tr("Interval {0} not yet implemented", string), PSQLState.SYNTAX_ERROR);
    }

    public static String sqltimestampdiff(List list) throws SQLException {
        if (list.size() != 3) {
            throw new PSQLException(GT.tr("{0} function takes three and only three arguments.", TIMESTAMPDIFF), PSQLState.SYNTAX_ERROR);
        }
        String string = EscapedFunctions.constantToDatePart(list.get(0).toString());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("extract( ").append(string).append(" from (").append(list.get(2)).append("-").append(list.get(1)).append("))");
        return stringBuffer.toString();
    }

    private static final String constantToDatePart(String string) throws SQLException {
        if (!string.startsWith(SQL_TSI_ROOT)) {
            throw new PSQLException(GT.tr("Interval {0} not yet implemented", string), PSQLState.SYNTAX_ERROR);
        }
        String string2 = string.substring(SQL_TSI_ROOT.length());
        if (SQL_TSI_DAY.equalsIgnoreCase(string2)) {
            return "day";
        }
        if (SQL_TSI_SECOND.equalsIgnoreCase(string2)) {
            return SECOND;
        }
        if (SQL_TSI_HOUR.equalsIgnoreCase(string2)) {
            return HOUR;
        }
        if (SQL_TSI_MINUTE.equalsIgnoreCase(string2)) {
            return MINUTE;
        }
        if (SQL_TSI_FRAC_SECOND.equalsIgnoreCase(string2)) {
            throw new PSQLException(GT.tr("Interval {0} not yet implemented", "SQL_TSI_FRAC_SECOND"), PSQLState.SYNTAX_ERROR);
        }
        throw new PSQLException(GT.tr("Interval {0} not yet implemented", string), PSQLState.SYNTAX_ERROR);
    }

    public static String sqldatabase(List list) throws SQLException {
        if (list.size() != 0) {
            throw new PSQLException(GT.tr("{0} function doesn''t take any argument.", DATABASE), PSQLState.SYNTAX_ERROR);
        }
        return "current_database()";
    }

    public static String sqlifnull(List list) throws SQLException {
        if (list.size() != 2) {
            throw new PSQLException(GT.tr("{0} function takes two and only two arguments.", IFNULL), PSQLState.SYNTAX_ERROR);
        }
        return "coalesce(" + list.get(0) + "," + list.get(1) + ")";
    }

    public static String sqluser(List list) throws SQLException {
        if (list.size() != 0) {
            throw new PSQLException(GT.tr("{0} function doesn''t take any argument.", USER), PSQLState.SYNTAX_ERROR);
        }
        return USER;
    }
}

